/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.writer;

import com.datastax.spark.connector.writer.RateLimiter$;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001I4AAE\n\u0001=!AQ\u0005\u0001B\u0001B\u0003%a\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003'\u0011!Q\u0003A!A!\u0002\u0013Y\u0003\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\t\u000bU\u0002A\u0011\u0001\u001c\t\u0011u\u0002!\u0019!C\u0001'yBaa\u0013\u0001!\u0002\u0013y\u0004\u0002\u0003'\u0001\u0005\u0004%\ta\u0005 \t\r5\u0003\u0001\u0015!\u0003@\u0011\u0015q\u0005\u0001\"\u0003P\u0011\u0019q\u0005\u0001\"\u0001\u00149\")Q\f\u0001C\u0001=\u001e9\u0011mEA\u0001\u0012\u0003\u0011ga\u0002\n\u0014\u0003\u0003E\ta\u0019\u0005\u0006k9!\t\u0001\u001a\u0005\bK:\t\n\u0011\"\u0001g\u0011\u001dyg\"%A\u0005\u0002A\u00141BU1uK2KW.\u001b;fe*\u0011A#F\u0001\u0007oJLG/\u001a:\u000b\u0005Y9\u0012!C2p]:,7\r^8s\u0015\tA\u0012$A\u0003ta\u0006\u00148N\u0003\u0002\u001b7\u0005AA-\u0019;bgR\f\u0007PC\u0001\u001d\u0003\r\u0019w.\\\u0002\u0001'\t\u0001q\u0004\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VMZ\u0001\u0005e\u0006$X\r\u0005\u0002!O%\u0011\u0001&\t\u0002\u0005\u0019>tw-\u0001\u0006ck\u000e\\W\r^*ju\u0016\fA\u0001^5nKB\u0019\u0001\u0005\f\u0014\n\u00055\n#!\u0003$v]\u000e$\u0018n\u001c81\u0003\u0015\u0019H.Z3q!\u0011\u0001\u0003G\n\u001a\n\u0005E\n#!\u0003$v]\u000e$\u0018n\u001c82!\t\u00013'\u0003\u00025C\t\u0019\u0011I\\=\u0002\rqJg.\u001b;?)\u00159\u0014HO\u001e=!\tA\u0004!D\u0001\u0014\u0011\u0015)S\u00011\u0001'\u0011\u0015IS\u00011\u0001'\u0011\u001dQS\u0001%AA\u0002-BqAL\u0003\u0011\u0002\u0003\u0007q&\u0001\u0006ck\u000e\\W\r\u001e$jY2,\u0012a\u0010\t\u0003\u0001&k\u0011!\u0011\u0006\u0003\u0005\u000e\u000ba!\u0019;p[&\u001c'B\u0001#F\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\r\u001e\u000bA!\u001e;jY*\t\u0001*\u0001\u0003kCZ\f\u0017B\u0001&B\u0005)\tEo\\7jG2{gnZ\u0001\fEV\u001c7.\u001a;GS2d\u0007%\u0001\u0005mCN$H+[7f\u0003%a\u0017m\u001d;US6,\u0007%\u0001\u0003mK\u0006\\GC\u0001)T!\t\u0001\u0013+\u0003\u0002SC\t!QK\\5u\u0011\u0015!&\u00021\u0001'\u0003\u0019!x\u000eT3bW\"\u0012!B\u0016\t\u0003/jk\u0011\u0001\u0017\u0006\u00033\u0006\n!\"\u00198o_R\fG/[8o\u0013\tY\u0006LA\u0004uC&d'/Z2\u0015\u0003A\u000b!\"\\1zE\u0016\u001cF.Z3q)\t\u0001v\fC\u0003a\u0019\u0001\u0007a%\u0001\u0006qC\u000e\\W\r^*ju\u0016\f1BU1uK2KW.\u001b;feB\u0011\u0001HD\n\u0003\u001d}!\u0012AY\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0003\u001dT#a\u000b5,\u0003%\u0004\"A[7\u000e\u0003-T!\u0001\u001c-\u0002\u0013Ut7\r[3dW\u0016$\u0017B\u00018l\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0003ET#a\f5")
public class RateLimiter {
    private final long rate;
    private final long bucketSize;
    private final Function0<Object> time;
    private final Function1<Object, Object> sleep;
    private final AtomicLong bucketFill;
    private final AtomicLong lastTime;

    public static Function1<Object, Object> $lessinit$greater$default$4() {
        return RateLimiter$.MODULE$.$lessinit$greater$default$4();
    }

    public static Function0<Object> $lessinit$greater$default$3() {
        return RateLimiter$.MODULE$.$lessinit$greater$default$3();
    }

    public AtomicLong bucketFill() {
        return this.bucketFill;
    }

    public AtomicLong lastTime() {
        return this.lastTime;
    }

    private void leak(long toLeak) {
        long reallyToLeak;
        long fill;
        do {
            fill = this.bucketFill().get();
            reallyToLeak = package$.MODULE$.min(fill, toLeak);
        } while (!this.bucketFill().compareAndSet(fill, fill - reallyToLeak));
    }

    public void leak() {
        long currentTime = this.time.apply$mcJ$sp();
        long prevTime = this.lastTime().getAndSet(currentTime);
        long elapsedTime = package$.MODULE$.max(currentTime - prevTime, 0L);
        this.leak(elapsedTime * this.rate / 1000L);
    }

    public void maybeSleep(long packetSize) {
        block0: {
            this.leak();
            long currentFill = this.bucketFill().addAndGet(packetSize);
            long overflow = currentFill - this.bucketSize;
            long delay = 1000L * overflow / this.rate;
            if (delay <= 0L) break block0;
            this.sleep.apply((Object)BoxesRunTime.boxToLong((long)delay));
        }
    }

    public RateLimiter(long rate, long bucketSize, Function0<Object> time, Function1<Object, Object> sleep) {
        this.rate = rate;
        this.bucketSize = bucketSize;
        this.time = time;
        this.sleep = sleep;
        Predef$.MODULE$.require(rate > 0L, (Function0 & java.io.Serializable & Serializable)() -> "A positive rate is required");
        Predef$.MODULE$.require(bucketSize > 0L, (Function0 & java.io.Serializable & Serializable)() -> "A positive bucket size is required");
        this.bucketFill = new AtomicLong(0L);
        this.lastTime = new AtomicLong(time.apply$mcJ$sp());
    }
}

