/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.writer;

import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Session;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.util.PatitionKeyTools$;
import com.datastax.spark.connector.writer.BoundStatementBuilder;
import com.datastax.spark.connector.writer.BoundStatementBuilder$;
import com.datastax.spark.connector.writer.ReplicaLocator$;
import com.datastax.spark.connector.writer.RoutingKeyGenerator;
import com.datastax.spark.connector.writer.RowWriter;
import com.datastax.spark.connector.writer.RowWriterFactory;
import java.io.Serializable;
import java.net.InetAddress;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001B\t\u0013\u0001uA\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006IA\f\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A\u0001\b\u0001B\u0001B\u0003%\u0011\bC\u0003I\u0001\u0011%\u0011\nC\u0004O\u0001\t\u0007I\u0011A(\t\rm\u0003\u0001\u0015!\u0003Q\u0011\u001da\u0006A1A\u0005\u0002=Ca!\u0018\u0001!\u0002\u0013\u0001\u0006b\u00020\u0001\u0005\u0004%\ta\u0018\u0005\u0007S\u0002\u0001\u000b\u0011\u00021\t\u000b)\u0004A\u0011A6\b\u000f\u00055!\u0003#\u0001\u0002\u0010\u00191\u0011C\u0005E\u0001\u0003#Aa\u0001S\u0007\u0005\u0002\u0005M\u0001bBA\u000b\u001b\u0011\u0005\u0011q\u0003\u0005\n\u0003\u007fi\u0011\u0011!C\u0005\u0003\u0003\u0012aBU3qY&\u001c\u0017\rT8dCR|'O\u0003\u0002\u0014)\u00051qO]5uKJT!!\u0006\f\u0002\u0013\r|gN\\3di>\u0014(BA\f\u0019\u0003\u0015\u0019\b/\u0019:l\u0015\tI\"$\u0001\u0005eCR\f7\u000f^1y\u0015\u0005Y\u0012aA2p[\u000e\u0001QC\u0001\u0010@'\u0011\u0001q$\n\u0015\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g!\t\u0001c%\u0003\u0002(C\ta1+\u001a:jC2L'0\u00192mKB\u0011\u0011\u0006L\u0007\u0002U)\u00111\u0006F\u0001\u0005kRLG.\u0003\u0002.U\t9Aj\\4hS:<\u0007CA\u00183\u001b\u0005\u0001$BA\u0019\u0015\u0003\r\u0019\u0017\u000f\\\u0005\u0003gA\u0012!cQ1tg\u0006tGM]1D_:tWm\u0019;pe\u0006AA/\u00192mK\u0012+g\r\u0005\u00020m%\u0011q\u0007\r\u0002\t)\u0006\u0014G.\u001a#fM\u0006I!o\\<Xe&$XM\u001d\t\u0004umjT\"\u0001\n\n\u0005q\u0012\"!\u0003*po^\u0013\u0018\u000e^3s!\tqt\b\u0004\u0001\u0005\u000b\u0001\u0003!\u0019A!\u0003\u0003Q\u000b\"AQ#\u0011\u0005\u0001\u001a\u0015B\u0001#\"\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001\t$\n\u0005\u001d\u000b#aA!os\u00061A(\u001b8jiz\"BAS&M\u001bB\u0019!\bA\u001f\t\u000bU!\u0001\u0019\u0001\u0018\t\u000bQ\"\u0001\u0019A\u001b\t\u000ba\"\u0001\u0019A\u001d\u0002\u0019-,\u0017p\u001d9bG\u0016t\u0015-\\3\u0016\u0003A\u0003\"!\u0015-\u000f\u0005I3\u0006CA*\"\u001b\u0005!&BA+\u001d\u0003\u0019a$o\\8u}%\u0011q+I\u0001\u0007!J,G-\u001a4\n\u0005eS&AB*ue&twM\u0003\u0002XC\u0005i1.Z=ta\u0006\u001cWMT1nK\u0002\n\u0011\u0002^1cY\u0016t\u0015-\\3\u0002\u0015Q\f'\r\\3OC6,\u0007%A\u0006d_2,XN\u001c(b[\u0016\u001cX#\u00011\u0011\u0007\u00054\u0007K\u0004\u0002cI:\u00111kY\u0005\u0002E%\u0011Q-I\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0007NA\u0002TKFT!!Z\u0011\u0002\u0019\r|G.^7o\u001d\u0006lWm\u001d\u0011\u0002\u001b-,\u0017PQ=SKBd\u0017nY1t)\ra\u0017q\u0001\t\u0004[B\u0014X\"\u00018\u000b\u0005=\f\u0013AC2pY2,7\r^5p]&\u0011\u0011O\u001c\u0002\t\u0013R,'/\u0019;peB!\u0001e];>\u0013\t!\u0018E\u0001\u0004UkBdWM\r\t\u0004mf\\X\"A<\u000b\u0005at\u0017!C5n[V$\u0018M\u00197f\u0013\tQxOA\u0002TKR\u00042\u0001`A\u0002\u001b\u0005i(B\u0001@\u0000\u0003\rqW\r\u001e\u0006\u0003\u0003\u0003\tAA[1wC&\u0019\u0011QA?\u0003\u0017%sW\r^!eIJ,7o\u001d\u0005\b\u0003\u0013Y\u0001\u0019AA\u0006\u0003\u0011!\u0017\r^1\u0011\u00075\u0004X(\u0001\bSKBd\u0017nY1M_\u000e\fGo\u001c:\u0011\u0005ij1cA\u0007 KQ\u0011\u0011qB\u0001\u0006CB\u0004H._\u000b\u0005\u00033\t\t\u0003\u0006\u0006\u0002\u001c\u00055\u0012qFA\u0019\u0003g!B!!\b\u0002$A!!\bAA\u0010!\rq\u0014\u0011\u0005\u0003\u0006\u0001>\u0011\r!\u0011\u0005\n\u0003Ky\u0011\u0011!a\u0002\u0003O\t!\"\u001a<jI\u0016t7-\u001a\u00132!\u0015Q\u0014\u0011FA\u0010\u0013\r\tYC\u0005\u0002\u0011%><xK]5uKJ4\u0015m\u0019;pefDQ!F\bA\u00029BQAT\bA\u0002ACQ\u0001X\bA\u0002ACq!!\u000e\u0010\u0001\u0004\t9$\u0001\nqCJ$\u0018\u000e^5p].+\u00170T1qa\u0016\u0014\b\u0003BA\u001d\u0003wi\u0011\u0001F\u0005\u0004\u0003{!\"AD\"pYVlgnU3mK\u000e$xN]\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002DA!\u0011QIA&\u001b\t\t9EC\u0002\u0002J}\fA\u0001\\1oO&!\u0011QJA$\u0005\u0019y%M[3di\u0002")
public class ReplicaLocator<T>
implements scala.Serializable,
Logging {
    private final CassandraConnector connector;
    private final TableDef tableDef;
    private final RowWriter<T> rowWriter;
    private final String keyspaceName;
    private final String tableName;
    private final Seq<String> columnNames;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    public static <T> ReplicaLocator<T> apply(CassandraConnector cassandraConnector, String string, String string2, ColumnSelector columnSelector, RowWriterFactory<T> rowWriterFactory) {
        return ReplicaLocator$.MODULE$.apply(cassandraConnector, string, string2, columnSelector, rowWriterFactory);
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    @Override
    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    public String keyspaceName() {
        return this.keyspaceName;
    }

    public String tableName() {
        return this.tableName;
    }

    public Seq<String> columnNames() {
        return this.columnNames;
    }

    public Iterator<Tuple2<Set<InetAddress>, T>> keyByReplicas(Iterator<T> data) {
        return (Iterator)this.connector.withSessionDo((Function1 & Serializable & scala.Serializable)session -> {
            ProtocolVersion protocolVersion = session.getCluster().getConfiguration().getProtocolOptions().getProtocolVersion();
            PreparedStatement stmt = PatitionKeyTools$.MODULE$.prepareDummyStatement((Session)session, $this.tableDef);
            RoutingKeyGenerator routingKeyGenerator = new RoutingKeyGenerator($this.tableDef, this.columnNames());
            RowWriter x$1 = $this.rowWriter;
            PreparedStatement x$2 = stmt;
            ProtocolVersion x$3 = protocolVersion;
            Seq<Object> x$4 = BoundStatementBuilder$.MODULE$.$lessinit$greater$default$3();
            boolean x$5 = BoundStatementBuilder$.MODULE$.$lessinit$greater$default$4();
            BoundStatementBuilder boundStmtBuilder = new BoundStatementBuilder(x$1, x$2, x$4, x$5, x$3);
            Metadata clusterMetadata = session.getCluster().getMetadata();
            return data.map((Function1 & Serializable & scala.Serializable)row -> {
                Set hosts = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaSet(clusterMetadata.getReplicas(Metadata.quote(this.keyspaceName()), routingKeyGenerator.apply(boundStmtBuilder.bind(row)))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getAddress(), Set$.MODULE$.canBuildFrom())).toSet();
                return new Tuple2((Object)hosts, row);
            });
        });
    }

    public ReplicaLocator(CassandraConnector connector, TableDef tableDef, RowWriter<T> rowWriter) {
        this.connector = connector;
        this.tableDef = tableDef;
        this.rowWriter = rowWriter;
        Logging.$init$(this);
        this.keyspaceName = tableDef.keyspaceName();
        this.tableName = tableDef.tableName();
        this.columnNames = rowWriter.columnNames();
    }
}

