/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.writer;

import com.datastax.spark.connector.CollectionBehavior;
import com.datastax.spark.connector.CollectionColumnName;
import com.datastax.spark.connector.CollectionPrepend$;
import com.datastax.spark.connector.CollectionRemove$;
import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.ColumnRole;
import com.datastax.spark.connector.cql.IndexDef;
import com.datastax.spark.connector.cql.Schema$;
import com.datastax.spark.connector.cql.StaticColumn$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.types.ColumnType;
import com.datastax.spark.connector.types.ListType;
import com.datastax.spark.connector.types.MapType;
import com.datastax.spark.connector.writer.RowWriter;
import com.datastax.spark.connector.writer.RowWriterFactory;
import com.datastax.spark.connector.writer.TableWriter;
import com.datastax.spark.connector.writer.WriteConf;
import java.io.Serializable;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class TableWriter$
implements scala.Serializable {
    public static TableWriter$ MODULE$;
    private final Set<String> InternalColumns;

    static {
        new TableWriter$();
    }

    public void com$datastax$spark$connector$writer$TableWriter$$checkMissingColumns(TableDef table, Seq<String> columnNames) {
        IndexedSeq allColumnNames = (IndexedSeq)table.columns().map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.columnName(), IndexedSeq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set missingColumns = (scala.collection.immutable.Set)columnNames.toSet().$minus$minus((GenTraversableOnce)allColumnNames);
        if (missingColumns.nonEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(21).append("Column(s) not found: ").append(missingColumns.mkString(", ")).toString());
        }
    }

    private void checkMissingPrimaryKeyColumns(TableDef table, Seq<String> columnNames) {
        IndexedSeq primaryKeyColumnNames = (IndexedSeq)table.primaryKey().map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.columnName(), IndexedSeq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set missingPrimaryKeyColumns = (scala.collection.immutable.Set)primaryKeyColumnNames.toSet().$minus$minus(columnNames);
        if (missingPrimaryKeyColumns.nonEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(71).append("Some primary key columns are missing in RDD or have not been selected: ").append(missingPrimaryKeyColumns.mkString(", ")).toString());
        }
    }

    private void checkMissingPartitionKeyColumns(TableDef table, Seq<String> columnNames) {
        Seq partitionKeyColumnNames = (Seq)table.partitionKey().map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.columnName(), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set missingPartitionKeyColumns = (scala.collection.immutable.Set)partitionKeyColumnNames.toSet().$minus$minus(columnNames);
        if (missingPartitionKeyColumns.nonEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(73).append("Some partition key columns are missing in RDD or have not been selected: ").append(missingPartitionKeyColumns.mkString(", ")).toString());
        }
    }

    private boolean onlyPartitionKeyAndStatic(TableDef table, Seq<String> columnNames) {
        scala.collection.immutable.Set nonPartitionKeyColumnNames = (scala.collection.immutable.Set)columnNames.toSet().$minus$minus((GenTraversableOnce)table.partitionKey().map((Function1 & Serializable & scala.Serializable)x$24 -> x$24.columnName(), Seq$.MODULE$.canBuildFrom()));
        Seq nonPartitionKeyColumnRefs = (Seq)table.allColumns().filter((Function1 & Serializable & scala.Serializable)columnDef -> BoxesRunTime.boxToBoolean((boolean)nonPartitionKeyColumnNames.contains((Object)columnDef.columnName())));
        return nonPartitionKeyColumnRefs.forall((Function1 & Serializable & scala.Serializable)columnDef -> BoxesRunTime.boxToBoolean((boolean)TableWriter$.$anonfun$onlyPartitionKeyAndStatic$3(columnDef)));
    }

    private void checkCollectionBehaviors(TableDef table, IndexedSeq<ColumnRef> columnRefs) {
        IndexedSeq tableCollectionColumns = (IndexedSeq)table.columns().filter((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)cd.isCollection()));
        IndexedSeq tableCollectionColumnNames = (IndexedSeq)tableCollectionColumns.map((Function1 & Serializable & scala.Serializable)x$25 -> x$25.columnName(), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq tableListColumnNames = (IndexedSeq)((TraversableLike)tableCollectionColumns.map((Function1 & Serializable & scala.Serializable)c -> new Tuple2((Object)c.columnName(), c.columnType()), IndexedSeq$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, ColumnType<Object>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    String name = (String)A1._1();
                    ColumnType x = (ColumnType)A1._2();
                    if (x instanceof ListType) {
                        object = name;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, ColumnType<Object>> x1) {
                ColumnType x;
                Tuple2<String, ColumnType<Object>> tuple2 = x1;
                boolean bl = tuple2 != null && (x = (ColumnType)tuple2._2()) instanceof ListType;
                return bl;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq tableMapColumnNames = (IndexedSeq)((TraversableLike)tableCollectionColumns.map((Function1 & Serializable & scala.Serializable)c -> new Tuple2((Object)c.columnName(), c.columnType()), IndexedSeq$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, ColumnType<Object>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 != null) {
                    String name = (String)A1._1();
                    ColumnType x = (ColumnType)A1._2();
                    if (x instanceof MapType) {
                        object = name;
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, ColumnType<Object>> x2) {
                ColumnType x;
                Tuple2<String, ColumnType<Object>> tuple2 = x2;
                boolean bl = tuple2 != null && (x = (ColumnType)tuple2._2()) instanceof MapType;
                return bl;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq refsWithCollectionBehavior = (IndexedSeq)columnRefs.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ColumnRef, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 instanceof CollectionColumnName) {
                    CollectionColumnName collectionColumnName = (CollectionColumnName)A1;
                    object = collectionColumnName;
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(ColumnRef x3) {
                ColumnRef columnRef = x3;
                boolean bl = columnRef instanceof CollectionColumnName;
                return bl;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq collectionBehaviorColumnNames = (IndexedSeq)refsWithCollectionBehavior.map((Function1 & Serializable & scala.Serializable)x$26 -> x$26.columnName(), IndexedSeq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set collectionBehaviorNormalColumn = (scala.collection.immutable.Set)collectionBehaviorColumnNames.toSet().$minus$minus((GenTraversableOnce)tableCollectionColumnNames.toSet());
        if (collectionBehaviorNormalColumn.nonEmpty()) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(139).append("Collection behaviors (add/remove/append/prepend) are only allowed on collection columns.\n           |Normal Columns with illegal behavior: ").append(collectionBehaviorNormalColumn.mkString()).toString())).stripMargin());
        }
        IndexedSeq prependBehaviorColumnNames = (IndexedSeq)((TraversableLike)refsWithCollectionBehavior.filter((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)TableWriter$.$anonfun$checkCollectionBehaviors$6(x$27)))).map((Function1 & Serializable & scala.Serializable)x$28 -> x$28.columnName(), IndexedSeq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set prependOnNonList = (scala.collection.immutable.Set)prependBehaviorColumnNames.toSet().$minus$minus((GenTraversableOnce)tableListColumnNames.toSet());
        if (prependOnNonList.nonEmpty()) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(84).append("The prepend collection behavior only applies to Lists. Prepend used on:\n           |").append(prependOnNonList.mkString()).toString())).stripMargin());
        }
        IndexedSeq removeBehaviorColumnNames = (IndexedSeq)((TraversableLike)refsWithCollectionBehavior.filter((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)TableWriter$.$anonfun$checkCollectionBehaviors$8(x$29)))).map((Function1 & Serializable & scala.Serializable)x$30 -> x$30.columnName(), IndexedSeq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set removeOnMap = (scala.collection.immutable.Set)removeBehaviorColumnNames.toSet().$amp((GenSet)tableMapColumnNames.toSet());
        if (removeOnMap.nonEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(74).append("The remove operation is currently not supported for Maps. Remove used on: ").append(removeOnMap.mkString()).toString());
        }
    }

    private void checkColumns(TableDef table, IndexedSeq<ColumnRef> columnRefs, boolean checkPartitionKey) {
        IndexedSeq columnNames = (IndexedSeq)columnRefs.map((Function1 & Serializable & scala.Serializable)x$31 -> x$31.columnName(), IndexedSeq$.MODULE$.canBuildFrom());
        this.com$datastax$spark$connector$writer$TableWriter$$checkMissingColumns(table, (Seq<String>)columnNames);
        if (checkPartitionKey) {
            this.checkMissingPartitionKeyColumns(table, (Seq<String>)columnNames);
        } else if (this.onlyPartitionKeyAndStatic(table, (Seq<String>)columnNames)) {
            this.checkMissingPartitionKeyColumns(table, (Seq<String>)columnNames);
        } else {
            this.checkMissingPrimaryKeyColumns(table, (Seq<String>)columnNames);
        }
        this.checkCollectionBehaviors(table, columnRefs);
    }

    private Set<String> InternalColumns() {
        return this.InternalColumns;
    }

    public <T> TableWriter<T> apply(CassandraConnector connector, String keyspaceName, String tableName, ColumnSelector columnNames, WriteConf writeConf, boolean checkPartitionKey, RowWriterFactory<T> evidence$1) {
        TableDef tableDef = Schema$.MODULE$.tableFromCassandra(connector, keyspaceName, tableName);
        IndexedSeq selectedColumns = (IndexedSeq)columnNames.selectFrom(tableDef).filter((Function1 & Serializable & scala.Serializable)col -> BoxesRunTime.boxToBoolean((boolean)TableWriter$.$anonfun$apply$1(col)));
        Seq optionColumns = (Seq)writeConf.optionsAsColumns().apply((Object)keyspaceName, (Object)tableName);
        Seq x$1 = (Seq)tableDef.regularColumns().$plus$plus((GenTraversableOnce)optionColumns, Seq$.MODULE$.canBuildFrom());
        String x$2 = tableDef.copy$default$1();
        String x$3 = tableDef.copy$default$2();
        Seq<ColumnDef> x$4 = tableDef.copy$default$3();
        Seq<ColumnDef> x$5 = tableDef.copy$default$4();
        Seq<IndexDef> x$6 = tableDef.copy$default$6();
        boolean x$7 = tableDef.copy$default$7();
        RowWriter rowWriter = ((RowWriterFactory)Predef$.MODULE$.implicitly(evidence$1)).rowWriter(tableDef.copy(x$2, x$3, x$4, x$5, (Seq<ColumnDef>)x$1, x$6, x$7), (IndexedSeq<ColumnRef>)((IndexedSeq)selectedColumns.$plus$plus((GenTraversableOnce)optionColumns.map((Function1 & Serializable & scala.Serializable)x$32 -> x$32.ref(), Seq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom())));
        this.checkColumns(tableDef, (IndexedSeq<ColumnRef>)selectedColumns, checkPartitionKey);
        return new TableWriter(connector, tableDef, (IndexedSeq<ColumnRef>)selectedColumns, rowWriter, writeConf);
    }

    public <T> boolean apply$default$6() {
        return false;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$onlyPartitionKeyAndStatic$3(ColumnDef columnDef) {
        ColumnRole columnRole = columnDef.columnRole();
        StaticColumn$ staticColumn$ = StaticColumn$.MODULE$;
        return !(columnRole != null ? !columnRole.equals(staticColumn$) : staticColumn$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkCollectionBehaviors$6(CollectionColumnName x$27) {
        CollectionBehavior collectionBehavior = x$27.collectionBehavior();
        CollectionPrepend$ collectionPrepend$ = CollectionPrepend$.MODULE$;
        return !(collectionBehavior != null ? !collectionBehavior.equals(collectionPrepend$) : collectionPrepend$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkCollectionBehaviors$8(CollectionColumnName x$29) {
        CollectionBehavior collectionBehavior = x$29.collectionBehavior();
        CollectionRemove$ collectionRemove$ = CollectionRemove$.MODULE$;
        return !(collectionBehavior != null ? !collectionBehavior.equals(collectionRemove$) : collectionRemove$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$apply$1(ColumnRef col) {
        return !MODULE$.InternalColumns().contains((Object)col.columnName());
    }

    private TableWriter$() {
        MODULE$ = this;
        this.InternalColumns = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"solr_query"}));
    }
}

