/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.writer;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Session;
import com.datastax.spark.connector.CollectionAppend$;
import com.datastax.spark.connector.CollectionBehavior;
import com.datastax.spark.connector.CollectionColumnName;
import com.datastax.spark.connector.CollectionOverwrite$;
import com.datastax.spark.connector.CollectionPrepend$;
import com.datastax.spark.connector.CollectionRemove$;
import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.types.ListType;
import com.datastax.spark.connector.util.CountingIterator;
import com.datastax.spark.connector.util.CountingIterator$;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.util.Quote$;
import com.datastax.spark.connector.writer.BatchGroupingKey;
import com.datastax.spark.connector.writer.BatchGroupingKey$None$;
import com.datastax.spark.connector.writer.BatchGroupingKey$Partition$;
import com.datastax.spark.connector.writer.BatchGroupingKey$ReplicaSet$;
import com.datastax.spark.connector.writer.BatchStatementBuilder;
import com.datastax.spark.connector.writer.BoundStatementBuilder;
import com.datastax.spark.connector.writer.BoundStatementBuilder$;
import com.datastax.spark.connector.writer.GroupingBatchBuilder;
import com.datastax.spark.connector.writer.PerRowWriteOptionValue;
import com.datastax.spark.connector.writer.QueryExecutor;
import com.datastax.spark.connector.writer.RateLimiter;
import com.datastax.spark.connector.writer.RateLimiter$;
import com.datastax.spark.connector.writer.RichStatement;
import com.datastax.spark.connector.writer.RoutingKeyGenerator;
import com.datastax.spark.connector.writer.RowWriter;
import com.datastax.spark.connector.writer.RowWriterFactory;
import com.datastax.spark.connector.writer.StaticWriteOptionValue;
import com.datastax.spark.connector.writer.TTLOption;
import com.datastax.spark.connector.writer.TTLOption$;
import com.datastax.spark.connector.writer.TableWriter$;
import com.datastax.spark.connector.writer.TimestampOption;
import com.datastax.spark.connector.writer.WriteConf;
import com.datastax.spark.connector.writer.WriteOptionValue;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.TaskContext;
import org.apache.spark.metrics.OutputMetricsUpdater;
import org.apache.spark.metrics.OutputMetricsUpdater$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tue\u0001\u0002\u00192\u0001qB\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005)\"Aq\u000b\u0001B\u0001B\u0003%\u0001\f\u0003\u0005c\u0001\t\u0005\t\u0015!\u0003d\u0011!\u0011\bA!A!\u0002\u0013\u0019\b\"\u0002<\u0001\t\u00139\bb\u0002@\u0001\u0005\u0004%\ta \u0005\t\u0003/\u0001\u0001\u0015!\u0003\u0002\u0002!A\u0011\u0011\u0004\u0001C\u0002\u0013\u0005q\u0010\u0003\u0005\u0002\u001c\u0001\u0001\u000b\u0011BA\u0001\u0011%\ti\u0002\u0001b\u0001\n\u0003\ty\u0002\u0003\u0005\u0002(\u0001\u0001\u000b\u0011BA\u0011\u0011%\tI\u0003\u0001b\u0001\n\u0003\tY\u0003\u0003\u0005\u00026\u0001\u0001\u000b\u0011BA\u0017\u0011)\t9\u0004\u0001EC\u0002\u0013\u00051g \u0005\b\u0003s\u0001A\u0011BA\u001e\u0011)\t9\u0005\u0001EC\u0002\u0013\u00051g \u0005\u000b\u0003\u0013\u0002\u0001R1A\u0005\n\u0005-\u0003BCA*\u0001!\u0015\r\u0011\"\u0003\u0002V!I\u0011Q\f\u0001\t\u0006\u0004%Ia \u0005\n\u0003?\u0002!\u0019!C\u0005\u0003+B\u0001\"!\u0019\u0001A\u0003%\u0011q\u000b\u0005\n\u0003G\u0002!\u0019!C\u0005\u0003+B\u0001\"!\u001a\u0001A\u0003%\u0011q\u000b\u0005\u000b\u0003O\u0002!\u0019!C\u0001g\u0005U\u0003\u0002CA5\u0001\u0001\u0006I!a\u0016\t\u000f\u0005-\u0004\u0001\"\u0003\u0002n!9\u0011Q\u0012\u0001\u0005\u0002\u0005=\u0005bBAU\u0001\u0011\u0005\u00111\u0016\u0005\b\u0003'\u0004A\u0011AAk\u0011\u001d\tY\u000e\u0001C\u0001\u0003;Dq!a9\u0001\t\u0003\t)\u000fC\u0004\u0002p\u0002!I!!=\b\u000f\u0005e\u0018\u0007#\u0001\u0002|\u001a1\u0001'\rE\u0001\u0003{DaA^\u0012\u0005\u0002\u0005}\bb\u0002B\u0001G\u0011%!1\u0001\u0005\b\u0005\u0017\u0019C\u0011\u0002B\u0007\u0011\u001d\u0011\u0019b\tC\u0005\u0005+AqAa\u0007$\t\u0013\u0011i\u0002C\u0004\u0003$\r\"IA!\n\t\u000f\t52\u0005\"\u0003\u00030!I!\u0011H\u0012C\u0002\u0013%!1\b\u0005\t\u0005#\u001a\u0003\u0015!\u0003\u0003>!9!1K\u0012\u0005\u0002\tU\u0003\"\u0003B<GE\u0005I\u0011\u0001B=\u0011%\u0011\u0019jIA\u0001\n\u0013\u0011)JA\u0006UC\ndWm\u0016:ji\u0016\u0014(B\u0001\u001a4\u0003\u00199(/\u001b;fe*\u0011A'N\u0001\nG>tg.Z2u_JT!AN\u001c\u0002\u000bM\u0004\u0018M]6\u000b\u0005aJ\u0014\u0001\u00033bi\u0006\u001cH/\u0019=\u000b\u0003i\n1aY8n\u0007\u0001)\"!P5\u0014\t\u0001qDi\u0012\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0002\u0003\u0006)1oY1mC&\u00111\t\u0011\u0002\u0007\u0003:L(+\u001a4\u0011\u0005}*\u0015B\u0001$A\u00051\u0019VM]5bY&T\u0018M\u00197f!\tA5*D\u0001J\u0015\tQ5'\u0001\u0003vi&d\u0017B\u0001'J\u0005\u001daunZ4j]\u001e\u0004\"AT)\u000e\u0003=S!\u0001U\u001a\u0002\u0007\r\fH.\u0003\u0002S\u001f\n\u00112)Y:tC:$'/Y\"p]:,7\r^8s\u0003!!\u0018M\u00197f\t\u00164\u0007C\u0001(V\u0013\t1vJ\u0001\u0005UC\ndW\rR3g\u00039\u0019w\u000e\\;n]N+G.Z2u_J\u00042!\u0017/_\u001b\u0005Q&BA.A\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003;j\u0013!\"\u00138eKb,GmU3r!\ty\u0006-D\u00014\u0013\t\t7GA\u0005D_2,XN\u001c*fM\u0006I!o\\<Xe&$XM\u001d\t\u0004I\u0016<W\"A\u0019\n\u0005\u0019\f$!\u0003*po^\u0013\u0018\u000e^3s!\tA\u0017\u000e\u0004\u0001\u0005\u000b)\u0004!\u0019A6\u0003\u0003Q\u000b\"\u0001\\8\u0011\u0005}j\u0017B\u00018A\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"a\u00109\n\u0005E\u0004%aA!os\u0006IqO]5uK\u000e{gN\u001a\t\u0003IRL!!^\u0019\u0003\u0013]\u0013\u0018\u000e^3D_:4\u0017A\u0002\u001fj]&$h\b\u0006\u0004ysj\\H0 \t\u0004I\u00029\u0007\"\u0002\u001b\u0007\u0001\u0004i\u0005\"B*\u0007\u0001\u0004!\u0006\"B,\u0007\u0001\u0004A\u0006\"\u00022\u0007\u0001\u0004\u0019\u0007\"\u0002:\u0007\u0001\u0004\u0019\u0018\u0001D6fsN\u0004\u0018mY3OC6,WCAA\u0001!\u0011\t\u0019!!\u0005\u000f\t\u0005\u0015\u0011Q\u0002\t\u0004\u0003\u000f\u0001UBAA\u0005\u0015\r\tYaO\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005=\u0001)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003'\t)B\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u001f\u0001\u0015!D6fsN\u0004\u0018mY3OC6,\u0007%A\u0005uC\ndWMT1nK\u0006QA/\u00192mK:\u000bW.\u001a\u0011\u0002\u0017\r|G.^7o\u001d\u0006lWm]\u000b\u0003\u0003C\u0001R!WA\u0012\u0003\u0003I1!!\n[\u0005\r\u0019V-]\u0001\rG>dW/\u001c8OC6,7\u000fI\u0001\bG>dW/\u001c8t+\t\ti\u0003E\u0003Z\u0003G\ty\u0003E\u0002O\u0003cI1!a\rP\u0005%\u0019u\u000e\\;n]\u0012+g-\u0001\u0005d_2,XN\\:!\u0003a\tX/\u001a:z)\u0016l\u0007\u000f\\1uKV\u001b\u0018N\\4J]N,'\u000f^\u0001\u0014I\u0016dW\r^3Rk\u0016\u0014\u0018\u0010V3na2\fG/\u001a\u000b\u0005\u0003\u0003\ti\u0004C\u0004\u0002@A\u0001\r!!\u0011\u0002\u001b\u0011,G.\u001a;f\u0007>dW/\u001c8t!\ry\u00161I\u0005\u0004\u0003\u000b\u001a$AD\"pYVlgnU3mK\u000e$xN]\u0001\u0019cV,'/\u001f+f[Bd\u0017\r^3Vg&tw-\u00169eCR,\u0017!\u0004;j[\u0016\u001cH/Y7q'B,7-\u0006\u0002\u0002NA)q(a\u0014\u0002\u0002%\u0019\u0011\u0011\u000b!\u0003\r=\u0003H/[8o\u0003)!H\u000f\\#oC\ndW\rZ\u000b\u0003\u0003/\u00022aPA-\u0013\r\tY\u0006\u0011\u0002\b\u0005>|G.Z1o\u0003-y\u0007\u000f^5p]N\u001c\u0006/Z2\u0002\u001f%\u001c8i\\;oi\u0016\u0014X\u000b\u001d3bi\u0016\f\u0001#[:D_VtG/\u001a:Va\u0012\fG/\u001a\u0011\u00027\r|g\u000e^1j]N\u001cu\u000e\u001c7fGRLwN\u001c\"fQ\u00064\u0018n\u001c:t\u0003q\u0019wN\u001c;bS:\u001c8i\u001c7mK\u000e$\u0018n\u001c8CK\"\fg/[8sg\u0002\nA\"[:JI\u0016l\u0007o\u001c;f]R\fQ\"[:JI\u0016l\u0007o\u001c;f]R\u0004\u0013\u0001\u00059sKB\f'/Z*uCR,W.\u001a8u)\u0019\ty'a \u0002\u0004B!\u0011\u0011OA>\u001b\t\t\u0019H\u0003\u0003\u0002v\u0005]\u0014\u0001B2pe\u0016T1!!\u001f8\u0003\u0019!'/\u001b<fe&!\u0011QPA:\u0005E\u0001&/\u001a9be\u0016$7\u000b^1uK6,g\u000e\u001e\u0005\b\u0003\u0003[\u0002\u0019AA\u0001\u00035\tX/\u001a:z)\u0016l\u0007\u000f\\1uK\"9\u0011QQ\u000eA\u0002\u0005\u001d\u0015aB:fgNLwN\u001c\t\u0005\u0003c\nI)\u0003\u0003\u0002\f\u0006M$aB*fgNLwN\\\u0001\u0010E\u0006$8\r\u001b*pkRLgnZ&fsR1\u0011\u0011SAO\u0003?#2a\\AJ\u0011\u001d\t)\n\ba\u0001\u0003/\u000b!AY:\u0011\t\u0005E\u0014\u0011T\u0005\u0005\u00037\u000b\u0019H\u0001\bC_VtGm\u0015;bi\u0016lWM\u001c;\t\u000f\u0005\u0015E\u00041\u0001\u0002\b\"9\u0011\u0011\u0015\u000fA\u0002\u0005\r\u0016a\u0005:pkRLgnZ&fs\u001e+g.\u001a:bi>\u0014\bc\u00013\u0002&&\u0019\u0011qU\u0019\u0003'I{W\u000f^5oO.+\u0017pR3oKJ\fGo\u001c:\u0002\u000b]\u0014\u0018\u000e^3\u0015\r\u00055\u00161WAe!\ry\u0014qV\u0005\u0004\u0003c\u0003%\u0001B+oSRDq!!.\u001e\u0001\u0004\t9,A\u0006uCN\\7i\u001c8uKb$\b\u0003BA]\u0003\u000bl!!a/\u000b\u0007Y\niL\u0003\u0003\u0002@\u0006\u0005\u0017AB1qC\u000eDWM\u0003\u0002\u0002D\u0006\u0019qN]4\n\t\u0005\u001d\u00171\u0018\u0002\f)\u0006\u001c8nQ8oi\u0016DH\u000fC\u0004\u0002Lv\u0001\r!!4\u0002\t\u0011\fG/\u0019\t\u00053\u0006=w-C\u0002\u0002Rj\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\u0007kB$\u0017\r^3\u0015\r\u00055\u0016q[Am\u0011\u001d\t)L\ba\u0001\u0003oCq!a3\u001f\u0001\u0004\ti-\u0001\u0004j]N,'\u000f\u001e\u000b\u0007\u0003[\u000by.!9\t\u000f\u0005Uv\u00041\u0001\u00028\"9\u00111Z\u0010A\u0002\u00055\u0017A\u00023fY\u0016$X\r\u0006\u0003\u0002h\u00065HCBAW\u0003S\fY\u000fC\u0004\u00026\u0002\u0002\r!a.\t\u000f\u0005-\u0007\u00051\u0001\u0002N\"9\u0011\u0011\u0006\u0011A\u0002\u0005\u0005\u0013!D<sSR,\u0017J\u001c;fe:\fG\u000e\u0006\u0005\u0002.\u0006M\u0018Q_A|\u0011\u001d\t\t)\ta\u0001\u0003\u0003Aq!!.\"\u0001\u0004\t9\fC\u0004\u0002L\u0006\u0002\r!!4\u0002\u0017Q\u000b'\r\\3Xe&$XM\u001d\t\u0003I\u000e\u001a2a\t E)\t\tY0A\ndQ\u0016\u001c7.T5tg&twmQ8mk6t7\u000f\u0006\u0004\u0002.\n\u0015!\u0011\u0002\u0005\u0007\u0005\u000f)\u0003\u0019\u0001+\u0002\u000bQ\f'\r\\3\t\u000f\u0005uQ\u00051\u0001\u0002\"\u0005i2\r[3dW6K7o]5oOB\u0013\u0018.\\1ss.+\u0017pQ8mk6t7\u000f\u0006\u0004\u0002.\n=!\u0011\u0003\u0005\u0007\u0005\u000f1\u0003\u0019\u0001+\t\u000f\u0005ua\u00051\u0001\u0002\"\u0005y2\r[3dW6K7o]5oOB\u000b'\u000f^5uS>t7*Z=D_2,XN\\:\u0015\r\u00055&q\u0003B\r\u0011\u0019\u00119a\na\u0001)\"9\u0011QD\u0014A\u0002\u0005\u0005\u0012!G8oYf\u0004\u0016M\u001d;ji&|gnS3z\u0003:$7\u000b^1uS\u000e$b!a\u0016\u0003 \t\u0005\u0002B\u0002B\u0004Q\u0001\u0007A\u000bC\u0004\u0002\u001e!\u0002\r!!\t\u00021\rDWmY6D_2dWm\u0019;j_:\u0014U\r[1wS>\u00148\u000f\u0006\u0004\u0002.\n\u001d\"\u0011\u0006\u0005\u0007\u0005\u000fI\u0003\u0019\u0001+\t\r\t-\u0012\u00061\u0001Y\u0003)\u0019w\u000e\\;n]J+gm]\u0001\rG\",7m[\"pYVlgn\u001d\u000b\t\u0003[\u0013\tDa\r\u00036!1!q\u0001\u0016A\u0002QCaAa\u000b+\u0001\u0004A\u0006b\u0002B\u001cU\u0001\u0007\u0011qK\u0001\u0012G\",7m\u001b)beRLG/[8o\u0017\u0016L\u0018aD%oi\u0016\u0014h.\u00197D_2,XN\\:\u0016\u0005\tu\u0002#B-\u0003@\t\r\u0013b\u0001B!5\n\u00191+\u001a;\u0011\t\t\u0015#qJ\u0007\u0003\u0005\u000fRAA!\u0013\u0003L\u0005!A.\u00198h\u0015\t\u0011i%\u0001\u0003kCZ\f\u0017\u0002BA\n\u0005\u000f\n\u0001#\u00138uKJt\u0017\r\\\"pYVlgn\u001d\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\t\t]#q\f\u000b\u000f\u00053\u0012YG!\u001c\u0003p\tE$1\u000fB;)\u0011\u0011YF!\u0019\u0011\t\u0011\u0004!Q\f\t\u0004Q\n}C!\u00026.\u0005\u0004Y\u0007\"\u0003B2[\u0005\u0005\t9\u0001B3\u0003))g/\u001b3f]\u000e,G%\r\t\u0006I\n\u001d$QL\u0005\u0004\u0005S\n$\u0001\u0005*po^\u0013\u0018\u000e^3s\r\u0006\u001cGo\u001c:z\u0011\u0015!T\u00061\u0001N\u0011\u0019qX\u00061\u0001\u0002\u0002!9\u0011\u0011D\u0017A\u0002\u0005\u0005\u0001bBA\u000f[\u0001\u0007\u0011\u0011\t\u0005\u0006e6\u0002\ra\u001d\u0005\n\u0005oi\u0003\u0013!a\u0001\u0003/\nq\"\u00199qYf$C-\u001a4bk2$HEN\u000b\u0005\u0005w\u0012\t*\u0006\u0002\u0003~)\"\u0011q\u000bB@W\t\u0011\t\t\u0005\u0003\u0003\u0004\n5UB\u0001BC\u0015\u0011\u00119I!#\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BF\u0001\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t=%Q\u0011\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G!\u00026/\u0005\u0004Y\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa&\u0011\t\t\u0015#\u0011T\u0005\u0005\u00057\u00139E\u0001\u0004PE*,7\r\u001e")
public class TableWriter<T>
implements scala.Serializable,
Logging {
    private String queryTemplateUsingInsert;
    private String queryTemplateUsingUpdate;
    private Option<String> timestampSpec;
    private boolean ttlEnabled;
    private String optionsSpec;
    private final CassandraConnector connector;
    private final TableDef tableDef;
    private final IndexedSeq<ColumnRef> columnSelector;
    private final RowWriter<T> rowWriter;
    private final WriteConf writeConf;
    private final String keyspaceName;
    private final String tableName;
    private final Seq<String> columnNames;
    private final Seq<ColumnDef> columns;
    private final boolean isCounterUpdate;
    private final boolean containsCollectionBehaviors;
    private final boolean isIdempotent;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;
    private volatile byte bitmap$0;

    public static <T> boolean apply$default$6() {
        return TableWriter$.MODULE$.apply$default$6();
    }

    public static <T> TableWriter<T> apply(CassandraConnector cassandraConnector, String string, String string2, ColumnSelector columnSelector, WriteConf writeConf, boolean bl, RowWriterFactory<T> rowWriterFactory) {
        return TableWriter$.MODULE$.apply(cassandraConnector, string, string2, columnSelector, writeConf, bl, rowWriterFactory);
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    @Override
    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    public String keyspaceName() {
        return this.keyspaceName;
    }

    public String tableName() {
        return this.tableName;
    }

    public Seq<String> columnNames() {
        return this.columnNames;
    }

    public Seq<ColumnDef> columns() {
        return this.columns;
    }

    private String queryTemplateUsingInsert$lzycompute() {
        TableWriter tableWriter = this;
        synchronized (tableWriter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Seq quotedColumnNames = (Seq)this.columnNames().map((Function1 & Serializable & scala.Serializable)name -> Quote$.MODULE$.quote((String)name), Seq$.MODULE$.canBuildFrom());
                String columnSpec = quotedColumnNames.mkString(", ");
                String valueSpec = ((TraversableOnce)quotedColumnNames.map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(1).append(":").append((String)x$1).toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
                String ifNotExistsSpec = this.writeConf.ifNotExists() ? "IF NOT EXISTS " : "";
                this.queryTemplateUsingInsert = new StringBuilder(27).append("INSERT INTO ").append(Quote$.MODULE$.quote(this.keyspaceName())).append(".").append(Quote$.MODULE$.quote(this.tableName())).append(" (").append(columnSpec).append(") VALUES (").append(valueSpec).append(") ").append(ifNotExistsSpec).append(this.optionsSpec()).toString().trim();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.queryTemplateUsingInsert;
    }

    public String queryTemplateUsingInsert() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.queryTemplateUsingInsert$lzycompute() : this.queryTemplateUsingInsert;
    }

    private String deleteQueryTemplate(ColumnSelector deleteColumns) {
        String usingTimestampClause;
        Seq deleteColumnNames = (Seq)deleteColumns.selectFrom(this.tableDef).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.columnName(), IndexedSeq$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = this.columns().partition((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isPrimaryKeyColumn()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq primaryKey = (Seq)tuple2._1();
        Seq regularColumns = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)primaryKey, (Object)regularColumns);
        Tuple2 tuple23 = tuple22;
        Seq primaryKey2 = (Seq)tuple23._1();
        Seq regularColumns2 = (Seq)tuple23._2();
        if (regularColumns2.nonEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(71).append("Only primary key columns can be used in delete. Regular columns found: ").append(regularColumns2.mkString(", ")).toString());
        }
        TableWriter$.MODULE$.com$datastax$spark$connector$writer$TableWriter$$checkMissingColumns(this.tableDef, (Seq<String>)deleteColumnNames);
        String deleteColumnsClause = ((TraversableOnce)deleteColumnNames.map((Function1 & Serializable & scala.Serializable)name -> Quote$.MODULE$.quote((String)name), Seq$.MODULE$.canBuildFrom())).mkString(", ");
        String whereClause = ((TraversableOnce)TableWriter.quotedColumnNames$1(primaryKey2).map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(4).append((String)c).append(" = :").append((String)c).toString(), Seq$.MODULE$.canBuildFrom())).mkString(" AND ");
        String string = usingTimestampClause = this.timestampSpec().nonEmpty() ? new StringBuilder(6).append("USING ").append(this.timestampSpec().get()).toString() : "";
        if (this.ttlEnabled()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append($this.writeConf.ttl()).append(" is ignored for DELETE query").toString());
        }
        return new StringBuilder(22).append("DELETE ").append(deleteColumnsClause).append(" FROM ").append(Quote$.MODULE$.quote(this.keyspaceName())).append(".").append(Quote$.MODULE$.quote(this.tableName())).append(" ").append(usingTimestampClause).append(" WHERE ").append(whereClause).toString();
    }

    private String queryTemplateUsingUpdate$lzycompute() {
        TableWriter tableWriter = this;
        synchronized (tableWriter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Tuple2 tuple2 = this.columns().partition((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isPrimaryKeyColumn()));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Seq primaryKey = (Seq)tuple2._1();
                Seq regularColumns = (Seq)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)primaryKey, (Object)regularColumns);
                Tuple2 tuple23 = tuple22;
                Seq primaryKey2 = (Seq)tuple23._1();
                Seq regularColumns2 = (Seq)tuple23._2();
                Tuple2 tuple24 = regularColumns2.partition((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isCounterColumn()));
                if (tuple24 == null) {
                    throw new MatchError((Object)tuple24);
                }
                Seq counterColumns = (Seq)tuple24._1();
                Seq nonCounterColumns = (Seq)tuple24._2();
                Tuple2 tuple25 = new Tuple2((Object)counterColumns, (Object)nonCounterColumns);
                Tuple2 tuple26 = tuple25;
                Seq counterColumns2 = (Seq)tuple26._1();
                Seq nonCounterColumns2 = (Seq)tuple26._2();
                Map nameToBehavior = ((TraversableOnce)this.columnSelector.collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends ColumnRef, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof CollectionColumnName) {
                            CollectionColumnName collectionColumnName = (CollectionColumnName)A1;
                            object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)collectionColumnName.columnName()), (Object)collectionColumnName.collectionBehavior());
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(ColumnRef x1) {
                        ColumnRef columnRef = x1;
                        boolean bl = columnRef instanceof CollectionColumnName;
                        return bl;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                Seq setNonCounterColumnsClause = (Seq)((TraversableLike)nonCounterColumns2.map((Function1 & Serializable & scala.Serializable)colDef -> {
                    String name = colDef.columnName();
                    Option collectionBehavior = nameToBehavior.get((Object)name);
                    String quotedName = Quote$.MODULE$.quote(name);
                    return new Tuple4(colDef, (Object)name, (Object)collectionBehavior, (Object)quotedName);
                }, Seq$.MODULE$.canBuildFrom())).map(TableWriter::$anonfun$queryTemplateUsingUpdate$4, Seq$.MODULE$.canBuildFrom());
                Seq setCounterColumnsClause = (Seq)TableWriter.quotedColumnNames$2(counterColumns2).map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(7).append((String)c).append(" = ").append((String)c).append(" + :").append((String)c).toString(), Seq$.MODULE$.canBuildFrom());
                String setClause = ((TraversableOnce)setNonCounterColumnsClause.$plus$plus((GenTraversableOnce)setCounterColumnsClause, Seq$.MODULE$.canBuildFrom())).mkString(", ");
                String whereClause = ((TraversableOnce)TableWriter.quotedColumnNames$2(primaryKey2).map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(4).append((String)c).append(" = :").append((String)c).toString(), Seq$.MODULE$.canBuildFrom())).mkString(" AND ");
                this.queryTemplateUsingUpdate = new StringBuilder(21).append("UPDATE ").append(Quote$.MODULE$.quote(this.keyspaceName())).append(".").append(Quote$.MODULE$.quote(this.tableName())).append(" ").append(this.optionsSpec()).append(" SET ").append(setClause).append(" WHERE ").append(whereClause).toString();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.queryTemplateUsingUpdate;
    }

    public String queryTemplateUsingUpdate() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.queryTemplateUsingUpdate$lzycompute() : this.queryTemplateUsingUpdate;
    }

    private Option<String> timestampSpec$lzycompute() {
        TableWriter tableWriter = this;
        synchronized (tableWriter) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                WriteOptionValue<Object> writeOptionValue;
                None$ none$;
                WriteOptionValue<Object> writeOptionValue2;
                TimestampOption timestampOption = this.writeConf.timestamp();
                if (timestampOption != null && (writeOptionValue2 = timestampOption.value()) instanceof PerRowWriteOptionValue) {
                    PerRowWriteOptionValue perRowWriteOptionValue = (PerRowWriteOptionValue)writeOptionValue2;
                    String placeholder = perRowWriteOptionValue.placeholder();
                    none$ = new Some((Object)new StringBuilder(11).append("TIMESTAMP :").append(placeholder).toString());
                } else if (timestampOption != null && (writeOptionValue = timestampOption.value()) instanceof StaticWriteOptionValue) {
                    StaticWriteOptionValue staticWriteOptionValue = (StaticWriteOptionValue)writeOptionValue;
                    long value = BoxesRunTime.unboxToLong(staticWriteOptionValue.value());
                    none$ = new Some((Object)new StringBuilder(10).append("TIMESTAMP ").append(value).toString());
                } else {
                    none$ = None$.MODULE$;
                }
                this.timestampSpec = none$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.timestampSpec;
    }

    private Option<String> timestampSpec() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.timestampSpec$lzycompute() : this.timestampSpec;
    }

    private boolean ttlEnabled$lzycompute() {
        TableWriter tableWriter = this;
        synchronized (tableWriter) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                TTLOption tTLOption = this.writeConf.ttl();
                TTLOption tTLOption2 = TTLOption$.MODULE$.defaultValue();
                this.ttlEnabled = tTLOption == null ? tTLOption2 != null : !((Object)tTLOption).equals(tTLOption2);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.ttlEnabled;
    }

    private boolean ttlEnabled() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.ttlEnabled$lzycompute() : this.ttlEnabled;
    }

    private String optionsSpec$lzycompute() {
        TableWriter tableWriter = this;
        synchronized (tableWriter) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                WriteOptionValue<Object> writeOptionValue;
                None$ none$;
                WriteOptionValue<Object> writeOptionValue2;
                TTLOption tTLOption = this.writeConf.ttl();
                if (tTLOption != null && (writeOptionValue2 = tTLOption.value()) instanceof PerRowWriteOptionValue) {
                    PerRowWriteOptionValue perRowWriteOptionValue = (PerRowWriteOptionValue)writeOptionValue2;
                    String placeholder = perRowWriteOptionValue.placeholder();
                    none$ = new Some((Object)new StringBuilder(5).append("TTL :").append(placeholder).toString());
                } else if (tTLOption != null && (writeOptionValue = tTLOption.value()) instanceof StaticWriteOptionValue) {
                    StaticWriteOptionValue staticWriteOptionValue = (StaticWriteOptionValue)writeOptionValue;
                    int value = BoxesRunTime.unboxToInt(staticWriteOptionValue.value());
                    none$ = new Some((Object)new StringBuilder(4).append("TTL ").append(value).toString());
                } else {
                    none$ = None$.MODULE$;
                }
                None$ ttlSpec = none$;
                List options = (List)new .colon.colon((Object)ttlSpec, (List)new .colon.colon(this.timestampSpec(), (List)Nil$.MODULE$)).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
                this.optionsSpec = options.nonEmpty() ? new StringBuilder(6).append("USING ").append(options.mkString(" AND ")).toString() : "";
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.optionsSpec;
    }

    private String optionsSpec() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.optionsSpec$lzycompute() : this.optionsSpec;
    }

    private boolean isCounterUpdate() {
        return this.isCounterUpdate;
    }

    private boolean containsCollectionBehaviors() {
        return this.containsCollectionBehaviors;
    }

    public boolean isIdempotent() {
        return this.isIdempotent;
    }

    private PreparedStatement prepareStatement(String queryTemplate, Session session) {
        PreparedStatement preparedStatement;
        try {
            preparedStatement = session.prepare(queryTemplate).setIdempotent(Predef$.MODULE$.boolean2Boolean(this.isIdempotent()));
        }
        catch (Throwable t) {
            throw new IOException(new StringBuilder(30).append("Failed to prepare statement ").append(queryTemplate).append(": ").append(t.getMessage()).toString(), t);
        }
        return preparedStatement;
    }

    public Object batchRoutingKey(Session session, RoutingKeyGenerator routingKeyGenerator, BoundStatement bs) {
        Comparable<Integer> comparable;
        BatchGroupingKey batchGroupingKey = this.writeConf.batchGroupingKey();
        if (BatchGroupingKey$None$.MODULE$.equals(batchGroupingKey)) {
            comparable = BoxesRunTime.boxToInteger((int)0);
        } else if (BatchGroupingKey$ReplicaSet$.MODULE$.equals(batchGroupingKey)) {
            Object object = bs.getRoutingKey(ProtocolVersion.NEWEST_SUPPORTED, CodecRegistry.DEFAULT_INSTANCE) == null ? bs.setRoutingKey(routingKeyGenerator.apply(bs)) : BoxedUnit.UNIT;
            comparable = BoxesRunTime.boxToInteger((int)((Object)session.getCluster().getMetadata().getReplicas(this.keyspaceName(), bs.getRoutingKey(ProtocolVersion.NEWEST_SUPPORTED, CodecRegistry.DEFAULT_INSTANCE))).hashCode());
        } else if (BatchGroupingKey$Partition$.MODULE$.equals(batchGroupingKey)) {
            Object object = bs.getRoutingKey(ProtocolVersion.NEWEST_SUPPORTED, CodecRegistry.DEFAULT_INSTANCE) == null ? bs.setRoutingKey(routingKeyGenerator.apply(bs)) : BoxedUnit.UNIT;
            comparable = bs.getRoutingKey(ProtocolVersion.NEWEST_SUPPORTED, CodecRegistry.DEFAULT_INSTANCE).duplicate();
        } else {
            throw new MatchError((Object)batchGroupingKey);
        }
        return comparable;
    }

    public void write(TaskContext taskContext, Iterator<T> data) {
        if (this.isCounterUpdate() || this.containsCollectionBehaviors()) {
            this.update(taskContext, data);
        } else {
            this.insert(taskContext, data);
        }
    }

    public void update(TaskContext taskContext, Iterator<T> data) {
        this.writeInternal(this.queryTemplateUsingUpdate(), taskContext, data);
    }

    public void insert(TaskContext taskContext, Iterator<T> data) {
        this.writeInternal(this.queryTemplateUsingInsert(), taskContext, data);
    }

    public void delete(ColumnSelector columns, TaskContext taskContext, Iterator<T> data) {
        this.writeInternal(this.deleteQueryTemplate(columns), taskContext, data);
    }

    private void writeInternal(String queryTemplate, TaskContext taskContext, Iterator<T> data) {
        OutputMetricsUpdater updater = OutputMetricsUpdater$.MODULE$.apply(taskContext, this.writeConf);
        this.connector.withSessionDo((Function1 & Serializable & scala.Serializable)session -> {
            TableWriter.$anonfun$writeInternal$1(this, data, queryTemplate, updater, session);
            return BoxedUnit.UNIT;
        });
    }

    private static final Seq quotedColumnNames$1(Seq columns) {
        return (Seq)((TraversableLike)columns.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.columnName(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)name -> Quote$.MODULE$.quote((String)name), Seq$.MODULE$.canBuildFrom());
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ String $anonfun$queryTemplateUsingUpdate$4(Tuple4 x$10) {
        var1_1 = x$10;
        if (var1_1 == null) ** GOTO lbl26
        collectionBehavior = (Option)var1_1._3();
        quotedName = (String)var1_1._4();
        var4_4 = false;
        var5_5 = null;
        var6_6 = collectionBehavior;
        if (!(var6_6 instanceof Some)) ** GOTO lbl-1000
        var4_4 = true;
        var5_5 = (Some)var6_6;
        var7_7 = (CollectionBehavior)var5_5.value();
        if (CollectionAppend$.MODULE$.equals(var7_7)) {
            var8_8 = new StringBuilder(7).append(quotedName).append(" = ").append(quotedName).append(" + :").append(quotedName).toString();
        } else if (var4_4 && CollectionPrepend$.MODULE$.equals(var9_9 = (CollectionBehavior)var5_5.value())) {
            var8_8 = new StringBuilder(7).append(quotedName).append(" = :").append(quotedName).append(" + ").append(quotedName).toString();
        } else if (var4_4 && CollectionRemove$.MODULE$.equals(var10_10 = (CollectionBehavior)var5_5.value())) {
            var8_8 = new StringBuilder(7).append(quotedName).append(" = ").append(quotedName).append(" - :").append(quotedName).toString();
        } else {
            var13_13 = var6_6 instanceof Some != false && CollectionOverwrite$.MODULE$.equals(var12_12 = (CollectionBehavior)(var11_11 = (Some)var6_6).value()) != false ? true : None$.MODULE$.equals(var6_6) != false;
            if (var13_13) {
                var8_8 = new StringBuilder(4).append(quotedName).append(" = :").append(quotedName).toString();
            } else {
                throw new MatchError((Object)var6_6);
lbl26:
                // 1 sources

                throw new MatchError((Object)var1_1);
            }
        }
        var14_14 = var8_8;
        return var14_14;
    }

    private static final Seq quotedColumnNames$2(Seq columns) {
        return (Seq)((TraversableLike)columns.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.columnName(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)name -> Quote$.MODULE$.quote((String)name), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$containsCollectionBehaviors$1(ColumnRef x$13) {
        return x$13 instanceof CollectionColumnName;
    }

    public static final /* synthetic */ boolean $anonfun$isIdempotent$2(TableWriter $this, ColumnRef x0$1) {
        boolean bl;
        ColumnRef columnRef = x0$1;
        if (columnRef instanceof CollectionColumnName) {
            CollectionColumnName collectionColumnName = (CollectionColumnName)columnRef;
            String name = collectionColumnName.columnName();
            CollectionBehavior behavior = collectionColumnName.collectionBehavior();
            boolean isNotList = !(((ColumnDef)$this.tableDef.columnByName().apply((Object)name)).columnType() instanceof ListType);
            CollectionBehavior collectionBehavior = behavior;
            boolean bl2 = CollectionPrepend$.MODULE$.equals(collectionBehavior) ? isNotList : (CollectionAppend$.MODULE$.equals(collectionBehavior) ? isNotList : true);
            bl = bl2;
        } else if (columnRef != null) {
            bl = true;
        } else {
            throw new MatchError((Object)columnRef);
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$writeInternal$6(QueryExecutor queryExecutor$1, RateLimiter rateLimiter$1, RichStatement stmtToWrite) {
        queryExecutor$1.executeAsync(stmtToWrite);
        Predef$.MODULE$.assert(stmtToWrite.bytesCount() > 0);
        rateLimiter$1.maybeSleep(stmtToWrite.bytesCount());
    }

    public static final /* synthetic */ void $anonfun$writeInternal$1(TableWriter $this, Iterator data$1, String queryTemplate$1, OutputMetricsUpdater updater$1, Session session) {
        block0: {
            ProtocolVersion protocolVersion = session.getCluster().getConfiguration().getProtocolOptions().getProtocolVersion();
            CountingIterator rowIterator = new CountingIterator(data$1, CountingIterator$.MODULE$.$lessinit$greater$default$2());
            PreparedStatement stmt = $this.prepareStatement(queryTemplate$1, session).setConsistencyLevel($this.writeConf.consistencyLevel());
            QueryExecutor queryExecutor = new QueryExecutor(session, $this.writeConf.parallelismLevel(), (Option<Function3<RichStatement, Object, Object, BoxedUnit>>)new Some((Function3 & Serializable & scala.Serializable)(x$15, x$16, x$17) -> {
                updater$1.batchFinished(true, x$15, BoxesRunTime.unboxToLong((Object)x$16), BoxesRunTime.unboxToLong((Object)x$17));
                return BoxedUnit.UNIT;
            }), (Option<Function3<RichStatement, Object, Object, BoxedUnit>>)new Some((Function3 & Serializable & scala.Serializable)(x$18, x$19, x$20) -> {
                updater$1.batchFinished(false, x$18, BoxesRunTime.unboxToLong((Object)x$19), BoxesRunTime.unboxToLong((Object)x$20));
                return BoxedUnit.UNIT;
            }));
            RoutingKeyGenerator routingKeyGenerator = new RoutingKeyGenerator($this.tableDef, $this.columnNames());
            BatchStatement.Type batchType = $this.isCounterUpdate() ? BatchStatement.Type.COUNTER : BatchStatement.Type.UNLOGGED;
            RowWriter x$1 = $this.rowWriter;
            PreparedStatement x$2 = stmt;
            ProtocolVersion x$3 = protocolVersion;
            boolean x$4 = $this.writeConf.ignoreNulls();
            Seq<Object> x$5 = BoundStatementBuilder$.MODULE$.$lessinit$greater$default$3();
            BoundStatementBuilder boundStmtBuilder = new BoundStatementBuilder(x$1, x$2, x$5, x$4, x$3);
            BatchStatementBuilder batchStmtBuilder = new BatchStatementBuilder(batchType, routingKeyGenerator, $this.writeConf.consistencyLevel());
            Function1 & Serializable & scala.Serializable batchKeyGenerator = (Function1 & Serializable & scala.Serializable)bs -> $this.batchRoutingKey(session, routingKeyGenerator, (BoundStatement)bs);
            GroupingBatchBuilder batchBuilder = new GroupingBatchBuilder(boundStmtBuilder, batchStmtBuilder, (Function1<BoundStatement, Object>)batchKeyGenerator, $this.writeConf.batchSize(), $this.writeConf.batchGroupingBufferSize(), rowIterator);
            RateLimiter rateLimiter = new RateLimiter((long)($this.writeConf.throughputMiBPS() * (double)1024 * (double)1024), 0x100000L, RateLimiter$.MODULE$.$lessinit$greater$default$3(), RateLimiter$.MODULE$.$lessinit$greater$default$4());
            $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Writing data partition to ").append($this.keyspaceName()).append(".").append($this.tableName()).append(" in batches of ").append($this.writeConf.batchSize()).append(".").toString());
            batchBuilder.foreach((Function1 & Serializable & scala.Serializable)stmtToWrite -> {
                TableWriter.$anonfun$writeInternal$6(queryExecutor, rateLimiter, stmtToWrite);
                return BoxedUnit.UNIT;
            });
            queryExecutor.waitForCurrentlyExecutingTasks();
            queryExecutor.getLatestException().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Throwable throwable = x0$1;
                throw new IOException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(206).append("Failed to write statements to ").append($this.keyspaceName()).append(".").append($this.tableName()).append(". The\n               |latest exception was\n               |  ").append(throwable.getMessage()).append("\n               |\n               |Please check the executor logs for more exceptions and information\n             ").toString())).stripMargin());
            });
            double duration = (double)updater$1.finish() / 1.0E9;
            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                Integer arg$macro$1 = BoxesRunTime.boxToInteger((int)rowIterator.count());
                String arg$macro$2 = $this.keyspaceName();
                String arg$macro$3 = $this.tableName();
                double arg$macro$4 = duration;
                return new StringOps("Wrote %s rows to %s.%s in %.3f s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, arg$macro$3, BoxesRunTime.boxToDouble((double)arg$macro$4)}));
            });
            if (!boundStmtBuilder.logUnsetToNullWarning()) break block0;
            $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> boundStmtBuilder.UnsetToNullWarning());
        }
    }

    public TableWriter(CassandraConnector connector, TableDef tableDef, IndexedSeq<ColumnRef> columnSelector, RowWriter<T> rowWriter, WriteConf writeConf) {
        this.connector = connector;
        this.tableDef = tableDef;
        this.columnSelector = columnSelector;
        this.rowWriter = rowWriter;
        this.writeConf = writeConf;
        Logging.$init$(this);
        Predef$.MODULE$.require(!tableDef.isView(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append($this.tableDef.name()).append(" is a Materialized View and Views are not writable").toString());
        this.keyspaceName = tableDef.keyspaceName();
        this.tableName = tableDef.tableName();
        this.columnNames = (Seq)rowWriter.columnNames().diff(writeConf.optionPlaceholders());
        this.columns = (Seq)this.columnNames().map(tableDef.columnByName(), Seq$.MODULE$.canBuildFrom());
        this.isCounterUpdate = tableDef.columns().exists((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.isCounterColumn()));
        this.containsCollectionBehaviors = columnSelector.exists((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)TableWriter.$anonfun$containsCollectionBehaviors$1(x$13)));
        this.isIdempotent = ((TraversableOnce)this.columns().filter((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.isCounterColumn()))).nonEmpty() ? false : columnSelector.forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TableWriter.$anonfun$isIdempotent$2(this, x0$1)));
    }
}

