/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.writer;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.DataType;
import com.datastax.spark.connector.BatchSize;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.RegularColumn$;
import com.datastax.spark.connector.types.ColumnType$;
import com.datastax.spark.connector.util.ConfigParameter;
import com.datastax.spark.connector.writer.BatchGroupingKey;
import com.datastax.spark.connector.writer.PerRowWriteOptionValue;
import com.datastax.spark.connector.writer.TTLOption;
import com.datastax.spark.connector.writer.TimestampOption;
import com.datastax.spark.connector.writer.WriteConf$;
import com.datastax.spark.connector.writer.WriteOption;
import com.datastax.spark.connector.writer.WriteOption$;
import com.datastax.spark.connector.writer.WriteOptionValue;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple11;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\rme\u0001B6m\u0001^D!\"!\u0003\u0001\u0005+\u0007I\u0011AA\u0006\u0011)\t)\u0002\u0001B\tB\u0003%\u0011Q\u0002\u0005\u000b\u0003/\u0001!Q3A\u0005\u0002\u0005e\u0001BCA\u0011\u0001\tE\t\u0015!\u0003\u0002\u001c!Q\u00111\u0005\u0001\u0003\u0016\u0004%\t!!\n\t\u0015\u0005=\u0002A!E!\u0002\u0013\t9\u0003\u0003\u0006\u00022\u0001\u0011)\u001a!C\u0001\u0003gA!\"!\u0012\u0001\u0005#\u0005\u000b\u0011BA\u001b\u0011)\t9\u0005\u0001BK\u0002\u0013\u0005\u0011\u0011\n\u0005\u000b\u0003#\u0002!\u0011#Q\u0001\n\u0005-\u0003BCA*\u0001\tU\r\u0011\"\u0001\u0002J!Q\u0011Q\u000b\u0001\u0003\u0012\u0003\u0006I!a\u0013\t\u0015\u0005]\u0003A!f\u0001\n\u0003\tI\u0002\u0003\u0006\u0002Z\u0001\u0011\t\u0012)A\u0005\u00037A!\"a\u0017\u0001\u0005+\u0007I\u0011AA/\u0011)\t)\u0007\u0001B\tB\u0003%\u0011q\f\u0005\u000b\u0003O\u0002!Q3A\u0005\u0002\u0005%\u0004BCA9\u0001\tE\t\u0015!\u0003\u0002l!Q\u00111\u000f\u0001\u0003\u0016\u0004%\t!!\u001e\t\u0015\u0005u\u0004A!E!\u0002\u0013\t9\b\u0003\u0006\u0002\u0000\u0001\u0011)\u001a!C\u0001\u0003\u0013B!\"!!\u0001\u0005#\u0005\u000b\u0011BA&\u0011\u001d\t\u0019\t\u0001C\u0001\u0003\u000bC!\"a(\u0001\u0005\u0004%\t\u0001\\AQ\u0011!\tY\r\u0001Q\u0001\n\u0005\r\u0006BCAg\u0001\t\u0007I\u0011\u00017\u0002P\"A\u0011Q\u001d\u0001!\u0002\u0013\t\t\u000eC\u0005\u0002h\u0002\u0011\r\u0011\"\u0001\u0002J!A\u0011\u0011\u001e\u0001!\u0002\u0013\tY\u0005C\u0005\u0002l\u0002\t\t\u0011\"\u0001\u0002n\"I!Q\u0001\u0001\u0012\u0002\u0013\u0005!q\u0001\u0005\n\u0005;\u0001\u0011\u0013!C\u0001\u0005?A\u0011Ba\t\u0001#\u0003%\tA!\n\t\u0013\t%\u0002!%A\u0005\u0002\t-\u0002\"\u0003B\u0018\u0001E\u0005I\u0011\u0001B\u0019\u0011%\u0011)\u0004AI\u0001\n\u0003\u0011\t\u0004C\u0005\u00038\u0001\t\n\u0011\"\u0001\u0003 !I!\u0011\b\u0001\u0012\u0002\u0013\u0005!1\b\u0005\n\u0005\u007f\u0001\u0011\u0013!C\u0001\u0005\u0003B\u0011B!\u0012\u0001#\u0003%\tAa\u0012\t\u0013\t-\u0003!%A\u0005\u0002\tE\u0002\"\u0003B'\u0001\u0005\u0005I\u0011\tB(\u0011%\u0011y\u0006AA\u0001\n\u0003\tI\u0002C\u0005\u0003b\u0001\t\t\u0011\"\u0001\u0003d!I!q\u000e\u0001\u0002\u0002\u0013\u0005#\u0011\u000f\u0005\n\u0005\u007f\u0002\u0011\u0011!C\u0001\u0005\u0003C\u0011B!\"\u0001\u0003\u0003%\tEa\"\t\u0013\t%\u0005!!A\u0005B\t-\u0005\"\u0003BG\u0001\u0005\u0005I\u0011\tBH\u000f\u001d\u0011\u0019\n\u001cE\u0001\u0005+3aa\u001b7\t\u0002\t]\u0005bBABg\u0011\u0005!\u0011\u0014\u0005\n\u00057\u001b$\u0019!C\u0001\u0005\u001fB\u0001B!(4A\u0003%!\u0011\u000b\u0005\n\u0005?\u001b$\u0019!C\u0001\u0005CC\u0001Ba,4A\u0003%!1\u0015\u0005\n\u0005c\u001b$\u0019!C\u0001\u0005gC\u0001B!04A\u0003%!Q\u0017\u0005\n\u0005\u007f\u001b$\u0019!C\u0001\u0005\u0003D\u0001B!24A\u0003%!1\u0019\u0005\n\u0005\u000f\u001c$\u0019!C\u0001\u0005\u0003D\u0001B!34A\u0003%!1\u0019\u0005\n\u0005\u0017\u001c$\u0019!C\u0001\u0005\u001bD\u0001B!54A\u0003%!q\u001a\u0005\n\u0005'\u001c$\u0019!C\u0001\u0005+D\u0001B!74A\u0003%!q\u001b\u0005\n\u00057\u001c$\u0019!C\u0001\u0005+D\u0001B!84A\u0003%!q\u001b\u0005\n\u0005?\u001c$\u0019!C\u0001\u0005\u0003D\u0001B!94A\u0003%!1\u0019\u0005\n\u0005G\u001c$\u0019!C\u0001\u0005KD\u0001B!;4A\u0003%!q\u001d\u0005\n\u0005W\u001c$\u0019!C\u0001\u0005\u0003D\u0001B!<4A\u0003%!1\u0019\u0005\n\u0005_\u001c$\u0019!C\u0001\u0005cD\u0001Ba?4A\u0003%!1\u001f\u0005\n\u0005{\u001c$\u0019!C\u0001\u0005+D\u0001Ba@4A\u0003%!q\u001b\u0005\n\u0007\u0003\u0019$\u0019!C\u0001\u0007\u0007A\u0001ba\u00064A\u0003%1Q\u0001\u0005\b\u0007C\u0019D\u0011AB\u0012\u0011%\u0019YdMA\u0001\n\u0003\u001bi\u0004C\u0005\u0004VM\n\n\u0011\"\u0001\u0003\b!I1qK\u001a\u0012\u0002\u0013\u0005!q\u0004\u0005\n\u00073\u001a\u0014\u0013!C\u0001\u0005KA\u0011ba\u00174#\u0003%\tAa\u000b\t\u0013\ru3'%A\u0005\u0002\tE\u0002\"CB0gE\u0005I\u0011\u0001B\u0019\u0011%\u0019\tgMI\u0001\n\u0003\u0011y\u0002C\u0005\u0004dM\n\n\u0011\"\u0001\u0003<!I1QM\u001a\u0012\u0002\u0013\u0005!\u0011\t\u0005\n\u0007O\u001a\u0014\u0013!C\u0001\u0005\u000fB\u0011b!\u001b4#\u0003%\tA!\r\t\u0013\r-4'!A\u0005\u0002\u000e5\u0004\"CB>gE\u0005I\u0011\u0001B\u0004\u0011%\u0019ihMI\u0001\n\u0003\u0011y\u0002C\u0005\u0004\u0000M\n\n\u0011\"\u0001\u0003&!I1\u0011Q\u001a\u0012\u0002\u0013\u0005!1\u0006\u0005\n\u0007\u0007\u001b\u0014\u0013!C\u0001\u0005cA\u0011b!\"4#\u0003%\tA!\r\t\u0013\r\u001d5'%A\u0005\u0002\t}\u0001\"CBEgE\u0005I\u0011\u0001B\u001e\u0011%\u0019YiMI\u0001\n\u0003\u0011\t\u0005C\u0005\u0004\u000eN\n\n\u0011\"\u0001\u0003H!I1qR\u001a\u0012\u0002\u0013\u0005!\u0011\u0007\u0005\n\u0007#\u001b\u0014\u0011!C\u0005\u0007'\u0013\u0011b\u0016:ji\u0016\u001cuN\u001c4\u000b\u00055t\u0017AB<sSR,'O\u0003\u0002pa\u0006I1m\u001c8oK\u000e$xN\u001d\u0006\u0003cJ\fQa\u001d9be.T!a\u001d;\u0002\u0011\u0011\fG/Y:uCbT\u0011!^\u0001\u0004G>l7\u0001A\n\u0006\u0001at\u00181\u0001\t\u0003srl\u0011A\u001f\u0006\u0002w\u0006)1oY1mC&\u0011QP\u001f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005e|\u0018bAA\u0001u\n9\u0001K]8ek\u000e$\bcA=\u0002\u0006%\u0019\u0011q\u0001>\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0013\t\fGo\u00195TSj,WCAA\u0007!\u0011\ty!!\u0005\u000e\u00039L1!a\u0005o\u0005%\u0011\u0015\r^2i'&TX-\u0001\u0006cCR\u001c\u0007nU5{K\u0002\nqCY1uG\"<%o\\;qS:<')\u001e4gKJ\u001c\u0016N_3\u0016\u0005\u0005m\u0001cA=\u0002\u001e%\u0019\u0011q\u0004>\u0003\u0007%sG/\u0001\rcCR\u001c\u0007n\u0012:pkBLgn\u001a\"vM\u001a,'oU5{K\u0002\n\u0001CY1uG\"<%o\\;qS:<7*Z=\u0016\u0005\u0005\u001d\u0002\u0003BA\u0015\u0003Wi\u0011\u0001\\\u0005\u0004\u0003[a'\u0001\u0005\"bi\u000eDwI]8va&twmS3z\u0003E\u0011\u0017\r^2i\u000fJ|W\u000f]5oO.+\u0017\u0010I\u0001\u0011G>t7/[:uK:\u001c\u0017\u0010T3wK2,\"!!\u000e\u0011\t\u0005]\u0012\u0011I\u0007\u0003\u0003sQA!a\u000f\u0002>\u0005!1m\u001c:f\u0015\r\tyD]\u0001\u0007IJLg/\u001a:\n\t\u0005\r\u0013\u0011\b\u0002\u0011\u0007>t7/[:uK:\u001c\u0017\u0010T3wK2\f\u0011cY8og&\u001cH/\u001a8ds2+g/\u001a7!\u0003-IgMT8u\u000bbL7\u000f^:\u0016\u0005\u0005-\u0003cA=\u0002N%\u0019\u0011q\n>\u0003\u000f\t{w\u000e\\3b]\u0006a\u0011N\u001a(pi\u0016C\u0018n\u001d;tA\u0005Y\u0011n\u001a8pe\u0016tU\u000f\u001c7t\u00031IwM\\8sK:+H\u000e\\:!\u0003A\u0001\u0018M]1mY\u0016d\u0017n]7MKZ,G.A\tqCJ\fG\u000e\\3mSNlG*\u001a<fY\u0002\nq\u0002\u001e5s_V<\u0007\u000e];u\u001b&\u0014\u0005kU\u000b\u0003\u0003?\u00022!_A1\u0013\r\t\u0019G\u001f\u0002\u0007\t>,(\r\\3\u0002!QD'o\\;hQB,H/T5C!N\u0003\u0013a\u0001;uYV\u0011\u00111\u000e\t\u0005\u0003S\ti'C\u0002\u0002p1\u0014\u0011\u0002\u0016+M\u001fB$\u0018n\u001c8\u0002\tQ$H\u000eI\u0001\ni&lWm\u001d;b[B,\"!a\u001e\u0011\t\u0005%\u0012\u0011P\u0005\u0004\u0003wb'a\u0004+j[\u0016\u001cH/Y7q\u001fB$\u0018n\u001c8\u0002\u0015QLW.Z:uC6\u0004\b%\u0001\nuCN\\W*\u001a;sS\u000e\u001cXI\\1cY\u0016$\u0017a\u0005;bg.lU\r\u001e:jGN,e.\u00192mK\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\r\u0002\b\u0006%\u00151RAG\u0003\u001f\u000b\t*a%\u0002\u0016\u0006]\u0015\u0011TAN\u0003;\u00032!!\u000b\u0001\u0011%\tIa\u0006I\u0001\u0002\u0004\ti\u0001C\u0005\u0002\u0018]\u0001\n\u00111\u0001\u0002\u001c!I\u00111E\f\u0011\u0002\u0003\u0007\u0011q\u0005\u0005\n\u0003c9\u0002\u0013!a\u0001\u0003kA\u0011\"a\u0012\u0018!\u0003\u0005\r!a\u0013\t\u0013\u0005Ms\u0003%AA\u0002\u0005-\u0003\"CA,/A\u0005\t\u0019AA\u000e\u0011%\tYf\u0006I\u0001\u0002\u0004\ty\u0006C\u0005\u0002h]\u0001\n\u00111\u0001\u0002l!I\u00111O\f\u0011\u0002\u0003\u0007\u0011q\u000f\u0005\n\u0003\u007f:\u0002\u0013!a\u0001\u0003\u0017\n!c\u001c9uS>t\u0007\u000b\\1dK\"|G\u000eZ3sgV\u0011\u00111\u0015\t\u0007\u0003K\u000b),a/\u000f\t\u0005\u001d\u0016\u0011\u0017\b\u0005\u0003S\u000by+\u0004\u0002\u0002,*\u0019\u0011Q\u0016<\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0018bAAZu\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\\\u0003s\u00131aU3r\u0015\r\t\u0019L\u001f\t\u0005\u0003{\u000b)M\u0004\u0003\u0002@\u0006\u0005\u0007cAAUu&\u0019\u00111\u0019>\u0002\rA\u0013X\rZ3g\u0013\u0011\t9-!3\u0003\rM#(/\u001b8h\u0015\r\t\u0019M_\u0001\u0014_B$\u0018n\u001c8QY\u0006\u001cW\r[8mI\u0016\u00148\u000fI\u0001\u0011_B$\u0018n\u001c8t\u0003N\u001cu\u000e\\;n]N,\"!!5\u0011\u0013e\f\u0019.a/\u0002<\u0006]\u0017bAAku\nIa)\u001e8di&|gN\r\t\u0007\u0003K\u000b),!7\u0011\t\u0005m\u0017\u0011]\u0007\u0003\u0003;T1!a8o\u0003\r\u0019\u0017\u000f\\\u0005\u0005\u0003G\fiNA\u0005D_2,XN\u001c#fM\u0006\tr\u000e\u001d;j_:\u001c\u0018i]\"pYVlgn\u001d\u0011\u0002#QD'o\u001c;uY&tw-\u00128bE2,G-\u0001\nuQJ|G\u000f\u001e7j]\u001e,e.\u00192mK\u0012\u0004\u0013\u0001B2paf$\u0002$a\"\u0002p\u0006E\u00181_A{\u0003o\fI0a?\u0002~\u0006}(\u0011\u0001B\u0002\u0011%\tIA\bI\u0001\u0002\u0004\ti\u0001C\u0005\u0002\u0018y\u0001\n\u00111\u0001\u0002\u001c!I\u00111\u0005\u0010\u0011\u0002\u0003\u0007\u0011q\u0005\u0005\n\u0003cq\u0002\u0013!a\u0001\u0003kA\u0011\"a\u0012\u001f!\u0003\u0005\r!a\u0013\t\u0013\u0005Mc\u0004%AA\u0002\u0005-\u0003\"CA,=A\u0005\t\u0019AA\u000e\u0011%\tYF\bI\u0001\u0002\u0004\ty\u0006C\u0005\u0002hy\u0001\n\u00111\u0001\u0002l!I\u00111\u000f\u0010\u0011\u0002\u0003\u0007\u0011q\u000f\u0005\n\u0003\u007fr\u0002\u0013!a\u0001\u0003\u0017\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\n)\"\u0011Q\u0002B\u0006W\t\u0011i\u0001\u0005\u0003\u0003\u0010\teQB\u0001B\t\u0015\u0011\u0011\u0019B!\u0006\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\fu\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tm!\u0011\u0003\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005CQC!a\u0007\u0003\f\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u0014U\u0011\t9Ca\u0003\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!Q\u0006\u0016\u0005\u0003k\u0011Y!\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\tM\"\u0006BA&\u0005\u0017\tabY8qs\u0012\"WMZ1vYR$c'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001c\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%qU\u0011!Q\b\u0016\u0005\u0003?\u0012Y!\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001d\u0016\u0005\t\r#\u0006BA6\u0005\u0017\tqbY8qs\u0012\"WMZ1vYR$\u0013\u0007M\u000b\u0003\u0005\u0013RC!a\u001e\u0003\f\u0005y1m\u001c9zI\u0011,g-Y;mi\u0012\n\u0014'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005#\u0002BAa\u0015\u0003^5\u0011!Q\u000b\u0006\u0005\u0005/\u0012I&\u0001\u0003mC:<'B\u0001B.\u0003\u0011Q\u0017M^1\n\t\u0005\u001d'QK\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011)Ga\u001b\u0011\u0007e\u00149'C\u0002\u0003ji\u00141!\u00118z\u0011%\u0011i\u0007LA\u0001\u0002\u0004\tY\"A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005g\u0002bA!\u001e\u0003|\t\u0015TB\u0001B<\u0015\r\u0011IH_\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B?\u0005o\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111\nBB\u0011%\u0011iGLA\u0001\u0002\u0004\u0011)'\u0001\u0005iCND7i\u001c3f)\t\tY\"\u0001\u0005u_N#(/\u001b8h)\t\u0011\t&\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u0017\u0012\t\nC\u0005\u0003nE\n\t\u00111\u0001\u0003f\u0005IqK]5uK\u000e{gN\u001a\t\u0004\u0003S\u00194\u0003B\u001ay\u0003\u0007!\"A!&\u0002!I+g-\u001a:f]\u000e,7+Z2uS>t\u0017!\u0005*fM\u0016\u0014XM\\2f'\u0016\u001cG/[8oA\u0005)2i\u001c8tSN$XM\\2z\u0019\u00164X\r\u001c)be\u0006lWC\u0001BR!\u0019\u0011)Ka+\u000265\u0011!q\u0015\u0006\u0004\u0005Ss\u0017\u0001B;uS2LAA!,\u0003(\ny1i\u001c8gS\u001e\u0004\u0016M]1nKR,'/\u0001\fD_:\u001c\u0018n\u001d;f]\u000eLH*\u001a<fYB\u000b'/Y7!\u0003I\u0011\u0015\r^2i'&TXMU8xgB\u000b'/Y7\u0016\u0005\tU\u0006C\u0002BS\u0005W\u00139\fE\u0003z\u0005s\u000bY\"C\u0002\u0003<j\u0014aa\u00149uS>t\u0017a\u0005\"bi\u000eD7+\u001b>f%><8\u000fU1sC6\u0004\u0013a\u0005\"bi\u000eD7+\u001b>f\u0005f$Xm\u001d)be\u0006lWC\u0001Bb!\u0019\u0011)Ka+\u0002\u001c\u0005!\")\u0019;dQNK'0\u001a\"zi\u0016\u001c\b+\u0019:b[\u0002\nACQ1uG\"\u0014UO\u001a4feNK'0\u001a)be\u0006l\u0017!\u0006\"bi\u000eD')\u001e4gKJ\u001c\u0016N_3QCJ\fW\u000eI\u0001\u0010\u0005\u0006$8\r\u001b'fm\u0016d\u0007+\u0019:b[V\u0011!q\u001a\t\u0007\u0005K\u0013Y+a\n\u0002!\t\u000bGo\u00195MKZ,G\u000eU1sC6\u0004\u0013\u0001E%g\u001d>$X\t_5tiN\u0004\u0016M]1n+\t\u00119\u000e\u0005\u0004\u0003&\n-\u00161J\u0001\u0012\u0013\u001atu\u000e^#ySN$8\u000fU1sC6\u0004\u0013\u0001E%h]>\u0014XMT;mYN\u0004\u0016M]1n\u0003EIuM\\8sK:+H\u000e\\:QCJ\fW\u000eI\u0001\u0016!\u0006\u0014\u0018\r\u001c7fY&\u001cX\u000eT3wK2\u0004\u0016M]1n\u0003Y\u0001\u0016M]1mY\u0016d\u0017n]7MKZ,G\u000eU1sC6\u0004\u0013\u0001\u0006+ie>,x\r\u001b9vi6K'\tU*QCJ\fW.\u0006\u0002\u0003hB1!Q\u0015BV\u0003?\nQ\u0003\u00165s_V<\u0007\u000e];u\u001b&\u0014\u0005k\u0015)be\u0006l\u0007%\u0001\u0005U)2\u0003\u0016M]1n\u0003%!F\u000b\u0014)be\u0006l\u0007%\u0001\bUS6,7\u000f^1naB\u000b'/Y7\u0016\u0005\tM\bC\u0002BS\u0005W\u0013)\u0010E\u0002z\u0005oL1A!?{\u0005\u0011auN\\4\u0002\u001fQKW.Z:uC6\u0004\b+\u0019:b[\u0002\n\u0001\u0003V1tW6+GO]5dgB\u000b'/Y7\u0002#Q\u000b7o['fiJL7m\u001d)be\u0006l\u0007%\u0001\u0006Qe>\u0004XM\u001d;jKN,\"a!\u0002\u0011\r\u0005u6qAB\u0006\u0013\u0011\u0019I!!3\u0003\u0007M+G\u000f\r\u0003\u0004\u000e\rM\u0001C\u0002BS\u0005W\u001by\u0001\u0005\u0003\u0004\u0012\rMA\u0002\u0001\u0003\f\u0007+\u0001\u0016\u0011!A\u0001\u0006\u0003\u0019IBA\u0002`II\n1\u0002\u0015:pa\u0016\u0014H/[3tAE!11\u0004B3!\rI8QD\u0005\u0004\u0007?Q(a\u0002(pi\"LgnZ\u0001\u000eMJ|Wn\u00159be.\u001cuN\u001c4\u0015\t\u0005\u001d5Q\u0005\u0005\b\u0007O\t\u0006\u0019AB\u0015\u0003\u0011\u0019wN\u001c4\u0011\t\r-2qG\u0007\u0003\u0007[Q1!]B\u0018\u0015\u0011\u0019\tda\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\u0019)$A\u0002pe\u001eLAa!\u000f\u0004.\tI1\u000b]1sW\u000e{gNZ\u0001\u0006CB\u0004H.\u001f\u000b\u0019\u0003\u000f\u001byd!\u0011\u0004D\r\u00153qIB%\u0007\u0017\u001aiea\u0014\u0004R\rM\u0003\"CA\u0005%B\u0005\t\u0019AA\u0007\u0011%\t9B\u0015I\u0001\u0002\u0004\tY\u0002C\u0005\u0002$I\u0003\n\u00111\u0001\u0002(!I\u0011\u0011\u0007*\u0011\u0002\u0003\u0007\u0011Q\u0007\u0005\n\u0003\u000f\u0012\u0006\u0013!a\u0001\u0003\u0017B\u0011\"a\u0015S!\u0003\u0005\r!a\u0013\t\u0013\u0005]#\u000b%AA\u0002\u0005m\u0001\"CA.%B\u0005\t\u0019AA0\u0011%\t9G\u0015I\u0001\u0002\u0004\tY\u0007C\u0005\u0002tI\u0003\n\u00111\u0001\u0002x!I\u0011q\u0010*\u0011\u0002\u0003\u0007\u00111J\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%c\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"\u0014aD1qa2LH\u0005Z3gCVdG\u000fJ\u001b\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIY\nq\"\u00199qYf$C-\u001a4bk2$HeN\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%q\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0013(\u0001\tbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00132a\u0005\u0001\u0012\r\u001d9ms\u0012\"WMZ1vYR$\u0013'M\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019yga\u001e\u0011\u000be\u0014Il!\u001d\u00113e\u001c\u0019(!\u0004\u0002\u001c\u0005\u001d\u0012QGA&\u0003\u0017\nY\"a\u0018\u0002l\u0005]\u00141J\u0005\u0004\u0007kR(a\u0002+va2,\u0017'\r\u0005\n\u0007sr\u0016\u0011!a\u0001\u0003\u000f\u000b1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00138\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%q\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIe\nA\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n\u0004'\u0001\u000f%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0007+\u0003BAa\u0015\u0004\u0018&!1\u0011\u0014B+\u0005\u0019y%M[3di\u0002")
public class WriteConf
implements Product,
scala.Serializable {
    private final BatchSize batchSize;
    private final int batchGroupingBufferSize;
    private final BatchGroupingKey batchGroupingKey;
    private final ConsistencyLevel consistencyLevel;
    private final boolean ifNotExists;
    private final boolean ignoreNulls;
    private final int parallelismLevel;
    private final double throughputMiBPS;
    private final TTLOption ttl;
    private final TimestampOption timestamp;
    private final boolean taskMetricsEnabled;
    private final Seq<String> optionPlaceholders;
    private final Function2<String, String, Seq<ColumnDef>> optionsAsColumns;
    private final boolean throttlingEnabled;

    public static boolean $lessinit$greater$default$11() {
        return WriteConf$.MODULE$.$lessinit$greater$default$11();
    }

    public static TimestampOption $lessinit$greater$default$10() {
        return WriteConf$.MODULE$.$lessinit$greater$default$10();
    }

    public static TTLOption $lessinit$greater$default$9() {
        return WriteConf$.MODULE$.$lessinit$greater$default$9();
    }

    public static double $lessinit$greater$default$8() {
        return WriteConf$.MODULE$.$lessinit$greater$default$8();
    }

    public static int $lessinit$greater$default$7() {
        return WriteConf$.MODULE$.$lessinit$greater$default$7();
    }

    public static boolean $lessinit$greater$default$6() {
        return WriteConf$.MODULE$.$lessinit$greater$default$6();
    }

    public static boolean $lessinit$greater$default$5() {
        return WriteConf$.MODULE$.$lessinit$greater$default$5();
    }

    public static ConsistencyLevel $lessinit$greater$default$4() {
        return WriteConf$.MODULE$.$lessinit$greater$default$4();
    }

    public static BatchGroupingKey $lessinit$greater$default$3() {
        return WriteConf$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return WriteConf$.MODULE$.$lessinit$greater$default$2();
    }

    public static BatchSize $lessinit$greater$default$1() {
        return WriteConf$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<Tuple11<BatchSize, Object, BatchGroupingKey, ConsistencyLevel, Object, Object, Object, Object, TTLOption, TimestampOption, Object>> unapply(WriteConf writeConf) {
        return WriteConf$.MODULE$.unapply(writeConf);
    }

    public static boolean apply$default$11() {
        return WriteConf$.MODULE$.apply$default$11();
    }

    public static TimestampOption apply$default$10() {
        return WriteConf$.MODULE$.apply$default$10();
    }

    public static TTLOption apply$default$9() {
        return WriteConf$.MODULE$.apply$default$9();
    }

    public static double apply$default$8() {
        return WriteConf$.MODULE$.apply$default$8();
    }

    public static int apply$default$7() {
        return WriteConf$.MODULE$.apply$default$7();
    }

    public static boolean apply$default$6() {
        return WriteConf$.MODULE$.apply$default$6();
    }

    public static boolean apply$default$5() {
        return WriteConf$.MODULE$.apply$default$5();
    }

    public static ConsistencyLevel apply$default$4() {
        return WriteConf$.MODULE$.apply$default$4();
    }

    public static BatchGroupingKey apply$default$3() {
        return WriteConf$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return WriteConf$.MODULE$.apply$default$2();
    }

    public static BatchSize apply$default$1() {
        return WriteConf$.MODULE$.apply$default$1();
    }

    public static WriteConf apply(BatchSize batchSize, int n, BatchGroupingKey batchGroupingKey, ConsistencyLevel consistencyLevel, boolean bl, boolean bl2, int n2, double d, TTLOption tTLOption, TimestampOption timestampOption, boolean bl3) {
        return WriteConf$.MODULE$.apply(batchSize, n, batchGroupingKey, consistencyLevel, bl, bl2, n2, d, tTLOption, timestampOption, bl3);
    }

    public static WriteConf fromSparkConf(SparkConf sparkConf) {
        return WriteConf$.MODULE$.fromSparkConf(sparkConf);
    }

    public static Set<ConfigParameter<?>> Properties() {
        return WriteConf$.MODULE$.Properties();
    }

    public static ConfigParameter<Object> TaskMetricsParam() {
        return WriteConf$.MODULE$.TaskMetricsParam();
    }

    public static ConfigParameter<Object> TimestampParam() {
        return WriteConf$.MODULE$.TimestampParam();
    }

    public static ConfigParameter<Object> TTLParam() {
        return WriteConf$.MODULE$.TTLParam();
    }

    public static ConfigParameter<Object> ThroughputMiBPSParam() {
        return WriteConf$.MODULE$.ThroughputMiBPSParam();
    }

    public static ConfigParameter<Object> ParallelismLevelParam() {
        return WriteConf$.MODULE$.ParallelismLevelParam();
    }

    public static ConfigParameter<Object> IgnoreNullsParam() {
        return WriteConf$.MODULE$.IgnoreNullsParam();
    }

    public static ConfigParameter<Object> IfNotExistsParam() {
        return WriteConf$.MODULE$.IfNotExistsParam();
    }

    public static ConfigParameter<BatchGroupingKey> BatchLevelParam() {
        return WriteConf$.MODULE$.BatchLevelParam();
    }

    public static ConfigParameter<Object> BatchBufferSizeParam() {
        return WriteConf$.MODULE$.BatchBufferSizeParam();
    }

    public static ConfigParameter<Object> BatchSizeBytesParam() {
        return WriteConf$.MODULE$.BatchSizeBytesParam();
    }

    public static ConfigParameter<Option<Object>> BatchSizeRowsParam() {
        return WriteConf$.MODULE$.BatchSizeRowsParam();
    }

    public static ConfigParameter<ConsistencyLevel> ConsistencyLevelParam() {
        return WriteConf$.MODULE$.ConsistencyLevelParam();
    }

    public static String ReferenceSection() {
        return WriteConf$.MODULE$.ReferenceSection();
    }

    public BatchSize batchSize() {
        return this.batchSize;
    }

    public int batchGroupingBufferSize() {
        return this.batchGroupingBufferSize;
    }

    public BatchGroupingKey batchGroupingKey() {
        return this.batchGroupingKey;
    }

    public ConsistencyLevel consistencyLevel() {
        return this.consistencyLevel;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    public boolean ignoreNulls() {
        return this.ignoreNulls;
    }

    public int parallelismLevel() {
        return this.parallelismLevel;
    }

    public double throughputMiBPS() {
        return this.throughputMiBPS;
    }

    public TTLOption ttl() {
        return this.ttl;
    }

    public TimestampOption timestamp() {
        return this.timestamp;
    }

    public boolean taskMetricsEnabled() {
        return this.taskMetricsEnabled;
    }

    public Seq<String> optionPlaceholders() {
        return this.optionPlaceholders;
    }

    public Function2<String, String, Seq<ColumnDef>> optionsAsColumns() {
        return this.optionsAsColumns;
    }

    public boolean throttlingEnabled() {
        return this.throttlingEnabled;
    }

    public WriteConf copy(BatchSize batchSize, int batchGroupingBufferSize, BatchGroupingKey batchGroupingKey, ConsistencyLevel consistencyLevel, boolean ifNotExists, boolean ignoreNulls, int parallelismLevel, double throughputMiBPS, TTLOption ttl, TimestampOption timestamp, boolean taskMetricsEnabled) {
        return new WriteConf(batchSize, batchGroupingBufferSize, batchGroupingKey, consistencyLevel, ifNotExists, ignoreNulls, parallelismLevel, throughputMiBPS, ttl, timestamp, taskMetricsEnabled);
    }

    public BatchSize copy$default$1() {
        return this.batchSize();
    }

    public TimestampOption copy$default$10() {
        return this.timestamp();
    }

    public boolean copy$default$11() {
        return this.taskMetricsEnabled();
    }

    public int copy$default$2() {
        return this.batchGroupingBufferSize();
    }

    public BatchGroupingKey copy$default$3() {
        return this.batchGroupingKey();
    }

    public ConsistencyLevel copy$default$4() {
        return this.consistencyLevel();
    }

    public boolean copy$default$5() {
        return this.ifNotExists();
    }

    public boolean copy$default$6() {
        return this.ignoreNulls();
    }

    public int copy$default$7() {
        return this.parallelismLevel();
    }

    public double copy$default$8() {
        return this.throughputMiBPS();
    }

    public TTLOption copy$default$9() {
        return this.ttl();
    }

    public String productPrefix() {
        return "WriteConf";
    }

    public int productArity() {
        return 11;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.batchSize();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.batchGroupingBufferSize());
                break;
            }
            case 2: {
                object = this.batchGroupingKey();
                break;
            }
            case 3: {
                object = this.consistencyLevel();
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ifNotExists());
                break;
            }
            case 5: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ignoreNulls());
                break;
            }
            case 6: {
                object = BoxesRunTime.boxToInteger((int)this.parallelismLevel());
                break;
            }
            case 7: {
                object = BoxesRunTime.boxToDouble((double)this.throughputMiBPS());
                break;
            }
            case 8: {
                object = this.ttl();
                break;
            }
            case 9: {
                object = this.timestamp();
                break;
            }
            case 10: {
                object = BoxesRunTime.boxToBoolean((boolean)this.taskMetricsEnabled());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof WriteConf;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.batchSize()));
        n = Statics.mix((int)n, (int)this.batchGroupingBufferSize());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.batchGroupingKey()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)((Object)this.consistencyLevel())));
        n = Statics.mix((int)n, (int)(this.ifNotExists() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.ignoreNulls() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)this.parallelismLevel());
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.throughputMiBPS()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.ttl()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.timestamp()));
        n = Statics.mix((int)n, (int)(this.taskMetricsEnabled() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)11);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof WriteConf)) return false;
        boolean bl = true;
        if (!bl) return false;
        WriteConf writeConf = (WriteConf)x$1;
        BatchSize batchSize = this.batchSize();
        BatchSize batchSize2 = writeConf.batchSize();
        if (batchSize == null) {
            if (batchSize2 != null) {
                return false;
            }
        } else if (!batchSize.equals(batchSize2)) return false;
        if (this.batchGroupingBufferSize() != writeConf.batchGroupingBufferSize()) return false;
        BatchGroupingKey batchGroupingKey = this.batchGroupingKey();
        BatchGroupingKey batchGroupingKey2 = writeConf.batchGroupingKey();
        if (batchGroupingKey == null) {
            if (batchGroupingKey2 != null) {
                return false;
            }
        } else if (!batchGroupingKey.equals(batchGroupingKey2)) return false;
        ConsistencyLevel consistencyLevel = this.consistencyLevel();
        ConsistencyLevel consistencyLevel2 = writeConf.consistencyLevel();
        if (consistencyLevel == null) {
            if (consistencyLevel2 != null) {
                return false;
            }
        } else if (!((Object)((Object)consistencyLevel)).equals((Object)consistencyLevel2)) return false;
        if (this.ifNotExists() != writeConf.ifNotExists()) return false;
        if (this.ignoreNulls() != writeConf.ignoreNulls()) return false;
        if (this.parallelismLevel() != writeConf.parallelismLevel()) return false;
        if (this.throughputMiBPS() != writeConf.throughputMiBPS()) return false;
        TTLOption tTLOption = this.ttl();
        TTLOption tTLOption2 = writeConf.ttl();
        if (tTLOption == null) {
            if (tTLOption2 != null) {
                return false;
            }
        } else if (!((Object)tTLOption).equals(tTLOption2)) return false;
        TimestampOption timestampOption = this.timestamp();
        TimestampOption timestampOption2 = writeConf.timestamp();
        if (timestampOption == null) {
            if (timestampOption2 != null) {
                return false;
            }
        } else if (!((Object)timestampOption).equals(timestampOption2)) return false;
        if (this.taskMetricsEnabled() != writeConf.taskMetricsEnabled()) return false;
        if (!writeConf.canEqual(this)) return false;
        return true;
    }

    private static final Option toRegularColDef$1(WriteOption opt, DataType dataType) {
        None$ none$;
        WriteOptionValue writeOptionValue;
        WriteOption writeOption = opt;
        Option<WriteOptionValue<?>> option = WriteOption$.MODULE$.unapply(writeOption);
        if (!option.isEmpty() && (writeOptionValue = (WriteOptionValue)option.get()) instanceof PerRowWriteOptionValue) {
            PerRowWriteOptionValue perRowWriteOptionValue = (PerRowWriteOptionValue)writeOptionValue;
            String placeholder = perRowWriteOptionValue.placeholder();
            none$ = new Some((Object)new ColumnDef(placeholder, RegularColumn$.MODULE$, ColumnType$.MODULE$.fromDriverType(dataType)));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public WriteConf(BatchSize batchSize, int batchGroupingBufferSize, BatchGroupingKey batchGroupingKey, ConsistencyLevel consistencyLevel, boolean ifNotExists, boolean ignoreNulls, int parallelismLevel, double throughputMiBPS, TTLOption ttl, TimestampOption timestamp, boolean taskMetricsEnabled) {
        this.batchSize = batchSize;
        this.batchGroupingBufferSize = batchGroupingBufferSize;
        this.batchGroupingKey = batchGroupingKey;
        this.consistencyLevel = consistencyLevel;
        this.ifNotExists = ifNotExists;
        this.ignoreNulls = ignoreNulls;
        this.parallelismLevel = parallelismLevel;
        this.throughputMiBPS = throughputMiBPS;
        this.ttl = ttl;
        this.timestamp = timestamp;
        this.taskMetricsEnabled = taskMetricsEnabled;
        Product.$init$((Product)this);
        this.optionPlaceholders = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{ttl, timestamp}))).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Product & scala.Serializable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                WriteOptionValue writeOptionValue;
                A1 A1 = x1;
                Option<WriteOptionValue<?>> option = WriteOption$.MODULE$.unapply((WriteOption)A1);
                if (!option.isEmpty() && (writeOptionValue = (WriteOptionValue)option.get()) instanceof PerRowWriteOptionValue) {
                    PerRowWriteOptionValue perRowWriteOptionValue = (PerRowWriteOptionValue)writeOptionValue;
                    String placeholder = perRowWriteOptionValue.placeholder();
                    object = placeholder;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Product x1) {
                WriteOptionValue writeOptionValue;
                Product product = x1;
                Option<WriteOptionValue<?>> option = WriteOption$.MODULE$.unapply((WriteOption)product);
                boolean bl = !option.isEmpty() && (writeOptionValue = (WriteOptionValue)option.get()) instanceof PerRowWriteOptionValue;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.optionsAsColumns = (Function2 & Serializable & scala.Serializable)(keyspace, table) -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{WriteConf.toRegularColDef$1(this.ttl(), DataType.cint()), WriteConf.toRegularColDef$1(this.timestamp(), DataType.bigint())})).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
        this.throttlingEnabled = throughputMiBPS < BoxesRunTime.unboxToDouble((Object)WriteConf$.MODULE$.ThroughputMiBPSParam().default());
    }
}

