/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.cassandra;

import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.CassandraConnectorConf$;
import com.datastax.spark.connector.rdd.ReadConf;
import com.datastax.spark.connector.rdd.ReadConf$;
import com.datastax.spark.connector.rdd.partitioner.DataSizeEstimates;
import com.datastax.spark.connector.rdd.partitioner.dht.Token;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenFactory;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenFactory$;
import com.datastax.spark.connector.util.ConfigParameter;
import com.datastax.spark.connector.writer.WriteConf;
import com.datastax.spark.connector.writer.WriteConf$;
import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.cassandra.CassandraPredicateRules;
import org.apache.spark.sql.cassandra.CassandraSourceOptions;
import org.apache.spark.sql.cassandra.CassandraSourceOptions$;
import org.apache.spark.sql.cassandra.CassandraSourceRelation;
import org.apache.spark.sql.cassandra.DefaultSource$;
import org.apache.spark.sql.cassandra.TableRef;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CassandraSourceRelation$ {
    public static CassandraSourceRelation$ MODULE$;
    private final String ReferenceSection;
    private final ConfigParameter<Option<Object>> TableSizeInBytesParam;
    private final ConfigParameter<List<CassandraPredicateRules>> AdditionalCassandraPushDownRulesParam;
    private final Seq<ConfigParameter<? extends Object>> Properties;
    private final String defaultClusterName;

    static {
        new CassandraSourceRelation$();
    }

    public String ReferenceSection() {
        return this.ReferenceSection;
    }

    public ConfigParameter<Option<Object>> TableSizeInBytesParam() {
        return this.TableSizeInBytesParam;
    }

    public ConfigParameter<List<CassandraPredicateRules>> AdditionalCassandraPushDownRulesParam() {
        return this.AdditionalCassandraPushDownRulesParam;
    }

    public Seq<ConfigParameter<? extends Object>> Properties() {
        return this.Properties;
    }

    public String defaultClusterName() {
        return this.defaultClusterName;
    }

    public CassandraSourceRelation apply(TableRef tableRef, SQLContext sqlContext, CassandraSourceOptions options, Option<StructType> schema) {
        Option option;
        SparkConf sparkConf = sqlContext.sparkContext().getConf();
        Map sqlConf = sqlContext.getAllConfs();
        SparkConf conf = this.consolidateConfs(sparkConf, (Map<String, String>)sqlConf, tableRef, options.cassandraConfs());
        Option tableSizeInBytesString = conf.getOption(this.TableSizeInBytesParam().name());
        CassandraConnector cassandraConnector = new CassandraConnector(CassandraConnectorConf$.MODULE$.apply(conf));
        Option option2 = tableSizeInBytesString;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String size = (String)some.value();
            option = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(size)).toLong()));
        } else if (None$.MODULE$.equals(option2)) {
            TokenFactory<Object, Token> tokenFactory = TokenFactory$.MODULE$.forSystemLocalPartitioner(cassandraConnector);
            long dataSizeInBytes = new DataSizeEstimates<Object, Token>(cassandraConnector, tableRef.keyspace(), tableRef.table(), tokenFactory).totalDataSizeInBytes();
            option = dataSizeInBytes <= 0L ? None$.MODULE$ : Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)dataSizeInBytes));
        } else {
            throw new MatchError((Object)option2);
        }
        Option tableSizeInBytes = option;
        ReadConf readConf = ReadConf$.MODULE$.fromSparkConf(conf);
        WriteConf writeConf = WriteConf$.MODULE$.fromSparkConf(conf);
        return new CassandraSourceRelation(tableRef, schema, options.pushdown(), options.confirmTruncate(), (Option<Object>)tableSizeInBytes, cassandraConnector, readConf, writeConf, conf, sqlContext);
    }

    public CassandraSourceOptions apply$default$3() {
        return new CassandraSourceOptions(CassandraSourceOptions$.MODULE$.apply$default$1(), CassandraSourceOptions$.MODULE$.apply$default$2(), CassandraSourceOptions$.MODULE$.apply$default$3());
    }

    public Option<StructType> apply$default$4() {
        return None$.MODULE$;
    }

    public SparkConf consolidateConfs(SparkConf sparkConf, Map<String, String> sqlConf, TableRef tableRef, Map<String, String> tableConf) {
        SparkConf conf = sparkConf.clone();
        String cluster = (String)tableRef.cluster().getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.defaultClusterName());
        String ks = tableRef.keyspace();
        DefaultSource$.MODULE$.confProperties().foreach((Function1 & Serializable & scala.Serializable)prop -> {
            CassandraSourceRelation$.$anonfun$consolidateConfs$2(tableConf, sqlConf, cluster, ks, conf, prop);
            return BoxedUnit.UNIT;
        });
        Set SCCProps = (Set)DefaultSource$.MODULE$.confProperties().flatMap((Function1 & Serializable & scala.Serializable)prop -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{prop, prop.toLowerCase(Locale.ROOT)})), Set$.MODULE$.canBuildFrom());
        conf.setAll((Traversable)tableConf.$minus$minus((GenTraversableOnce)SCCProps));
        return conf;
    }

    public static final /* synthetic */ void $anonfun$consolidateConfs$2(Map tableConf$1, Map sqlConf$1, String cluster$1, String ks$1, SparkConf conf$1, String prop) {
        String lowerCasedProp = prop.toLowerCase(Locale.ROOT);
        Option value = ((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{tableConf$1.get((Object)lowerCasedProp), tableConf$1.get((Object)prop), sqlConf$1.get((Object)new StringBuilder(2).append(cluster$1).append(":").append(ks$1).append("/").append(prop).toString()), sqlConf$1.get((Object)new StringBuilder(1).append(cluster$1).append("/").append(prop).toString()), sqlConf$1.get((Object)new StringBuilder(8).append("default/").append(prop).toString()), sqlConf$1.get((Object)prop)})).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).headOption();
        value.foreach((Function1 & Serializable & scala.Serializable)x$7 -> conf$1.set(prop, x$7));
    }

    private CassandraSourceRelation$() {
        MODULE$ = this;
        this.ReferenceSection = "Cassandra DataFrame Source Parameters";
        this.TableSizeInBytesParam = new ConfigParameter<None$>("spark.cassandra.table.size.in.bytes", this.ReferenceSection(), None$.MODULE$, new StringOps(Predef$.MODULE$.augmentString("Used by DataFrames Internally, will be updated in a future release to\n        |retrieve size from Cassandra. Can be set manually now")).stripMargin());
        this.AdditionalCassandraPushDownRulesParam = new ConfigParameter<List>("spark.cassandra.sql.pushdown.additionalClasses", this.ReferenceSection(), List$.MODULE$.empty(), new StringOps(Predef$.MODULE$.augmentString("A comma separated list of classes to be used (in order) to apply additional\n        | pushdown rules for Cassandra Dataframes. Classes must implement CassandraPredicateRules\n      ")).stripMargin());
        this.Properties = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigParameter[]{this.AdditionalCassandraPushDownRulesParam(), this.TableSizeInBytesParam()}));
        this.defaultClusterName = "default";
    }
}

