/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.cassandra;

import com.datastax.driver.core.ProtocolVersion;
import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.SomeColumns;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.Schema$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.rdd.CassandraRDD;
import com.datastax.spark.connector.rdd.CassandraTableScanRDD;
import com.datastax.spark.connector.rdd.CassandraTableScanRDD$;
import com.datastax.spark.connector.rdd.ReadConf;
import com.datastax.spark.connector.rdd.ValidRDDType$;
import com.datastax.spark.connector.types.ColumnType;
import com.datastax.spark.connector.types.InetType$;
import com.datastax.spark.connector.types.UUIDType$;
import com.datastax.spark.connector.types.VarIntType$;
import com.datastax.spark.connector.util.ConfigParameter;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.util.Quote$;
import com.datastax.spark.connector.util.ReflectionUtil$;
import com.datastax.spark.connector.writer.RowWriterFactory;
import com.datastax.spark.connector.writer.SqlRowWriter$Factory$;
import com.datastax.spark.connector.writer.WriteConf;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.UUID;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.cassandra.AnalyzedPredicates;
import org.apache.spark.sql.cassandra.BasicCassandraPredicatePushDown;
import org.apache.spark.sql.cassandra.CassandraPredicateRules;
import org.apache.spark.sql.cassandra.CassandraSQLRow;
import org.apache.spark.sql.cassandra.CassandraSQLRow$;
import org.apache.spark.sql.cassandra.CassandraSQLRow$CassandraSQLRowReader$;
import org.apache.spark.sql.cassandra.CassandraSourceOptions;
import org.apache.spark.sql.cassandra.CassandraSourceRelation$;
import org.apache.spark.sql.cassandra.DataTypeConverter$;
import org.apache.spark.sql.cassandra.PredicateOps$FilterOps$;
import org.apache.spark.sql.cassandra.TableRef;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.InsertableRelation;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.PrunedFilteredScan;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rub!B\u001b7\u0001Y\u0002\u0005\u0002\u0003.\u0001\u0005\u0003\u0005\u000b\u0011\u0002/\t\u0011\u0001\u0004!\u0011!Q\u0001\n\u0005D\u0001\"\u001c\u0001\u0003\u0002\u0003\u0006IA\u001c\u0005\tc\u0002\u0011\t\u0011)A\u0005]\"A!\u000f\u0001B\u0001B\u0003%1\u000f\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003x\u0011!i\bA!A!\u0002\u0013q\bBCA\u0005\u0001\t\u0005\t\u0015!\u0003\u0002\f!Q\u0011q\u0003\u0001\u0003\u0002\u0003\u0006I!!\u0007\t\u0015\u0005\u0005\u0002A!b\u0001\n\u0003\n\u0019\u0003\u0003\u0006\u0002.\u0001\u0011\t\u0011)A\u0005\u0003KAq!a\f\u0001\t\u0003\t\t\u0004C\u0005\u0002J\u0001\u0011\r\u0011b\u0001\u0002L!9\u0011Q\n\u0001!\u0002\u0013q\b\"CA(\u0001\t\u0007I1AA)\u0011!\ty\u0006\u0001Q\u0001\n\u0005M\u0003\"CA1\u0001\t\u0007I1AA2\u0011\u001d\t)\u0007\u0001Q\u0001\n]D\u0001\"a\u001a\u0001A\u0003%\u0011\u0011\u000e\u0005\b\u0003_\u0002A\u0011IA9\u0011\u001d\t\u0019\b\u0001C!\u0003kBq!!+\u0001\t\u0003\nY\u000b\u0003\u0005\u0002.\u0002\u0001\u000b\u0011BAX\u0011\u001d\tY\f\u0001C\u0001\u0003{Cq!!3\u0001\t\u0003\nY\r\u0003\u0006\u0002^\u0002A)\u0019!C\u0001\u0003?Dq!a>\u0001\t\u0013\tI\u0010C\u0004\u0002<\u0002!\tEa\u0001\u0006\r\tu\u0001\u0001\u0002B\u0010\u0011\u001d\u0011)\u0003\u0001C\u0005\u0005OAqA!\r\u0001\t\u0013\u0011\u0019\u0004C\u0004\u0003<\u0001!IA!\u0010\t\u000f\tE\u0003\u0001\"\u0003\u0003T!9!q\f\u0001\u0005\n\t\u0005\u0004b\u0002B5\u0001\u0011%!1N\u0004\b\u0005c2\u0004\u0012\u0001B:\r\u0019)d\u0007#\u0001\u0003v!9\u0011qF\u0013\u0005\u0002\tu\u0004\"\u0003B@K\t\u0007I\u0011\u0001BA\u0011!\u0011\t*\nQ\u0001\n\t\r\u0005\"\u0003BJK\t\u0007I\u0011\u0001BK\u0011!\u0011i*\nQ\u0001\n\t]\u0005\"\u0003BPK\t\u0007I\u0011\u0001BQ\u0011!\u0011Y+\nQ\u0001\n\t\r\u0006\"\u0003BWK\t\u0007I\u0011\u0001BX\u0011!\u0011y/\nQ\u0001\n\tE\u0006\"\u0003ByK\t\u0007I\u0011\u0001BA\u0011!\u0011\u00190\nQ\u0001\n\t\r\u0005b\u0002B{K\u0011\u0005!q\u001f\u0005\n\u0007\u0013)\u0013\u0013!C\u0001\u0007\u0017A\u0011b!\t&#\u0003%\taa\t\t\u000f\r\u001dR\u0005\"\u0001\u0004*\t92)Y:tC:$'/Y*pkJ\u001cWMU3mCRLwN\u001c\u0006\u0003oa\n\u0011bY1tg\u0006tGM]1\u000b\u0005eR\u0014aA:rY*\u00111\bP\u0001\u0006gB\f'o\u001b\u0006\u0003{y\na!\u00199bG\",'\"A \u0002\u0007=\u0014xmE\u0003\u0001\u0003\u001eSU\n\u0005\u0002C\u000b6\t1I\u0003\u0002Eq\u000591o\\;sG\u0016\u001c\u0018B\u0001$D\u00051\u0011\u0015m]3SK2\fG/[8o!\t\u0011\u0005*\u0003\u0002J\u0007\n\u0011\u0012J\\:feR\f'\r\\3SK2\fG/[8o!\t\u00115*\u0003\u0002M\u0007\n\u0011\u0002K];oK\u00124\u0015\u000e\u001c;fe\u0016$7kY1o!\tq\u0005,D\u0001P\u0015\t\u0001\u0016+\u0001\u0003vi&d'B\u0001*T\u0003%\u0019wN\u001c8fGR|'O\u0003\u0002<)*\u0011QKV\u0001\tI\u0006$\u0018m\u001d;bq*\tq+A\u0002d_6L!!W(\u0003\u000f1{wmZ5oO\u0006AA/\u00192mKJ+gm\u0001\u0001\u0011\u0005usV\"\u0001\u001c\n\u0005}3$\u0001\u0003+bE2,'+\u001a4\u0002'U\u001cXM]*qK\u000eLg-[3e'\u000eDW-\\1\u0011\u0007\t,w-D\u0001d\u0015\u0005!\u0017!B:dC2\f\u0017B\u00014d\u0005\u0019y\u0005\u000f^5p]B\u0011\u0001n[\u0007\u0002S*\u0011!\u000eO\u0001\u0006if\u0004Xm]\u0005\u0003Y&\u0014!b\u0015;sk\u000e$H+\u001f9f\u000391\u0017\u000e\u001c;feB+8\u000f\u001b3po:\u0004\"AY8\n\u0005A\u001c'a\u0002\"p_2,\u0017M\\\u0001\u0010G>tg-\u001b:n)J,hnY1uK\u0006\u0001B/\u00192mKNK'0Z%o\u0005f$Xm\u001d\t\u0004E\u0016$\bC\u00012v\u0013\t18M\u0001\u0003M_:<\u0007C\u0001=|\u001b\u0005I(B\u0001>R\u0003\r\u0019\u0017\u000f\\\u0005\u0003yf\u0014!cQ1tg\u0006tGM]1D_:tWm\u0019;pe\u0006A!/Z1e\u0007>tg\rE\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\r\u0011+A\u0002sI\u0012LA!a\u0002\u0002\u0002\tA!+Z1e\u0007>tg-A\u0005xe&$XmQ8oMB!\u0011QBA\n\u001b\t\tyAC\u0002\u0002\u0012E\u000baa\u001e:ji\u0016\u0014\u0018\u0002BA\u000b\u0003\u001f\u0011\u0011b\u0016:ji\u0016\u001cuN\u001c4\u0002\u0013M\u0004\u0018M]6D_:4\u0007\u0003BA\u000e\u0003;i\u0011AO\u0005\u0004\u0003?Q$!C*qCJ\\7i\u001c8g\u0003)\u0019\u0018\u000f\\\"p]R,\u0007\u0010^\u000b\u0003\u0003K\u0001B!a\n\u0002*5\t\u0001(C\u0002\u0002,a\u0012!bU)M\u0007>tG/\u001a=u\u0003-\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\u0011\u0002\rqJg.\u001b;?)Y\t\u0019$!\u000e\u00028\u0005e\u00121HA\u001f\u0003\u007f\t\t%a\u0011\u0002F\u0005\u001d\u0003CA/\u0001\u0011\u0015QF\u00021\u0001]\u0011\u0015\u0001G\u00021\u0001b\u0011\u0015iG\u00021\u0001o\u0011\u0015\tH\u00021\u0001o\u0011\u0015\u0011H\u00021\u0001t\u0011\u0015\u0011F\u00021\u0001x\u0011\u0015iH\u00021\u0001\u007f\u0011\u001d\tI\u0001\u0004a\u0001\u0003\u0017Aq!a\u0006\r\u0001\u0004\tI\u0002C\u0004\u0002\"1\u0001\r!!\n\u0002\u0011I,\u0017\rZ2p]\u001a,\u0012A`\u0001\ne\u0016\fGmY8oM\u0002\n1A]<g+\t\t\u0019\u0006\u0005\u0004\u0002\u000e\u0005U\u0013\u0011L\u0005\u0005\u0003/\nyA\u0001\tS_^<&/\u001b;fe\u001a\u000b7\r^8ssB!\u0011qEA.\u0013\r\ti\u0006\u000f\u0002\u0004%><\u0018\u0001\u0002:xM\u0002\n!cY1tg\u0006tGM]1D_:tWm\u0019;peV\tq/A\ndCN\u001c\u0018M\u001c3sC\u000e{gN\\3di>\u0014\b%\u0001\u0005uC\ndW\rR3g!\rA\u00181N\u0005\u0004\u0003[J(\u0001\u0003+bE2,G)\u001a4\u0002\rM\u001c\u0007.Z7b+\u00059\u0017AB5og\u0016\u0014H\u000f\u0006\u0004\u0002x\u0005u\u0014Q\u0015\t\u0004E\u0006e\u0014bAA>G\n!QK\\5u\u0011\u001d\ty(\u0006a\u0001\u0003\u0003\u000bA\u0001Z1uCB!\u00111QAP\u001d\u0011\t))a'\u000f\t\u0005\u001d\u0015\u0011\u0014\b\u0005\u0003\u0013\u000b9J\u0004\u0003\u0002\f\u0006Ue\u0002BAG\u0003'k!!a$\u000b\u0007\u0005E5,\u0001\u0004=e>|GOP\u0005\u0002\u007f%\u0011QHP\u0005\u0003wqJ!!\u000f\u001e\n\u0007\u0005u\u0005(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0005\u00161\u0015\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T1!!(9\u0011\u0019\t9+\u0006a\u0001]\u0006IqN^3soJLG/Z\u0001\fg&TX-\u00138CsR,7/F\u0001u\u0003\u001d\u0011\u0017m]3SI\u0012\u0004Ra`AY\u0003kKA!a-\u0002\u0002\t)2)Y:tC:$'/\u0019+bE2,7kY1o%\u0012#\u0005cA/\u00028&\u0019\u0011\u0011\u0018\u001c\u0003\u001f\r\u000b7o]1oIJ\f7+\u0015'S_^\f\u0011BY;jY\u0012\u001c6-\u00198\u0015\u0005\u0005}\u0006CBAa\u0003\u000b\fI&\u0004\u0002\u0002D*\u0019\u00111\u0001\u001e\n\t\u0005\u001d\u00171\u0019\u0002\u0004%\u0012#\u0015\u0001E;oQ\u0006tG\r\\3e\r&dG/\u001a:t)\u0011\ti-!7\u0011\u000b\t\fy-a5\n\u0007\u0005E7MA\u0003BeJ\f\u0017\u0010E\u0002C\u0003+L1!a6D\u0005\u00191\u0015\u000e\u001c;fe\"9\u00111\\\rA\u0002\u00055\u0017a\u00024jYR,'o]\u0001\u0010C\u0012$\u0017\u000e^5p]\u0006d'+\u001e7fgV\u0011\u0011\u0011\u001d\t\u0007\u0003G\fY/!=\u000f\t\u0005\u0015\u0018\u0011\u001e\b\u0005\u0003\u001b\u000b9/C\u0001e\u0013\r\tijY\u0005\u0005\u0003[\fyOA\u0002TKFT1!!(d!\ri\u00161_\u0005\u0004\u0003k4$aF\"bgN\fg\u000e\u001a:b!J,G-[2bi\u0016\u0014V\u000f\\3t\u0003E\u0001(/\u001a3jG\u0006$X\rU;tQ\u0012{wO\u001c\u000b\u0005\u0003w\u0014\t\u0001E\u0002^\u0003{L1!a@7\u0005I\te.\u00197zu\u0016$\u0007K]3eS\u000e\fG/Z:\t\u000f\u0005m7\u00041\u0001\u0002NR1\u0011q\u0018B\u0003\u00057AqAa\u0002\u001d\u0001\u0004\u0011I!A\bsKF,\u0018N]3e\u0007>dW/\u001c8t!\u0015\u0011\u0017q\u001aB\u0006!\u0011\u0011iA!\u0006\u000f\t\t=!\u0011\u0003\t\u0004\u0003\u001b\u001b\u0017b\u0001B\nG\u00061\u0001K]3eK\u001aLAAa\u0006\u0003\u001a\t11\u000b\u001e:j]\u001eT1Aa\u0005d\u0011\u001d\tY\u000e\ba\u0001\u0003\u001b\u0014qA\u0015#E)f\u0004X\rE\u0003\u0000\u0005C\t),\u0003\u0003\u0003$\u0005\u0005!\u0001D\"bgN\fg\u000e\u001a:b%\u0012#\u0015aC7bs\n,7+\u001a7fGR$b!a0\u0003*\t=\u0002bBA\u0002=\u0001\u0007!1\u0006\t\u0004\u0005[iR\"\u0001\u0001\t\u000f\t\u001da\u00041\u0001\u0003\n\u0005!R.Y=cKB+8\u000f\u001b3po:4\u0015\u000e\u001c;feN$bAa\u000b\u00036\t]\u0002bBA\u0002?\u0001\u0007!1\u0006\u0005\b\u00037|\u0002\u0019\u0001B\u001d!\u0019\t\u0019/a;\u0002T\u0006\u0019b-\u001b7uKJ$vnQ9m\u0003:$g+\u00197vKR!!q\bB'!\u001d\u0011'\u0011\tB\u0006\u0005\u000bJ1Aa\u0011d\u0005\u0019!V\u000f\u001d7feA1\u00111]Av\u0005\u000f\u00022A\u0019B%\u0013\r\u0011Ye\u0019\u0002\u0004\u0003:L\bb\u0002B(A\u0001\u0007!qI\u0001\u0007M&dG/\u001a:\u0002\u0017Q|7)\u001d7WC2,Xm\u001d\u000b\u0007\u0005\u000b\u0012)F!\u0017\t\u000f\t]\u0013\u00051\u0001\u0003\f\u0005Q1m\u001c7v[:t\u0015-\\3\t\u000f\tm\u0013\u00051\u0001\u0003^\u00051a/\u00197vKN\u0004RAYAh\u0005\u000f\n!\u0002^8Dc24\u0016\r\\;f)\u0019\u00119Ea\u0019\u0003f!9!q\u000b\u0012A\u0002\t-\u0001b\u0002B4E\u0001\u0007!qI\u0001\u0006m\u0006dW/Z\u0001\fo\",'/Z\"mCV\u001cX\r\u0006\u0003\u0003@\t5\u0004b\u0002B8G\u0001\u0007!QI\u0001\u0010aV\u001c\b\u000eZ8x]\u001aKG\u000e^3sg\u000692)Y:tC:$'/Y*pkJ\u001cWMU3mCRLwN\u001c\t\u0003;\u0016\u001a2!\nB<!\r\u0011'\u0011P\u0005\u0004\u0005w\u001a'AB!osJ+g\r\u0006\u0002\u0003t\u0005\u0001\"+\u001a4fe\u0016t7-Z*fGRLwN\\\u000b\u0003\u0005\u0007\u0003BA!\"\u0003\u00106\u0011!q\u0011\u0006\u0005\u0005\u0013\u0013Y)\u0001\u0003mC:<'B\u0001BG\u0003\u0011Q\u0017M^1\n\t\t]!qQ\u0001\u0012%\u00164WM]3oG\u0016\u001cVm\u0019;j_:\u0004\u0013!\u0006+bE2,7+\u001b>f\u0013:\u0014\u0015\u0010^3t!\u0006\u0014\u0018-\\\u000b\u0003\u0005/\u0003BA\u0014BMg&\u0019!1T(\u0003\u001f\r{gNZ5h!\u0006\u0014\u0018-\\3uKJ\fa\u0003V1cY\u0016\u001c\u0016N_3J]\nKH/Z:QCJ\fW\u000eI\u0001&\u0003\u0012$\u0017\u000e^5p]\u0006d7)Y:tC:$'/\u0019)vg\"$un\u001e8Sk2,7\u000fU1sC6,\"Aa)\u0011\u000b9\u0013IJ!*\u0011\r\u0005\r(qUAy\u0013\u0011\u0011I+a<\u0003\t1K7\u000f^\u0001'\u0003\u0012$\u0017\u000e^5p]\u0006d7)Y:tC:$'/\u0019)vg\"$un\u001e8Sk2,7\u000fU1sC6\u0004\u0013A\u0003)s_B,'\u000f^5fgV\u0011!\u0011\u0017\t\u0007\u0005g\u0013ILa/\u000e\u0005\tU&b\u0001B\\G\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u00055(Q\u0017\u0019\u0005\u0005{\u0013\u0019\rE\u0003O\u00053\u0013y\f\u0005\u0003\u0003B\n\rG\u0002\u0001\u0003\f\u0005\u000b\u0004\u0011\u0011!A\u0001\u0006\u0003\u00119M\u0001\u0002`cE!!\u0011\u001aBm%\u0015\u0011Ym\u001dBh\r\u0019\u0011i\r\u0001\u0001\u0003J\naAH]3gS:,W.\u001a8u}A1!\u0011\u001bBl\u0003cl!Aa5\u000b\t\tU'QW\u0001\nS6lW\u000f^1cY\u0016LAA!+\u0003TJA!1\u001cBo\u0005G\u0014IO\u0002\u0004\u0003N\u0002\u0001!\u0011\u001c\t\u0004E\n}\u0017b\u0001BqG\n9\u0001K]8ek\u000e$\bc\u00012\u0003f&\u0019!q]2\u0003\u0019M+'/[1mSj\f'\r\\3\u0011\t\t\u0015%1^\u0005\u0005\u0005[\u00149I\u0001\u0004PE*,7\r^\u0001\f!J|\u0007/\u001a:uS\u0016\u001c\b%\u0001\neK\u001a\fW\u000f\u001c;DYV\u001cH/\u001a:OC6,\u0017a\u00053fM\u0006,H\u000e^\"mkN$XM\u001d(b[\u0016\u0004\u0013!B1qa2LHCCA\u001a\u0005s\u0014YP!@\u0004\b!)!,\ra\u00019\"9\u0011\u0011E\u0019A\u0002\u0005\u0015\u0002\"\u0003B\u0000cA\u0005\t\u0019AB\u0001\u0003\u001dy\u0007\u000f^5p]N\u00042!XB\u0002\u0013\r\u0019)A\u000e\u0002\u0017\u0007\u0006\u001c8/\u00198ee\u0006\u001cv.\u001e:dK>\u0003H/[8og\"A\u0011qN\u0019\u0011\u0002\u0003\u0007\u0011-A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019iA\u000b\u0003\u0004\u0002\r=1FAB\t!\u0011\u0019\u0019b!\b\u000e\u0005\rU!\u0002BB\f\u00073\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\rm1-\u0001\u0006b]:|G/\u0019;j_:LAaa\b\u0004\u0016\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQ*\"a!\n+\u0007\u0005\u001cy!\u0001\td_:\u001cx\u000e\\5eCR,7i\u001c8ggRQ\u0011\u0011DB\u0016\u0007[\u00199d!\u000f\t\u000f\u0005]A\u00071\u0001\u0002\u001a!91q\u0006\u001bA\u0002\rE\u0012aB:rY\u000e{gN\u001a\t\t\u0005\u001b\u0019\u0019Da\u0003\u0003\f%!1Q\u0007B\r\u0005\ri\u0015\r\u001d\u0005\u00065R\u0002\r\u0001\u0018\u0005\b\u0007w!\u0004\u0019AB\u0019\u0003%!\u0018M\u00197f\u0007>tg\r")
public class CassandraSourceRelation
extends BaseRelation
implements InsertableRelation,
PrunedFilteredScan,
Logging {
    private Seq<CassandraPredicateRules> additionalRules;
    private final TableRef tableRef;
    private final Option<StructType> userSpecifiedSchema;
    private final boolean filterPushdown;
    private final boolean confirmTruncate;
    private final Option<Object> tableSizeInBytes;
    private final CassandraConnector connector;
    private final WriteConf writeConf;
    private final SparkConf sparkConf;
    private final SQLContext sqlContext;
    private final ReadConf readconf;
    private final RowWriterFactory<Row> rwf;
    private final CassandraConnector cassandraConnector;
    private final TableDef tableDef;
    private final CassandraTableScanRDD<CassandraSQLRow> baseRdd;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;
    private volatile boolean bitmap$0;

    public static SparkConf consolidateConfs(SparkConf sparkConf, Map<String, String> map, TableRef tableRef, Map<String, String> map2) {
        return CassandraSourceRelation$.MODULE$.consolidateConfs(sparkConf, map, tableRef, map2);
    }

    public static Option<StructType> apply$default$4() {
        return CassandraSourceRelation$.MODULE$.apply$default$4();
    }

    public static CassandraSourceOptions apply$default$3() {
        return CassandraSourceRelation$.MODULE$.apply$default$3();
    }

    public static CassandraSourceRelation apply(TableRef tableRef, SQLContext sQLContext, CassandraSourceOptions cassandraSourceOptions, Option<StructType> option) {
        return CassandraSourceRelation$.MODULE$.apply(tableRef, sQLContext, cassandraSourceOptions, option);
    }

    public static String defaultClusterName() {
        return CassandraSourceRelation$.MODULE$.defaultClusterName();
    }

    public static Seq<ConfigParameter<? extends Object>> Properties() {
        return CassandraSourceRelation$.MODULE$.Properties();
    }

    public static ConfigParameter<List<CassandraPredicateRules>> AdditionalCassandraPushDownRulesParam() {
        return CassandraSourceRelation$.MODULE$.AdditionalCassandraPushDownRulesParam();
    }

    public static ConfigParameter<Option<Object>> TableSizeInBytesParam() {
        return CassandraSourceRelation$.MODULE$.TableSizeInBytesParam();
    }

    public static String ReferenceSection() {
        return CassandraSourceRelation$.MODULE$.ReferenceSection();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    @Override
    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public ReadConf readconf() {
        return this.readconf;
    }

    public RowWriterFactory<Row> rwf() {
        return this.rwf;
    }

    public CassandraConnector cassandraConnector() {
        return this.cassandraConnector;
    }

    public StructType schema() {
        return (StructType)this.userSpecifiedSchema.getOrElse((Function0 & Serializable & scala.Serializable)() -> StructType$.MODULE$.apply((Seq)$this.tableDef.columns().map((Function1 & Serializable & scala.Serializable)column -> DataTypeConverter$.MODULE$.toStructField((ColumnDef)column), IndexedSeq$.MODULE$.canBuildFrom())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insert(Dataset<Row> data, boolean overwrite) {
        Object object;
        if (overwrite) {
            if (!this.confirmTruncate) throw new UnsupportedOperationException(new StringOps(Predef$.MODULE$.augmentString("You are attempting to use overwrite mode which will truncate\n          |this table prior to inserting data. If you would merely like\n          |to change data already in the table use the \"Append\" mode.\n          |To actually truncate please pass in true value to the option\n          |\"confirm.truncate\" when saving. ")).stripMargin());
            String keyspace = Quote$.MODULE$.quote(this.tableRef.keyspace());
            String table = Quote$.MODULE$.quote(this.tableRef.table());
            object = this.connector.withSessionDo((Function1 & Serializable & scala.Serializable)session -> session.execute(new StringBuilder(10).append("TRUNCATE ").append(keyspace).append(".").append(table).toString()));
        } else {
            object = BoxedUnit.UNIT;
        }
        SomeColumns columns = new SomeColumns((Seq<ColumnRef>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data.columns())).map((Function1 & Serializable & scala.Serializable)x -> com.datastax.spark.connector.package$.MODULE$.toNamedColumnRef((String)x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ColumnRef.class)))));
        com.datastax.spark.connector.package$.MODULE$.toRDDFunctions(data.rdd()).saveToCassandra(this.tableRef.keyspace(), this.tableRef.table(), columns, this.writeConf, this.cassandraConnector(), this.rwf());
    }

    public long sizeInBytes() {
        return BoxesRunTime.unboxToLong((Object)this.tableSizeInBytes.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.sqlContext().conf().defaultSizeInBytes()));
    }

    public RDD<Row> buildScan() {
        return this.baseRdd;
    }

    public Filter[] unhandledFilters(Filter[] filters) {
        Filter[] filterArray;
        boolean bl = this.filterPushdown;
        if (bl) {
            filterArray = (Filter[])this.predicatePushDown(filters).handledBySpark().toArray(ClassTag$.MODULE$.apply(Filter.class));
        } else if (!bl) {
            filterArray = filters;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return filterArray;
    }

    private Seq<CassandraPredicateRules> additionalRules$lzycompute() {
        CassandraSourceRelation cassandraSourceRelation = this;
        synchronized (cassandraSourceRelation) {
            if (!this.bitmap$0) {
                Seq seq;
                SparkContext sc = this.sqlContext().sparkContext();
                Option userClasses = sc.getConf().getOption(CassandraSourceRelation$.MODULE$.AdditionalCassandraPushDownRulesParam().name()).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)sc.getLocalProperty(CassandraSourceRelation$.MODULE$.AdditionalCassandraPushDownRulesParam().name())));
                Option option = userClasses;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String classes = (String)some.value();
                    seq = Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])classes.trim().split("\\s*,\\s*"))).map((Function1 & Serializable & scala.Serializable)objectName -> {
                        JavaUniverse $u = package$.MODULE$.universe();
                        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CassandraSourceRelation.class.getClassLoader());
                        public final class Org_apache_spark_sql_cassandra_CassandraSourceRelation$$typecreator1$1
                        extends TypeCreator {
                            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                                Universe $u = $m$untyped.universe();
                                Mirror<U> $m = $m$untyped;
                                return $m.staticClass("org.apache.spark.sql.cassandra.CassandraPredicateRules").asType().toTypeConstructor();
                            }

                            public Org_apache_spark_sql_cassandra_CassandraSourceRelation$$typecreator1$1(CassandraSourceRelation $outer) {
                            }
                        }
                        return (CassandraPredicateRules)ReflectionUtil$.MODULE$.findGlobalObject((String)objectName, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_cassandra_CassandraSourceRelation$$typecreator1$1(null)));
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(CassandraPredicateRules.class))))).reverse());
                } else if (None$.MODULE$.equals(option)) {
                    seq = (Seq)CassandraSourceRelation$.MODULE$.AdditionalCassandraPushDownRulesParam().default();
                } else {
                    throw new MatchError((Object)option);
                }
                this.additionalRules = seq;
                this.bitmap$0 = true;
            }
        }
        return this.additionalRules;
    }

    public Seq<CassandraPredicateRules> additionalRules() {
        return !this.bitmap$0 ? this.additionalRules$lzycompute() : this.additionalRules;
    }

    private AnalyzedPredicates predicatePushDown(Filter[] filters) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Input Predicates: [").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filters)).mkString(", ")).append("]").toString());
        ProtocolVersion pv = (ProtocolVersion)((Object)this.connector.withClusterDo((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getConfiguration().getProtocolOptions().getProtocolVersion()));
        BasicCassandraPredicatePushDown<Filter> bcpp = new BasicCassandraPredicatePushDown<Filter>(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filters)).toSet(), this.tableDef, pv, PredicateOps$FilterOps$.MODULE$);
        AnalyzedPredicates basicPushdown = new AnalyzedPredicates(bcpp.predicatesToPushDown(), bcpp.predicatesToPreserve());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Basic Rules Applied:\n").append(basicPushdown).toString());
        AnalyzedPredicates finalPushdown = (AnalyzedPredicates)this.additionalRules().foldRight((Object)basicPushdown, (Function2 & Serializable & scala.Serializable)(rules, pushdowns) -> {
            void var3_3;
            AnalyzedPredicates pd = rules.apply((AnalyzedPredicates)pushdowns, $this.tableDef, $this.sparkConf);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Applied ").append(rules.getClass().getSimpleName()).append(" Pushdown Filters:\n").append(pd).toString());
            return var3_3;
        });
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Final Pushdown filters:\n").append(finalPushdown).toString());
        return finalPushdown;
    }

    public RDD<Row> buildScan(String[] requiredColumns, Filter[] filters) {
        CassandraRDD cassandraRDD;
        if (this.filterPushdown) {
            Filter[] pushdownFilters = (Filter[])this.predicatePushDown(filters).handledByCassandra().toArray(ClassTag$.MODULE$.apply(Filter.class));
            cassandraRDD = this.maybePushdownFilters(this.baseRdd, (Seq<Filter>)Predef$.MODULE$.wrapRefArray((Object[])pushdownFilters));
        } else {
            cassandraRDD = this.baseRdd;
        }
        CassandraTableScanRDD<CassandraSQLRow> filteredRdd = cassandraRDD;
        return this.maybeSelect(filteredRdd, requiredColumns);
    }

    private RDD<Row> maybeSelect(CassandraRDD<CassandraSQLRow> rdd, String[] requiredColumns) {
        CassandraRDD cassandraRDD;
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)).nonEmpty()) {
            cassandraRDD = rdd.select((Seq<ColumnRef>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)).map((Function1 & Serializable & scala.Serializable)column -> com.datastax.spark.connector.package$.MODULE$.toNamedColumnRef((String)column), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ColumnRef.class)))));
        } else {
            CassandraRDD cassandraRDD2;
            CassandraRDD cassandraRDD3 = rdd;
            if (cassandraRDD3 instanceof CassandraTableScanRDD) {
                CassandraTableScanRDD cassandraTableScanRDD = (CassandraTableScanRDD)cassandraRDD3;
                CassandraTableScanRDD<Object> qual$1 = CassandraTableScanRDD$.MODULE$.countRDD(cassandraTableScanRDD);
                Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)x$2 -> x$2.flatMap((Function1 & Serializable & scala.Serializable)count -> CassandraSourceRelation.$anonfun$maybeSelect$3(BoxesRunTime.unboxToLong((Object)count)));
                boolean x$22 = qual$1.mapPartitions$default$2();
                cassandraRDD2 = qual$1.mapPartitions(x$1, x$22, ClassTag$.MODULE$.apply(CassandraSQLRow.class));
            } else {
                cassandraRDD2 = rdd;
            }
            cassandraRDD = cassandraRDD2;
        }
        CassandraRDD prunedRdd = cassandraRDD;
        return prunedRdd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CassandraRDD<CassandraSQLRow> maybePushdownFilters(CassandraRDD<CassandraSQLRow> rdd, Seq<Filter> filters) {
        Tuple2<String, Seq<Object>> tuple2 = this.whereClause(filters);
        if (tuple2 == null) return rdd;
        String cql = (String)tuple2._1();
        Seq values = (Seq)tuple2._2();
        if (!values.nonEmpty()) return rdd;
        return rdd.where(cql, (Seq<Object>)values);
    }

    private Tuple2<String, Seq<Object>> filterToCqlAndValue(Object filter) {
        Tuple2 tuple2;
        Object object = filter;
        if (object instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)object;
            String attribute = equalTo.attribute();
            Object value = equalTo.value();
            tuple2 = new Tuple2((Object)new StringBuilder(4).append(Quote$.MODULE$.quote(attribute)).append(" = ?").toString(), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toCqlValue(attribute, value)})));
        } else if (object instanceof LessThan) {
            LessThan lessThan = (LessThan)object;
            String attribute = lessThan.attribute();
            Object value = lessThan.value();
            tuple2 = new Tuple2((Object)new StringBuilder(4).append(Quote$.MODULE$.quote(attribute)).append(" < ?").toString(), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toCqlValue(attribute, value)})));
        } else if (object instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)object;
            String attribute = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            tuple2 = new Tuple2((Object)new StringBuilder(5).append(Quote$.MODULE$.quote(attribute)).append(" <= ?").toString(), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toCqlValue(attribute, value)})));
        } else if (object instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)object;
            String attribute = greaterThan.attribute();
            Object value = greaterThan.value();
            tuple2 = new Tuple2((Object)new StringBuilder(4).append(Quote$.MODULE$.quote(attribute)).append(" > ?").toString(), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toCqlValue(attribute, value)})));
        } else if (object instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)object;
            String attribute = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            tuple2 = new Tuple2((Object)new StringBuilder(5).append(Quote$.MODULE$.quote(attribute)).append(" >= ?").toString(), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toCqlValue(attribute, value)})));
        } else if (object instanceof In) {
            In in = (In)object;
            String attribute = in.attribute();
            Object[] values = in.values();
            tuple2 = new Tuple2((Object)new StringBuilder(4).append(Quote$.MODULE$.quote(attribute)).append(" IN ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)values).map((Function1 & Serializable & scala.Serializable)x$3 -> "?", Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("(", ", ", ")")).toString(), this.toCqlValues(attribute, values));
        } else {
            throw new UnsupportedOperationException(new StringBuilder(81).append("It's not a valid filter ").append(filter).append(" to be pushed down, only >, <, >=, <= and In are allowed.").toString());
        }
        return tuple2;
    }

    private Seq<Object> toCqlValues(String columnName, Object[] values) {
        return Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps((Object)values).map((Function1 & Serializable & scala.Serializable)x$4 -> this.toCqlValue(columnName, x$4), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).toSeq();
    }

    private Object toCqlValue(String columnName, Object value) {
        Object object;
        Object object2 = value;
        if (object2 instanceof Decimal) {
            Decimal decimal = (Decimal)object2;
            ColumnType<?> columnType = ((ColumnDef)this.tableDef.columnByName().apply((Object)columnName)).columnType();
            VarIntType$ varIntType$ = VarIntType$.MODULE$;
            boolean isVarIntColumn = !(columnType != null ? !columnType.equals(varIntType$) : varIntType$ != null);
            object = isVarIntColumn ? decimal.toJavaBigDecimal().toBigInteger() : decimal;
        } else if (object2 instanceof UTF8String) {
            Serializable serializable;
            ColumnType<?> columnType;
            UTF8String uTF8String = (UTF8String)object2;
            ColumnType<?> columnType2 = columnType = ((ColumnDef)this.tableDef.columnByName().apply((Object)columnName)).columnType();
            InetType$ inetType$ = InetType$.MODULE$;
            if (!(columnType2 != null ? !columnType2.equals(inetType$) : inetType$ != null)) {
                serializable = InetAddress.getByName(uTF8String.toString());
            } else {
                ColumnType<?> columnType3 = columnType;
                UUIDType$ uUIDType$ = UUIDType$.MODULE$;
                serializable = !(columnType3 != null ? !columnType3.equals(uUIDType$) : uUIDType$ != null) ? UUID.fromString(uTF8String.toString()) : uTF8String;
            }
            object = serializable;
        } else {
            object = object2;
        }
        return object;
    }

    private Tuple2<String, Seq<Object>> whereClause(Seq<Object> pushdownFilters) {
        Seq cqlValue = (Seq)pushdownFilters.map((Function1 & Serializable & scala.Serializable)filter -> this.filterToCqlAndValue(filter), Seq$.MODULE$.canBuildFrom());
        String cql = ((TraversableOnce)cqlValue.map((Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5._1(), Seq$.MODULE$.canBuildFrom())).mkString(" AND ");
        Seq args = (Seq)cqlValue.flatMap((Function1 & Serializable & scala.Serializable)x$6 -> (Seq)x$6._2(), Seq$.MODULE$.canBuildFrom());
        return new Tuple2((Object)cql, (Object)args);
    }

    public static final /* synthetic */ Iterator $anonfun$maybeSelect$3(long count) {
        return scala.package$.MODULE$.Iterator().fill((int)count, (Function0 & Serializable & scala.Serializable)() -> CassandraSQLRow$.MODULE$.empty());
    }

    public CassandraSourceRelation(TableRef tableRef, Option<StructType> userSpecifiedSchema, boolean filterPushdown, boolean confirmTruncate, Option<Object> tableSizeInBytes, CassandraConnector connector, ReadConf readConf, WriteConf writeConf, SparkConf sparkConf, SQLContext sqlContext) {
        this.tableRef = tableRef;
        this.userSpecifiedSchema = userSpecifiedSchema;
        this.filterPushdown = filterPushdown;
        this.confirmTruncate = confirmTruncate;
        this.tableSizeInBytes = tableSizeInBytes;
        this.connector = connector;
        this.writeConf = writeConf;
        this.sparkConf = sparkConf;
        this.sqlContext = sqlContext;
        Logging.$init$(this);
        this.readconf = readConf;
        this.rwf = SqlRowWriter$Factory$.MODULE$;
        this.cassandraConnector = connector;
        this.tableDef = Schema$.MODULE$.tableFromCassandra(connector, tableRef.keyspace(), tableRef.table());
        this.baseRdd = com.datastax.spark.connector.package$.MODULE$.toSparkContextFunctions(sqlContext.sparkContext()).cassandraTable(tableRef.keyspace(), tableRef.table(), this.cassandraConnector(), this.readconf(), ClassTag$.MODULE$.apply(CassandraSQLRow.class), CassandraSQLRow$CassandraSQLRowReader$.MODULE$, ValidRDDType$.MODULE$.javaSerializableAsValidRDDType());
    }
}

