/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.google.common.collect;

import java.io.Serializable;
import javax.annotation.Nullable;
import shade.com.datastax.spark.connector.google.common.annotations.GwtCompatible;
import shade.com.datastax.spark.connector.google.common.base.Function;
import shade.com.datastax.spark.connector.google.common.base.Objects;
import shade.com.datastax.spark.connector.google.common.base.Preconditions;
import shade.com.datastax.spark.connector.google.common.collect.Ordering;

@GwtCompatible(serializable=true)
final class ByFunctionOrdering<F, T>
extends Ordering<F>
implements Serializable {
    final Function<F, ? extends T> function;
    final Ordering<T> ordering;
    private static final long serialVersionUID = 0L;

    ByFunctionOrdering(Function<F, ? extends T> function, Ordering<T> ordering) {
        this.function = Preconditions.checkNotNull(function);
        this.ordering = Preconditions.checkNotNull(ordering);
    }

    @Override
    public int compare(F left, F right) {
        return this.ordering.compare(this.function.apply(left), this.function.apply(right));
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ByFunctionOrdering) {
            ByFunctionOrdering that = (ByFunctionOrdering)object;
            return this.function.equals(that.function) && this.ordering.equals(that.ordering);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.function, this.ordering);
    }

    public String toString() {
        String string = String.valueOf(String.valueOf(this.ordering));
        String string2 = String.valueOf(String.valueOf(this.function));
        return new StringBuilder(13 + string.length() + string2.length()).append(string).append(".onResultOf(").append(string2).append(")").toString();
    }
}

