/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.CassandraConnector$;
import com.datastax.spark.connector.cql.ClusteringColumn;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.ColumnRole;
import com.datastax.spark.connector.cql.PartitionKeyColumn$;
import com.datastax.spark.connector.cql.RegularColumn$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.mapper.DataFrameColumnMapper;
import com.datastax.spark.connector.types.ColumnType;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.cassandra.AlwaysOn$;
import org.apache.spark.sql.cassandra.CassandraSourceRelation$;
import org.apache.spark.sql.cassandra.DirectJoinSetting;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005}e\u0001\u0002\t\u0012\u0001iA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\ty\u0001\u0011\u0019\u0011)A\u0006{!)\u0001\t\u0001C\u0001\u0003\"9q\t\u0001b\u0001\n\u0003A\u0005BB'\u0001A\u0003%\u0011\nC\u0003O\u0001\u0011\u0005q\nC\u0004Y\u0001E\u0005I\u0011A-\t\u000b\u0011\u0004A\u0011A3\t\u0013\u0005E\u0002!%A\u0005\u0002\u0005M\u0002\"CA\u001c\u0001E\u0005I\u0011AA\u001a\u0011%\tI\u0004AI\u0001\n\u0003\tY\u0004C\u0004\u0002H\u0001!\t!!\u0013\t\u0013\u0005\r\u0005!%A\u0005\u0002\u0005\u0015\u0005\"CAE\u0001E\u0005I\u0011AAF\u0011%\ty\tAI\u0001\n\u0003\t\tJ\u0001\tECR\f7/\u001a;Gk:\u001cG/[8og*\u0011!cE\u0001\nG>tg.Z2u_JT!\u0001F\u000b\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y9\u0012\u0001\u00033bi\u0006\u001cH/\u0019=\u000b\u0003a\t1aY8n\u0007\u0001)\"aG\u001a\u0014\u0007\u0001a\"\u0005\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0004B]f\u0014VM\u001a\t\u0003;\rJ!\u0001\n\u0010\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000f\u0011\fG/Y:fiB\u0019qeL\u0019\u000e\u0003!R!!\u000b\u0016\u0002\u0007M\fHN\u0003\u0002\u0015W)\u0011A&L\u0001\u0007CB\f7\r[3\u000b\u00039\n1a\u001c:h\u0013\t\u0001\u0004FA\u0004ECR\f7/\u001a;\u0011\u0005I\u001aD\u0002\u0001\u0003\u0006i\u0001\u0011\r!\u000e\u0002\u0002\u0017F\u0011a'\u000f\t\u0003;]J!\u0001\u000f\u0010\u0003\u000f9{G\u000f[5oOB\u0011QDO\u0005\u0003wy\u00111!\u00118z\u0003))g/\u001b3f]\u000e,G%\r\t\u0004Oy\n\u0014BA )\u0005\u001d)enY8eKJ\fa\u0001P5oSRtDC\u0001\"G)\t\u0019U\tE\u0002E\u0001Ej\u0011!\u0005\u0005\u0006y\r\u0001\u001d!\u0010\u0005\u0006K\r\u0001\rAJ\u0001\rgB\f'o[\"p]R,\u0007\u0010^\u000b\u0002\u0013B\u0011!jS\u0007\u0002U%\u0011AJ\u000b\u0002\r'B\f'o[\"p]R,\u0007\u0010^\u0001\u000egB\f'o[\"p]R,\u0007\u0010\u001e\u0011\u0002\u0015\u0011L'/Z2u\u0015>Lg\u000e\u0006\u0002'!\"9\u0011K\u0002I\u0001\u0002\u0004\u0011\u0016!\u00053je\u0016\u001cGOS8j]N+G\u000f^5oOB\u00111KV\u0007\u0002)*\u0011Q\u000bK\u0001\nG\u0006\u001c8/\u00198ee\u0006L!a\u0016+\u0003#\u0011K'/Z2u\u0015>LgnU3ui&tw-\u0001\u000beSJ,7\r\u001e&pS:$C-\u001a4bk2$H%M\u000b\u00025*\u0012!kW\u0016\u00029B\u0011QLY\u0007\u0002=*\u0011q\fY\u0001\nk:\u001c\u0007.Z2lK\u0012T!!\u0019\u0010\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002d=\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002)\r\u0014X-\u0019;f\u0007\u0006\u001c8/\u00198ee\u0006$\u0016M\u00197f)\u001d1\u0017O`A\u0001\u0003;!\"a\u001a6\u0011\u0005uA\u0017BA5\u001f\u0005\u0011)f.\u001b;\t\u000fIA\u0001\u0013!a\u0002WB\u0011An\\\u0007\u0002[*\u0011a.E\u0001\u0004GFd\u0017B\u00019n\u0005I\u0019\u0015m]:b]\u0012\u0014\u0018mQ8o]\u0016\u001cGo\u001c:\t\u000bID\u0001\u0019A:\u0002\u0019-,\u0017p\u001d9bG\u0016t\u0015-\\3\u0011\u0005Q\\hBA;z!\t1h$D\u0001x\u0015\tA\u0018$\u0001\u0004=e>|GOP\u0005\u0003uz\ta\u0001\u0015:fI\u00164\u0017B\u0001?~\u0005\u0019\u0019FO]5oO*\u0011!P\b\u0005\u0006\u007f\"\u0001\ra]\u0001\ni\u0006\u0014G.\u001a(b[\u0016D\u0011\"a\u0001\t!\u0003\u0005\r!!\u0002\u0002'A\f'\u000f^5uS>t7*Z=D_2,XN\\:\u0011\u000bu\t9!a\u0003\n\u0007\u0005%aD\u0001\u0004PaRLwN\u001c\t\u0006\u0003\u001b\t9b\u001d\b\u0005\u0003\u001f\t\u0019BD\u0002w\u0003#I\u0011aH\u0005\u0004\u0003+q\u0012a\u00029bG.\fw-Z\u0005\u0005\u00033\tYBA\u0002TKFT1!!\u0006\u001f\u0011%\ty\u0002\u0003I\u0001\u0002\u0004\t)!\u0001\u000bdYV\u001cH/\u001a:j]\u001e\\U-_\"pYVlgn\u001d\u0015\b\u0011\u0005\r\u0012\u0011FA\u0017!\ri\u0012QE\u0005\u0004\u0003Oq\"A\u00033faJ,7-\u0019;fI\u0006\u0012\u00111F\u0001\u001d+N,\u0007\u0005R1uCN|WO]2f-J\u00023)\u0019;bY><\u0007%\u00119jC\t\ty#A\u00034]Ar\u0003'\u0001\u0010de\u0016\fG/Z\"bgN\fg\u000e\u001a:b)\u0006\u0014G.\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u0007\u0016\u0004\u0003\u000bY\u0016AH2sK\u0006$XmQ1tg\u0006tGM]1UC\ndW\r\n3fM\u0006,H\u000e\u001e\u00135\u0003y\u0019'/Z1uK\u000e\u000b7o]1oIJ\fG+\u00192mK\u0012\"WMZ1vYR$S\u0007\u0006\u0006\u0002>\u0005}\u0012\u0011IA\"\u0003\u000bR#a[.\t\u000bI\\\u0001\u0019A:\t\u000b}\\\u0001\u0019A:\t\u000f\u0005\r1\u00021\u0001\u0002\u0006!9\u0011qD\u0006A\u0002\u0005\u0015\u0011AF2sK\u0006$XmQ1tg\u0006tGM]1UC\ndW-\u0012=\u0015\u001d\u0005-\u0013qJA)\u0003'\n)&!\u001c\u0002xQ\u0019q-!\u0014\t\u000fIa\u0001\u0013!a\u0002W\")!\u000f\u0004a\u0001g\")q\u0010\u0004a\u0001g\"9\u00111\u0001\u0007A\u0002\u0005-\u0001bBA\u0010\u0019\u0001\u0007\u0011q\u000b\t\u0007\u0003\u001b\t9\"!\u0017\u0011\ru\tYf]A0\u0013\r\tiF\b\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005\u0005\u0014q\r\b\u0004Y\u0006\r\u0014bAA3[\u0006\u00012\t\\;ti\u0016\u0014\u0018N\\4D_2,XN\\\u0005\u0005\u0003S\nYG\u0001\u0007T_J$\u0018N\\4Pe\u0012,'OC\u0002\u0002f5D\u0011\"a\u001c\r!\u0003\u0005\r!!\u001d\u0002\u0017%4gj\u001c;Fq&\u001cHo\u001d\t\u0004;\u0005M\u0014bAA;=\t9!i\\8mK\u0006t\u0007\"CA=\u0019A\u0005\t\u0019AA>\u00031!\u0018M\u00197f\u001fB$\u0018n\u001c8t!\u0015!\u0018QP:t\u0013\r\ty( \u0002\u0004\u001b\u0006\u0004\bf\u0002\u0007\u0002$\u0005%\u0012QF\u0001!GJ,\u0017\r^3DCN\u001c\u0018M\u001c3sCR\u000b'\r\\3Fq\u0012\"WMZ1vYR$S'\u0006\u0002\u0002\b*\u001a\u0011\u0011O.\u0002A\r\u0014X-\u0019;f\u0007\u0006\u001c8/\u00198ee\u0006$\u0016M\u00197f\u000bb$C-\u001a4bk2$HEN\u000b\u0003\u0003\u001bS3!a\u001f\\\u0003\u0001\u001a'/Z1uK\u000e\u000b7o]1oIJ\fG+\u00192mK\u0016CH\u0005Z3gCVdG\u000fJ\u001c\u0015\u001d\u0005u\u00121SAK\u0003/\u000bI*a'\u0002\u001e\")!o\u0004a\u0001g\")qp\u0004a\u0001g\"9\u00111A\bA\u0002\u0005-\u0001bBA\u0010\u001f\u0001\u0007\u0011q\u000b\u0005\b\u0003_z\u0001\u0019AA9\u0011\u001d\tIh\u0004a\u0001\u0003w\u0002")
public class DatasetFunctions<K>
implements scala.Serializable {
    private final Dataset<K> dataset;
    private final Encoder<K> evidence$1;
    private final SparkContext sparkContext;

    public SparkContext sparkContext() {
        return this.sparkContext;
    }

    public Dataset<K> directJoin(DirectJoinSetting directJoinSetting) {
        return CassandraSourceRelation$.MODULE$.setDirectJoin(this.dataset, directJoinSetting, this.evidence$1);
    }

    public DirectJoinSetting directJoin$default$1() {
        return AlwaysOn$.MODULE$;
    }

    public void createCassandraTable(String keyspaceName, String tableName, Option<Seq<String>> partitionKeyColumns, Option<Seq<String>> clusteringKeyColumns, CassandraConnector connector) {
        ProtocolVersion protocolVersion = (ProtocolVersion)connector.withSessionDo((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getContext().getProtocolVersion());
        TableDef rawTable = new DataFrameColumnMapper(this.dataset.schema()).newTable(keyspaceName, tableName, protocolVersion);
        Seq partitionKeyNames = (Seq)partitionKeyColumns.getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)rawTable.partitionKey().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.columnName(), Seq$.MODULE$.canBuildFrom()));
        Seq clusteringKeyNames = (Seq)clusteringKeyColumns.getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
        this.createCassandraTableEx(keyspaceName, tableName, (Seq<String>)partitionKeyNames, (Seq<Tuple2<String, ClusteringColumn.SortingOrder>>)((Seq)clusteringKeyNames.map((Function1 & Serializable & scala.Serializable)x$3 -> new Tuple2(x$3, (Object)ClusteringColumn.Ascending$.MODULE$), Seq$.MODULE$.canBuildFrom())), this.createCassandraTableEx$default$5(), this.createCassandraTableEx$default$6(), connector);
    }

    public Option<Seq<String>> createCassandraTable$default$3() {
        return None$.MODULE$;
    }

    public Option<Seq<String>> createCassandraTable$default$4() {
        return None$.MODULE$;
    }

    public CassandraConnector createCassandraTable$default$5(String keyspaceName, String tableName, Option<Seq<String>> partitionKeyColumns, Option<Seq<String>> clusteringKeyColumns) {
        return CassandraConnector$.MODULE$.apply(this.sparkContext());
    }

    public void createCassandraTableEx(String keyspaceName, String tableName, Seq<String> partitionKeyColumns, Seq<Tuple2<String, ClusteringColumn.SortingOrder>> clusteringKeyColumns, boolean ifNotExists, Map<String, String> tableOptions, CassandraConnector connector) {
        ProtocolVersion protocolVersion = (ProtocolVersion)connector.withSessionDo((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getContext().getProtocolVersion());
        TableDef rawTable = new DataFrameColumnMapper(this.dataset.schema()).newTable(keyspaceName, tableName, protocolVersion);
        Map columnMapping = rawTable.columnByName();
        Set columnNames = columnMapping.keys().toSet();
        Seq<String> partitionKeyNames = partitionKeyColumns;
        Seq clusteringKeyNames = (Seq)clusteringKeyColumns.map((Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5._1(), Seq$.MODULE$.canBuildFrom());
        Seq regularColumnNames = ((SetLike)columnNames.$minus$minus((GenTraversableOnce)partitionKeyNames.$plus$plus((GenTraversableOnce)clusteringKeyNames, Seq$.MODULE$.canBuildFrom()))).toSeq();
        Seq x$10 = (Seq)((TraversableLike)partitionKeyNames.map((Function1 & Serializable & scala.Serializable)partitionKeyName -> (ColumnDef)columnMapping.getOrElse(partitionKeyName, (Function0 & Serializable & scala.Serializable)() -> {
            throw DatasetFunctions.missingColumnException$1(partitionKeyName, "Partition Key Column", columnNames);
        }), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$6 -> {
            PartitionKeyColumn$ x$1 = PartitionKeyColumn$.MODULE$;
            String x$2 = x$6.copy$default$1();
            ColumnType x$3 = x$6.copy$default$3();
            return x$6.copy(x$2, (ColumnRole)x$1, x$3);
        }, Seq$.MODULE$.canBuildFrom());
        Seq x$11 = (Seq)((TraversableLike)((IterableLike)clusteringKeyColumns.map((Function1 & Serializable & scala.Serializable)clusteringKey -> new Tuple2(columnMapping.getOrElse(clusteringKey._1(), (Function0 & Serializable & scala.Serializable)() -> {
            throw DatasetFunctions.missingColumnException$1((String)clusteringKey._1(), "Clustering Column", columnNames);
        }), clusteringKey._2()), Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Tuple2 col = (Tuple2)tuple2._1();
            int index = tuple2._2$mcI$sp();
            ClusteringColumn x$4 = new ClusteringColumn(index, (ClusteringColumn.SortingOrder)col._2());
            String x$5 = ((ColumnDef)col._1()).copy$default$1();
            ColumnType x$6 = ((ColumnDef)col._1()).copy$default$3();
            ColumnDef columnDef = ((ColumnDef)col._1()).copy(x$5, (ColumnRole)x$4, x$6);
            return columnDef;
        }, Seq$.MODULE$.canBuildFrom());
        Seq x$12 = (Seq)((TraversableLike)regularColumnNames.map((Function1 & Serializable & scala.Serializable)regularColumnName -> (ColumnDef)columnMapping.getOrElse(regularColumnName, (Function0 & Serializable & scala.Serializable)() -> {
            throw DatasetFunctions.missingColumnException$1(regularColumnName, "Regular Column", columnNames);
        }), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$7 -> {
            RegularColumn$ x$72 = RegularColumn$.MODULE$;
            String x$8 = x$7.copy$default$1();
            ColumnType x$9 = x$7.copy$default$3();
            return x$7.copy(x$8, (ColumnRole)x$72, x$9);
        }, Seq$.MODULE$.canBuildFrom());
        boolean x$13 = ifNotExists;
        Map<String, String> x$14 = tableOptions;
        String x$15 = rawTable.copy$default$1();
        String x$16 = rawTable.copy$default$2();
        Seq x$17 = rawTable.copy$default$6();
        boolean x$18 = rawTable.copy$default$7();
        TableDef table = rawTable.copy(x$15, x$16, x$10, x$11, x$12, x$17, x$18, x$13, x$14);
        connector.withSessionDo((Function1 & Serializable & scala.Serializable)session -> session.execute(table.cql()));
    }

    public boolean createCassandraTableEx$default$5() {
        return false;
    }

    public Map<String, String> createCassandraTableEx$default$6() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public CassandraConnector createCassandraTableEx$default$7(String keyspaceName, String tableName, Seq<String> partitionKeyColumns, Seq<Tuple2<String, ClusteringColumn.SortingOrder>> clusteringKeyColumns, boolean ifNotExists, Map<String, String> tableOptions) {
        return CassandraConnector$.MODULE$.apply(this.sparkContext());
    }

    private static final IllegalArgumentException missingColumnException$1(String columnName, String columnType, Set columnNames$1) {
        return new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(81).append("\"").append(columnName).append("\" not Found. Unable to make specified column ").append(columnName).append(" a ").append(columnType).append(".\n          |Available Columns: ").append(columnNames$1).toString())).stripMargin());
    }

    public DatasetFunctions(Dataset<K> dataset, Encoder<K> evidence$1) {
        this.dataset = dataset;
        this.evidence$1 = evidence$1;
        this.sparkContext = dataset.sqlContext().sparkContext();
    }
}

