/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.bdp.util.ScalaJavaUtil$;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.spark.connector.CassandraRowMetadata;
import com.datastax.spark.connector.CassandraRowMetadata$;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.CassandraConnectorConf;
import com.datastax.spark.connector.cql.ScanResult;
import com.datastax.spark.connector.cql.Scanner;
import com.datastax.spark.connector.cql.package$;
import com.datastax.spark.connector.rdd.ReadConf;
import com.datastax.spark.connector.rdd.reader.PrefetchingResultSetIterator$;
import com.datastax.spark.connector.util.Threads$;
import com.datastax.spark.connector.writer.RateLimiter;
import com.datastax.spark.connector.writer.RateLimiter$;
import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001\u0002\u0007\u000e\u0001aA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!Aa\u0006\u0001B\u0001B\u0003%q\u0006C\u0003D\u0001\u0011\u0005A\tC\u0004J\u0001\t\u0007I\u0011\u0002&\t\r]\u0003\u0001\u0015!\u0003L\u0011\u001dA\u0006A1A\u0005\neCa\u0001\u001a\u0001!\u0002\u0013Q\u0006\"B3\u0001\t\u00032\u0007\"\u00026\u0001\t\u0003Z\u0007BB@\u0001\t\u0003\n\tA\u0001\bEK\u001a\fW\u000f\u001c;TG\u0006tg.\u001a:\u000b\u00059y\u0011aA2rY*\u0011\u0001#E\u0001\nG>tg.Z2u_JT!AE\n\u0002\u000bM\u0004\u0018M]6\u000b\u0005Q)\u0012\u0001\u00033bi\u0006\u001cH/\u0019=\u000b\u0003Y\t1aY8n\u0007\u0001\u00192\u0001A\r !\tQR$D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005\u0019\te.\u001f*fMB\u0011\u0001%I\u0007\u0002\u001b%\u0011!%\u0004\u0002\b'\u000e\fgN\\3s\u0003!\u0011X-\u00193D_:4\u0007CA\u0013)\u001b\u00051#BA\u0014\u0010\u0003\r\u0011H\rZ\u0005\u0003S\u0019\u0012\u0001BU3bI\u000e{gNZ\u0001\tG>tgnQ8oMB\u0011\u0001\u0005L\u0005\u0003[5\u0011acQ1tg\u0006tGM]1D_:tWm\u0019;pe\u000e{gNZ\u0001\fG>dW/\u001c8OC6,7\u000fE\u00021qmr!!\r\u001c\u000f\u0005I*T\"A\u001a\u000b\u0005Q:\u0012A\u0002\u001fs_>$h(C\u0001\u001d\u0013\t94$A\u0004qC\u000e\\\u0017mZ3\n\u0005eR$AC%oI\u0016DX\rZ*fc*\u0011qg\u0007\t\u0003y\u0001s!!\u0010 \u0011\u0005IZ\u0012BA \u001c\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011I\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}Z\u0012A\u0002\u001fj]&$h\b\u0006\u0003F\r\u001eC\u0005C\u0001\u0011\u0001\u0011\u0015\u0019C\u00011\u0001%\u0011\u0015QC\u00011\u0001,\u0011\u0015qC\u00011\u00010\u0003\u001d\u0019Xm]:j_:,\u0012a\u0013\t\u0003\u0019Vk\u0011!\u0014\u0006\u0003\u001d>\u000bAaY8sK*\u0011\u0001+U\u0001\u0004CBL'B\u0001*T\u0003\u0019!'/\u001b<fe*\u0011AkE\u0001\u0004_N\u001c\u0018B\u0001,N\u0005)\u0019\u0015\u000f\\*fgNLwN\\\u0001\tg\u0016\u001c8/[8oA\u0005i1m\u001c3fGJ+w-[:uef,\u0012A\u0017\t\u00037\nl\u0011\u0001\u0018\u0006\u0003;z\u000b\u0001B]3hSN$(/\u001f\u0006\u0003?\u0002\fQaY8eK\u000eT!!Y'\u0002\tQL\b/Z\u0005\u0003Gr\u0013QbQ8eK\u000e\u0014VmZ5tiJL\u0018AD2pI\u0016\u001c'+Z4jgR\u0014\u0018\u0010I\u0001\u0006G2|7/\u001a\u000b\u0002OB\u0011!\u0004[\u0005\u0003Sn\u0011A!\u00168ji\u0006!1oY1o+\taG\u000f\u0006\u0002naB\u0011\u0001E\\\u0005\u0003_6\u0011!bU2b]J+7/\u001e7u\u0011\u0015\t(\u00021\u0001s\u0003%\u0019H/\u0019;f[\u0016tG\u000f\u0005\u0002ti2\u0001A!B;\u000b\u0005\u00041(AC*uCR,W.\u001a8u)F\u0011qO\u001f\t\u00035aL!!_\u000e\u0003\u000f9{G\u000f[5oOB\u001910 :\u000e\u0003qT!AD'\n\u0005yd(!C*uCR,W.\u001a8u\u0003)9W\r^*fgNLwN\u001c\u000b\u0002\u0017\u0002")
public class DefaultScanner
implements Scanner {
    private final ReadConf readConf;
    private final IndexedSeq<String> columnNames;
    private final CqlSession session;
    private final CodecRegistry codecRegistry;

    private CqlSession session() {
        return this.session;
    }

    private CodecRegistry codecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public void close() {
        this.session().close();
    }

    @Override
    public <StatementT extends Statement<StatementT>> ScanResult scan(StatementT statement) {
        CompletionStage rs2 = this.session().executeAsync(com.datastax.spark.connector.util.package$.MODULE$.maybeExecutingAs(statement, this.readConf.executeAs()));
        Future scanResult = ScalaJavaUtil$.MODULE$.asScalaFuture(rs2, (ExecutionContextExecutor)Threads$.MODULE$.BlockingIOExecutionContext()).map((Function1 & Serializable & scala.Serializable)rs -> {
            Iterator iterator;
            CassandraRowMetadata columnMetaData = CassandraRowMetadata$.MODULE$.fromResultSet($this.columnNames, rs, this.codecRegistry());
            Iterator prefetchingIterator = new Iterator((AsyncResultSet)rs, PrefetchingResultSetIterator$.MODULE$.$lessinit$greater$default$2());
            Option<Object> option = $this.readConf.throughputMiBPS();
            if (option instanceof Some) {
                Some some = (Some)option;
                double throughput = BoxesRunTime.unboxToDouble((Object)some.value());
                RateLimiter rateLimiter = new RateLimiter((long)(throughput * (double)1024 * (double)1024), 0x100000L, RateLimiter$.MODULE$.$lessinit$greater$default$3(), RateLimiter$.MODULE$.$lessinit$greater$default$4());
                iterator = prefetchingIterator.map((Function1 & Serializable & scala.Serializable)row -> {
                    rateLimiter.maybeSleep(package$.MODULE$.getRowBinarySize((Row)row));
                    return row;
                });
            } else if (None$.MODULE$.equals(option)) {
                iterator = prefetchingIterator;
            } else {
                throw new MatchError(option);
            }
            Iterator rateLimitingIterator = iterator;
            return new ScanResult((Iterator<Row>)rateLimitingIterator, columnMetaData);
        }, (ExecutionContext)Threads$.MODULE$.BlockingIOExecutionContext());
        return (ScanResult)Await$.MODULE$.result((Awaitable)scanResult, (Duration)Duration$.MODULE$.Inf());
    }

    @Override
    public CqlSession getSession() {
        return this.session();
    }

    public DefaultScanner(ReadConf readConf, CassandraConnectorConf connConf, IndexedSeq<String> columnNames) {
        this.readConf = readConf;
        this.columnNames = columnNames;
        this.session = new CassandraConnector(connConf).openSession();
        this.codecRegistry = this.session().getContext().getCodecRegistry();
    }
}

