/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.datasource;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.RelationMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.util.NameTools$;
import java.io.Serializable;
import java.util.Optional;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException$;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException$;
import org.apache.spark.sql.connector.catalog.Identifier;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.ArrayOps;

public final class CassandraCatalog$ {
    public static CassandraCatalog$ MODULE$;
    private final String OnlyOneNamespace;

    static {
        new CassandraCatalog$();
    }

    private String OnlyOneNamespace() {
        return this.OnlyOneNamespace;
    }

    public TableMetadata getTableMetaData(CassandraConnector connector, Identifier ident) {
        String[] namespace = ident.namespace();
        this.checkNamespace(namespace);
        TableMetadata tableMeta = (TableMetadata)((KeyspaceMetadata)this.com$datastax$spark$connector$datasource$CassandraCatalog$$getMetadata(connector).getKeyspace(CqlIdentifier.fromInternal((String)((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespace)).head()))).orElseThrow(() -> MODULE$.namespaceMissing(MODULE$.com$datastax$spark$connector$datasource$CassandraCatalog$$getMetadata(connector), namespace))).getTable(CqlIdentifier.fromInternal((String)ident.name())).orElseThrow(() -> MODULE$.tableMissing(MODULE$.com$datastax$spark$connector$datasource$CassandraCatalog$$getMetadata(connector), namespace, ident.name()));
        return tableMeta;
    }

    public RelationMetadata getRelationMetaData(CassandraConnector connector, Identifier ident) {
        String[] namespace = ident.namespace();
        this.checkNamespace(namespace);
        KeyspaceMetadata keyspaceMeta = (KeyspaceMetadata)this.com$datastax$spark$connector$datasource$CassandraCatalog$$getMetadata(connector).getKeyspace(CqlIdentifier.fromInternal((String)((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespace)).head()))).orElseThrow(() -> MODULE$.namespaceMissing(MODULE$.com$datastax$spark$connector$datasource$CassandraCatalog$$getMetadata(connector), namespace));
        RelationMetadata relationMeta = this.getKeyspaceRelationMetadata(ident, keyspaceMeta).orElseThrow(() -> MODULE$.tableMissing(MODULE$.com$datastax$spark$connector$datasource$CassandraCatalog$$getMetadata(connector), namespace, ident.name()));
        return relationMeta;
    }

    public Optional<RelationMetadata> getKeyspaceRelationMetadata(Identifier ident, KeyspaceMetadata keyspaceMeta) {
        Optional tableMetadata = keyspaceMeta.getTable(CqlIdentifier.fromInternal((String)ident.name()));
        return tableMetadata.isPresent() ? tableMetadata : keyspaceMeta.getView(CqlIdentifier.fromInternal((String)ident.name()));
    }

    public KeyspaceMetadata com$datastax$spark$connector$datasource$CassandraCatalog$$getKeyspaceMeta(CassandraConnector connector, String[] namespace) {
        this.checkNamespace(namespace);
        return (KeyspaceMetadata)this.com$datastax$spark$connector$datasource$CassandraCatalog$$getMetadata(connector).getKeyspace(CqlIdentifier.fromInternal((String)((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespace)).head()))).orElseThrow(() -> MODULE$.namespaceMissing(MODULE$.com$datastax$spark$connector$datasource$CassandraCatalog$$getMetadata(connector), namespace));
    }

    public void checkNamespace(String[] namespace) {
        if (namespace.length != 1) {
            throw new NoSuchNamespaceException(new StringBuilder(2).append(this.OnlyOneNamespace()).append(": ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespace)).mkString(".")).toString(), NoSuchNamespaceException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public NoSuchNamespaceException namespaceMissing(Metadata metadata, String[] namespace) {
        Option suggestions = NameTools$.MODULE$.getSuggestions(metadata, (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespace)).head());
        String error = NameTools$.MODULE$.getErrorString((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespace)).head(), (Option)None$.MODULE$, suggestions);
        return new NoSuchNamespaceException(error, NoSuchNamespaceException$.MODULE$.$lessinit$greater$default$2());
    }

    public Metadata com$datastax$spark$connector$datasource$CassandraCatalog$$getMetadata(CassandraConnector connector) {
        Predef$.MODULE$.require(connector != null, (Function0 & Serializable & scala.Serializable)() -> "CassandraCatalog not initialized properly, No Connection to Cassandra Available");
        return (Metadata)connector.withSessionDo((Function1 & Serializable & scala.Serializable)x$15 -> x$15.getMetadata());
    }

    public Throwable tableMissing(Metadata metadata, String[] namespace, String name) {
        Option suggestions = NameTools$.MODULE$.getSuggestions(metadata, (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespace)).head(), name);
        String error = NameTools$.MODULE$.getErrorString((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespace)).head(), (Option)new Some((Object)name), suggestions);
        return new NoSuchTableException(error, NoSuchTableException$.MODULE$.$lessinit$greater$default$2());
    }

    private CassandraCatalog$() {
        MODULE$ = this;
        this.OnlyOneNamespace = "Cassandra only supports a keyspace name of a single level (no periods in keyspace name)";
    }
}

