/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.datasource;

import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.datasource.CassandraScanBuilder;
import com.datastax.spark.connector.rdd.CqlWhereClause;
import com.datastax.spark.connector.rdd.CqlWhereClause$;
import com.datastax.spark.connector.types.ColumnType;
import com.datastax.spark.connector.types.InetType$;
import com.datastax.spark.connector.types.UUIDType$;
import com.datastax.spark.connector.types.VarIntType$;
import com.datastax.spark.connector.util.Quote$;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.UUID;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;

public final class CassandraScanBuilder$
implements scala.Serializable {
    public static CassandraScanBuilder$ MODULE$;

    static {
        new CassandraScanBuilder$();
    }

    public CqlWhereClause filterToCqlWhereClause(TableDef tableDef, Filter[] filters) {
        return (CqlWhereClause)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filters)).foldLeft((Object)CqlWhereClause$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            CqlWhereClause where;
            Tuple2 tuple22 = new Tuple2(x0$1, x1$1);
            if (tuple22 != null) {
                where = (CqlWhereClause)tuple22._1();
                Filter filter = (Filter)tuple22._2();
                Tuple2<String, Seq<Object>> tuple23 = MODULE$.filterToCqlAndValue(tableDef, filter);
                if (tuple23 == null) {
                    throw new MatchError(tuple23);
                }
                String predicate = (String)tuple23._1();
                Seq values = (Seq)tuple23._2();
                tuple2 = new Tuple2((Object)predicate, (Object)values);
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple24 = tuple2;
            String predicate = (String)tuple24._1();
            Seq values = (Seq)tuple24._2();
            CqlWhereClause newClause = new CqlWhereClause((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{predicate}))), (Seq<Object>)values);
            CqlWhereClause cqlWhereClause = where.and(newClause);
            return cqlWhereClause;
        });
    }

    private Tuple2<String, Seq<Object>> filterToCqlAndValue(TableDef tableDef, Object filter) {
        Tuple2 tuple2;
        Object object = filter;
        if (object instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)object;
            String attribute = equalTo.attribute();
            Object value = equalTo.value();
            tuple2 = new Tuple2((Object)new StringBuilder(4).append(Quote$.MODULE$.quote(attribute)).append(" = ?").toString(), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toCqlValue(tableDef, attribute, value)})));
        } else if (object instanceof LessThan) {
            LessThan lessThan = (LessThan)object;
            String attribute = lessThan.attribute();
            Object value = lessThan.value();
            tuple2 = new Tuple2((Object)new StringBuilder(4).append(Quote$.MODULE$.quote(attribute)).append(" < ?").toString(), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toCqlValue(tableDef, attribute, value)})));
        } else if (object instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)object;
            String attribute = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            tuple2 = new Tuple2((Object)new StringBuilder(5).append(Quote$.MODULE$.quote(attribute)).append(" <= ?").toString(), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toCqlValue(tableDef, attribute, value)})));
        } else if (object instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)object;
            String attribute = greaterThan.attribute();
            Object value = greaterThan.value();
            tuple2 = new Tuple2((Object)new StringBuilder(4).append(Quote$.MODULE$.quote(attribute)).append(" > ?").toString(), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toCqlValue(tableDef, attribute, value)})));
        } else if (object instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)object;
            String attribute = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            tuple2 = new Tuple2((Object)new StringBuilder(5).append(Quote$.MODULE$.quote(attribute)).append(" >= ?").toString(), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toCqlValue(tableDef, attribute, value)})));
        } else if (object instanceof In) {
            In in = (In)object;
            String attribute = in.attribute();
            Object[] values = in.values();
            tuple2 = new Tuple2((Object)new StringBuilder(4).append(Quote$.MODULE$.quote(attribute)).append(" IN ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)values).map((Function1 & Serializable & scala.Serializable)x$7 -> "?", Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("(", ", ", ")")).toString(), this.toCqlValues(tableDef, attribute, values));
        } else {
            throw new UnsupportedOperationException(new StringBuilder(81).append("It's not a valid filter ").append(filter).append(" to be pushed down, only >, <, >=, <= and In are allowed.").toString());
        }
        return tuple2;
    }

    private Seq<Object> toCqlValues(TableDef tableDef, String columnName, Object[] values) {
        return Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps((Object)values).map((Function1 & Serializable & scala.Serializable)x$8 -> MODULE$.toCqlValue(tableDef, columnName, x$8), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).toSeq();
    }

    private Object toCqlValue(TableDef tableDef, String columnName, Object value) {
        Object object;
        Object object2 = value;
        if (object2 instanceof Decimal) {
            Decimal decimal = (Decimal)object2;
            ColumnType columnType = ((ColumnDef)tableDef.columnByName().apply((Object)columnName)).columnType();
            VarIntType$ varIntType$ = VarIntType$.MODULE$;
            boolean isVarIntColumn = !(columnType != null ? !columnType.equals(varIntType$) : varIntType$ != null);
            object = isVarIntColumn ? decimal.toJavaBigDecimal().toBigInteger() : decimal;
        } else if (object2 instanceof UTF8String) {
            Serializable serializable;
            ColumnType columnType;
            UTF8String uTF8String = (UTF8String)object2;
            ColumnType columnType2 = columnType = ((ColumnDef)tableDef.columnByName().apply((Object)columnName)).columnType();
            InetType$ inetType$ = InetType$.MODULE$;
            if (!(columnType2 != null ? !columnType2.equals(inetType$) : inetType$ != null)) {
                serializable = InetAddress.getByName(uTF8String.toString());
            } else {
                ColumnType columnType3 = columnType;
                UUIDType$ uUIDType$ = UUIDType$.MODULE$;
                serializable = !(columnType3 != null ? !columnType3.equals(uUIDType$) : uUIDType$ != null) ? UUID.fromString(uTF8String.toString()) : uTF8String;
            }
            object = serializable;
        } else {
            object = object2;
        }
        return object;
    }

    public CassandraScanBuilder apply(SparkSession session, TableDef tableDef, String catalogName, CaseInsensitiveStringMap options) {
        return new CassandraScanBuilder(session, tableDef, catalogName, options);
    }

    public Option<Tuple4<SparkSession, TableDef, String, CaseInsensitiveStringMap>> unapply(CassandraScanBuilder x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.session(), (Object)x$0.tableDef(), (Object)x$0.catalogName(), (Object)x$0.options()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CassandraScanBuilder$() {
        MODULE$ = this;
    }
}

