/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.datasource;

import com.datastax.spark.connector.TupleValue;
import com.datastax.spark.connector.UDTValue;
import com.datastax.spark.connector.UDTValue$;
import java.io.Serializable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class UdtProjectionDecoder$ {
    public static UdtProjectionDecoder$ MODULE$;

    static {
        new UdtProjectionDecoder$();
    }

    public Function1<Row, Row> build(StructType schema) {
        return this.hasProjections(schema) ? this.buildRootDecoder(schema) : x -> (Row)Predef$.MODULE$.identity(x);
    }

    private Function1<Row, Row> buildRootDecoder(StructType schema) {
        Function1[] childEncoders = (Function1[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)field -> MODULE$.buildDataTypeDecoder(field.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function1.class)));
        return (Function1 & Serializable & scala.Serializable)row -> {
            Object[] updated = (Object[])Array$.MODULE$.tabulate(childEncoders.length, (Function1 & Serializable & scala.Serializable)idx -> UdtProjectionDecoder$.$anonfun$buildRootDecoder$3(childEncoders, row, BoxesRunTime.unboxToInt((Object)idx)), ClassTag$.MODULE$.Any());
            return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)updated));
        };
    }

    public Function1<Object, Object> buildDataTypeDecoder(DataType dataType) {
        Function1<Object, Object> function1;
        DataType dataType2 = dataType;
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            function1 = this.structTypeDecoder(structType);
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            function1 = this.arrayTypeDecoder(arrayType);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            function1 = this.mapTypeDecoder(mapType);
        } else {
            function1 = x -> Predef$.MODULE$.identity(x);
        }
        return function1;
    }

    private Function1<Object, Object> structTypeDecoder(StructType structType) {
        scala.collection.immutable.IndexedSeq childDecoders = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).map((Function1 & Serializable & scala.Serializable)field -> MODULE$.buildDataTypeDecoder(field.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function1.class))))).toIndexedSeq();
        return (Function1 & Serializable & scala.Serializable)input -> {
            Object object;
            Object object2 = input;
            if (object2 == null) {
                object = null;
            } else if (object2 instanceof UDTValue) {
                UDTValue uDTValue = (UDTValue)object2;
                Object[] selectedValues = (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Object decoded;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    StructField field = (StructField)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    int originalIndex = uDTValue.indexOf(field.name());
                    Object object = decoded = ((Function1)childDecoders.apply(idx)).apply(uDTValue.columnValues().apply(originalIndex));
                    return object;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.AnyRef()));
                object = UDTValue$.MODULE$.apply((IndexedSeq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fieldNames())).toIndexedSeq(), (IndexedSeq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(selectedValues)).toIndexedSeq());
            } else if (object2 instanceof TupleValue) {
                TupleValue tupleValue = (TupleValue)object2;
                Object[] selectedValues = (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Object decoded;
                    int n;
                    int idx;
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        StructField field = (StructField)tuple2._1();
                        idx = tuple2._2$mcI$sp();
                        try {
                            n = new StringOps(Predef$.MODULE$.augmentString(field.name())).toInt();
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IllegalArgumentException(new StringBuilder(44).append("Expected integer for tuple column name, got ").append(field.name()).toString());
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    int fieldInt = n;
                    Object object = decoded = ((Function1)childDecoders.apply(idx)).apply(tupleValue.values().apply(fieldInt));
                    return object;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.AnyRef()));
                object = new TupleValue((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(selectedValues)).toIndexedSeq());
            } else {
                object = object2;
            }
            return object;
        };
    }

    private Function1<Object, Object> arrayTypeDecoder(ArrayType arrayType) {
        Function1<Object, Object> keyDecoder = this.buildDataTypeDecoder(arrayType.elementType());
        return (Function1 & Serializable & scala.Serializable)input -> {
            Object object;
            Object object2 = input;
            if (object2 == null) {
                object = null;
            } else if (object2 instanceof Seq) {
                Seq seq = (Seq)object2;
                object = seq.map(keyDecoder, Seq$.MODULE$.canBuildFrom());
            } else {
                object = object2;
            }
            return object;
        };
    }

    private Function1<Object, Object> mapTypeDecoder(MapType mapType) {
        Function1<Object, Object> keyDecoder = this.buildDataTypeDecoder(mapType.keyType());
        Function1<Object, Object> valueDecoder = this.buildDataTypeDecoder(mapType.valueType());
        return (Function1 & Serializable & scala.Serializable)input -> {
            Object object;
            Object object2 = input;
            if (object2 == null) {
                object = null;
            } else if (object2 instanceof Map) {
                Map map = (Map)object2;
                object = ((TraversableOnce)map.toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Object k = tuple2._1();
                    Object v = tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(keyDecoder.apply(k)), valueDecoder.apply(v));
                    return tuple22;
                }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            } else {
                object = object2;
            }
            return object;
        };
    }

    private boolean hasProjections(StructType schema) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).exists((Function1 & Serializable & scala.Serializable)structField -> BoxesRunTime.boxToBoolean((boolean)UdtProjectionDecoder$.MODULE$.hasStructTypes(structField.dataType())));
    }

    private boolean hasStructTypes(DataType dataType) {
        boolean bl;
        block3: {
            block4: {
                while (true) {
                    DataType dataType2;
                    if ((dataType2 = dataType) instanceof StructType) {
                        bl = true;
                        break block3;
                    }
                    if (dataType2 instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)dataType2;
                        dataType = arrayType.elementType();
                        continue;
                    }
                    if (!(dataType2 instanceof MapType)) break block4;
                    MapType mapType = (MapType)dataType2;
                    if (this.hasStructTypes(mapType.keyType())) break;
                    dataType = mapType.valueType();
                }
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ Object $anonfun$buildRootDecoder$3(Function1[] childEncoders$1, Row row$1, int idx) {
        return childEncoders$1[idx].apply(row$1.get(idx));
    }

    private UdtProjectionDecoder$() {
        MODULE$ = this;
    }
}

