/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.japi;

import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.spark.connector.CassandraRowMetadata;
import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.japi.CassandraRow;
import com.datastax.spark.connector.japi.CassandraRow$;
import com.datastax.spark.connector.rdd.reader.RowReader;
import com.datastax.spark.connector.rdd.reader.RowReaderFactory;
import scala.Option;
import scala.collection.IndexedSeq;
import scala.collection.Seq;

public class GenericJavaRowReaderFactory {
    public static final RowReaderFactory<CassandraRow> instance = new RowReaderFactory<CassandraRow>(){

        @Override
        public RowReader<CassandraRow> rowReader(TableDef tableDef, IndexedSeq<ColumnRef> indexedSeq) {
            return JavaRowReader.instance;
        }

        @Override
        public Class<CassandraRow> targetClass() {
            return CassandraRow.class;
        }
    };

    public static class JavaRowReader
    implements RowReader<CassandraRow> {
        public static final JavaRowReader instance = new JavaRowReader();

        private JavaRowReader() {
        }

        @Override
        public CassandraRow read(Row row, CassandraRowMetadata cassandraRowMetadata) {
            assert (row.getColumnDefinitions().size() == cassandraRowMetadata.columnNames().size()) : "Number of columns in a row must match the number of columns in the table metadata";
            return CassandraRow$.MODULE$.fromJavaDriverRow(row, cassandraRowMetadata);
        }

        @Override
        public Option<Seq<ColumnRef>> neededColumns() {
            return Option.empty();
        }
    }
}

