/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.japi.rdd;

import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.japi.CassandraJavaUtil;
import com.datastax.spark.connector.japi.PairRDDJavaFunctions;
import com.datastax.spark.connector.rdd.CassandraRDD;
import com.datastax.spark.connector.rdd.EmptyCassandraRDD;
import com.datastax.spark.connector.rdd.ReadConf;
import com.datastax.spark.connector.util.JavaApiHelper;
import java.util.Collection;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassTag;

public class CassandraJavaPairRDD<K, V>
extends JavaPairRDD<K, V> {
    public CassandraJavaPairRDD(CassandraRDD<Tuple2<K, V>> cassandraRDD, ClassTag<K> classTag, ClassTag<V> classTag2) {
        super(cassandraRDD, classTag, classTag2);
    }

    public CassandraJavaPairRDD(CassandraRDD<Tuple2<K, V>> cassandraRDD, Class<K> clazz, Class<V> clazz2) {
        super(cassandraRDD, JavaApiHelper.getClassTag(clazz), JavaApiHelper.getClassTag(clazz2));
    }

    private CassandraJavaPairRDD<K, V> wrap(CassandraRDD<Tuple2<K, V>> cassandraRDD) {
        return new CassandraJavaPairRDD<K, V>(cassandraRDD, this.kClassTag(), this.vClassTag());
    }

    public CassandraRDD<Tuple2<K, V>> rdd() {
        return (CassandraRDD)super.rdd();
    }

    public CassandraJavaPairRDD<K, V> select(String ... stringArray) {
        Seq seq = JavaApiHelper.toScalaSeq(CassandraJavaUtil.toSelectableColumnRefs(stringArray));
        CassandraRDD cassandraRDD = this.rdd().select((Seq<ColumnRef>)seq.toSeq());
        return this.wrap(cassandraRDD);
    }

    public CassandraJavaPairRDD<K, V> select(ColumnRef ... columnRefArray) {
        Seq seq = JavaApiHelper.toScalaSeq(columnRefArray);
        CassandraRDD cassandraRDD = this.rdd().select((Seq<ColumnRef>)seq.toSeq());
        return this.wrap(cassandraRDD);
    }

    public CassandraJavaPairRDD<K, V> where(String string, Object ... objectArray) {
        CassandraRDD cassandraRDD = this.rdd().where(string, JavaApiHelper.toScalaSeq(objectArray));
        return this.wrap(cassandraRDD);
    }

    public CassandraJavaPairRDD<K, V> withAscOrder() {
        CassandraRDD cassandraRDD = this.rdd().withAscOrder();
        return this.wrap(cassandraRDD);
    }

    public CassandraJavaPairRDD<K, V> withDescOrder() {
        CassandraRDD cassandraRDD = this.rdd().withDescOrder();
        return this.wrap(cassandraRDD);
    }

    public CassandraJavaPairRDD<K, V> limit(Long l) {
        CassandraRDD cassandraRDD = this.rdd().limit(l);
        return this.wrap(cassandraRDD);
    }

    public CassandraJavaPairRDD<K, V> perPartitionLimit(Long l) {
        CassandraRDD cassandraRDD = this.rdd().perPartitionLimit(l);
        return this.wrap(cassandraRDD);
    }

    public ColumnRef[] selectedColumnRefs() {
        ClassTag<ColumnRef> classTag = JavaApiHelper.getClassTag(ColumnRef.class);
        return (ColumnRef[])this.rdd().selectedColumnRefs().toArray(classTag);
    }

    public String[] selectedColumnNames() {
        ClassTag<String> classTag = JavaApiHelper.getClassTag(String.class);
        return (String[])this.rdd().selectedColumnNames().toArray(classTag);
    }

    public CassandraJavaPairRDD<K, V> withConnector(CassandraConnector cassandraConnector) {
        CassandraRDD cassandraRDD = this.rdd().withConnector(cassandraConnector);
        return this.wrap(cassandraRDD);
    }

    public CassandraJavaPairRDD<K, V> withReadConf(ReadConf readConf) {
        CassandraRDD cassandraRDD = this.rdd().withReadConf(readConf);
        return this.wrap(cassandraRDD);
    }

    public CassandraJavaPairRDD<K, V> toEmptyCassandraRDD() {
        EmptyCassandraRDD<Tuple2<K, V>> emptyCassandraRDD = this.rdd().toEmptyCassandraRDD();
        return this.wrap(emptyCassandraRDD);
    }

    public JavaPairRDD<K, Collection<V>> spanByKey() {
        return new PairRDDJavaFunctions(this.rdd()).spanByKey(this.kClassTag());
    }

    public <U> JavaPairRDD<U, Iterable<Tuple2<K, V>>> spanBy(Function<Tuple2<K, V>, U> function, ClassTag<U> classTag) {
        return new PairRDDJavaFunctions(this.rdd()).spanBy(function, classTag);
    }

    public <U> JavaPairRDD<U, Iterable<Tuple2<K, V>>> spanBy(Function<Tuple2<K, V>, U> function, Class<U> clazz) {
        return new PairRDDJavaFunctions(this.rdd()).spanBy(function, JavaApiHelper.getClassTag(clazz));
    }

    public long cassandraCount() {
        return this.rdd().cassandraCount();
    }
}

