/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd;

import com.datastax.bdp.util.ScalaJavaUtil$;
import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.spark.connector.CassandraRowMetadata;
import com.datastax.spark.connector.CassandraRowMetadata$;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.rdd.CassandraCoGroupedRDD$;
import com.datastax.spark.connector.rdd.CassandraTableScanRDD;
import com.datastax.spark.connector.rdd.ReadConf;
import com.datastax.spark.connector.rdd.ReadConf$;
import com.datastax.spark.connector.rdd.partitioner.CassandraPartition;
import com.datastax.spark.connector.rdd.partitioner.CqlTokenRange;
import com.datastax.spark.connector.rdd.reader.PrefetchingResultSetIterator;
import com.datastax.spark.connector.rdd.reader.PrefetchingResultSetIterator$;
import com.datastax.spark.connector.rdd.reader.RowReader;
import com.datastax.spark.connector.types.ColumnType$;
import com.datastax.spark.connector.types.TypeConverter;
import com.datastax.spark.connector.util.CountingIterator;
import com.datastax.spark.connector.util.CountingIterator$;
import com.datastax.spark.connector.util.MultiMergeJoinIterator;
import com.datastax.spark.connector.util.NameTools$;
import com.datastax.spark.connector.util.Quote$;
import com.datastax.spark.connector.util.Threads$;
import com.datastax.spark.connector.util.package$;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.metrics.InputMetricsUpdater;
import org.apache.spark.metrics.InputMetricsUpdater$;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t]e\u0001B\r\u001b\u0001\u0015B\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\t#\u0002\u0011\t\u0011)A\u0005%\"Aq\u000b\u0001B\u0001B\u0003-\u0001\fC\u0003_\u0001\u0011\u0005q\f\u0003\u0005\u001e\u0001!\u0015\r\u0011\"\u0001f\u0011\u0015a\u0007\u0001\"\u0001n\u0011\u0019y\b\u0001\"\u0005\u0002\u0002!9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0001bBA\n\u0001\u0011%\u0011Q\u0003\u0005\b\u0003?\u0001A\u0011BA\u0011\u0011\u001d\ty\u0003\u0001C\u0001\u0003cAq!!\u0019\u0001\t\u0013\t\u0019\u0007C\u0004\u0002\u0018\u0002!I!!'\t\u000f\u0005\r\u0007\u0001\"\u0003\u0002F\"9\u0011\u0011\u001f\u0001\u0005\n\u0005M\bb\u0002B\u0016\u0001\u0011\u0005#Q\u0006\u0005\b\u0005'\u0002A\u0011\u000bB+\u0011\u001d\u0011i\u0006\u0001C!\u0005?:qA!\u001a\u001b\u0011\u0003\u00119G\u0002\u0004\u001a5!\u0005!\u0011\u000e\u0005\u0007=R!\tAa\u001e\t\u0013\teDC1A\u0005\u0002\tm\u0004\u0002\u0003BF)\u0001\u0006IA! \t\u0013\t5E#!A\u0005\n\t=%!F\"bgN\fg\u000e\u001a:b\u0007><%o\\;qK\u0012\u0014F\t\u0012\u0006\u00037q\t1A\u001d3e\u0015\tib$A\u0005d_:tWm\u0019;pe*\u0011q\u0004I\u0001\u0006gB\f'o\u001b\u0006\u0003C\t\n\u0001\u0002Z1uCN$\u0018\r\u001f\u0006\u0002G\u0005\u00191m\\7\u0004\u0001U\u0011aEQ\n\u0003\u0001\u001d\u00022\u0001K\u00182\u001b\u0005I#BA\u000e+\u0015\ty2F\u0003\u0002-[\u00051\u0011\r]1dQ\u0016T\u0011AL\u0001\u0004_J<\u0017B\u0001\u0019*\u0005\r\u0011F\t\u0012\t\u0004eqzdBA\u001a:\u001d\t!t'D\u00016\u0015\t1D%\u0001\u0004=e>|GOP\u0005\u0002q\u0005)1oY1mC&\u0011!hO\u0001\ba\u0006\u001c7.Y4f\u0015\u0005A\u0014BA\u001f?\u0005\r\u0019V-\u001d\u0006\u0003um\u00022A\r\u001fA!\t\t%\t\u0004\u0001\u0005\u000b\r\u0003!\u0019\u0001#\u0003\u0003Q\u000b\"!R%\u0011\u0005\u0019;U\"A\u001e\n\u0005![$a\u0002(pi\"Lgn\u001a\t\u0003\r*K!aS\u001e\u0003\u0007\u0005s\u00170\u0001\u0002tGB\u0011ajT\u0007\u0002U%\u0011\u0001K\u000b\u0002\r'B\f'o[\"p]R,\u0007\u0010^\u0001\tg\u000e\fgN\u0015#EgB\u0019!\u0007P*\u0011\u0007Q+\u0006)D\u0001\u001b\u0013\t1&DA\u000bDCN\u001c\u0018M\u001c3sCR\u000b'\r\\3TG\u0006t'\u000b\u0012#\u0002\u0011\rd\u0017m]:UC\u001e\u00042!\u0017/A\u001b\u0005Q&BA.<\u0003\u001d\u0011XM\u001a7fGRL!!\u0018.\u0003\u0011\rc\u0017m]:UC\u001e\fa\u0001P5oSRtDc\u00011dIR\u0011\u0011M\u0019\t\u0004)\u0002\u0001\u0005\"B,\u0005\u0001\bA\u0006\"\u0002'\u0005\u0001\u0004i\u0005\"B)\u0005\u0001\u0004\u0011V#\u00014\u0011\u0005\u001dTW\"\u00015\u000b\u0005%d\u0012aA2rY&\u00111\u000e\u001b\u0002\u0013\u0007\u0006\u001c8/\u00198ee\u0006\u001cuN\u001c8fGR|'/A\bhKR\u0004\u0016M\u001d;ji&|gnS3z)\u0011q'o]?\u0011\u0007Ibt\u000e\u0005\u0002ha&\u0011\u0011\u000f\u001b\u0002\n\u0007>dW/\u001c8EK\u001aDQ!\b\u0004A\u0002\u0019DQ\u0001\u001e\u0004A\u0002U\fAb[3zgB\f7-\u001a(b[\u0016\u0004\"A\u001e>\u000f\u0005]D\bC\u0001\u001b<\u0013\tI8(\u0001\u0004Qe\u0016$WMZ\u0005\u0003wr\u0014aa\u0015;sS:<'BA=<\u0011\u0015qh\u00011\u0001v\u0003%!\u0018M\u00197f\u001d\u0006lW-A\ndQ\u0016\u001c7NV1mS\u0012lUM]4f\u0015>Lg\u000e\u0006\u0002\u0002\u0004A\u0019a)!\u0002\n\u0007\u0005\u001d1H\u0001\u0003V]&$\u0018\u0001E5t-\u0006d\u0017\u000eZ'fe\u001e,'j\\5o)\t\ti\u0001E\u0002G\u0003\u001fI1!!\u0005<\u0005\u001d\u0011un\u001c7fC:\f!\u0004[1t\u000bF,\u0018\r\u001c)beRLG/[8o\u0017\u0016L8\u000fV=qKN$b!!\u0004\u0002\u0018\u0005m\u0001BBA\r\u0013\u0001\u00071+A\u0006mK\u001a$8kY1o%\u0012#\u0005BBA\u000f\u0013\u0001\u00071+\u0001\u0007sS\u001eDGoU2b]J#E)A\bqCJ$\u0018\u000e^5p].+\u0017p\u0015;s)\r)\u00181\u0005\u0005\u00077)\u0001\r!!\n1\t\u0005\u001d\u00121\u0006\t\u0005)V\u000bI\u0003E\u0002B\u0003W!1\"!\f\u0002$\u0005\u0005\t\u0011!B\u0001\t\n\u0019q\f\n\u001a\u0002\u001dQ|7.\u001a8FqR\u0014\u0018m\u0019;peR!\u00111GA*!\u0011\t)$a\u0014\u000e\u0005\u0005]\"\u0002BA\u001d\u0003w\tQ\u0001^8lK:TA!!\u0010\u0002@\u0005AQ.\u001a;bI\u0006$\u0018M\u0003\u0003\u0002B\u0005\r\u0013\u0001B2pe\u0016TA!!\u0012\u0002H\u0005\u0019\u0011\r]5\u000b\t\u0005%\u00131J\u0001\u0007IJLg/\u001a:\u000b\u0007\u00055\u0003%A\u0002pgNLA!!\u0015\u00028\t)Ak\\6f]\"9\u0011QK\u0006A\u0002\u0005]\u0013a\u0001:poB!\u0011\u0011LA/\u001b\t\tYFC\u0002j\u0003\u007fIA!a\u0018\u0002\\\t\u0019!k\\<\u0002)Q|7.\u001a8SC:<W\rV8Dc2\fV/\u001a:z+\u0011\t)'a\u001e\u0015\r\u0005\u001d\u0014qNA=!\u00191\u0015\u0011N;\u0002n%\u0019\u00111N\u001e\u0003\rQ+\b\u000f\\33!\r\u0011D(\u0013\u0005\b\u0003cb\u0001\u0019AA:\u0003\u001d1'o\\7S\t\u0012\u0003B\u0001V+\u0002vA\u0019\u0011)a\u001e\u0005\u000b\rc!\u0019\u0001#\t\u000f\u0005mD\u00021\u0001\u0002~\u0005)!/\u00198hKB2\u0011qPAG\u0003'\u0003\u0002\"!!\u0002\b\u0006-\u0015\u0011S\u0007\u0003\u0003\u0007S1!!\"\u001b\u0003-\u0001\u0018M\u001d;ji&|g.\u001a:\n\t\u0005%\u00151\u0011\u0002\u000e\u0007FdGk\\6f]J\u000bgnZ3\u0011\u0007\u0005\u000bi\tB\u0006\u0002\u0010\u0006e\u0014\u0011!A\u0001\u0006\u0003!%aA0%gA\u0019\u0011)a%\u0005\u0017\u0005U\u0015\u0011PA\u0001\u0002\u0003\u0015\t\u0001\u0012\u0002\u0004?\u0012\"\u0014aD2sK\u0006$Xm\u0015;bi\u0016lWM\u001c;\u0015\u0015\u0005m\u0015\u0011UAW\u0003o\u000bI\f\u0005\u0003\u0002Z\u0005u\u0015\u0002BAP\u00037\u0012aBQ8v]\u0012\u001cF/\u0019;f[\u0016tG\u000fC\u0004\u0002$6\u0001\r!!*\u0002\u000fM,7o]5p]B!\u0011qUAU\u001b\t\ty$\u0003\u0003\u0002,\u0006}\"AC\"rYN+7o]5p]\"9\u0011qV\u0007A\u0002\u0005E\u0016\u0001\u0003:fC\u0012\u001cuN\u001c4\u0011\u0007Q\u000b\u0019,C\u0002\u00026j\u0011\u0001BU3bI\u000e{gN\u001a\u0005\u0006S6\u0001\r!\u001e\u0005\b\u0003wk\u0001\u0019AA_\u0003\u00191\u0018\r\\;fgB!a)a0J\u0013\r\t\tm\u000f\u0002\u000byI,\u0007/Z1uK\u0012t\u0014!D2p]Z,'\u000f\u001e*poN+\u0017/\u0006\u0003\u0002H\u00065G\u0003CAe\u0003\u001f\f).!:\u0011\tIb\u00141\u001a\t\u0004\u0003\u00065G!B\"\u000f\u0005\u0004!\u0005bBAi\u001d\u0001\u0007\u00111[\u0001\u0004g\u0016\f\b\u0003\u0002\u001a=\u0003/Bq!a6\u000f\u0001\u0004\tI.A\u0005s_^\u0014V-\u00193feB1\u00111\\Aq\u0003\u0017l!!!8\u000b\u0007\u0005}'$\u0001\u0004sK\u0006$WM]\u0005\u0005\u0003G\fiNA\u0005S_^\u0014V-\u00193fe\"9\u0011q\u001d\bA\u0002\u0005%\u0018AD2pYVlg.T3uC\u0012\u000bG/\u0019\t\u0005\u0003W\fi/D\u0001\u001d\u0013\r\ty\u000f\b\u0002\u0015\u0007\u0006\u001c8/\u00198ee\u0006\u0014vn^'fi\u0006$\u0017\r^1\u0002\u001f\u0019,Go\u00195U_.,gNU1oO\u0016,B!!>\u0003\bQQ\u0011q_A\u0000\u0005\u0003\u0011IAa\u0007\u0011\u000f\u0019\u000bI'!;\u0002zB)!'a?\u0002X%\u0019\u0011Q  \u0003\u0011%#XM]1u_JDq!a)\u0010\u0001\u0004\t)\u000bC\u0004\u0002r=\u0001\rAa\u0001\u0011\tQ+&Q\u0001\t\u0004\u0003\n\u001dA!B\"\u0010\u0005\u0004!\u0005bBA>\u001f\u0001\u0007!1\u0002\u0019\u0007\u0005\u001b\u0011\tBa\u0006\u0011\u0011\u0005\u0005\u0015q\u0011B\b\u0005+\u00012!\u0011B\t\t-\u0011\u0019B!\u0003\u0002\u0002\u0003\u0005)\u0011\u0001#\u0003\u0007}#S\u0007E\u0002B\u0005/!1B!\u0007\u0003\n\u0005\u0005\t\u0011!B\u0001\t\n\u0019q\f\n\u001c\t\u000f\tuq\u00021\u0001\u0003 \u0005\u0019\u0012N\u001c9vi6+GO]5dgV\u0003H-\u0019;feB!!\u0011\u0005B\u0014\u001b\t\u0011\u0019CC\u0002\u0003&)\nq!\\3ue&\u001c7/\u0003\u0003\u0003*\t\r\"aE%oaV$X*\u001a;sS\u000e\u001cX\u000b\u001d3bi\u0016\u0014\u0018aB2p[B,H/\u001a\u000b\u0007\u0005_\u0011\tDa\u000f\u0011\tI\nY0\r\u0005\b\u0005g\u0001\u0002\u0019\u0001B\u001b\u0003\u0015\u0019\b\u000f\\5u!\rq%qG\u0005\u0004\u0005sQ#!\u0003)beRLG/[8o\u0011\u001d\u0011i\u0004\u0005a\u0001\u0005\u007f\tqaY8oi\u0016DH\u000fE\u0002O\u0005\u0003J1Aa\u0011+\u0005-!\u0016m]6D_:$X\r\u001f;)\u0007A\u00119\u0005\u0005\u0003\u0003J\t=SB\u0001B&\u0015\r\u0011iEK\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B)\u0005\u0017\u0012A\u0002R3wK2|\u0007/\u001a:Ba&\fQbZ3u!\u0006\u0014H/\u001b;j_:\u001cXC\u0001B,!\u00151%\u0011\fB\u001b\u0013\r\u0011Yf\u000f\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0016O\u0016$\bK]3gKJ\u0014X\r\u001a'pG\u0006$\u0018n\u001c8t)\u0011\u0011\tGa\u0019\u0011\u0007IbT\u000fC\u0004\u00034I\u0001\rA!\u000e\u0002+\r\u000b7o]1oIJ\f7i\\$s_V\u0004X\r\u001a*E\tB\u0011A\u000bF\n\u0006)\t-$\u0011\u000f\t\u0004\r\n5\u0014b\u0001B8w\t1\u0011I\\=SK\u001a\u00042A\u0012B:\u0013\r\u0011)h\u000f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0005O\n1\u0002V8lK:\u001cu\u000e\\;n]V\u0011!Q\u0010\t\u0005\u0005\u007f\u0012I)\u0004\u0002\u0003\u0002*!!1\u0011BC\u0003\u0011a\u0017M\\4\u000b\u0005\t\u001d\u0015\u0001\u00026bm\u0006L1a\u001fBA\u00031!vn[3o\u0007>dW/\u001c8!\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\tE\u0005\u0003\u0002B@\u0005'KAA!&\u0003\u0002\n1qJ\u00196fGR\u0004")
public class CassandraCoGroupedRDD<T>
extends RDD<Seq<Seq<T>>> {
    private CassandraConnector connector;
    private final Seq<CassandraTableScanRDD<T>> scanRDDs;
    private volatile boolean bitmap$0;

    public static String TokenColumn() {
        return CassandraCoGroupedRDD$.MODULE$.TokenColumn();
    }

    private CassandraConnector connector$lzycompute() {
        CassandraCoGroupedRDD cassandraCoGroupedRDD = this;
        synchronized (cassandraCoGroupedRDD) {
            if (!this.bitmap$0) {
                this.connector = ((CassandraTableScanRDD)this.scanRDDs.head()).connector();
                this.bitmap$0 = true;
            }
        }
        return this.connector;
    }

    public CassandraConnector connector() {
        return !this.bitmap$0 ? this.connector$lzycompute() : this.connector;
    }

    public Seq<ColumnDef> getPartitionKey(CassandraConnector connector, String keyspaceName, String tableName) {
        Option option = package$.MODULE$.schemaFromCassandra(connector, (Option<String>)new Some((Object)keyspaceName), (Option<String>)new Some((Object)tableName)).tables().headOption();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                Metadata metadata = (Metadata)connector.withSessionDo((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getMetadata());
                Option suggestions = NameTools$.MODULE$.getSuggestions(metadata, keyspaceName, tableName);
                String errorMessage = NameTools$.MODULE$.getErrorString(keyspaceName, (Option)new Some((Object)tableName), suggestions);
                throw new IOException(errorMessage);
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        TableDef table = (TableDef)some.value();
        Seq seq = table.partitionKey();
        return seq;
    }

    public void checkValidMergeJoin() {
        Predef$.MODULE$.assert(this.scanRDDs.size() > 1, (Function0 & Serializable & scala.Serializable)() -> "Can not merge less then 2 tables");
        ((IterableLike)this.scanRDDs.tail()).foreach((Function1 & Serializable & scala.Serializable)rdd -> {
            Predef$.MODULE$.assert(this.hasEqualPartitionKeysTypes((CassandraTableScanRDD)this.scanRDDs.head(), rdd), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Partition key types do not match between the ").append(((CassandraTableScanRDD)$this.scanRDDs.head()).tableName()).append(" and ").append(rdd.tableName()).append(" RDDs in CoGroup").toString());
            return BoxedUnit.UNIT;
        });
    }

    public boolean isValidMergeJoin() {
        return this.scanRDDs.size() > 1 && ((IterableLike)this.scanRDDs.tail()).forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)this.hasEqualPartitionKeysTypes((CassandraTableScanRDD)this.scanRDDs.head(), x$2)));
    }

    private boolean hasEqualPartitionKeysTypes(CassandraTableScanRDD<T> leftScanRDD, CassandraTableScanRDD<T> rightScanRDD) {
        Seq leftPartitionKeyTypes = (Seq)this.getPartitionKey(leftScanRDD.connector(), leftScanRDD.keyspaceName(), leftScanRDD.tableName()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.columnType(), Seq$.MODULE$.canBuildFrom());
        Seq rightPartitionKeyTypes = (Seq)this.getPartitionKey(rightScanRDD.connector(), rightScanRDD.keyspaceName(), rightScanRDD.tableName()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.columnType(), Seq$.MODULE$.canBuildFrom());
        Seq seq = leftPartitionKeyTypes;
        Seq seq2 = rightPartitionKeyTypes;
        return !(seq != null ? !seq.equals(seq2) : seq2 != null);
    }

    private String partitionKeyStr(CassandraTableScanRDD<?> rdd) {
        return ((TraversableOnce)((TraversableLike)this.getPartitionKey(this.connector(), rdd.keyspaceName(), rdd.tableName()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.columnName(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)name -> Quote$.MODULE$.quote(name), Seq$.MODULE$.canBuildFrom())).mkString(", ");
    }

    public Token tokenExtractor(Row row) {
        return row.getToken(CassandraCoGroupedRDD$.MODULE$.TokenColumn());
    }

    private <T> Tuple2<String, Seq<Object>> tokenRangeToCqlQuery(CassandraTableScanRDD<T> fromRDD, CqlTokenRange<?, ?> range) {
        String columns = ((TraversableOnce)fromRDD.selectedColumnRefs().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.cql(), IndexedSeq$.MODULE$.canBuildFrom())).mkString(", ");
        String pk = ((TraversableOnce)fromRDD.tableDef().partitionKey().map((Function1 & Serializable & scala.Serializable)colDef -> Quote$.MODULE$.quote(colDef.columnName()), Seq$.MODULE$.canBuildFrom())).mkString(",");
        Tuple2<String, Seq<Object>> tuple2 = range.cql(this.partitionKeyStr(fromRDD));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String cql = (String)tuple2._1();
        Seq values = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)cql, (Object)values);
        Tuple2 tuple23 = tuple22;
        String cql2 = (String)tuple23._1();
        Seq values2 = (Seq)tuple23._2();
        String string = cql2;
        String filter = ((TraversableOnce)((TraversableLike)fromRDD.where().predicates().$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)CassandraCoGroupedRDD.$anonfun$tokenRangeToCqlQuery$3(x$9)))).mkString(" AND ");
        String limitClause = (String)fromRDD.limit().map((Function1 & Serializable & scala.Serializable)limit -> new StringBuilder(6).append("LIMIT ").append(limit).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String orderBy = (String)fromRDD.clusteringOrder().map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.toCql(fromRDD.tableDef())).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String quotedKeyspaceName = Quote$.MODULE$.quote(fromRDD.keyspaceName());
        String quotedTableName = Quote$.MODULE$.quote(fromRDD.tableName());
        String queryTemplate = new StringBuilder(52).append("SELECT ").append(columns).append(", TOKEN(").append(pk).append(") as ").append(CassandraCoGroupedRDD$.MODULE$.TokenColumn()).append(" ").append("FROM ").append(quotedKeyspaceName).append(".").append(quotedTableName).append(" ").append("WHERE ").append(filter).append(" ").append(orderBy).append(" ").append(limitClause).append(" ALLOW FILTERING").toString();
        Seq queryParamValues = (Seq)values2.$plus$plus(fromRDD.where().values(), Seq$.MODULE$.canBuildFrom());
        return new Tuple2((Object)queryTemplate, (Object)queryParamValues);
    }

    private BoundStatement createStatement(CqlSession session, ReadConf readConf, String cql, Seq<Object> values) {
        BoundStatement boundStatement;
        try {
            PreparedStatement stmt = session.prepare(cql);
            TypeConverter[] converters = (TypeConverter[])((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)stmt.getVariableDefinitions()).asScala()).map((Function1 & Serializable & scala.Serializable)v -> ColumnType$.MODULE$.converterToCassandra(v.getType()), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(TypeConverter.class));
            Seq convertedValues = (Seq)((TraversableLike)values.zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])converters), Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)CassandraCoGroupedRDD.$anonfun$createStatement$2(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$11 -> {
                Tuple2 tuple2 = x$11;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object value = tuple2._1();
                TypeConverter converter = (TypeConverter)tuple2._2();
                Object object = converter.convert(value);
                return object;
            }, Seq$.MODULE$.canBuildFrom());
            boundStatement = (BoundStatement)stmt.bind((Object[])convertedValues.toArray(ClassTag$.MODULE$.AnyRef())).setIdempotent(Predef$.MODULE$.boolean2Boolean(true)).setConsistencyLevel(readConf.consistencyLevel()).setPageSize(readConf.fetchSizeInRows());
        }
        catch (Throwable t) {
            throw new IOException(new StringBuilder(34).append("Exception during preparation of ").append(cql).append(": ").append(t.getMessage()).toString(), t);
        }
        return boundStatement;
    }

    private <T> Seq<T> convertRowSeq(Seq<Row> seq, RowReader<T> rowReader, CassandraRowMetadata columnMetaData) {
        return (Seq)seq.map((Function1 & Serializable & scala.Serializable)x$12 -> rowReader.read((Row)x$12, columnMetaData), Seq$.MODULE$.canBuildFrom());
    }

    private <T> Tuple2<CassandraRowMetadata, Iterator<Row>> fetchTokenRange(CqlSession session, CassandraTableScanRDD<T> fromRDD, CqlTokenRange<?, ?> range, InputMetricsUpdater inputMetricsUpdater) {
        Tuple2<String, Seq<Object>> tuple2 = this.tokenRangeToCqlQuery(fromRDD, range);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String cql = (String)tuple2._1();
        Seq values = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)cql, (Object)values);
        Tuple2 tuple23 = tuple22;
        String cql2 = (String)tuple23._1();
        Seq values2 = (Seq)tuple23._2();
        this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Fetching data for range ").append(range).append(" ").append("with ").append(cql2).append(" ").append("with params ").append(values2.mkString("[", ",", "]")).toString());
        BoundStatement stmt = this.createStatement(session, fromRDD.readConf(), cql2, (Seq<Object>)values2);
        Future fetchResult = ScalaJavaUtil$.MODULE$.asScalaFuture(session.executeAsync((Statement)stmt), (ExecutionContextExecutor)Threads$.MODULE$.BlockingIOExecutionContext()).map((Function1 & Serializable & scala.Serializable)rs -> {
            scala.collection.immutable.IndexedSeq columnNames = (scala.collection.immutable.IndexedSeq)((TraversableOnce)fromRDD.selectedColumnRefs().map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.selectedAs(), IndexedSeq$.MODULE$.canBuildFrom())).toIndexedSeq().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{CassandraCoGroupedRDD$.MODULE$.TokenColumn()})), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom());
            CassandraRowMetadata columnMetaData = CassandraRowMetadata$.MODULE$.fromResultSet((IndexedSeq)columnNames, rs, session.getContext().getCodecRegistry());
            PrefetchingResultSetIterator iterator = new PrefetchingResultSetIterator((AsyncResultSet)rs, PrefetchingResultSetIterator$.MODULE$.$lessinit$greater$default$2());
            Iterator iteratorWithMetrics = iterator.map((Function1 & Serializable & scala.Serializable)row -> inputMetricsUpdater.updateMetrics((Row)row));
            this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Row iterator for range ").append(range).append(" obtained successfully.").toString());
            return new Tuple2((Object)columnMetaData, iteratorWithMetrics);
        }, (ExecutionContext)Threads$.MODULE$.BlockingIOExecutionContext()).recover((PartialFunction)new scala.Serializable(null, cql2){
            public static final long serialVersionUID = 0L;
            private final String cql$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    A1 A12 = A1;
                    throw new IOException(new StringBuilder(32).append("Exception during execution of ").append(this.cql$1).append(": ").append(A12.getMessage()).toString(), A12);
                }
                Object object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable != null;
                return bl;
            }
            {
                this.cql$1 = cql$1;
            }
        }, (ExecutionContext)Threads$.MODULE$.BlockingIOExecutionContext());
        return (Tuple2)Await$.MODULE$.result((Awaitable)fetchResult, (Duration)Duration$.MODULE$.Inf());
    }

    @DeveloperApi
    public Iterator<Seq<Seq<T>>> compute(Partition split, TaskContext context2) {
        Seq rddWithSessions = (Seq)this.scanRDDs.map((Function1 & Serializable & scala.Serializable)rdd -> new Tuple2(rdd, (Object)this.openSession$1((CassandraTableScanRDD)rdd)), Seq$.MODULE$.canBuildFrom());
        CassandraPartition partition = (CassandraPartition)split;
        Iterable tokenRanges = partition.tokenRanges();
        boolean x$1 = this.scanRDDs.exists((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)CassandraCoGroupedRDD.$anonfun$compute$3(x$15)));
        Option<Object> x$2 = ReadConf$.MODULE$.$lessinit$greater$default$1();
        int x$3 = ReadConf$.MODULE$.$lessinit$greater$default$2();
        int x$4 = ReadConf$.MODULE$.$lessinit$greater$default$3();
        ConsistencyLevel x$5 = ReadConf$.MODULE$.$lessinit$greater$default$4();
        Option<Object> x$6 = ReadConf$.MODULE$.$lessinit$greater$default$6();
        Option<Object> x$7 = ReadConf$.MODULE$.$lessinit$greater$default$7();
        int x$8 = ReadConf$.MODULE$.$lessinit$greater$default$8();
        Option<String> x$9 = ReadConf$.MODULE$.$lessinit$greater$default$9();
        ReadConf metricsReadConf = new ReadConf(x$2, x$3, x$4, x$5, x$1, x$6, x$7, x$8, x$9);
        InputMetricsUpdater metricsUpdater = InputMetricsUpdater$.MODULE$.apply(context2, metricsReadConf, InputMetricsUpdater$.MODULE$.apply$default$3());
        Iterator mergingIterator = tokenRanges.iterator().flatMap((Function1 & Serializable & scala.Serializable)tokenRange -> {
            Seq rowsWithMeta = (Seq)rddWithSessions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                CassandraTableScanRDD rdd = (CassandraTableScanRDD)tuple2._1();
                CqlSession session = (CqlSession)tuple2._2();
                Tuple2<CassandraRowMetadata, Iterator<Row>> tuple22 = this.fetchTokenRange(session, rdd, (CqlTokenRange<?, ?>)tokenRange, metricsUpdater);
                return tuple22;
            }, Seq$.MODULE$.canBuildFrom());
            Seq metaData = (Seq)rowsWithMeta.map((Function1 & Serializable & scala.Serializable)x$16 -> (CassandraRowMetadata)x$16._1(), Seq$.MODULE$.canBuildFrom());
            Seq rows = (Seq)rowsWithMeta.map((Function1 & Serializable & scala.Serializable)x$17 -> (Iterator)x$17._2(), Seq$.MODULE$.canBuildFrom());
            MultiMergeJoinIterator rowMerger = new MultiMergeJoinIterator(rows, (Function1 & Serializable & scala.Serializable)row -> this.tokenExtractor((Row)row), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
            return rowMerger.map((Function1 & Serializable & scala.Serializable)allGroups -> (Seq)((TraversableLike)((IterableLike)allGroups.zip((GenIterable)metaData, Seq$.MODULE$.canBuildFrom())).zip($this.scanRDDs, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                CassandraTableScanRDD rdd;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$2;
                        if (tuple22 == null) break block2;
                        tuple2 = (Tuple2)tuple22._1();
                        rdd = (CassandraTableScanRDD)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                Seq rows = (Seq)tuple2._1();
                CassandraRowMetadata meta = (CassandraRowMetadata)tuple2._2();
                Seq seq = this.convertRowSeq((Seq<Row>)rows, rdd.rowReader(), meta);
                return seq;
            }, Seq$.MODULE$.canBuildFrom()));
        });
        CountingIterator countingIterator = new CountingIterator(mergingIterator, CountingIterator$.MODULE$.$lessinit$greater$default$2());
        context2.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)context -> {
            double duration = (double)metricsUpdater.finish() / 1.0E9;
            this.logDebug((Function0 & Serializable & scala.Serializable)() -> {
                Integer arg$macro$1 = BoxesRunTime.boxToInteger((int)countingIterator.count());
                String arg$macro$2 = ((CassandraTableScanRDD)$this.scanRDDs.head()).keyspaceName();
                Integer arg$macro$3 = BoxesRunTime.boxToInteger((int)partition.index());
                double arg$macro$4 = duration;
                return new StringOps(Predef$.MODULE$.augmentString(new StringOps("Fetched %s rows from\n            |%s\n            |for partition %s in %.3f s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, arg$macro$3, BoxesRunTime.boxToDouble((double)arg$macro$4)})))).stripMargin();
            });
            CassandraCoGroupedRDD.closeSessions$1((Seq)rddWithSessions.map((Function1 & Serializable & scala.Serializable)x$18 -> (CqlSession)x$18._2(), Seq$.MODULE$.canBuildFrom()));
            return context;
        });
        return countingIterator;
    }

    public Partition[] getPartitions() {
        this.checkValidMergeJoin();
        return ((RDD)this.scanRDDs.maxBy((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToInteger((int)CassandraCoGroupedRDD.$anonfun$getPartitions$1(x$19)), (Ordering)Ordering.Int$.MODULE$)).partitions();
    }

    public Seq<String> getPreferredLocations(Partition split) {
        return Predef$.MODULE$.wrapRefArray((Object[])((CassandraPartition)split).endpoints());
    }

    public static final /* synthetic */ boolean $anonfun$tokenRangeToCqlQuery$3(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$createStatement$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    private final CqlSession openSession$1(CassandraTableScanRDD rdd) {
        CassandraConnector cassandraConnector = this.connector();
        CassandraConnector cassandraConnector2 = rdd.connector();
        return !(cassandraConnector != null ? !cassandraConnector.equals(cassandraConnector2) : cassandraConnector2 != null) ? this.connector().openSession() : rdd.connector().openSession();
    }

    public static final /* synthetic */ void $anonfun$compute$1(CqlSession s) {
        block0: {
            if (s.isClosed()) break block0;
            s.close();
        }
    }

    private static final void closeSessions$1(Seq sessions) {
        sessions.foreach((Function1 & Serializable & scala.Serializable)s -> {
            CassandraCoGroupedRDD.$anonfun$compute$1(s);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$compute$3(CassandraTableScanRDD x$15) {
        return x$15.readConf().taskMetricsEnabled();
    }

    public static final /* synthetic */ int $anonfun$getPartitions$1(CassandraTableScanRDD x$19) {
        return x$19.partitions().length;
    }

    public CassandraCoGroupedRDD(SparkContext sc, Seq<CassandraTableScanRDD<T>> scanRDDs, ClassTag<T> classTag) {
        this.scanRDDs = scanRDDs;
        super(sc, (Seq)Seq$.MODULE$.empty(), ClassTag$.MODULE$.apply(Seq.class));
    }
}

