/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.data.GettableByIndex;
import com.datastax.spark.connector.AllColumns$;
import com.datastax.spark.connector.ColumnName;
import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.PartitionKeyColumns$;
import com.datastax.spark.connector.PrimaryKeyColumns$;
import com.datastax.spark.connector.SomeColumns;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.datasource.ScanHelper$;
import com.datastax.spark.connector.package$;
import com.datastax.spark.connector.rdd.ReadConf;
import com.datastax.spark.connector.rdd.reader.RowReader;
import com.datastax.spark.connector.rdd.reader.RowReaderFactory;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005-da\u0002\u000b\u0016!\u0003\r\t\u0001\t\u0005\u0006Q\u0001!\t!\u000b\u0005\u00061\u00011\t\"\f\u0005\u0006i\u00011\t\"\u000e\u0005\u0006\u0003\u00021\t\"\u000e\u0005\u0006\u0005\u00021\tb\u0011\u0005\u0006\u0011\u00021\t\"\u0013\u0005\u0006\u001d\u0002!\tb\u0014\u0005\u0007-\u0002!\tbF,\t\u000bm\u0003A\u0011\u0003/\t\u000bu\u0003A\u0011\u00030\t\u000f-\u0004!\u0019!D\tY\"9a\u0010\u0001b\u0001\u000e#y\bBCA\u0007\u0001!\u0015\r\u0011\"\u0001\u0002\u0010!Q\u0011q\u0003\u0001\t\u0006\u0004%\t!!\u0007\t\u0015\u0005\u0005\u0002\u0001#b\u0001\n\u0003\t\u0019\u0003C\u0004\u0002>\u0001!\t!a\u0010\t\u000f\u0005-\u0003\u0001\"\u0003\u0002N!Q\u0011Q\u000b\u0001\t\u0006\u0004%\t\"a\u0016\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u0002j\ty2)Y:tC:$'/\u0019+bE2,'k\\<SK\u0006$WM\u001d)s_ZLG-\u001a:\u000b\u0005Y9\u0012a\u0001:eI*\u0011\u0001$G\u0001\nG>tg.Z2u_JT!AG\u000e\u0002\u000bM\u0004\u0018M]6\u000b\u0005qi\u0012\u0001\u00033bi\u0006\u001cH/\u0019=\u000b\u0003y\t1aY8n\u0007\u0001)\"!I;\u0014\u0005\u0001\u0011\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#AB!osJ+g-\u0001\u0004%S:LG\u000f\n\u000b\u0002UA\u00111eK\u0005\u0003Y\u0011\u0012A!\u00168jiV\ta\u0006\u0005\u00020e5\t\u0001G\u0003\u00022/\u0005\u00191-\u001d7\n\u0005M\u0002$AE\"bgN\fg\u000e\u001a:b\u0007>tg.Z2u_J\fAb[3zgB\f7-\u001a(b[\u0016,\u0012A\u000e\t\u0003oyr!\u0001\u000f\u001f\u0011\u0005e\"S\"\u0001\u001e\u000b\u0005mz\u0012A\u0002\u001fs_>$h(\u0003\u0002>I\u00051\u0001K]3eK\u001aL!a\u0010!\u0003\rM#(/\u001b8h\u0015\tiD%A\u0005uC\ndWMT1nK\u0006Y1m\u001c7v[:t\u0015-\\3t+\u0005!\u0005CA#G\u001b\u00059\u0012BA$\u0018\u00059\u0019u\u000e\\;n]N+G.Z2u_J\f\u0001B]3bI\u000e{gNZ\u000b\u0002\u0015B\u00111\nT\u0007\u0002+%\u0011Q*\u0006\u0002\t%\u0016\fGmQ8oM\u0006Q1\u000f\u001d7ji\u000e{WO\u001c;\u0016\u0003A\u00032aI)T\u0013\t\u0011FE\u0001\u0004PaRLwN\u001c\t\u0003GQK!!\u0016\u0013\u0003\u0007%sG/A\u0005ta2LGoU5{KV\t\u0001\f\u0005\u0002$3&\u0011!\f\n\u0002\u0005\u0019>tw-A\u0005gKR\u001c\u0007nU5{KV\t1+\u0001\td_:\u001c\u0018n\u001d;f]\u000eLH*\u001a<fYV\tq\f\u0005\u0002aS6\t\u0011M\u0003\u0002cG\u0006!1m\u001c:f\u0015\t!W-A\u0002ba&T!AZ4\u0002\r\u0011\u0014\u0018N^3s\u0015\tA7$A\u0002pgNL!A[1\u0003!\r{gn]5ti\u0016t7-\u001f'fm\u0016d\u0017\u0001\u0005:poJ+\u0017\rZ3s\r\u0006\u001cGo\u001c:z+\u0005i\u0007c\u00018rg6\tqN\u0003\u0002q+\u00051!/Z1eKJL!A]8\u0003!I{wOU3bI\u0016\u0014h)Y2u_JL\bC\u0001;v\u0019\u0001!QA\u001e\u0001C\u0002]\u0014\u0011AU\t\u0003qn\u0004\"aI=\n\u0005i$#a\u0002(pi\"Lgn\u001a\t\u0003GqL!! \u0013\u0003\u0007\u0005s\u00170\u0001\u0005dY\u0006\u001c8\u000fV1h+\t\t\t\u0001E\u0003\u0002\u0004\u0005%1/\u0004\u0002\u0002\u0006)\u0019\u0011q\u0001\u0013\u0002\u000fI,g\r\\3di&!\u00111BA\u0003\u0005!\u0019E.Y:t)\u0006<\u0017!\u0003:poJ+\u0017\rZ3s+\t\t\t\u0002\u0005\u0003o\u0003'\u0019\u0018bAA\u000b_\nI!k\\<SK\u0006$WM]\u0001\ti\u0006\u0014G.\u001a#fMV\u0011\u00111\u0004\t\u0004_\u0005u\u0011bAA\u0010a\tAA+\u00192mK\u0012+g-\u0001\ntK2,7\r^3e\u0007>dW/\u001c8SK\u001a\u001cXCAA\u0013!\u0019\t9#!\r\u000289!\u0011\u0011FA\u0017\u001d\rI\u00141F\u0005\u0002K%\u0019\u0011q\u0006\u0013\u0002\u000fA\f7m[1hK&!\u00111GA\u001b\u0005)Ie\u000eZ3yK\u0012\u001cV-\u001d\u0006\u0004\u0003_!\u0003cA#\u0002:%\u0019\u00111H\f\u0003\u0013\r{G.^7o%\u00164\u0017!\u00068beJ|woQ8mk6t7+\u001a7fGRLwN\u001c\u000b\u0005\u0003\u0003\n9\u0005\u0005\u0004\u0002(\u0005\r\u0013qG\u0005\u0005\u0003\u000b\n)DA\u0002TKFDq!!\u0013\u0011\u0001\u0004\t\t%A\u0004d_2,XN\\:\u0002+\rDWmY6D_2,XN\\:Bm\u0006LG.\u00192mKR)!&a\u0014\u0002R!9\u0011\u0011J\tA\u0002\u0005\u0005\u0003bBA*#\u0001\u0007\u0011\u0011I\u0001\u0011CZ\f\u0017\u000e\\1cY\u0016\u001cu\u000e\\;n]N\fQdY1tg\u0006tGM]1QCJ$\u0018\u000e^5p]\u0016\u00148\t\\1tg:\u000bW.Z\u000b\u0003\u00033\u0002B!a\u0017\u0002f5\u0011\u0011Q\f\u0006\u0005\u0003?\n\t'\u0001\u0003mC:<'BAA2\u0003\u0011Q\u0017M^1\n\u0007}\ni&\u0001\u0004wKJLg-\u001f\u000b\u0003\u0003#\u0001")
public interface CassandraTableRowReaderProvider<R> {
    public CassandraConnector connector();

    public String keyspaceName();

    public String tableName();

    public ColumnSelector columnNames();

    public ReadConf readConf();

    public static /* synthetic */ Option splitCount$(CassandraTableRowReaderProvider $this) {
        return $this.splitCount();
    }

    default public Option<Object> splitCount() {
        return this.readConf().splitCount();
    }

    public static /* synthetic */ long splitSize$(CassandraTableRowReaderProvider $this) {
        return $this.splitSize();
    }

    default public long splitSize() {
        return (long)this.readConf().splitSizeInMB() * 1024L * 1024L;
    }

    public static /* synthetic */ int fetchSize$(CassandraTableRowReaderProvider $this) {
        return $this.fetchSize();
    }

    default public int fetchSize() {
        return this.readConf().fetchSizeInRows();
    }

    public static /* synthetic */ ConsistencyLevel consistencyLevel$(CassandraTableRowReaderProvider $this) {
        return $this.consistencyLevel();
    }

    default public ConsistencyLevel consistencyLevel() {
        return this.readConf().consistencyLevel();
    }

    public RowReaderFactory<R> rowReaderFactory();

    public ClassTag<R> classTag();

    public static /* synthetic */ RowReader rowReader$(CassandraTableRowReaderProvider $this) {
        return $this.rowReader();
    }

    default public RowReader<R> rowReader() {
        return this.rowReaderFactory().rowReader(this.tableDef(), this.columnNames().selectFrom(this.tableDef()));
    }

    public static /* synthetic */ TableDef tableDef$(CassandraTableRowReaderProvider $this) {
        return $this.tableDef();
    }

    default public TableDef tableDef() {
        return com.datastax.spark.connector.util.package$.MODULE$.tableFromCassandra(this.connector(), this.keyspaceName(), this.tableName());
    }

    public static /* synthetic */ IndexedSeq selectedColumnRefs$(CassandraTableRowReaderProvider $this) {
        return $this.selectedColumnRefs();
    }

    default public IndexedSeq<ColumnRef> selectedColumnRefs() {
        scala.collection.immutable.IndexedSeq indexedSeq;
        Seq<ColumnRef> seq;
        ColumnSelector columnSelector = this.columnNames();
        if (AllColumns$.MODULE$.equals(columnSelector)) {
            seq = (Seq<ColumnRef>)this.tableDef().columns().map((Function1 & Serializable & scala.Serializable)col -> package$.MODULE$.toNamedColumnRef(col.columnName()), IndexedSeq$.MODULE$.canBuildFrom());
        } else if (PrimaryKeyColumns$.MODULE$.equals(columnSelector)) {
            seq = (Seq)this.tableDef().primaryKey().map((Function1 & Serializable & scala.Serializable)col -> package$.MODULE$.toNamedColumnRef(col.columnName()), IndexedSeq$.MODULE$.canBuildFrom());
        } else if (PartitionKeyColumns$.MODULE$.equals(columnSelector)) {
            seq = (Seq)this.tableDef().partitionKey().map((Function1 & Serializable & scala.Serializable)col -> package$.MODULE$.toNamedColumnRef(col.columnName()), Seq$.MODULE$.canBuildFrom());
        } else if (columnSelector instanceof SomeColumns) {
            SomeColumns someColumns = (SomeColumns)columnSelector;
            Seq<ColumnRef> cs = someColumns.columns();
            seq = ScanHelper$.MODULE$.checkColumnsExistence(cs, this.tableDef());
        } else {
            throw new MatchError((Object)columnSelector);
        }
        Seq<ColumnRef> providedColumns = seq;
        Option<Seq<ColumnRef>> option = this.rowReader().neededColumns();
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq neededColumns = (Seq)some.value();
            indexedSeq = ((TraversableOnce)providedColumns.filter((Function1)neededColumns.toSet())).toIndexedSeq();
        } else if (None$.MODULE$.equals(option)) {
            indexedSeq = providedColumns.toIndexedSeq();
        } else {
            throw new MatchError(option);
        }
        return indexedSeq;
    }

    public static /* synthetic */ Seq narrowColumnSelection$(CassandraTableRowReaderProvider $this, Seq columns) {
        return $this.narrowColumnSelection((Seq<ColumnRef>)columns);
    }

    default public Seq<ColumnRef> narrowColumnSelection(Seq<ColumnRef> columns) {
        ColumnSelector columnSelector = this.columnNames();
        if (columnSelector instanceof SomeColumns) {
            SomeColumns someColumns = (SomeColumns)columnSelector;
            Seq<ColumnRef> cs = someColumns.columns();
            this.checkColumnsAvailable(columns, cs);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (AllColumns$.MODULE$.equals(columnSelector)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean bl = PartitionKeyColumns$.MODULE$.equals(columnSelector) ? true : PrimaryKeyColumns$.MODULE$.equals(columnSelector);
            if (bl) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)columnSelector);
            }
        }
        return columns;
    }

    private void checkColumnsAvailable(Seq<ColumnRef> columns, Seq<ColumnRef> availableColumns) {
        Set availableColumnsSet = ((TraversableOnce)availableColumns.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ColumnRef, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof ColumnName) {
                    ColumnName columnName = (ColumnName)A1;
                    String columnName2 = columnName.columnName();
                    object = columnName2;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(ColumnRef x1) {
                ColumnRef columnRef = x1;
                boolean bl = columnRef instanceof ColumnName;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        Option notFound = columns.collectFirst((PartialFunction)new scala.Serializable(null, availableColumnsSet){
            public static final long serialVersionUID = 0L;
            private final Set availableColumnsSet$1;

            public final <A1 extends ColumnRef, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                ColumnName columnName;
                String columnName2;
                A1 A1 = x2;
                Object object = A1 instanceof ColumnName && !this.availableColumnsSet$1.contains((Object)(columnName2 = (columnName = (ColumnName)A1).columnName())) ? columnName2 : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(ColumnRef x2) {
                ColumnName columnName;
                String columnName2;
                ColumnRef columnRef = x2;
                boolean bl = columnRef instanceof ColumnName && !this.availableColumnsSet$1.contains((Object)(columnName2 = (columnName = (ColumnName)columnRef).columnName()));
                return bl;
            }
            {
                this.availableColumnsSet$1 = availableColumnsSet$1;
            }
        });
        if (notFound.isDefined()) {
            throw new IllegalArgumentException(new StringBuilder(55).append("Column not found in selection: ").append(notFound.get()).append(". ").append("Available columns: [").append(availableColumns.mkString(",")).append("].").toString());
        }
    }

    public static /* synthetic */ String cassandraPartitionerClassName$(CassandraTableRowReaderProvider $this) {
        return $this.cassandraPartitionerClassName();
    }

    default public String cassandraPartitionerClassName() {
        return (String)this.connector().withSessionDo((Function1 & Serializable & scala.Serializable)session -> ((GettableByIndex)session.execute("SELECT partitioner FROM system.local").one()).getString(0));
    }

    public static /* synthetic */ RowReader verify$(CassandraTableRowReaderProvider $this) {
        return $this.verify();
    }

    default public RowReader<R> verify() {
        this.tableDef().columns();
        return this.rowReader();
    }

    public static void $init$(CassandraTableRowReaderProvider $this) {
    }
}

