/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd.partitioner;

import com.datastax.spark.connector.rdd.partitioner.MonotonicBucketing;
import com.datastax.spark.connector.rdd.partitioner.MonotonicBucketing$;
import com.datastax.spark.connector.rdd.partitioner.RangeBounds;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001\u0002\t\u0012\u0001yA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t}\u0001\u0011\t\u0011)A\u0006\u007f!Aa\t\u0001B\u0001B\u0003-q\t\u0003\u0005K\u0001\t\u0005\t\u0015a\u0003L\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u001d1\u0006A1A\u0005\n]Caa\u0017\u0001!\u0002\u0013A\u0006b\u0002/\u0001\u0005\u0004%Ia\u0016\u0005\u0007;\u0002\u0001\u000b\u0011\u0002-\t\u000fy\u0003!\u0019!C\u0005?\"11\u000e\u0001Q\u0001\n\u0001Dq\u0001\u001c\u0001C\u0002\u0013%Q\u000e\u0003\u0004r\u0001\u0001\u0006IA\u001c\u0005\u0006e\u0002!Ia\u001d\u0005\u0006{\u0002!\tA \u0002\u0014\u0005V\u001c7.\u001a;j]\u001e\u0014\u0016M\\4f\u0013:$W\r\u001f\u0006\u0003%M\t1\u0002]1si&$\u0018n\u001c8fe*\u0011A#F\u0001\u0004e\u0012$'B\u0001\f\u0018\u0003%\u0019wN\u001c8fGR|'O\u0003\u0002\u00193\u0005)1\u000f]1sW*\u0011!dG\u0001\tI\u0006$\u0018m\u001d;bq*\tA$A\u0002d_6\u001c\u0001!F\u0002 k\u0011\u001b\"\u0001\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\r\u0005s\u0017PU3g\u0003\u0019\u0011\u0018M\\4fgB\u0019\u0001\u0006M\u001a\u000f\u0005%rcB\u0001\u0016.\u001b\u0005Y#B\u0001\u0017\u001e\u0003\u0019a$o\\8u}%\t1%\u0003\u00020E\u00059\u0001/Y2lC\u001e,\u0017BA\u00193\u0005\r\u0019V-\u001d\u0006\u0003_\t\u0002\"\u0001N\u001b\r\u0001\u0011)a\u0007\u0001b\u0001o\t\t!+\u0005\u00029wA\u0011\u0011%O\u0005\u0003u\t\u0012qAT8uQ&tw\r\u0005\u0002\"y%\u0011QH\t\u0002\u0004\u0003:L\u0018A\u00022pk:$7\u000f\u0005\u0003A\u0003N\u001aU\"A\t\n\u0005\t\u000b\"a\u0003*b]\u001e,'i\\;oIN\u0004\"\u0001\u000e#\u0005\u000b\u0015\u0003!\u0019A\u001c\u0003\u0003Q\u000b\u0001b\u001c:eKJLgn\u001a\t\u0004Q!\u001b\u0015BA%3\u0005!y%\u000fZ3sS:<\u0017!\u00032vG.,G/\u001b8h!\r\u0001EjQ\u0005\u0003\u001bF\u0011!#T8o_R|g.[2Ck\u000e\\W\r^5oO\u00061A(\u001b8jiz\"\"\u0001U+\u0015\tE\u00136\u000b\u0016\t\u0005\u0001\u0002\u00194\tC\u0003?\u000b\u0001\u000fq\bC\u0003G\u000b\u0001\u000fq\tC\u0003K\u000b\u0001\u000f1\nC\u0003'\u000b\u0001\u0007q%A\u0004tSj,Gj\\4\u0016\u0003a\u0003\"!I-\n\u0005i\u0013#aA%oi\u0006A1/\u001b>f\u0019><\u0007%\u0001\u0003tSj,\u0017!B:ju\u0016\u0004\u0013!\u0002;bE2,W#\u00011\u0011\u0007\u0005\n7-\u0003\u0002cE\t)\u0011I\u001d:bsB\u0019A-[\u001a\u000e\u0003\u0015T!AZ4\u0002\u000f5,H/\u00192mK*\u0011\u0001NI\u0001\u000bG>dG.Z2uS>t\u0017B\u00016f\u0005-\t%O]1z\u0005V4g-\u001a:\u0002\rQ\f'\r\\3!\u0003\u0019\u0011WoY6fiV\ta\u000e\u0005\u0003\"_\u000eC\u0016B\u00019#\u0005%1UO\\2uS>t\u0017'A\u0004ck\u000e\\W\r\u001e\u0011\u0002\u0007\u0005$G\r\u0006\u0003uof\\\bCA\u0011v\u0013\t1(E\u0001\u0003V]&$\b\"\u0002=\u000f\u0001\u0004\u0019\u0014!\u0001:\t\u000bit\u0001\u0019\u0001-\u0002\u0013M$\u0018M\u001d;ICND\u0007\"\u0002?\u000f\u0001\u0004A\u0016aB3oI\"\u000b7\u000f[\u0001\u0011e\u0006tw-Z:D_:$\u0018-\u001b8j]\u001e$2a`A\u0003!\u0011A\u0013\u0011A\u001a\n\u0007\u0005\r!G\u0001\u0006J]\u0012,\u00070\u001a3TKFDa!a\u0002\u0010\u0001\u0004\u0019\u0015!\u00029pS:$\b")
public class BucketingRangeIndex<R, T> {
    private final RangeBounds<R, T> bounds;
    private final Ordering<T> ordering;
    private final int sizeLog;
    private final int size;
    private final ArrayBuffer<R>[] table;
    private final Function1<T, Object> bucket;

    private int sizeLog() {
        return this.sizeLog;
    }

    private int size() {
        return this.size;
    }

    private ArrayBuffer<R>[] table() {
        return this.table;
    }

    private Function1<T, Object> bucket() {
        return this.bucket;
    }

    private void add(R r, int startHash, int endHash) {
        for (int i = startHash; i <= endHash; ++i) {
            this.table()[i].$plus$eq(r);
        }
    }

    public IndexedSeq<R> rangesContaining(T point) {
        return ((TraversableOnce)this.table()[BoxesRunTime.unboxToInt((Object)this.bucket().apply(point))].filter((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)this.bounds.contains(x$1, point)))).toIndexedSeq();
    }

    public static final /* synthetic */ void $anonfun$new$1(BucketingRangeIndex $this, Object r) {
        Object start = $this.bounds.start(r);
        Object end = $this.bounds.end(r);
        int startBucket = BoxesRunTime.unboxToInt((Object)$this.bucket().apply(start));
        int endBucket = BoxesRunTime.unboxToInt((Object)$this.bucket().apply(end));
        if ($this.bounds.isFull(r)) {
            $this.add(r, 0, $this.size() - 1);
        } else if ($this.ordering.lt(end, start)) {
            $this.add(r, startBucket, $this.size() - 1);
            $this.add(r, 0, endBucket);
        } else {
            $this.add(r, startBucket, endBucket);
        }
    }

    public BucketingRangeIndex(Seq<R> ranges, RangeBounds<R, T> bounds, Ordering<T> ordering, MonotonicBucketing<T> bucketing) {
        this.bounds = bounds;
        this.ordering = ordering;
        this.sizeLog = (int)MonotonicBucketing$.MODULE$.log2(ranges.size()) + 1;
        this.size = (int)package$.MODULE$.pow(2.0, (double)this.sizeLog());
        this.table = (ArrayBuffer[])Array$.MODULE$.fill(this.size(), (Function0 & java.io.Serializable & Serializable)() -> new ArrayBuffer(), ClassTag$.MODULE$.apply(ArrayBuffer.class));
        this.bucket = bucketing.bucket(this.size());
        ranges.foreach((Function1 & java.io.Serializable & Serializable)r -> {
            BucketingRangeIndex.$anonfun$new$1(this, r);
            return BoxedUnit.UNIT;
        });
    }
}

