/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd.partitioner;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.TokenMap;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.rdd.partitioner.CassandraPartition;
import com.datastax.spark.connector.rdd.partitioner.CassandraPartitionGenerator$;
import com.datastax.spark.connector.rdd.partitioner.CassandraPartitioner;
import com.datastax.spark.connector.rdd.partitioner.CqlTokenRange;
import com.datastax.spark.connector.rdd.partitioner.Murmur3PartitionerTokenRangeSplitter;
import com.datastax.spark.connector.rdd.partitioner.NodeAddresses;
import com.datastax.spark.connector.rdd.partitioner.RandomPartitionerTokenRangeSplitter;
import com.datastax.spark.connector.rdd.partitioner.TokenRangeClusterer;
import com.datastax.spark.connector.rdd.partitioner.TokenRangeSplitter;
import com.datastax.spark.connector.rdd.partitioner.dht.BigIntToken;
import com.datastax.spark.connector.rdd.partitioner.dht.Token;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenFactory;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenFactory$Murmur3TokenFactory$;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenFactory$RandomPartitionerTokenFactory$;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenRange;
import com.datastax.spark.connector.util.DriverUtil$;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.writer.RowWriterFactory;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.spark.sql.connector.read.InputPartition;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.BigInt;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005=h!B\f\u0019\u0001q!\u0003\u0002C\u000f\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\t\u0011e\u0002!\u0011!Q\u0001\niB\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\u0003\u0002\u0011\t\u0011)A\u0006\u0005\")!\f\u0001C\u00017\u0016!\u0011\f\u0001\u0001d\u000b\u0011!\u0007\u0001A3\t\u000f\u001d\u0004!\u0019!C\u0005Q\"1Q\u000f\u0001Q\u0001\n%DQA\u001e\u0001\u0005\n]D\u0001\"!\u0005\u0001\t\u0003A\u00121\u0003\u0005\b\u0003[\u0001A\u0011BA\u0018\u0011\u001d\t9\u0004\u0001C\u0005\u0003sAq!!\u0012\u0001\t\u0003\t9\u0005C\u0004\u0002R\u0001!\t!a\u0015\t\re\u0001A\u0011AA<\u000f\u001d\tY\f\u0007E\u0001\u0003{3aa\u0006\r\t\u0002\u0005}\u0006B\u0002.\u0013\t\u0003\t\t-B\u0003L%\u0001\t\u0019-B\u0003V%\u0001\tY\rC\u0004\u0002ZJ!\t!a7\u00037\r\u000b7o]1oIJ\f\u0007+\u0019:uSRLwN\\$f]\u0016\u0014\u0018\r^8s\u0015\tI\"$A\u0006qCJ$\u0018\u000e^5p]\u0016\u0014(BA\u000e\u001d\u0003\r\u0011H\r\u001a\u0006\u0003;y\t\u0011bY8o]\u0016\u001cGo\u001c:\u000b\u0005}\u0001\u0013!B:qCJ\\'BA\u0011#\u0003!!\u0017\r^1ti\u0006D(\"A\u0012\u0002\u0007\r|W.F\u0002&\u0015R\u001b2\u0001\u0001\u0014-!\t9#&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\u0019\te.\u001f*fMB\u0011Q\u0006M\u0007\u0002])\u0011q\u0006H\u0001\u0005kRLG.\u0003\u00022]\t9Aj\\4hS:<7\u0001\u0001\t\u0003i]j\u0011!\u000e\u0006\u0003mq\t1aY9m\u0013\tATG\u0001\nDCN\u001c\u0018M\u001c3sC\u000e{gN\\3di>\u0014\u0018\u0001\u0003;bE2,G)\u001a4\u0011\u0005QZ\u0014B\u0001\u001f6\u0005!!\u0016M\u00197f\t\u00164\u0017AC:qY&$8i\\;oiB\u0011qeP\u0005\u0003\u0001\"\u00121!\u00138u\u00031!xn[3o\r\u0006\u001cGo\u001c:z!\u0011\u0019e\tS*\u000e\u0003\u0011S!!\u0012\r\u0002\u0007\u0011DG/\u0003\u0002H\t\naAk\\6f]\u001a\u000b7\r^8ssB\u0011\u0011J\u0013\u0007\u0001\t\u0015Y\u0005A1\u0001M\u0005\u00051\u0016CA'Q!\t9c*\u0003\u0002PQ\t9aj\u001c;iS:<\u0007CA\u0014R\u0013\t\u0011\u0006FA\u0002B]f\u0004\"!\u0013+\u0005\u000bU\u0003!\u0019\u0001,\u0003\u0003Q\u000b\"!T,\u0011\u0007\rC\u0006*\u0003\u0002Z\t\n)Ak\\6f]\u00061A(\u001b8jiz\"B\u0001\u00181bER\u0011Ql\u0018\t\u0005=\u0002A5+D\u0001\u0019\u0011\u0015\tU\u0001q\u0001C\u0011\u0015iR\u00011\u00014\u0011\u0015IT\u00011\u0001;\u0011\u0015iT\u00011\u0001?!\r\u0019\u0005l\u0015\u0002\u000b)>\\WM\u001c*b]\u001e,\u0007\u0003B\"g\u0011NK!\u0001\u001a#\u0002\u0019-,\u0017p\u001d9bG\u0016t\u0015-\\3\u0016\u0003%\u0004\"A[:\u000e\u0003-T!\u0001\\7\u0002\t\r|'/\u001a\u0006\u0003]>\f1!\u00199j\u0015\t\u0001\u0018/\u0001\u0004ee&4XM\u001d\u0006\u0003e\u0002\n1a\\:t\u0013\t!8NA\u0007Dc2LE-\u001a8uS\u001aLWM]\u0001\u000eW\u0016L8\u000f]1dK:\u000bW.\u001a\u0011\u0002\u0015Q|7.\u001a8SC:<W\r\u0006\u0003yu\u0006\u001d\u0001CA=\b\u001b\u0005\u0001\u0001\"B>\u000b\u0001\u0004a\u0018!\u0002:b]\u001e,\u0007cA?\u0002\u00065\taPC\u0002\u0000\u0003\u0003\tQ\u0001^8lK:T1!a\u0001l\u0003!iW\r^1eCR\f\u0017B\u00013\u007f\u0011\u001d\t\u0019A\u0003a\u0001\u0003\u0013\u0001B!a\u0003\u0002\u000e5\u0011\u0011\u0011A\u0005\u0005\u0003\u001f\t\tA\u0001\u0005U_.,g.T1q\u00031!Wm]2sS\n,'+\u001b8h+\t\t)\u0002E\u0003\u0002\u0018\u0005\u001d\u0002P\u0004\u0003\u0002\u001a\u0005\rb\u0002BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}!'\u0001\u0004=e>|GOP\u0005\u0002S%\u0019\u0011Q\u0005\u0015\u0002\u000fA\f7m[1hK&!\u0011\u0011FA\u0016\u0005\r\u0019V-\u001d\u0006\u0004\u0003KA\u0013\u0001G2sK\u0006$X\rV8lK:\u0014\u0016M\\4f'Bd\u0017\u000e\u001e;feV\u0011\u0011\u0011\u0007\t\u0006=\u0006M\u0002jU\u0005\u0004\u0003kA\"A\u0005+pW\u0016t'+\u00198hKN\u0003H.\u001b;uKJ\f!B]1oO\u0016$vnQ9m)\u0011\tY$a\u0011\u0011\r\u0005]\u0011qEA\u001f!\u0015q\u0016q\b%T\u0013\r\t\t\u0005\u0007\u0002\u000e\u0007FdGk\\6f]J\u000bgnZ3\t\u000bml\u0001\u0019\u0001=\u0002\u0015A\f'\u000f^5uS>t7/\u0006\u0002\u0002JA1\u0011qCA\u0014\u0003\u0017\u0002RAXA'\u0011NK1!a\u0014\u0019\u0005I\u0019\u0015m]:b]\u0012\u0014\u0018\rU1si&$\u0018n\u001c8\u0002%\u001d,G/\u00138qkR\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0003\u0003+\u0002RaJA,\u00037J1!!\u0017)\u0005\u0015\t%O]1z!\u0011\ti&a\u001d\u000e\u0005\u0005}#\u0002BA1\u0003G\nAA]3bI*\u0019Q$!\u001a\u000b\t\u0005\u001d\u0014\u0011N\u0001\u0004gFd'bA\u0010\u0002l)!\u0011QNA8\u0003\u0019\t\u0007/Y2iK*\u0011\u0011\u0011O\u0001\u0004_J<\u0017\u0002BA;\u0003?\u0012a\"\u00138qkR\u0004\u0016M\u001d;ji&|g.\u0006\u0003\u0002z\u0005-E\u0003BA>\u0003_#b!! \u0002\u0010\u0006}\u0005#B\u0014\u0002\u0000\u0005\r\u0015bAAAQ\t1q\n\u001d;j_:\u0004rAXAC\u0003\u0013C5+C\u0002\u0002\bb\u0011AcQ1tg\u0006tGM]1QCJ$\u0018\u000e^5p]\u0016\u0014\bcA%\u0002\f\u00121\u0011Q\u0012\tC\u00021\u00131aS3z\u0011%\t\t\nEA\u0001\u0002\b\t\u0019*\u0001\u0006fm&$WM\\2fIE\u0002b!!&\u0002\u001c\u0006%UBAAL\u0015\r\tI\nK\u0001\be\u00164G.Z2u\u0013\u0011\ti*a&\u0003\u0011\rc\u0017m]:UC\u001eD\u0011\"!)\u0011\u0003\u0003\u0005\u001d!a)\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007\u0005\u0004\u0002&\u0006-\u0016\u0011R\u0007\u0003\u0003OS1!!+\u001d\u0003\u00199(/\u001b;fe&!\u0011QVAT\u0005A\u0011vn^,sSR,'OR1di>\u0014\u0018\u0010C\u0004\u00022B\u0001\r!a-\u0002\u0013-,\u00170T1qa\u0016\u0014\b\u0003BA[\u0003ok\u0011\u0001H\u0005\u0004\u0003sc\"AD\"pYVlgnU3mK\u000e$xN]\u0001\u001c\u0007\u0006\u001c8/\u00198ee\u0006\u0004\u0016M\u001d;ji&|gnR3oKJ\fGo\u001c:\u0011\u0005y\u00132C\u0001\n')\t\ti\f\r\u0003\u0002F\u0006\u001d\u0007cA%\u0002H\u0012Q\u0011\u0011\u001a\u000b\u0002\u0002\u0003\u0005)\u0011\u0001'\u0003\u0003Q\u0004D!!4\u0002PB\u0019\u0011*a4\u0005\u0017\u0005%W#!A\u0001\u0002\u000b\u0005\u0011\u0011[\t\u0004\u001b\u0006M\u0007\u0003B\"Y\u0003+\u00042!a6\u0015\u001b\u0005\u0011\u0012!B1qa2LH\u0003CAo\u0003O\fY/!<\u0015\t\u0005}\u00171\u001d\t\u0007=\u0002\t).!9\u0011\u0007\u0005]W\u0003\u0003\u0004B-\u0001\u000f\u0011Q\u001d\t\u0007\u0007\u001a\u000b).!9\t\r\u0005%h\u00031\u00014\u0003\u0011\u0019wN\u001c8\t\u000be2\u0002\u0019\u0001\u001e\t\u000bu2\u0002\u0019\u0001 ")
public class CassandraPartitionGenerator<V, T extends Token<V>>
implements Logging {
    private final CassandraConnector connector;
    private final TableDef tableDef;
    private final int splitCount;
    private final TokenFactory<V, T> tokenFactory;
    private final CqlIdentifier keyspaceName;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    public static CassandraPartitionGenerator<Object, Token> apply(CassandraConnector cassandraConnector, TableDef tableDef, int n, TokenFactory<Object, Token> tokenFactory) {
        return CassandraPartitionGenerator$.MODULE$.apply(cassandraConnector, tableDef, n, tokenFactory);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    private CqlIdentifier keyspaceName() {
        return this.keyspaceName;
    }

    private TokenRange<V, T> tokenRange(com.datastax.oss.driver.api.core.metadata.token.TokenRange range, TokenMap metadata) {
        T startToken = this.tokenFactory.tokenFromString(metadata.format(range.getStart()));
        T endToken = this.tokenFactory.tokenFromString(metadata.format(range.getEnd()));
        scala.collection.immutable.Set replicas = ((TraversableOnce)((SetLike)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(metadata.getReplicas(this.keyspaceName(), range)).asScala()).map((Function1 & Serializable & scala.Serializable)node -> (InetSocketAddress)DriverUtil$.MODULE$.toAddress(node).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(46).append("Unable to determine Node Broadcast Address of ").append(node).toString());
        }), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getAddress(), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).toSet();
        return new TokenRange<V, T>(startToken, endToken, (scala.collection.immutable.Set<InetAddress>)replicas, this.tokenFactory);
    }

    public Seq<TokenRange<V, T>> describeRing() {
        Seq seq;
        Set ranges = (Set)this.connector.withSessionDo((Function1 & Serializable & scala.Serializable)session -> {
            TokenMap tokenMap = (TokenMap)Option$.MODULE$.apply(session.getMetadata().getTokenMap().get()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException("Unable to determine Token Range Metadata");
            });
            return (Set)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(tokenMap.getTokenRanges()).asScala()).map((Function1 & Serializable & scala.Serializable)tr -> this.tokenRange((com.datastax.oss.driver.api.core.metadata.token.TokenRange)tr, tokenMap), scala.collection.mutable.Set$.MODULE$.canBuildFrom());
        });
        if (this.splitCount == 1) {
            TokenRange[] tokenRangeArray = new TokenRange[1];
            TokenRange qual$1 = (TokenRange)ranges.head();
            T x$1 = this.tokenFactory.minToken();
            T x$2 = this.tokenFactory.minToken();
            scala.collection.immutable.Set<InetAddress> x$3 = qual$1.copy$default$3();
            TokenFactory x$4 = qual$1.copy$default$4();
            tokenRangeArray[0] = qual$1.copy(x$1, x$2, x$3, x$4);
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tokenRangeArray));
        } else {
            seq = ranges.toSeq();
        }
        return seq;
    }

    private TokenRangeSplitter<V, T> createTokenRangeSplitter() {
        TokenRangeSplitter<BigInt, BigIntToken> tokenRangeSplitter;
        TokenFactory<V, T> tokenFactory = this.tokenFactory;
        if (TokenFactory$RandomPartitionerTokenFactory$.MODULE$.equals(tokenFactory)) {
            tokenRangeSplitter = new RandomPartitionerTokenRangeSplitter();
        } else if (TokenFactory$Murmur3TokenFactory$.MODULE$.equals(tokenFactory)) {
            tokenRangeSplitter = new Murmur3PartitionerTokenRangeSplitter();
        } else {
            throw new UnsupportedOperationException(new StringBuilder(25).append("Unsupported TokenFactory ").append(this.tokenFactory).toString());
        }
        return tokenRangeSplitter;
    }

    private Seq<CqlTokenRange<V, T>> rangeToCql(TokenRange<V, T> range) {
        return (Seq)range.unwrap(this.tokenFactory).map((Function1 & Serializable & scala.Serializable)x$2 -> new CqlTokenRange(x$2, $this.tokenFactory), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<CassandraPartition<V, T>> partitions() {
        NodeAddresses hostAddresses = new NodeAddresses(this.connector);
        Seq<TokenRange<V, T>> tokenRanges = this.describeRing();
        int endpointCount = ((TraversableOnce)((TraversableOnce)tokenRanges.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.replicas(), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$4, x$5) -> (scala.collection.immutable.Set)x$4.$plus$plus((GenTraversableOnce)x$5))).size();
        if (endpointCount == 0) {
            throw new IllegalArgumentException(new StringBuilder(137).append("Could not retrieve endpoints for the given table ").append("(").append(this.keyspaceName()).append(".").append(this.tableDef.name()).append("), are you trying to read a table view? Table views are not supported, ").append("see SPARKC-612.").toString());
        }
        int maxGroupSize = tokenRanges.size() / endpointCount;
        TokenRangeSplitter<V, T> splitter = this.createTokenRangeSplitter();
        Seq splits = splitter.split((Iterable<TokenRange<V, T>>)tokenRanges, this.splitCount).toSeq();
        TokenRangeClusterer clusterer = new TokenRangeClusterer(this.splitCount, maxGroupSize);
        Seq[] tokenRangeGroups = (Seq[])clusterer.group(splits).toArray(ClassTag$.MODULE$.apply(Seq.class));
        CassandraPartition[] partitions = (CassandraPartition[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokenRangeGroups)).map((Function1 & Serializable & scala.Serializable)group -> {
            scala.collection.immutable.Set replicas = (scala.collection.immutable.Set)((TraversableOnce)group.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.replicas(), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$7, x$8) -> (scala.collection.immutable.Set)x$7.intersect((GenSet)x$8));
            BigInt rowCount = (BigInt)((TraversableOnce)group.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.rangeSize(), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.BigIntIsIntegral$.MODULE$);
            Seq cqlRanges = (Seq)group.flatMap((Function1 & Serializable & scala.Serializable)range -> this.rangeToCql((TokenRange)range), Seq$.MODULE$.canBuildFrom());
            return new CassandraPartition(0, (String[])((TraversableOnce)replicas.flatMap((Function1 & Serializable & scala.Serializable)nativeTransportAddress -> hostAddresses.hostNames((InetAddress)nativeTransportAddress), Set$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)), cqlRanges, rowCount.toLong());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(CassandraPartition.class)));
        Seq partitionsGroupedByEndpoints = (Seq)((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitions)).groupBy((Function1 & Serializable & scala.Serializable)x$10 -> x$10.endpoints()).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)CassandraPartitionGenerator.$anonfun$partitions$10(x$11)), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$12 -> (CassandraPartition[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$12._2())).sortBy((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)CassandraPartitionGenerator.$anonfun$partitions$12(x$13)), (Ordering)Ordering.Long$.MODULE$), Seq$.MODULE$.canBuildFrom());
        Seq groupIterators = (Seq)partitionsGroupedByEndpoints.map((Function1 & Serializable & scala.Serializable)x$14 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$14)).iterator(), Seq$.MODULE$.canBuildFrom());
        Seq roundRobinSelectedPartitions = TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)package$.MODULE$.Iterator().continually((Function0 & Serializable & scala.Serializable)() -> (Seq)((TraversableLike)groupIterators.filter((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)x$15.hasNext()))).map((Function1 & Serializable & scala.Serializable)x$16 -> (CassandraPartition)x$16.next(), Seq$.MODULE$.canBuildFrom())).takeWhile((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)x$17.nonEmpty())), (Function1)Predef$.MODULE$.$conforms()).flatten().toSeq();
        Seq indexedPartitions = (Seq)((TraversableLike)roundRobinSelectedPartitions.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            CassandraPartition p = (CassandraPartition)tuple2._1();
            int index = tuple2._2$mcI$sp();
            CassandraPartition cassandraPartition = p.copy(index, p.copy$default$2(), p.copy$default$3(), p.copy$default$4());
            return cassandraPartition;
        }, Seq$.MODULE$.canBuildFrom());
        return indexedPartitions;
    }

    public InputPartition[] getInputPartitions() {
        return (InputPartition[])this.partitions().toArray(ClassTag$.MODULE$.apply(InputPartition.class));
    }

    public <Key> Option<CassandraPartitioner<Key, V, T>> partitioner(ColumnSelector keyMapper, ClassTag<Key> evidence$1, RowWriterFactory<Key> evidence$2) {
        Try part;
        block0: {
            part = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                CassandraPartitioner newPartitioner = new CassandraPartitioner($this.connector, $this.tableDef, this.partitions(), keyMapper, evidence$1, evidence$2, $this.tokenFactory);
                newPartitioner.verify(false);
                return newPartitioner;
            });
            if (!part.isFailure()) break block0;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Not able to automatically create a partitioner: ").append(((Throwable)part.failed().get()).getMessage()).toString());
        }
        return part.toOption();
    }

    public static final /* synthetic */ int $anonfun$partitions$10(Tuple2 x$11) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$11._1())).size();
    }

    public static final /* synthetic */ long $anonfun$partitions$12(CassandraPartition x$13) {
        return -x$13.dataSize();
    }

    public CassandraPartitionGenerator(CassandraConnector connector, TableDef tableDef, int splitCount, TokenFactory<V, T> tokenFactory) {
        this.connector = connector;
        this.tableDef = tableDef;
        this.splitCount = splitCount;
        this.tokenFactory = tokenFactory;
        Logging.$init$((Logging)this);
        this.keyspaceName = CqlIdentifier.fromInternal((String)tableDef.keyspaceName());
    }
}

