/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd.partitioner;

import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.PartitionKeyColumns$;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.rdd.partitioner.BucketingRangeIndex;
import com.datastax.spark.connector.rdd.partitioner.CassandraPartition;
import com.datastax.spark.connector.rdd.partitioner.CassandraPartitioner$;
import com.datastax.spark.connector.rdd.partitioner.MonotonicBucketing;
import com.datastax.spark.connector.rdd.partitioner.TokenGenerator;
import com.datastax.spark.connector.rdd.partitioner.TokenRangeWithPartitionIndex;
import com.datastax.spark.connector.rdd.partitioner.TokenRangeWithPartitionIndex$;
import com.datastax.spark.connector.rdd.partitioner.dht.Token;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenFactory;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.writer.RowWriter;
import com.datastax.spark.connector.writer.RowWriterFactory;
import java.io.Serializable;
import org.apache.spark.Partitioner;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t5c!\u0002\u0012$\u0001\u001dz\u0003\u0002\u0003\u0015\u0001\u0005\u000b\u0007I\u0011B!\t\u0011!\u0003!\u0011!Q\u0001\n\tC\u0001\"\u0013\u0001\u0003\u0006\u0004%IA\u0013\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u0017\"Aq\n\u0001BC\u0002\u0013\u0005\u0001\u000b\u0003\u0005z\u0001\t\u0005\t\u0015!\u0003R\u0011!Q\bA!b\u0001\n\u0003Y\b\"CA\u0001\u0001\t\u0005\t\u0015!\u0003}\u0011)\t\u0019\u0001\u0001B\u0002B\u0003-\u0011Q\u0001\u0005\u000b\u0003/\u0001!Q1A\u0005\f\u0005e\u0001BCA\u0014\u0001\t\u0005\t\u0015!\u0003\u0002\u001c!Q\u0011\u0011\u0007\u0001\u0003\u0002\u0003\u0006Y!a\r\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<!9\u0011q\n\u0001\u0005\u0002\u0005E\u0003bBA+\u0001\u0011\u0005\u0011q\u000b\u0005\u000b\u00037\u0002\u0001R1A\u0005\n\u0005u\u0003BCA@\u0001!\u0015\r\u0011\"\u0003\u0002\u0002\"Q\u0011\u0011\u0013\u0001\t\u0006\u0004%I!a%\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u001e\"I\u0011q\u0016\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0017\u0005\u000b\u0003\u000f\u0004\u0001R1A\u0005\n\u0005%WABAj\u0001\u0011\t)\u000e\u0003\u0006\u0002\\\u0002A)\u0019!C\u0005\u0003;D!\"a:\u0001\u0011\u000b\u0007I\u0011BAu\u0011\u001d\t\u0019\u0010\u0001C!\u0003kDqA!\u0001\u0001\t\u0003\u0012\u0019\u0001C\u0004\u0003\u0006\u0001!\tEa\u0002\t\u000f\t5\u0001\u0001\"\u0011\u0003\u0010\u001dQ!\u0011C\u0012\u0002\u0002#\u0005qEa\u0005\u0007\u0013\t\u001a\u0013\u0011!E\u0001O\tU\u0001bBA\u001d=\u0011\u0005!1\u0005\u0005\n\u0005Kq\u0012\u0013!C\u0001\u0005OA\u0011B!\u000f\u001f\u0003\u0003%IAa\u000f\u0003)\r\u000b7o]1oIJ\f\u0007+\u0019:uSRLwN\\3s\u0015\t!S%A\u0006qCJ$\u0018\u000e^5p]\u0016\u0014(B\u0001\u0014(\u0003\r\u0011H\r\u001a\u0006\u0003Q%\n\u0011bY8o]\u0016\u001cGo\u001c:\u000b\u0005)Z\u0013!B:qCJ\\'B\u0001\u0017.\u0003!!\u0017\r^1ti\u0006D(\"\u0001\u0018\u0002\u0007\r|W.F\u00031\u0003')\u0007oE\u0002\u0001ci\u0002\"A\r\u001d\u000e\u0003MR!A\u000b\u001b\u000b\u0005U2\u0014AB1qC\u000eDWMC\u00018\u0003\ry'oZ\u0005\u0003sM\u00121\u0002U1si&$\u0018n\u001c8feB\u00111HP\u0007\u0002y)\u0011QhJ\u0001\u0005kRLG.\u0003\u0002@y\t9Aj\\4hS:<7\u0001A\u000b\u0002\u0005B\u00111IR\u0007\u0002\t*\u0011QiJ\u0001\u0004GFd\u0017BA$E\u0005I\u0019\u0015m]:b]\u0012\u0014\u0018mQ8o]\u0016\u001cGo\u001c:\u0002\u0015\r|gN\\3di>\u0014\b%\u0001\u0005uC\ndW\rR3g+\u0005Y\u0005CA\"M\u0013\tiEI\u0001\u0005UC\ndW\rR3g\u0003%!\u0018M\u00197f\t\u00164\u0007%\u0001\u0006qCJ$\u0018\u000e^5p]N,\u0012!\u0015\t\u0004%r{fBA*Z\u001d\t!v+D\u0001V\u0015\t1\u0006)\u0001\u0004=e>|GOP\u0005\u00021\u0006)1oY1mC&\u0011!lW\u0001\ba\u0006\u001c7.Y4f\u0015\u0005A\u0016BA/_\u0005\r\u0019V-\u001d\u0006\u00035n\u0003B\u0001Y1d_6\t1%\u0003\u0002cG\t\u00112)Y:tC:$'/\u0019)beRLG/[8o!\t!W\r\u0004\u0001\u0005\u000b\u0019\u0004!\u0019A4\u0003\u0003Y\u000b\"\u0001\u001b7\u0011\u0005%TW\"A.\n\u0005-\\&a\u0002(pi\"Lgn\u001a\t\u0003S6L!A\\.\u0003\u0007\u0005s\u0017\u0010\u0005\u0002ea\u0012)\u0011\u000f\u0001b\u0001e\n\tA+\u0005\u0002igB\u0019Ao^2\u000e\u0003UT!A^\u0012\u0002\u0007\u0011DG/\u0003\u0002yk\n)Ak\\6f]\u0006Y\u0001/\u0019:uSRLwN\\:!\u0003)YW-_'baBLgnZ\u000b\u0002yB\u0011QP`\u0007\u0002O%\u0011qp\n\u0002\u000f\u0007>dW/\u001c8TK2,7\r^8s\u0003-YW-_'baBLgn\u001a\u0011\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007\u0005\u0004\u0002\b\u00055\u0011\u0011C\u0007\u0003\u0003\u0013Q1!a\u0003\\\u0003\u001d\u0011XM\u001a7fGRLA!a\u0004\u0002\n\tA1\t\\1tgR\u000bw\rE\u0002e\u0003'!a!!\u0006\u0001\u0005\u00049'aA&fs\u0006\u0019!o\u001e4\u0016\u0005\u0005m\u0001CBA\u000f\u0003G\t\t\"\u0004\u0002\u0002 )\u0019\u0011\u0011E\u0014\u0002\r]\u0014\u0018\u000e^3s\u0013\u0011\t)#a\b\u0003!I{wo\u0016:ji\u0016\u0014h)Y2u_JL\u0018\u0001\u0002:xM\u0002B3aCA\u0016!\rI\u0017QF\u0005\u0004\u0003_Y&!\u0003;sC:\u001c\u0018.\u001a8u\u00031!xn[3o\r\u0006\u001cGo\u001c:z!\u0015!\u0018QG2p\u0013\r\t9$\u001e\u0002\r)>\\WM\u001c$bGR|'/_\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015\u0005u\u0012qIA%\u0003\u0017\ni\u0005\u0006\u0005\u0002@\u0005\u0005\u00131IA#!\u0019\u0001\u0007!!\u0005d_\"9\u00111A\u0007A\u0004\u0005\u0015\u0001bBA\f\u001b\u0001\u000f\u00111\u0004\u0005\b\u0003ci\u00019AA\u001a\u0011\u0015AS\u00021\u0001C\u0011\u0015IU\u00021\u0001L\u0011\u0015yU\u00021\u0001R\u0011\u001dQX\u0002%AA\u0002q\fAb^5uQR\u000b'\r\\3EK\u001a$B!a\u0010\u0002T!)\u0011J\u0004a\u0001\u0017\u0006qq/\u001b;i\u0017\u0016LX*\u00199qS:<G\u0003BA \u00033BQA_\bA\u0002q\f\u0011\u0003]1si&$\u0018n\u001c8LKft\u0015-\\3t+\t\ty\u0006\u0005\u0004\u0002b\u0005-\u0014qN\u0007\u0003\u0003GRA!!\u001a\u0002h\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003SZ\u0016AC2pY2,7\r^5p]&!\u0011QNA2\u0005\r\u0019V\r\u001e\t\u0005\u0003c\nIH\u0004\u0003\u0002t\u0005U\u0004C\u0001+\\\u0013\r\t9hW\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0014Q\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005]4,A\nqCJ$\u0018\u000e^5p].+\u00170T1qa&tw-\u0006\u0002\u0002\u0004B1\u0011QQAD\u0003\u0017k!!a\u001a\n\t\u0005%\u0015q\r\u0002\u000b\u0013:$W\r_3e'\u0016\f\bcA?\u0002\u000e&\u0019\u0011qR\u0014\u0003\u0013\r{G.^7o%\u00164\u0017A\u00059beRLG/[8o\u0017\u0016LxK]5uKJ,\"!!&\u0011\r\u0005u\u0011qSA\t\u0013\u0011\tI*a\b\u0003\u0013I{wo\u0016:ji\u0016\u0014\u0018A\u0002<fe&4\u0017\u0010\u0006\u0003\u0002 \u0006\u0015\u0006cA5\u0002\"&\u0019\u00111U.\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003O\u001b\u0002\u0013!a\u0001\u0003S\u000b1\u0001\\8h!\rI\u00171V\u0005\u0004\u0003[[&a\u0002\"p_2,\u0017M\\\u0001\u0011m\u0016\u0014\u0018NZ=%I\u00164\u0017-\u001e7uIE*\"!a-+\t\u0005%\u0016QW\u0016\u0003\u0003o\u0003B!!/\u0002D6\u0011\u00111\u0018\u0006\u0005\u0003{\u000by,A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011Y.\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002F\u0006m&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006qAo\\6f]\u001e+g.\u001a:bi>\u0014XCAAf!\u0015\u0001\u0017QZA\t\u0013\r\tym\t\u0002\u000f)>\\WM\\$f]\u0016\u0014\u0018\r^8sQ\r)\u00121\u0006\u0002\u0004\u0013R\u0013\u0006#\u00021\u0002X\u000e|\u0017bAAmG\taBk\\6f]J\u000bgnZ3XSRD\u0007+\u0019:uSRLwN\\%oI\u0016D\u0018AE5oI\u0016DX\r\u001a+pW\u0016t'+\u00198hKN,\"!a8\u0011\tIc\u0016\u0011\u001d\t\u0004\u0003G4R\"\u0001\u0001)\u0007]\tY#A\u000bu_.,gNU1oO\u0016dun\\6vaR\u000b'\r\\3\u0016\u0005\u0005-\bC\u00021\u0002n\u0006\u0005x.C\u0002\u0002p\u000e\u00121CQ;dW\u0016$\u0018N\\4SC:<W-\u00138eKbD3\u0001GA\u0016\u000319W\r\u001e)beRLG/[8o)\u0011\t90!@\u0011\u0007%\fI0C\u0002\u0002|n\u00131!\u00138u\u0011\u0019\ty0\u0007a\u0001Y\u0006\u00191.Z=\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t+\t\t90\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003S\u0013I\u0001\u0003\u0004\u0003\fm\u0001\r\u0001\\\u0001\u0005i\"\fG/\u0001\u0005iCND7i\u001c3f)\t\t90\u0001\u000bDCN\u001c\u0018M\u001c3sCB\u000b'\u000f^5uS>tWM\u001d\t\u0003Az\u0019RA\bB\f\u0005;\u00012!\u001bB\r\u0013\r\u0011Yb\u0017\u0002\u0007\u0003:L(+\u001a4\u0011\u0007%\u0014y\"C\u0002\u0003\"m\u0013AbU3sS\u0006d\u0017N_1cY\u0016$\"Aa\u0005\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+!\u0011IC!\f\u00030\tERC\u0001B\u0016U\ra\u0018Q\u0017\u0003\u0007\u0003+\u0001#\u0019A4\u0005\u000b\u0019\u0004#\u0019A4\u0005\rE\u0004#\u0019\u0001B\u001a#\rA'Q\u0007\t\u0005i^\u00149\u0004E\u0002e\u0005_\t1B]3bIJ+7o\u001c7wKR\u0011!Q\b\t\u0005\u0005\u007f\u0011I%\u0004\u0002\u0003B)!!1\tB#\u0003\u0011a\u0017M\\4\u000b\u0005\t\u001d\u0013\u0001\u00026bm\u0006LAAa\u0013\u0003B\t1qJ\u00196fGR\u0004")
public class CassandraPartitioner<Key, V, T extends Token<V>>
extends Partitioner
implements Logging {
    private Set<String> partitionKeyNames;
    private IndexedSeq<ColumnRef> partitionKeyMapping;
    private RowWriter<Key> partitionKeyWriter;
    private transient TokenGenerator<Key> tokenGenerator;
    private transient Seq<TokenRangeWithPartitionIndex<V, T>> indexedTokenRanges;
    private transient BucketingRangeIndex<TokenRangeWithPartitionIndex<V, T>, T> tokenRangeLookupTable;
    private final CassandraConnector connector;
    private final TableDef tableDef;
    private final Seq<CassandraPartition<V, T>> partitions;
    private final ColumnSelector keyMapping;
    private final ClassTag<Key> evidence$1;
    private final transient RowWriterFactory<Key> rwf;
    private final TokenFactory<V, T> tokenFactory;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;
    private volatile transient byte bitmap$trans$0;
    private volatile byte bitmap$0;

    public static <Key, V, T extends Token<V>> ColumnSelector $lessinit$greater$default$4() {
        return CassandraPartitioner$.MODULE$.$lessinit$greater$default$4();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    private CassandraConnector connector() {
        return this.connector;
    }

    private TableDef tableDef() {
        return this.tableDef;
    }

    public Seq<CassandraPartition<V, T>> partitions() {
        return this.partitions;
    }

    public ColumnSelector keyMapping() {
        return this.keyMapping;
    }

    private RowWriterFactory<Key> rwf() {
        return this.rwf;
    }

    public CassandraPartitioner<Key, V, T> withTableDef(TableDef tableDef) {
        String string = tableDef.keyspaceName();
        String string2 = this.tableDef().keyspaceName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(121).append("Cannot apply partitioner from keyspace\n           |").append(this.tableDef().keyspaceName()).append(" to table\n           |").append(tableDef.keyspaceName()).append(".").append(tableDef.tableName()).append(" because the keyspaces do\n           |not match").toString())).stripMargin());
        }
        return new CassandraPartitioner<Key, V, T>(this.connector(), tableDef, this.partitions(), this.keyMapping(), this.evidence$1, this.rwf(), this.tokenFactory);
    }

    public CassandraPartitioner<Key, V, T> withKeyMapping(ColumnSelector keyMapping) {
        return new CassandraPartitioner<Key, V, T>(this.connector(), this.tableDef(), this.partitions(), keyMapping, this.evidence$1, this.rwf(), this.tokenFactory);
    }

    private Set<String> partitionKeyNames$lzycompute() {
        CassandraPartitioner cassandraPartitioner = this;
        synchronized (cassandraPartitioner) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.partitionKeyNames = ((TraversableOnce)PartitionKeyColumns$.MODULE$.selectFrom(this.tableDef()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.columnName(), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.partitionKeyNames;
    }

    private Set<String> partitionKeyNames() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.partitionKeyNames$lzycompute() : this.partitionKeyNames;
    }

    private IndexedSeq<ColumnRef> partitionKeyMapping$lzycompute() {
        CassandraPartitioner cassandraPartitioner = this;
        synchronized (cassandraPartitioner) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.partitionKeyMapping = (IndexedSeq)this.keyMapping().selectFrom(this.tableDef()).filter((Function1 & Serializable & scala.Serializable)colRef -> BoxesRunTime.boxToBoolean((boolean)CassandraPartitioner.$anonfun$partitionKeyMapping$1(this, colRef)));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.partitionKeyMapping;
    }

    private IndexedSeq<ColumnRef> partitionKeyMapping() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.partitionKeyMapping$lzycompute() : this.partitionKeyMapping;
    }

    private RowWriter<Key> partitionKeyWriter$lzycompute() {
        CassandraPartitioner cassandraPartitioner = this;
        synchronized (cassandraPartitioner) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(65).append("Building Partitioner with mapping\n         |").append(this.partitionKeyMapping().map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)x.columnName(), (Object)x.selectedAs()), scala.collection.IndexedSeq$.MODULE$.canBuildFrom())).append("\n         |for table ").append(this.tableDef()).toString())).stripMargin());
                this.partitionKeyWriter = ((RowWriterFactory)Predef$.MODULE$.implicitly(this.rwf())).rowWriter(this.tableDef(), this.partitionKeyMapping());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.partitionKeyWriter;
    }

    private RowWriter<Key> partitionKeyWriter() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.partitionKeyWriter$lzycompute() : this.partitionKeyWriter;
    }

    public void verify(boolean log) {
        Try attempt = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.partitionKeyWriter());
        if (attempt.isFailure()) {
            if (log) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unable to build partition key writer CassandraPartitioner.", (Throwable)attempt.failed().get());
            }
            throw (Throwable)attempt.failed().get();
        }
    }

    public boolean verify$default$1() {
        return true;
    }

    private TokenGenerator<Key> tokenGenerator$lzycompute() {
        CassandraPartitioner cassandraPartitioner = this;
        synchronized (cassandraPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.tokenGenerator = new TokenGenerator<Key>(this.connector(), this.tableDef(), this.partitionKeyWriter());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.tokenGenerator;
    }

    private TokenGenerator<Key> tokenGenerator() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.tokenGenerator$lzycompute() : this.tokenGenerator;
    }

    private Seq<TokenRangeWithPartitionIndex<V, T>> indexedTokenRanges$lzycompute() {
        CassandraPartitioner cassandraPartitioner = this;
        synchronized (cassandraPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.indexedTokenRanges = (Seq)this.partitions().flatMap((Function1 & Serializable & scala.Serializable)p -> (Iterable)p.tokenRanges().map((Function1 & Serializable & scala.Serializable)tr -> new TokenRangeWithPartitionIndex(tr.range(), p.index()), Iterable$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.indexedTokenRanges;
    }

    private Seq<TokenRangeWithPartitionIndex<V, T>> indexedTokenRanges() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.indexedTokenRanges$lzycompute() : this.indexedTokenRanges;
    }

    private BucketingRangeIndex<TokenRangeWithPartitionIndex<V, T>, T> tokenRangeLookupTable$lzycompute() {
        CassandraPartitioner cassandraPartitioner = this;
        synchronized (cassandraPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                Ordering<T> tokenOrdering = this.tokenFactory.tokenOrdering();
                MonotonicBucketing<T> tokenBucketing = this.tokenFactory.tokenBucketing();
                this.tokenRangeLookupTable = new BucketingRangeIndex<TokenRangeWithPartitionIndex<V, T>, T>(this.indexedTokenRanges(), TokenRangeWithPartitionIndex$.MODULE$.rangeBounds(this.tokenFactory), tokenOrdering, tokenBucketing);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.tokenRangeLookupTable;
    }

    private BucketingRangeIndex<TokenRangeWithPartitionIndex<V, T>, T> tokenRangeLookupTable() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.tokenRangeLookupTable$lzycompute() : this.tokenRangeLookupTable;
    }

    public int getPartition(Object key) {
        Object object = key;
        Option option = this.evidence$1.unapply(object);
        if (option.isEmpty() || !(option.get() instanceof Object)) {
            throw new IllegalArgumentException(new StringBuilder(39).append("Couldn't determine the key from object ").append(object).toString());
        }
        String driverToken = this.tokenGenerator().getStringTokenFor(object);
        T connectorToken = this.tokenFactory.tokenFromString(driverToken);
        int n = ((TokenRangeWithPartitionIndex)this.tokenRangeLookupTable().rangesContaining(connectorToken).head()).partitionIndex();
        return n;
    }

    public int numPartitions() {
        return this.partitions().length();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof CassandraPartitioner)) return false;
        CassandraPartitioner cassandraPartitioner = (CassandraPartitioner)((Object)object);
        Seq<TokenRangeWithPartitionIndex<V, T>> seq = this.indexedTokenRanges();
        Seq<TokenRangeWithPartitionIndex<V, T>> seq2 = cassandraPartitioner.indexedTokenRanges();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        String string = this.tableDef().keyspaceName();
        String string2 = cassandraPartitioner.tableDef().keyspaceName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        CassandraConnector cassandraConnector = this.connector();
        CassandraConnector cassandraConnector2 = cassandraPartitioner.connector();
        if (cassandraConnector == null) {
            if (cassandraConnector2 == null) return true;
            return false;
        } else {
            if (!cassandraConnector.equals(cassandraConnector2)) return false;
            return true;
        }
    }

    public int hashCode() {
        return this.indexedTokenRanges().hashCode() + this.tableDef().keyspaceName().hashCode() * 31;
    }

    public static final /* synthetic */ boolean $anonfun$partitionKeyMapping$1(CassandraPartitioner $this, ColumnRef colRef) {
        return $this.partitionKeyNames().contains((Object)colRef.columnName());
    }

    public CassandraPartitioner(CassandraConnector connector, TableDef tableDef, Seq<CassandraPartition<V, T>> partitions, ColumnSelector keyMapping, ClassTag<Key> evidence$1, RowWriterFactory<Key> rwf, TokenFactory<V, T> tokenFactory) {
        this.connector = connector;
        this.tableDef = tableDef;
        this.partitions = partitions;
        this.keyMapping = keyMapping;
        this.evidence$1 = evidence$1;
        this.rwf = rwf;
        this.tokenFactory = tokenFactory;
        Logging.$init$((Logging)this);
    }
}

