/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd.partitioner;

import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.SimpleStatementBuilder;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.servererrors.InvalidQueryException;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.rdd.partitioner.DataSizeEstimates$;
import com.datastax.spark.connector.rdd.partitioner.DataSizeEstimates$TokenRangeSizeEstimate$;
import com.datastax.spark.connector.rdd.partitioner.dht.Token;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenFactory;
import com.datastax.spark.connector.util.Logging;
import java.io.Serializable;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\t\u001db\u0001\u0002\u00180\u0001qB\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\t#\u0002\u0011\t\u0011)A\u0005%\"AQ\f\u0001B\u0001B\u0003%!\u000b\u0003\u0005_\u0001\t\u0005\t\u0015a\u0003`\u0011\u00159\b\u0001\"\u0001y\r\u0019\t\t\u0001\u0001#\u0002\u0004!Q\u0011\u0011\u0003\u0004\u0003\u0016\u0004%\t!a\u0005\t\u0013\u0005UaA!E!\u0002\u0013\u0001\bBCA\f\r\tU\r\u0011\"\u0001\u0002\u0014!I\u0011\u0011\u0004\u0004\u0003\u0012\u0003\u0006I\u0001\u001d\u0005\u000b\u000371!Q3A\u0005\u0002\u0005u\u0001BCA\u0013\r\tE\t\u0015!\u0003\u0002 !Q\u0011q\u0005\u0004\u0003\u0016\u0004%\t!!\b\t\u0015\u0005%bA!E!\u0002\u0013\ty\u0002\u0003\u0004x\r\u0011\u0005\u00111\u0006\u0005\b\u0003s1A\u0011AA\u001e\u0011\u001d\t\u0019E\u0002C\u0001\u0003;A\u0011\"!\u0012\u0007\u0003\u0003%\t!a\u0012\t\u0013\u0005Ec!%A\u0005\u0002\u0005M\u0003\"CA5\rE\u0005I\u0011AA*\u0011%\tYGBI\u0001\n\u0003\ti\u0007C\u0005\u0002r\u0019\t\n\u0011\"\u0001\u0002n!I\u00111\u000f\u0004\u0002\u0002\u0013\u0005\u0013Q\u000f\u0005\n\u0003\u000b3\u0011\u0011!C\u0001\u0003\u000fC\u0011\"a$\u0007\u0003\u0003%\t!!%\t\u0013\u0005]e!!A\u0005B\u0005e\u0005\"CAT\r\u0005\u0005I\u0011AAU\u0011%\t\u0019LBA\u0001\n\u0003\n)\fC\u0005\u00028\u001a\t\t\u0011\"\u0011\u0002:\"I\u00111\u0018\u0004\u0002\u0002\u0013\u0005\u0013QX\u0004\n\u0003\u0003\u0004\u0011\u0011!E\u0005\u0003\u00074\u0011\"!\u0001\u0001\u0003\u0003EI!!2\t\r]\u0004C\u0011AAj\u0011%\t9\fIA\u0001\n\u000b\nI\fC\u0005\u0002V\u0002\n\t\u0011\"!\u0002X\"I\u0011\u0011\u001d\u0011\u0002\u0002\u0013\u0005\u00151\u001d\u0005\u000b\u0003k\u0004\u0001R1A\u0005\n\u0005]\bBCA\u001d\u0001!\u0015\r\u0011\"\u0003\u0002<!Q!1\u0002\u0001\t\u0006\u0004%\t!!\b\t\u0015\t5\u0001\u0001#b\u0001\n\u0003\ti\u0002\u0003\u0006\u0003\u0010\u0001A)\u0019!C\u0001\u0003;9qA!\u00050\u0011\u0003\u0011\u0019B\u0002\u0004/_!\u0005!Q\u0003\u0005\u0007o.\"\tAa\u0006\t\u000f\te1\u0006\"\u0001\u0003\u001c\t\tB)\u0019;b'&TX-R:uS6\fG/Z:\u000b\u0005A\n\u0014a\u00039beRLG/[8oKJT!AM\u001a\u0002\u0007I$GM\u0003\u00025k\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u0003m]\nQa\u001d9be.T!\u0001O\u001d\u0002\u0011\u0011\fG/Y:uCbT\u0011AO\u0001\u0004G>l7\u0001A\u000b\u0004{\u001d\f8c\u0001\u0001?\tB\u0011qHQ\u0007\u0002\u0001*\t\u0011)A\u0003tG\u0006d\u0017-\u0003\u0002D\u0001\n1\u0011I\\=SK\u001a\u0004\"!\u0012%\u000e\u0003\u0019S!aR\u001a\u0002\tU$\u0018\u000e\\\u0005\u0003\u0013\u001a\u0013q\u0001T8hO&tw-\u0001\u0003d_:t\u0007C\u0001'P\u001b\u0005i%B\u0001(4\u0003\r\u0019\u0017\u000f\\\u0005\u0003!6\u0013!cQ1tg\u0006tGM]1D_:tWm\u0019;pe\u0006a1.Z=ta\u0006\u001cWMT1nKB\u00111K\u0017\b\u0003)b\u0003\"!\u0016!\u000e\u0003YS!aV\u001e\u0002\rq\u0012xn\u001c;?\u0013\tI\u0006)\u0001\u0004Qe\u0016$WMZ\u0005\u00037r\u0013aa\u0015;sS:<'BA-A\u0003%!\u0018M\u00197f\u001d\u0006lW-\u0001\u0007u_.,gNR1di>\u0014\u0018\u0010\u0005\u0003aG\u0016\u0004X\"A1\u000b\u0005\t|\u0013a\u00013ii&\u0011A-\u0019\u0002\r)>\\WM\u001c$bGR|'/\u001f\t\u0003M\u001ed\u0001\u0001B\u0003i\u0001\t\u0007\u0011NA\u0001W#\tQW\u000e\u0005\u0002@W&\u0011A\u000e\u0011\u0002\b\u001d>$\b.\u001b8h!\tyd.\u0003\u0002p\u0001\n\u0019\u0011I\\=\u0011\u0005\u0019\fH!\u0002:\u0001\u0005\u0004\u0019(!\u0001+\u0012\u0005)$\bc\u00011vK&\u0011a/\u0019\u0002\u0006)>\\WM\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\telhp \u000b\u0003ur\u0004Ba\u001f\u0001fa6\tq\u0006C\u0003_\u000b\u0001\u000fq\fC\u0003K\u000b\u0001\u00071\nC\u0003R\u000b\u0001\u0007!\u000bC\u0003^\u000b\u0001\u0007!K\u0001\fU_.,gNU1oO\u0016\u001c\u0016N_3FgRLW.\u0019;f'\u00191a(!\u0002\u0002\fA\u0019q(a\u0002\n\u0007\u0005%\u0001IA\u0004Qe>$Wo\u0019;\u0011\u0007}\ni!C\u0002\u0002\u0010\u0001\u0013AbU3sS\u0006d\u0017N_1cY\u0016\f!B]1oO\u0016\u001cF/\u0019:u+\u0005\u0001\u0018a\u0003:b]\u001e,7\u000b^1si\u0002\n\u0001B]1oO\u0016,e\u000eZ\u0001\ne\u0006tw-Z#oI\u0002\nq\u0002]1si&$\u0018n\u001c8t\u0007>,h\u000e^\u000b\u0003\u0003?\u00012aPA\u0011\u0013\r\t\u0019\u0003\u0011\u0002\u0005\u0019>tw-\u0001\tqCJ$\u0018\u000e^5p]N\u001cu.\u001e8uA\u0005\tR.Z1o!\u0006\u0014H/\u001b;j_:\u001c\u0016N_3\u0002%5,\u0017M\u001c)beRLG/[8o'&TX\r\t\u000b\u000b\u0003[\t\t$a\r\u00026\u0005]\u0002cAA\u0018\r5\t\u0001\u0001\u0003\u0004\u0002\u0012=\u0001\r\u0001\u001d\u0005\u0007\u0003/y\u0001\u0019\u00019\t\u000f\u0005mq\u00021\u0001\u0002 !9\u0011qE\bA\u0002\u0005}\u0011\u0001\u0004:j]\u001e4%/Y2uS>tWCAA\u001f!\ry\u0014qH\u0005\u0004\u0003\u0003\u0002%A\u0002#pk\ndW-\u0001\tu_R\fGnU5{K&s')\u001f;fg\u0006!1m\u001c9z))\ti#!\u0013\u0002L\u00055\u0013q\n\u0005\t\u0003#\u0011\u0002\u0013!a\u0001a\"A\u0011q\u0003\n\u0011\u0002\u0003\u0007\u0001\u000fC\u0005\u0002\u001cI\u0001\n\u00111\u0001\u0002 !I\u0011q\u0005\n\u0011\u0002\u0003\u0007\u0011qD\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)FK\u0002q\u0003/Z#!!\u0017\u0011\t\u0005m\u0013QM\u0007\u0003\u0003;RA!a\u0018\u0002b\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003G\u0002\u0015AC1o]>$\u0018\r^5p]&!\u0011qMA/\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!a\u001c+\t\u0005}\u0011qK\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u000f\t\u0005\u0003s\n\u0019)\u0004\u0002\u0002|)!\u0011QPA@\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0015\u0001\u00026bm\u0006L1aWA>\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tI\tE\u0002@\u0003\u0017K1!!$A\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\ri\u00171\u0013\u0005\n\u0003+K\u0012\u0011!a\u0001\u0003\u0013\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAN!\u0015\ti*a)n\u001b\t\tyJC\u0002\u0002\"\u0002\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)+a(\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003W\u000b\t\fE\u0002@\u0003[K1!a,A\u0005\u001d\u0011un\u001c7fC:D\u0001\"!&\u001c\u0003\u0003\u0005\r!\\\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011R\u0001\ti>\u001cFO]5oOR\u0011\u0011qO\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005-\u0016q\u0018\u0005\t\u0003+s\u0012\u0011!a\u0001[\u00061Bk\\6f]J\u000bgnZ3TSj,Wi\u001d;j[\u0006$X\rE\u0002\u00020\u0001\u001aR\u0001IAd\u0003\u0017\u0001B\"!3\u0002PB\u0004\u0018qDA\u0010\u0003[i!!a3\u000b\u0007\u00055\u0007)A\u0004sk:$\u0018.\\3\n\t\u0005E\u00171\u001a\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$DCAAb\u0003\u0015\t\u0007\u000f\u001d7z))\ti#!7\u0002\\\u0006u\u0017q\u001c\u0005\u0007\u0003#\u0019\u0003\u0019\u00019\t\r\u0005]1\u00051\u0001q\u0011\u001d\tYb\ta\u0001\u0003?Aq!a\n$\u0001\u0004\ty\"A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\u0015\u0018\u0011\u001f\t\u0006\u007f\u0005\u001d\u00181^\u0005\u0004\u0003S\u0004%AB(qi&|g\u000eE\u0005@\u0003[\u0004\b/a\b\u0002 %\u0019\u0011q\u001e!\u0003\rQ+\b\u000f\\35\u0011%\t\u0019\u0010JA\u0001\u0002\u0004\ti#A\u0002yIA\n1\u0002^8lK:\u0014\u0016M\\4fgV\u0011\u0011\u0011 \t\u0007\u0003w\u0014)!!\f\u000f\t\u0005u(\u0011\u0001\b\u0004+\u0006}\u0018\"A!\n\u0007\t\r\u0001)A\u0004qC\u000e\\\u0017mZ3\n\t\t\u001d!\u0011\u0002\u0002\u0004'\u0016\f(b\u0001B\u0002\u0001\u0006q\u0001/\u0019:uSRLwN\\\"pk:$\u0018a\u00043bi\u0006\u001c\u0016N_3J]\nKH/Z:\u0002)Q|G/\u00197ECR\f7+\u001b>f\u0013:\u0014\u0015\u0010^3t\u0003E!\u0015\r^1TSj,Wi\u001d;j[\u0006$Xm\u001d\t\u0003w.\u001a\"a\u000b \u0015\u0005\tM\u0011\u0001G<bSR4uN\u001d#bi\u0006\u001c\u0016N_3FgRLW.\u0019;fgRQ\u00111\u0016B\u000f\u0005?\u0011\tCa\t\t\u000b)k\u0003\u0019A&\t\u000bEk\u0003\u0019\u0001*\t\u000buk\u0003\u0019\u0001*\t\u000f\t\u0015R\u00061\u0001\u0002\n\u0006YA/[7f_V$\u0018J\\'t\u0001")
public class DataSizeEstimates<V, T extends Token<V>>
implements Logging {
    private volatile DataSizeEstimates$TokenRangeSizeEstimate$ TokenRangeSizeEstimate$module;
    private Seq<TokenRangeSizeEstimate> tokenRanges;
    private double ringFraction;
    private long partitionCount;
    private long dataSizeInBytes;
    private long totalDataSizeInBytes;
    private CassandraConnector conn;
    private final String keyspaceName;
    private final String tableName;
    public final TokenFactory<V, T> com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$tokenFactory;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;
    private volatile byte bitmap$0;

    public static boolean waitForDataSizeEstimates(CassandraConnector cassandraConnector, String string, String string2, int n) {
        return DataSizeEstimates$.MODULE$.waitForDataSizeEstimates(cassandraConnector, string, string2, n);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    private DataSizeEstimates$TokenRangeSizeEstimate$ TokenRangeSizeEstimate() {
        if (this.TokenRangeSizeEstimate$module == null) {
            this.TokenRangeSizeEstimate$lzycompute$1();
        }
        return this.TokenRangeSizeEstimate$module;
    }

    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    private Seq<TokenRangeSizeEstimate> tokenRanges$lzycompute() {
        DataSizeEstimates dataSizeEstimates = this;
        synchronized (dataSizeEstimates) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.tokenRanges = (Seq)this.conn.withSessionDo((Function1 & Serializable & scala.Serializable)session -> {
                    Seq seq;
                    try {
                        ResultSet rs = session.execute((Statement)new SimpleStatementBuilder("SELECT range_start, range_end, partitions_count, mean_partition_size FROM system.size_estimates WHERE keyspace_name = ? AND table_name = ?").addPositionalValues(new Object[]{$this.keyspaceName, $this.tableName}).build());
                        seq = ((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(rs.all()).asScala()).map((Function1 & Serializable & scala.Serializable)row -> new TokenRangeSizeEstimate(this, $this.com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$tokenFactory.tokenFromString(row.getString("range_start")), $this.com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$tokenFactory.tokenFromString(row.getString("range_end")), row.getLong("partitions_count"), row.getLong("mean_partition_size")), Buffer$.MODULE$.canBuildFrom())).toSeq();
                    }
                    catch (InvalidQueryException e) {
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(179).append("Failed to fetch size estimates for ").append($this.keyspaceName).append(".").append($this.tableName).append(" from system.size_estimates ").append("table. The number of created Spark partitions may be inaccurate. ").append("Please make sure you use Cassandra 2.1.5 or newer.").toString(), e);
                        seq = (Seq)Seq$.MODULE$.empty();
                    }
                    return seq;
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.conn = null;
        return this.tokenRanges;
    }

    private Seq<TokenRangeSizeEstimate> tokenRanges() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.tokenRanges$lzycompute() : this.tokenRanges;
    }

    private double ringFraction$lzycompute() {
        DataSizeEstimates dataSizeEstimates = this;
        synchronized (dataSizeEstimates) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.ringFraction = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)this.tokenRanges().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1.ringFraction()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.ringFraction;
    }

    private double ringFraction() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.ringFraction$lzycompute() : this.ringFraction;
    }

    private long partitionCount$lzycompute() {
        DataSizeEstimates dataSizeEstimates = this;
        synchronized (dataSizeEstimates) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                long partitionsCount = BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.tokenRanges().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.partitionsCount()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                long normalizedCount = (long)((double)partitionsCount / this.ringFraction());
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Estimated partition count of ").append($this.keyspaceName).append(".").append($this.tableName).append(" is ").append(normalizedCount).toString());
                this.partitionCount = normalizedCount;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.partitionCount;
    }

    public long partitionCount() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.partitionCount$lzycompute() : this.partitionCount;
    }

    /*
     * WARNING - void declaration
     */
    private long dataSizeInBytes$lzycompute() {
        DataSizeEstimates dataSizeEstimates = this;
        synchronized (dataSizeEstimates) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                void var2_2;
                long tokenRangeSizeInBytes = (long)((double)this.totalDataSizeInBytes() / this.ringFraction());
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Estimated size of ").append($this.keyspaceName).append(".").append($this.tableName).append(" is ").append(tokenRangeSizeInBytes).append(" bytes").toString());
                this.dataSizeInBytes = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.dataSizeInBytes;
    }

    public long dataSizeInBytes() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.dataSizeInBytes$lzycompute() : this.dataSizeInBytes;
    }

    private long totalDataSizeInBytes$lzycompute() {
        DataSizeEstimates dataSizeEstimates = this;
        synchronized (dataSizeEstimates) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.totalDataSizeInBytes = BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.tokenRanges().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.totalSizeInBytes()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.totalDataSizeInBytes;
    }

    public long totalDataSizeInBytes() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.totalDataSizeInBytes$lzycompute() : this.totalDataSizeInBytes;
    }

    private final void TokenRangeSizeEstimate$lzycompute$1() {
        DataSizeEstimates dataSizeEstimates = this;
        synchronized (dataSizeEstimates) {
            if (this.TokenRangeSizeEstimate$module == null) {
                this.TokenRangeSizeEstimate$module = new DataSizeEstimates$TokenRangeSizeEstimate$(this);
            }
        }
    }

    public DataSizeEstimates(CassandraConnector conn, String keyspaceName, String tableName, TokenFactory<V, T> tokenFactory) {
        this.conn = conn;
        this.keyspaceName = keyspaceName;
        this.tableName = tableName;
        this.com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$tokenFactory = tokenFactory;
        Logging.$init$((Logging)this);
    }

    public class TokenRangeSizeEstimate
    implements Product,
    scala.Serializable {
        private final T rangeStart;
        private final T rangeEnd;
        private final long partitionsCount;
        private final long meanPartitionSize;
        public final /* synthetic */ DataSizeEstimates $outer;

        public T rangeStart() {
            return this.rangeStart;
        }

        public T rangeEnd() {
            return this.rangeEnd;
        }

        public long partitionsCount() {
            return this.partitionsCount;
        }

        public long meanPartitionSize() {
            return this.meanPartitionSize;
        }

        public double ringFraction() {
            return this.com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$TokenRangeSizeEstimate$$$outer().com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$$tokenFactory.ringFraction(this.rangeStart(), this.rangeEnd());
        }

        public long totalSizeInBytes() {
            return this.partitionsCount() * this.meanPartitionSize();
        }

        public TokenRangeSizeEstimate copy(T rangeStart, T rangeEnd, long partitionsCount, long meanPartitionSize) {
            return new TokenRangeSizeEstimate(this.com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$TokenRangeSizeEstimate$$$outer(), rangeStart, rangeEnd, partitionsCount, meanPartitionSize);
        }

        public T copy$default$1() {
            return this.rangeStart();
        }

        public T copy$default$2() {
            return this.rangeEnd();
        }

        public long copy$default$3() {
            return this.partitionsCount();
        }

        public long copy$default$4() {
            return this.meanPartitionSize();
        }

        public String productPrefix() {
            return "TokenRangeSizeEstimate";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.rangeStart();
                    break;
                }
                case 1: {
                    object = this.rangeEnd();
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.partitionsCount());
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToLong((long)this.meanPartitionSize());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TokenRangeSizeEstimate;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.rangeStart()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.rangeEnd()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.partitionsCount()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.meanPartitionSize()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TokenRangeSizeEstimate)) return false;
            if (((TokenRangeSizeEstimate)object).com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$TokenRangeSizeEstimate$$$outer() != this.com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$TokenRangeSizeEstimate$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            TokenRangeSizeEstimate tokenRangeSizeEstimate = (TokenRangeSizeEstimate)x$1;
            Object t = this.rangeStart();
            Object t2 = tokenRangeSizeEstimate.rangeStart();
            if (t == null) {
                if (t2 != null) {
                    return false;
                }
            } else if (!t.equals(t2)) return false;
            Object t3 = this.rangeEnd();
            Object t4 = tokenRangeSizeEstimate.rangeEnd();
            if (t3 == null) {
                if (t4 != null) {
                    return false;
                }
            } else if (!t3.equals(t4)) return false;
            if (this.partitionsCount() != tokenRangeSizeEstimate.partitionsCount()) return false;
            if (this.meanPartitionSize() != tokenRangeSizeEstimate.meanPartitionSize()) return false;
            if (!tokenRangeSizeEstimate.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ DataSizeEstimates com$datastax$spark$connector$rdd$partitioner$DataSizeEstimates$TokenRangeSizeEstimate$$$outer() {
            return this.$outer;
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public TokenRangeSizeEstimate(T t, T meanPartitionSize, long l, long l2) {
            void partitionsCount;
            void rangeStart;
            this.rangeStart = rangeStart;
            this.rangeEnd = rangeEnd;
            this.partitionsCount = partitionsCount;
            this.meanPartitionSize = (long)meanPartitionSize;
            if ($outer == null) {
                throw null;
            }
            this.$outer = (DataSizeEstimates)$outer;
            Product.$init$((Product)this);
        }
    }
}

