/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd.partitioner;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.metadata.TokenMap;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.rdd.partitioner.NodeAddresses;
import com.datastax.spark.connector.rdd.partitioner.ReplicaPartition;
import com.datastax.spark.connector.rdd.partitioner.TokenGenerator;
import com.datastax.spark.connector.util.DriverUtil$;
import com.datastax.spark.connector.util.package$;
import com.datastax.spark.connector.writer.RowWriter;
import com.datastax.spark.connector.writer.RowWriterFactory;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.spark.Partition;
import org.apache.spark.Partitioner;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\teb\u0001\u0002\u0015*\u0001YB\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005\u0005\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003W\u0011!q\u0003A!b\u0001\n\u0003Q\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011B.\t\u0011\t\u0004!\u0011!Q\u0001\f\rD\u0001\u0002\u001e\u0001\u0003\u0006\u0004%Y!\u001e\u0005\ty\u0002\u0011\t\u0011)A\u0005m\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001\"CA\u000e\u0001\t\u0007I\u0011AA\u000f\u0011!\t9\u0004\u0001Q\u0001\n\u0005}\u0001\"CA\u001d\u0001\t\u0007I\u0011AA\u001e\u0011!\t\u0019\u0005\u0001Q\u0001\n\u0005u\u0002\"CA#\u0001\t\u0007I\u0011AA$\u0011!\ty\u0005\u0001Q\u0001\n\u0005%\u0003BCA)\u0001!\u0015\r\u0011\"\u0003\u0002T!Q\u0011Q\f\u0001\t\u0006\u0004%I!a\u0018\t\u0015\u0005=\u0004\u0001#b\u0001\n\u0013\t\t\b\u0003\u0006\u0002|\u0001A)\u0019!C\u0005\u0003{B\u0011\"!'\u0001\u0005\u0004%I!a'\t\u0011\u0005]\u0006\u0001)A\u0005\u0003;C\u0011\"!/\u0001\u0005\u0004%I!a/\t\u0011\u00055\u0007\u0001)A\u0005\u0003{C\u0011\"a4\u0001\u0005\u0004%I!!5\t\u000f\u0005M\u0007\u0001)A\u0005#\"I\u0011Q\u001b\u0001C\u0002\u0013%\u0011q\u001b\u0005\t\u0003K\u0004\u0001\u0015!\u0003\u0002Z\"I\u0011q\u001d\u0001C\u0002\u0013%\u0011\u0011\u001e\u0005\t\u0003c\u0004\u0001\u0015!\u0003\u0002l\"I\u00111\u001f\u0001C\u0002\u0013%\u0011Q\u001f\u0005\t\u0003s\u0004\u0001\u0015!\u0003\u0002x\"9\u00111 \u0001\u0005\n\u0005u\bb\u0002B\u0004\u0001\u0011%!\u0011\u0002\u0005\b\u0005\u001f\u0001A\u0011\tB\t\u0011\u001d\u00119\u0002\u0001C!\u0003#D\u0011B!\u0007\u0001\u0005\u0004%\tAa\u0007\t\u0011\t\r\u0002\u0001)A\u0005\u0005;AqA!\n\u0001\t\u0003\u00119C\u0001\nSKBd\u0017nY1QCJ$\u0018\u000e^5p]\u0016\u0014(B\u0001\u0016,\u0003-\u0001\u0018M\u001d;ji&|g.\u001a:\u000b\u00051j\u0013a\u0001:eI*\u0011afL\u0001\nG>tg.Z2u_JT!\u0001M\u0019\u0002\u000bM\u0004\u0018M]6\u000b\u0005I\u001a\u0014\u0001\u00033bi\u0006\u001cH/\u0019=\u000b\u0003Q\n1aY8n\u0007\u0001)\"aN6\u0014\u0005\u0001A\u0004CA\u001d@\u001b\u0005Q$B\u0001\u0019<\u0015\taT(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002}\u0005\u0019qN]4\n\u0005\u0001S$a\u0003)beRLG/[8oKJ\fQ\u0001^1cY\u0016\u0004\"a\u0011'\u000f\u0005\u0011S\u0005CA#I\u001b\u00051%BA$6\u0003\u0019a$o\\8u})\t\u0011*A\u0003tG\u0006d\u0017-\u0003\u0002L\u0011\u00061\u0001K]3eK\u001aL!!\u0014(\u0003\rM#(/\u001b8h\u0015\tY\u0005*\u0001\u0005lKf\u001c\b/Y2f\u0003]\u0001\u0018M\u001d;ji&|gn\u001d)feJ+\u0007\u000f\\5dCN+G\u000f\u0005\u0002S'6\t\u0001*\u0003\u0002U\u0011\n\u0019\u0011J\u001c;\u0002%A\f'\u000f^5uS>t7*Z=NCB\u0004XM\u001d\t\u0003/bk\u0011!L\u0005\u000336\u0012abQ8mk6t7+\u001a7fGR|'/F\u0001\\!\tav,D\u0001^\u0015\tqV&A\u0002dc2L!\u0001Y/\u0003%\r\u000b7o]1oIJ\f7i\u001c8oK\u000e$xN]\u0001\u000bG>tg.Z2u_J\u0004\u0013aC2veJ,g\u000e\u001e+za\u0016\u00042\u0001Z4j\u001b\u0005)'B\u00014I\u0003\u001d\u0011XM\u001a7fGRL!\u0001[3\u0003\u0011\rc\u0017m]:UC\u001e\u0004\"A[6\r\u0001\u0011)A\u000e\u0001b\u0001[\n\tA+\u0005\u0002ocB\u0011!k\\\u0005\u0003a\"\u0013qAT8uQ&tw\r\u0005\u0002Se&\u00111\u000f\u0013\u0002\u0004\u0003:L\u0018a\u0001:xMV\ta\u000fE\u0002xu&l\u0011\u0001\u001f\u0006\u0003s6\naa\u001e:ji\u0016\u0014\u0018BA>y\u0005A\u0011vn^,sSR,'OR1di>\u0014\u00180\u0001\u0003so\u001a\u0004\u0003FA\u0005\u007f!\t\u0011v0C\u0002\u0002\u0002!\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002\rqJg.\u001b;?)1\t9!!\u0005\u0002\u0014\u0005U\u0011qCA\r)\u0019\tI!!\u0004\u0002\u0010A!\u00111\u0002\u0001j\u001b\u0005I\u0003\"\u00022\u000b\u0001\b\u0019\u0007\"\u0002;\u000b\u0001\b1\b\"B!\u000b\u0001\u0004\u0011\u0005\"B(\u000b\u0001\u0004\u0011\u0005\"\u0002)\u000b\u0001\u0004\t\u0006\"B+\u000b\u0001\u00041\u0006\"\u0002\u0018\u000b\u0001\u0004Y\u0016!C0lKf\u001c\b/Y2f+\t\ty\u0002\u0005\u0003\u0002\"\u0005MRBAA\u0012\u0015\u0011\t)#a\n\u0002\t\r|'/\u001a\u0006\u0005\u0003S\tY#A\u0002ba&TA!!\f\u00020\u00051AM]5wKJT1!!\r2\u0003\ry7o]\u0005\u0005\u0003k\t\u0019CA\u0007Dc2LE-\u001a8uS\u001aLWM]\u0001\u000b?.,\u0017p\u001d9bG\u0016\u0004\u0013\u0001\u0003;bE2,G)\u001a4\u0016\u0005\u0005u\u0002c\u0001/\u0002@%\u0019\u0011\u0011I/\u0003\u0011Q\u000b'\r\\3EK\u001a\f\u0011\u0002^1cY\u0016$UM\u001a\u0011\u0002\u0013I|wo\u0016:ji\u0016\u0014XCAA%!\u00119\u00181J5\n\u0007\u00055\u0003PA\u0005S_^<&/\u001b;fe\u0006Q!o\\<Xe&$XM\u001d\u0011\u0002\u001dQ|7.\u001a8HK:,'/\u0019;peV\u0011\u0011Q\u000b\t\u0006\u0003\u0017\t9&[\u0005\u0004\u00033J#A\u0004+pW\u0016tw)\u001a8fe\u0006$xN\u001d\u0015\u0003#y\f\u0001\u0002^8lK:l\u0015\r]\u000b\u0003\u0003C\u0002B!a\u0019\u0002j5\u0011\u0011Q\r\u0006\u0005\u0003O\n\u0019#\u0001\u0005nKR\fG-\u0019;b\u0013\u0011\tY'!\u001a\u0003\u0011Q{7.\u001a8NCBD#A\u0005@\u0002\u001fA\u0014x\u000e^8d_24VM]:j_:,\"!a\u001d\u0011\t\u0005\u0005\u0012QO\u0005\u0005\u0003o\n\u0019CA\bQe>$xnY8m-\u0016\u00148/[8oQ\t\u0019b0A\u0003dY\u0006T(0\u0006\u0002\u0002\u0000A\"\u0011\u0011QAJ!\u0019\t\u0019)!$\u0002\u00126\u0011\u0011Q\u0011\u0006\u0005\u0003\u000f\u000bI)\u0001\u0003mC:<'BAAF\u0003\u0011Q\u0017M^1\n\t\u0005=\u0015Q\u0011\u0002\u0006\u00072\f7o\u001d\t\u0004U\u0006MEACAK)\u0005\u0005\t\u0011!B\u0001[\n\u0019q\fJ\u0019)\u0005Qq\u0018!\u00025pgR\u001cXCAAO!\u0019\ty*!*\u0002,:\u0019!+!)\n\u0007\u0005\r\u0006*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0016\u0011\u0016\u0002\u0007-\u0016\u001cGo\u001c:\u000b\u0007\u0005\r\u0006\n\u0005\u0003\u0002.\u0006MVBAAX\u0015\u0011\t\t,!#\u0002\u00079,G/\u0003\u0003\u00026\u0006=&aC%oKR\fE\r\u001a:fgN\fa\u0001[8tiN\u0004\u0013a\u00025pgR\u001cV\r^\u000b\u0003\u0003{\u0003b!a0\u0002J\u0006-VBAAa\u0015\u0011\t\u0019-!2\u0002\u0013%lW.\u001e;bE2,'bAAd\u0011\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005-\u0017\u0011\u0019\u0002\u0004'\u0016$\u0018\u0001\u00035pgR\u001cV\r\u001e\u0011\u0002\u00119,X\u000eS8tiN,\u0012!U\u0001\n]Vl\u0007j\\:ug\u0002\n\u0001\u0003]1si&$\u0018n\u001c8J]\u0012,\u00070Z:\u0016\u0005\u0005e\u0007CBAP\u00037\fy.\u0003\u0003\u0002^\u0006%&\u0001\u0002'jgR\u0004R!a0\u0002bFKA!a9\u0002B\nQ\u0011J\u001c3fq\u0016$7+Z9\u0002#A\f'\u000f^5uS>t\u0017J\u001c3fq\u0016\u001c\b%A\u0004i_N$X*\u00199\u0016\u0005\u0005-\b\u0003CA`\u0003[\fY+a8\n\t\u0005=\u0018\u0011\u0019\u0002\u0004\u001b\u0006\u0004\u0018\u0001\u00035pgRl\u0015\r\u001d\u0011\u0002\u0011%tG-\u001a=NCB,\"!a>\u0011\u000f\u0005}\u0016Q^)\u0002,\u0006I\u0011N\u001c3fq6\u000b\u0007\u000fI\u0001\nC\n\u001cXj\u001c3vY>$R!UA\u0000\u0005\u0007AaA!\u0001\"\u0001\u0004\t\u0016\u0001\u00033jm&$WM\u001c3\t\r\t\u0015\u0011\u00051\u0001R\u0003\u001d!\u0017N^5t_J\f!B]1oI>l\u0007j\\:u)\u0011\tYKa\u0003\t\r\t5!\u00051\u0001R\u0003\u0015Ig\u000eZ3y\u000319W\r\u001e)beRLG/[8o)\r\t&1\u0003\u0005\u0007\u0005+\u0019\u0003\u0019A9\u0002\u0007-,\u00170A\u0007ok6\u0004\u0016M\u001d;ji&|gn]\u0001\u000e]>$W-\u00113ee\u0016\u001c8/Z:\u0016\u0005\tu\u0001\u0003BA\u0006\u0005?I1A!\t*\u00055qu\u000eZ3BI\u0012\u0014Xm]:fg\u0006qan\u001c3f\u0003\u0012$'/Z:tKN\u0004\u0013\u0001F4fi\u0016sG\r]8j]R\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0003\u0003*\t=\u0002\u0003BA\u0006\u0005WI1A!\f*\u0005A\u0011V\r\u001d7jG\u0006\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u00032\u001d\u0002\rAa\r\u0002\u0013A\f'\u000f^5uS>t\u0007cA\u001d\u00036%\u0019!q\u0007\u001e\u0003\u0013A\u000b'\u000f^5uS>t\u0007")
public class ReplicaPartitioner<T>
extends Partitioner {
    private transient TokenGenerator<T> tokenGenerator;
    private transient TokenMap tokenMap;
    private transient ProtocolVersion protocolVersion;
    private transient Class<?> clazz;
    private final int partitionsPerReplicaSet;
    private final CassandraConnector connector;
    private final ClassTag<T> currentType;
    private final transient RowWriterFactory<T> rwf;
    private final CqlIdentifier _keyspace;
    private final TableDef tableDef;
    private final RowWriter<T> rowWriter;
    private final Vector<InetAddress> hosts;
    private final scala.collection.immutable.Set<InetAddress> hostSet;
    private final int numHosts;
    private final List<IndexedSeq<Object>> partitionIndexes;
    private final Map<InetAddress, IndexedSeq<Object>> hostMap;
    private final Map<Object, InetAddress> indexMap;
    private final NodeAddresses nodeAddresses;
    private volatile transient byte bitmap$trans$0;

    public CassandraConnector connector() {
        return this.connector;
    }

    private RowWriterFactory<T> rwf() {
        return this.rwf;
    }

    public CqlIdentifier _keyspace() {
        return this._keyspace;
    }

    public TableDef tableDef() {
        return this.tableDef;
    }

    public RowWriter<T> rowWriter() {
        return this.rowWriter;
    }

    private TokenGenerator<T> tokenGenerator$lzycompute() {
        ReplicaPartitioner replicaPartitioner = this;
        synchronized (replicaPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.tokenGenerator = new TokenGenerator<T>(this.connector(), this.tableDef(), this.rowWriter());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.tokenGenerator;
    }

    private TokenGenerator<T> tokenGenerator() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.tokenGenerator$lzycompute() : this.tokenGenerator;
    }

    private TokenMap tokenMap$lzycompute() {
        ReplicaPartitioner replicaPartitioner = this;
        synchronized (replicaPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.tokenMap = (TokenMap)this.connector().withSessionDo((Function1 & Serializable & scala.Serializable)x$1 -> (TokenMap)x$1.getMetadata().getTokenMap().get());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.tokenMap;
    }

    private TokenMap tokenMap() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.tokenMap$lzycompute() : this.tokenMap;
    }

    private ProtocolVersion protocolVersion$lzycompute() {
        ReplicaPartitioner replicaPartitioner = this;
        synchronized (replicaPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.protocolVersion = (ProtocolVersion)this.connector().withSessionDo((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getContext().getProtocolVersion());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.protocolVersion;
    }

    private ProtocolVersion protocolVersion() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.protocolVersion$lzycompute() : this.protocolVersion;
    }

    private Class<?> clazz$lzycompute() {
        ReplicaPartitioner replicaPartitioner = this;
        synchronized (replicaPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.clazz = ((ClassTag)Predef$.MODULE$.implicitly(this.currentType)).runtimeClass();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.clazz;
    }

    private Class<?> clazz() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.clazz$lzycompute() : this.clazz;
    }

    private Vector<InetAddress> hosts() {
        return this.hosts;
    }

    private scala.collection.immutable.Set<InetAddress> hostSet() {
        return this.hostSet;
    }

    private int numHosts() {
        return this.numHosts;
    }

    private List<IndexedSeq<Object>> partitionIndexes() {
        return this.partitionIndexes;
    }

    private Map<InetAddress, IndexedSeq<Object>> hostMap() {
        return this.hostMap;
    }

    private Map<Object, InetAddress> indexMap() {
        return this.indexMap;
    }

    private int absModulo(int dividend, int divisor) {
        return Math.abs(dividend % divisor);
    }

    private InetAddress randomHost(int index) {
        return (InetAddress)this.hosts().apply(this.absModulo(index, this.hosts().length()));
    }

    public int getPartition(Object key) {
        int n2;
        Object object = key;
        Option option = this.currentType.unapply(object);
        if (!option.isEmpty() && option.get() instanceof Object && this.clazz().isInstance(object)) {
            Token token = this.tokenGenerator().getTokenFor(object);
            int tokenHash = Math.abs(token.hashCode());
            Set replicas = (Set)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(this.tokenMap().getReplicas(this._keyspace(), token)).asScala()).map((Function1 & Serializable & scala.Serializable)n -> ((InetSocketAddress)DriverUtil$.MODULE$.toAddress(n).get()).getAddress(), scala.collection.mutable.Set$.MODULE$.canBuildFrom());
            Vector replicaSetInDC = ((TraversableOnce)this.hostSet().$amp((GenSet)replicas)).toVector();
            if (replicaSetInDC.nonEmpty()) {
                InetAddress endpoint = (InetAddress)replicaSetInDC.apply(this.absModulo(tokenHash, replicaSetInDC.size()));
                n2 = BoxesRunTime.unboxToInt((Object)((SeqLike)this.hostMap().apply((Object)endpoint)).apply(this.absModulo(tokenHash, this.partitionsPerReplicaSet)));
            } else {
                n2 = BoxesRunTime.unboxToInt((Object)((SeqLike)this.hostMap().apply((Object)this.randomHost(tokenHash))).apply(this.absModulo(tokenHash, this.partitionsPerReplicaSet)));
            }
        } else {
            throw new IllegalArgumentException(new StringBuilder(119).append("ReplicaPartitioner can only determine the partition of a tuple whose key is a non-empty Set[InetAddress]. ").append("Invalid key: ").append(key).toString());
        }
        int n3 = n2;
        return n3;
    }

    public int numPartitions() {
        return this.partitionsPerReplicaSet * this.numHosts();
    }

    public NodeAddresses nodeAddresses() {
        return this.nodeAddresses;
    }

    public ReplicaPartition getEndpointPartition(Partition partition) {
        InetAddress endpoints = (InetAddress)this.indexMap().getOrElse((Object)BoxesRunTime.boxToInteger((int)partition.index()), (Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException(new StringBuilder(45).append(this.indexMap()).append(" : Can't get an endpoint for Partition ").append(partition).append(".index").toString());
        });
        return new ReplicaPartition(partition.index(), (String[])this.nodeAddresses().hostNames(endpoints).toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    public static final /* synthetic */ boolean $anonfun$indexMap$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ Tuple2 $anonfun$indexMap$3(InetAddress ip$1, int partition) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)partition), (Object)ip$1);
    }

    public ReplicaPartitioner(String table, String keyspace, int partitionsPerReplicaSet, ColumnSelector partitionKeyMapper, CassandraConnector connector, ClassTag<T> currentType, RowWriterFactory<T> rwf) {
        this.partitionsPerReplicaSet = partitionsPerReplicaSet;
        this.connector = connector;
        this.currentType = currentType;
        this.rwf = rwf;
        this._keyspace = CqlIdentifier.fromInternal((String)keyspace);
        this.tableDef = package$.MODULE$.tableFromCassandra(connector, keyspace, table);
        this.rowWriter = ((RowWriterFactory)Predef$.MODULE$.implicitly(rwf)).rowWriter(this.tableDef(), partitionKeyMapper.selectFrom(this.tableDef()));
        this.hosts = ((TraversableOnce)connector.hosts().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getAddress(), Set$.MODULE$.canBuildFrom())).toVector();
        this.hostSet = this.hosts().toSet();
        this.numHosts = this.hosts().size();
        this.partitionIndexes = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionsPerReplicaSet * this.numHosts()).grouped(partitionsPerReplicaSet).toList();
        this.hostMap = ((TraversableOnce)this.hosts().zip(this.partitionIndexes(), Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.indexMap = (Map)this.hostMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaPartitioner.$anonfun$indexMap$1(check$ifrefutable$1))).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            InetAddress ip = (InetAddress)tuple2._1();
            IndexedSeq partitions = (IndexedSeq)tuple2._2();
            IndexedSeq indexedSeq = (IndexedSeq)partitions.map((Function1 & Serializable & scala.Serializable)partition -> ReplicaPartitioner.$anonfun$indexMap$3(ip, BoxesRunTime.unboxToInt((Object)partition)), IndexedSeq$.MODULE$.canBuildFrom());
            return indexedSeq;
        }, Map$.MODULE$.canBuildFrom());
        this.nodeAddresses = new NodeAddresses(connector);
    }
}

