/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.writer;

import com.datastax.spark.connector.writer.RateLimiter$;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y4Aa\u0005\u000b\u0001?!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003+\u0011!q\u0003A!A!\u0002\u0013y\u0003\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\t\u000be\u0002A\u0011\u0001\u001e\t\u0011\u0005\u0003!\u0019!C\u0001)\tCaa\u0014\u0001!\u0002\u0013\u0019\u0005\u0002\u0003)\u0001\u0005\u0004%\t\u0001\u0006\"\t\rE\u0003\u0001\u0015!\u0003D\u0011\u0015\u0011\u0006\u0001\"\u0003T\u0011\u0019\u0011\u0006\u0001\"\u0001\u0015A\")\u0011\r\u0001C\u0001E\u001e9Q\rFA\u0001\u0012\u00031gaB\n\u0015\u0003\u0003E\ta\u001a\u0005\u0006s9!\t\u0001\u001b\u0005\bS:\t\n\u0011\"\u0001k\u0011\u001d\u0019h\"%A\u0005\u0002QDqA\u001e\b\u0002\u0002\u0013%qOA\u0006SCR,G*[7ji\u0016\u0014(BA\u000b\u0017\u0003\u00199(/\u001b;fe*\u0011q\u0003G\u0001\nG>tg.Z2u_JT!!\u0007\u000e\u0002\u000bM\u0004\u0018M]6\u000b\u0005ma\u0012\u0001\u00033bi\u0006\u001cH/\u0019=\u000b\u0003u\t1aY8n\u0007\u0001\u00192\u0001\u0001\u0011'!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u0019\te.\u001f*fMB\u0011\u0011eJ\u0005\u0003Q\t\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fAA]1uKB\u0011\u0011eK\u0005\u0003Y\t\u0012A\u0001T8oO\u0006Q!-^2lKR\u001c\u0016N_3\u0002\tQLW.\u001a\t\u0004CAR\u0013BA\u0019#\u0005%1UO\\2uS>t\u0007'A\u0003tY\u0016,\u0007\u000f\u0005\u0003\"i)2\u0014BA\u001b#\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002\"o%\u0011\u0001H\t\u0002\u0004\u0003:L\u0018A\u0002\u001fj]&$h\bF\u0003<{yz\u0004\t\u0005\u0002=\u00015\tA\u0003C\u0003*\u000b\u0001\u0007!\u0006C\u0003.\u000b\u0001\u0007!\u0006C\u0004/\u000bA\u0005\t\u0019A\u0018\t\u000fI*\u0001\u0013!a\u0001g\u0005Q!-^2lKR4\u0015\u000e\u001c7\u0016\u0003\r\u0003\"\u0001R'\u000e\u0003\u0015S!AR$\u0002\r\u0005$x.\\5d\u0015\tA\u0015*\u0001\u0006d_:\u001cWO\u001d:f]RT!AS&\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0019\u0006!!.\u0019<b\u0013\tqUI\u0001\u0006Bi>l\u0017n\u0019'p]\u001e\f1BY;dW\u0016$h)\u001b7mA\u0005AA.Y:u)&lW-A\u0005mCN$H+[7fA\u0005!A.Z1l)\t!v\u000b\u0005\u0002\"+&\u0011aK\t\u0002\u0005+:LG\u000fC\u0003Y\u0015\u0001\u0007!&\u0001\u0004u_2+\u0017m\u001b\u0015\u0003\u0015i\u0003\"a\u00170\u000e\u0003qS!!\u0018\u0012\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002`9\n9A/Y5me\u0016\u001cG#\u0001+\u0002\u00155\f\u0017PY3TY\u0016,\u0007\u000f\u0006\u0002UG\")A\r\u0004a\u0001U\u0005Q\u0001/Y2lKR\u001c\u0016N_3\u0002\u0017I\u000bG/\u001a'j[&$XM\u001d\t\u0003y9\u00192A\u0004\u0011')\u00051\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'F\u0001lU\tyCnK\u0001n!\tq\u0017/D\u0001p\u0015\t\u0001H,A\u0005v]\u000eDWmY6fI&\u0011!o\u001c\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'F\u0001vU\t\u0019D.A\u0006sK\u0006$'+Z:pYZ,G#\u0001=\u0011\u0005edX\"\u0001>\u000b\u0005m\\\u0015\u0001\u00027b]\u001eL!! >\u0003\r=\u0013'.Z2u\u0001")
public class RateLimiter
implements Serializable {
    private final long rate;
    private final long bucketSize;
    private final Function0<Object> time;
    private final Function1<Object, Object> sleep;
    private final AtomicLong bucketFill;
    private final AtomicLong lastTime;

    public static Function1<Object, Object> $lessinit$greater$default$4() {
        return RateLimiter$.MODULE$.$lessinit$greater$default$4();
    }

    public static Function0<Object> $lessinit$greater$default$3() {
        return RateLimiter$.MODULE$.$lessinit$greater$default$3();
    }

    public AtomicLong bucketFill() {
        return this.bucketFill;
    }

    public AtomicLong lastTime() {
        return this.lastTime;
    }

    private void leak(long toLeak) {
        long reallyToLeak;
        long fill;
        do {
            fill = this.bucketFill().get();
            reallyToLeak = package$.MODULE$.min(fill, toLeak);
        } while (!this.bucketFill().compareAndSet(fill, fill - reallyToLeak));
    }

    public void leak() {
        long currentTime = this.time.apply$mcJ$sp();
        long prevTime = this.lastTime().getAndSet(currentTime);
        long elapsedTime = package$.MODULE$.max(currentTime - prevTime, 0L);
        this.leak(elapsedTime * this.rate / 1000L);
    }

    public void maybeSleep(long packetSize) {
        block0: {
            this.leak();
            long currentFill = this.bucketFill().addAndGet(packetSize);
            long overflow = currentFill - this.bucketSize;
            long delay = 1000L * overflow / this.rate;
            if (delay <= 0L) break block0;
            this.sleep.apply((Object)BoxesRunTime.boxToLong((long)delay));
        }
    }

    public RateLimiter(long rate, long bucketSize, Function0<Object> time, Function1<Object, Object> sleep) {
        this.rate = rate;
        this.bucketSize = bucketSize;
        this.time = time;
        this.sleep = sleep;
        Predef$.MODULE$.require(rate > 0L, (Function0 & java.io.Serializable & Serializable)() -> "A positive rate is required");
        Predef$.MODULE$.require(bucketSize > 0L, (Function0 & java.io.Serializable & Serializable)() -> "A positive bucket size is required");
        this.bucketFill = new AtomicLong(0L);
        this.lastTime = new AtomicLong(time.apply$mcJ$sp());
    }
}

