/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.writer;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.datastax.spark.connector.BatchSize;
import com.datastax.spark.connector.BatchSize$;
import com.datastax.spark.connector.BytesInBatch;
import com.datastax.spark.connector.RowsInBatch;
import com.datastax.spark.connector.util.ConfigCheck;
import com.datastax.spark.connector.util.ConfigCheck$;
import com.datastax.spark.connector.util.ConfigParameter;
import com.datastax.spark.connector.util.ConfigParameter$;
import com.datastax.spark.connector.util.DeprecatedConfigParameter;
import com.datastax.spark.connector.util.DeprecatedConfigParameter$;
import com.datastax.spark.connector.writer.BatchGroupingKey;
import com.datastax.spark.connector.writer.BatchGroupingKey$;
import com.datastax.spark.connector.writer.BatchGroupingKey$Partition$;
import com.datastax.spark.connector.writer.TTLOption;
import com.datastax.spark.connector.writer.TTLOption$;
import com.datastax.spark.connector.writer.TimestampOption;
import com.datastax.spark.connector.writer.TimestampOption$;
import com.datastax.spark.connector.writer.WriteConf;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple12;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class WriteConf$
implements scala.Serializable {
    public static WriteConf$ MODULE$;
    private final String ReferenceSection;
    private final ConfigParameter<ConsistencyLevel> ConsistencyLevelParam;
    private final ConfigParameter<Option<Object>> BatchSizeRowsParam;
    private final ConfigParameter<Object> BatchSizeBytesParam;
    private final ConfigParameter<Object> BatchBufferSizeParam;
    private final ConfigParameter<BatchGroupingKey> BatchLevelParam;
    private final ConfigParameter<Object> IfNotExistsParam;
    private final ConfigParameter<Object> IgnoreNullsParam;
    private final ConfigParameter<Object> ParallelismLevelParam;
    private final ConfigParameter<Option<Object>> ThroughputMiBPSParam;
    private final DeprecatedConfigParameter<Option<Object>> DeprecatedThroughputMiBPSParam;
    private final ConfigParameter<Object> TTLParam;
    private final ConfigParameter<Object> TimestampParam;
    private final ConfigParameter<Object> TaskMetricsParam;

    static {
        new WriteConf$();
    }

    public BatchSize $lessinit$greater$default$1() {
        return BatchSize$.MODULE$.Automatic();
    }

    public int $lessinit$greater$default$2() {
        return BoxesRunTime.unboxToInt((Object)this.BatchBufferSizeParam().default());
    }

    public BatchGroupingKey $lessinit$greater$default$3() {
        return this.BatchLevelParam().default();
    }

    public ConsistencyLevel $lessinit$greater$default$4() {
        return this.ConsistencyLevelParam().default();
    }

    public boolean $lessinit$greater$default$5() {
        return BoxesRunTime.unboxToBoolean((Object)this.IfNotExistsParam().default());
    }

    public boolean $lessinit$greater$default$6() {
        return BoxesRunTime.unboxToBoolean((Object)this.IgnoreNullsParam().default());
    }

    public int $lessinit$greater$default$7() {
        return BoxesRunTime.unboxToInt((Object)this.ParallelismLevelParam().default());
    }

    public Option<Object> $lessinit$greater$default$8() {
        return this.ThroughputMiBPSParam().default();
    }

    public TTLOption $lessinit$greater$default$9() {
        return TTLOption$.MODULE$.defaultValue();
    }

    public TimestampOption $lessinit$greater$default$10() {
        return TimestampOption$.MODULE$.defaultValue();
    }

    public boolean $lessinit$greater$default$11() {
        return BoxesRunTime.unboxToBoolean((Object)this.TaskMetricsParam().default());
    }

    public Option<String> $lessinit$greater$default$12() {
        return None$.MODULE$;
    }

    public String ReferenceSection() {
        return this.ReferenceSection;
    }

    public ConfigParameter<ConsistencyLevel> ConsistencyLevelParam() {
        return this.ConsistencyLevelParam;
    }

    public ConfigParameter<Option<Object>> BatchSizeRowsParam() {
        return this.BatchSizeRowsParam;
    }

    public ConfigParameter<Object> BatchSizeBytesParam() {
        return this.BatchSizeBytesParam;
    }

    public ConfigParameter<Object> BatchBufferSizeParam() {
        return this.BatchBufferSizeParam;
    }

    public ConfigParameter<BatchGroupingKey> BatchLevelParam() {
        return this.BatchLevelParam;
    }

    public ConfigParameter<Object> IfNotExistsParam() {
        return this.IfNotExistsParam;
    }

    public ConfigParameter<Object> IgnoreNullsParam() {
        return this.IgnoreNullsParam;
    }

    public ConfigParameter<Object> ParallelismLevelParam() {
        return this.ParallelismLevelParam;
    }

    public ConfigParameter<Option<Object>> ThroughputMiBPSParam() {
        return this.ThroughputMiBPSParam;
    }

    public DeprecatedConfigParameter<Option<Object>> DeprecatedThroughputMiBPSParam() {
        return this.DeprecatedThroughputMiBPSParam;
    }

    public ConfigParameter<Object> TTLParam() {
        return this.TTLParam;
    }

    public ConfigParameter<Object> TimestampParam() {
        return this.TimestampParam;
    }

    public ConfigParameter<Object> TaskMetricsParam() {
        return this.TaskMetricsParam;
    }

    public WriteConf fromSparkConf(SparkConf conf) {
        Product product;
        ConfigCheck$.MODULE$.checkConfig(conf);
        int batchSizeInBytes = conf.getInt(this.BatchSizeBytesParam().name(), BoxesRunTime.unboxToInt((Object)this.BatchSizeBytesParam().default()));
        DefaultConsistencyLevel consistencyLevel = DefaultConsistencyLevel.valueOf((String)conf.get(this.ConsistencyLevelParam().name(), this.ConsistencyLevelParam().default().name()));
        String batchSizeInRowsStr = conf.get(this.BatchSizeRowsParam().name(), "auto");
        boolean ifNotExists = conf.getBoolean(this.IfNotExistsParam().name(), BoxesRunTime.unboxToBoolean((Object)this.IfNotExistsParam().default()));
        boolean ignoreNulls = conf.getBoolean(this.IgnoreNullsParam().name(), BoxesRunTime.unboxToBoolean((Object)this.IgnoreNullsParam().default()));
        Regex Number2 = new StringOps(Predef$.MODULE$.augmentString("([0-9]+)")).r();
        String string = batchSizeInRowsStr;
        if ("auto".equals(string)) {
            product = new BytesInBatch(batchSizeInBytes);
        } else {
            Option option = Number2.unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                String x = (String)((LinearSeqOptimized)option.get()).apply(0);
                product = new RowsInBatch(new StringOps(Predef$.MODULE$.augmentString(x)).toInt());
            } else {
                throw new ConfigCheck.ConnectorConfigurationException(new StringBuilder(84).append("Invalid value of spark.cassandra.output.batch.size.rows: ").append(string).append(". Number or 'auto' expected").toString());
            }
        }
        BytesInBatch batchSize = product;
        int batchBufferSize = conf.getInt(this.BatchBufferSizeParam().name(), BoxesRunTime.unboxToInt((Object)this.BatchBufferSizeParam().default()));
        BatchGroupingKey batchGroupingKey = (BatchGroupingKey)conf.getOption(this.BatchLevelParam().name()).map((Function1 & Serializable & scala.Serializable)name -> BatchGroupingKey$.MODULE$.apply((String)name)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.BatchLevelParam().default());
        int parallelismLevel = conf.getInt(this.ParallelismLevelParam().name(), BoxesRunTime.unboxToInt((Object)this.ParallelismLevelParam().default()));
        Option throughputMiBPS = conf.getOption(this.ThroughputMiBPSParam().name()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)WriteConf$.$anonfun$fromSparkConf$3(x$1)));
        boolean metricsEnabled = conf.getBoolean(this.TaskMetricsParam().name(), BoxesRunTime.unboxToBoolean((Object)this.TaskMetricsParam().default()));
        int ttlSeconds = conf.getInt(this.TTLParam().name(), BoxesRunTime.unboxToInt((Object)this.TTLParam().default()));
        TTLOption ttlOption = ttlSeconds == BoxesRunTime.unboxToInt((Object)this.TTLParam().default()) ? TTLOption$.MODULE$.defaultValue() : TTLOption$.MODULE$.constant(ttlSeconds);
        long timestampMicros = conf.getLong(this.TimestampParam().name(), BoxesRunTime.unboxToLong((Object)this.TimestampParam().default()));
        TimestampOption timestampOption = timestampMicros == BoxesRunTime.unboxToLong((Object)this.TimestampParam().default()) ? TimestampOption$.MODULE$.defaultValue() : TimestampOption$.MODULE$.constant(timestampMicros);
        BytesInBatch x$12 = batchSize;
        int x$2 = batchBufferSize;
        BatchGroupingKey x$3 = batchGroupingKey;
        DefaultConsistencyLevel x$4 = consistencyLevel;
        int x$5 = parallelismLevel;
        Option x$6 = throughputMiBPS;
        boolean x$7 = metricsEnabled;
        TTLOption x$8 = ttlOption;
        TimestampOption x$9 = timestampOption;
        boolean x$10 = ignoreNulls;
        boolean x$11 = ifNotExists;
        Option<String> x$122 = this.apply$default$12();
        return new WriteConf(x$12, x$2, x$3, (ConsistencyLevel)x$4, x$11, x$10, x$5, (Option<Object>)x$6, x$8, x$9, x$7, x$122);
    }

    public WriteConf apply(BatchSize batchSize, int batchGroupingBufferSize, BatchGroupingKey batchGroupingKey, ConsistencyLevel consistencyLevel, boolean ifNotExists, boolean ignoreNulls, int parallelismLevel, Option<Object> throughputMiBPS, TTLOption ttl, TimestampOption timestamp, boolean taskMetricsEnabled, Option<String> executeAs) {
        return new WriteConf(batchSize, batchGroupingBufferSize, batchGroupingKey, consistencyLevel, ifNotExists, ignoreNulls, parallelismLevel, throughputMiBPS, ttl, timestamp, taskMetricsEnabled, executeAs);
    }

    public BatchSize apply$default$1() {
        return BatchSize$.MODULE$.Automatic();
    }

    public TimestampOption apply$default$10() {
        return TimestampOption$.MODULE$.defaultValue();
    }

    public boolean apply$default$11() {
        return BoxesRunTime.unboxToBoolean((Object)this.TaskMetricsParam().default());
    }

    public Option<String> apply$default$12() {
        return None$.MODULE$;
    }

    public int apply$default$2() {
        return BoxesRunTime.unboxToInt((Object)this.BatchBufferSizeParam().default());
    }

    public BatchGroupingKey apply$default$3() {
        return this.BatchLevelParam().default();
    }

    public ConsistencyLevel apply$default$4() {
        return this.ConsistencyLevelParam().default();
    }

    public boolean apply$default$5() {
        return BoxesRunTime.unboxToBoolean((Object)this.IfNotExistsParam().default());
    }

    public boolean apply$default$6() {
        return BoxesRunTime.unboxToBoolean((Object)this.IgnoreNullsParam().default());
    }

    public int apply$default$7() {
        return BoxesRunTime.unboxToInt((Object)this.ParallelismLevelParam().default());
    }

    public Option<Object> apply$default$8() {
        return this.ThroughputMiBPSParam().default();
    }

    public TTLOption apply$default$9() {
        return TTLOption$.MODULE$.defaultValue();
    }

    public Option<Tuple12<BatchSize, Object, BatchGroupingKey, ConsistencyLevel, Object, Object, Object, Option<Object>, TTLOption, TimestampOption, Object, Option<String>>> unapply(WriteConf x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple12((Object)x$0.batchSize(), (Object)BoxesRunTime.boxToInteger((int)x$0.batchGroupingBufferSize()), (Object)x$0.batchGroupingKey(), (Object)x$0.consistencyLevel(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.ifNotExists()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.ignoreNulls()), (Object)BoxesRunTime.boxToInteger((int)x$0.parallelismLevel()), x$0.throughputMiBPS(), (Object)x$0.ttl(), (Object)x$0.timestamp(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.taskMetricsEnabled()), x$0.executeAs()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ double $anonfun$fromSparkConf$3(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toDouble();
    }

    private WriteConf$() {
        MODULE$ = this;
        this.ReferenceSection = "Write Tuning Parameters";
        this.ConsistencyLevelParam = ConfigParameter$.MODULE$.apply("spark.cassandra.output.consistency.level", this.ReferenceSection(), DefaultConsistencyLevel.LOCAL_QUORUM, "Consistency level for writing");
        this.BatchSizeRowsParam = ConfigParameter$.MODULE$.apply("spark.cassandra.output.batch.size.rows", this.ReferenceSection(), None$.MODULE$, new StringOps(Predef$.MODULE$.augmentString("Number of rows per single batch. The default is 'auto'\n      |which means the connector will adjust the number\n      |of rows based on the amount of data\n      |in each row")).stripMargin());
        this.BatchSizeBytesParam = ConfigParameter$.MODULE$.apply("spark.cassandra.output.batch.size.bytes", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)1024), new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(68).append("Maximum total size of the batch in bytes. Overridden by\n      |").append(this.BatchSizeRowsParam().name()).append("\n    ").toString())).stripMargin());
        this.BatchBufferSizeParam = ConfigParameter$.MODULE$.apply("spark.cassandra.output.batch.grouping.buffer.size", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)1000), new StringOps(Predef$.MODULE$.augmentString(" How many batches per single Spark task can be stored in\n      |memory before sending to Cassandra")).stripMargin());
        this.BatchLevelParam = ConfigParameter$.MODULE$.apply("spark.cassandra.output.batch.grouping.key", this.ReferenceSection(), BatchGroupingKey$Partition$.MODULE$, new StringOps(Predef$.MODULE$.augmentString("Determines how insert statements are grouped into batches. Available values are\n    |<ul>\n    |  <li> <code> none </code> : a batch may contain any statements </li>\n    |  <li> <code> replica_set </code> : a batch may contain only statements to be written to the same replica set </li>\n    |  <li> <code> partition </code> : a batch may contain only statements for rows sharing the same partition key value </li>\n    |</ul>\n    |")).stripMargin());
        this.IfNotExistsParam = ConfigParameter$.MODULE$.apply("spark.cassandra.output.ifNotExists", this.ReferenceSection(), BoxesRunTime.boxToBoolean((boolean)false), new StringOps(Predef$.MODULE$.augmentString("Determines that the INSERT operation is not performed if a row with the same primary\n        \t\t\t\t|key already exists. Using the feature incurs a performance hit.")).stripMargin());
        this.IgnoreNullsParam = ConfigParameter$.MODULE$.apply("spark.cassandra.output.ignoreNulls", this.ReferenceSection(), BoxesRunTime.boxToBoolean((boolean)false), new StringOps(Predef$.MODULE$.augmentString(" In Cassandra >= 2.2 null values can be left as unset in bound statements. Setting\n        |this to true will cause all null values to be left as unset rather than bound. For\n        |finer control see the CassandraOption class")).stripMargin());
        this.ParallelismLevelParam = ConfigParameter$.MODULE$.apply("spark.cassandra.output.concurrent.writes", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)5), new StringOps(Predef$.MODULE$.augmentString("Maximum number of batches executed in parallel by a\n      | single Spark task")).stripMargin());
        this.ThroughputMiBPSParam = ConfigParameter$.MODULE$.apply("spark.cassandra.output.throughputMBPerSec", this.ReferenceSection(), None$.MODULE$, new StringOps(Predef$.MODULE$.augmentString("*(Floating points allowed)* <br> Maximum write throughput allowed\n      | per single core in MB/s. <br> Limit this on long (+8 hour) runs to 70% of your max throughput\n      | as seen on a smaller job for stability")).stripMargin());
        String x$1 = "spark.cassandra.output.throughput_mb_per_sec";
        Some x$2 = new Some(this.ThroughputMiBPSParam());
        String x$3 = "DSE 6.0.0";
        Function1<String, String> x$4 = DeprecatedConfigParameter$.MODULE$.apply$default$3();
        String x$5 = DeprecatedConfigParameter$.MODULE$.apply$default$5();
        this.DeprecatedThroughputMiBPSParam = DeprecatedConfigParameter$.MODULE$.apply(x$1, x$2, x$4, x$3, x$5);
        this.TTLParam = ConfigParameter$.MODULE$.apply("spark.cassandra.output.ttl", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)0), new StringOps(Predef$.MODULE$.augmentString("Time To Live(TTL) assigned to writes to Cassandra. A value of 0 means no TTL")).stripMargin());
        this.TimestampParam = ConfigParameter$.MODULE$.apply("spark.cassandra.output.timestamp", this.ReferenceSection(), BoxesRunTime.boxToLong((long)0L), new StringOps(Predef$.MODULE$.augmentString("Timestamp (microseconds since epoch) of the write. If not specified, the time that the\n        | write occurred is used. A value of 0 means time of write.")).stripMargin());
        this.TaskMetricsParam = ConfigParameter$.MODULE$.apply("spark.cassandra.output.metrics", this.ReferenceSection(), BoxesRunTime.boxToBoolean((boolean)true), "Sets whether to record connector specific metrics on write");
    }
}

