/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.cassandra;

import com.datastax.oss.driver.api.core.metadata.schema.RelationMetadata;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.datasource.CassandraTable;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.cassandra.CassandraMetaDataRule$;
import org.apache.spark.sql.cassandra.CassandraMetadataFunction;
import org.apache.spark.sql.cassandra.NullableUnresolvedAttribute;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class CassandraMetaDataRule$
extends Rule<LogicalPlan> {
    public static CassandraMetaDataRule$ MODULE$;

    static {
        new CassandraMetaDataRule$();
    }

    public LogicalPlan replaceMetadata(CassandraMetadataFunction metaDataExpression, LogicalPlan plan) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        Predef$.MODULE$.assert(((UnaryLike)metaDataExpression).child() instanceof AttributeReference, (Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(85).append("Can only use Cassandra Metadata Functions on Attribute References,\n         |found a ").append(((UnaryLike)metaDataExpression).child().getClass()).toString())).stripMargin());
        String cassandraColumnName = ((AttributeReference)((UnaryLike)metaDataExpression).child()).name();
        String cassandraCql = new StringBuilder(2).append(metaDataExpression.cql()).append("(").append(cassandraColumnName).append(")").toString();
        CassandraTable cassandraTable = (CassandraTable)plan.collectFirst((PartialFunction)new scala.Serializable(cassandraColumnName){
            public static final long serialVersionUID = 0L;
            private final String cassandraColumnName$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                CassandraTable cassandraTable;
                DataSourceV2Relation dataSourceV2Relation;
                Table table;
                A1 A1 = x1;
                Object object = A1 instanceof DataSourceV2Relation && (table = (dataSourceV2Relation = (DataSourceV2Relation)A1).table()) instanceof CassandraTable && (cassandraTable = (CassandraTable)table).tableDef().columnByName().contains((Object)this.cassandraColumnName$1) ? cassandraTable : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                CassandraTable cassandraTable;
                DataSourceV2Relation dataSourceV2Relation;
                Table table;
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof DataSourceV2Relation && (table = (dataSourceV2Relation = (DataSourceV2Relation)logicalPlan).table()) instanceof CassandraTable && (cassandraTable = (CassandraTable)table).tableDef().columnByName().contains((Object)this.cassandraColumnName$1);
                return bl;
            }
            {
                this.cassandraColumnName$1 = cassandraColumnName$1;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(70).append("Unable to find Cassandra Source Relation for TTL/Writetime for column ").append(cassandraColumnName).toString());
        });
        ColumnDef columnDef = (ColumnDef)cassandraTable.tableDef().columnByName().apply((Object)cassandraColumnName);
        if (columnDef.isPrimaryKeyColumn()) {
            throw new AnalysisException(new StringBuilder(45).append("Unable to use ").append(metaDataExpression.cql()).append(" function on non-normal column ").append(columnDef.columnName()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        }
        if (columnDef.isMultiCell()) {
            String x$1 = cassandraCql;
            ArrayType x$2 = ArrayType$.MODULE$.apply(((Expression)metaDataExpression).dataType());
            boolean x$3 = true;
            Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, (DataType)x$2, x$3, x$4);
            Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, (DataType)x$2, x$3, x$4);
            Tuple2 tuple23 = new Tuple2((Object)new AttributeReference(x$1, (DataType)x$2, x$3, x$4, x$5, x$6), (Object)new StructField(cassandraCql, (DataType)ArrayType$.MODULE$.apply(((Expression)metaDataExpression).dataType()), true, StructField$.MODULE$.apply$default$4()));
            tuple22 = tuple23;
        } else {
            String x$7 = cassandraCql;
            DataType x$8 = ((Expression)metaDataExpression).dataType();
            boolean x$9 = true;
            Metadata x$10 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$11 = AttributeReference$.MODULE$.apply$default$5(x$7, x$8, x$9, x$10);
            Seq x$12 = AttributeReference$.MODULE$.apply$default$6(x$7, x$8, x$9, x$10);
            tuple22 = tuple2 = new Tuple2((Object)new AttributeReference(x$7, x$8, x$9, x$10, x$11, x$12), (Object)new StructField(cassandraCql, ((Expression)metaDataExpression).dataType(), true, StructField$.MODULE$.apply$default$4()));
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AttributeReference cassandraAttributeReference = (AttributeReference)tuple2._1();
        StructField cassandraField = (StructField)tuple2._2();
        Tuple2 tuple24 = new Tuple2((Object)cassandraAttributeReference, (Object)cassandraField);
        Tuple2 tuple25 = tuple24;
        AttributeReference cassandraAttributeReference2 = (AttributeReference)tuple25._1();
        StructField cassandraField2 = (StructField)tuple25._2();
        NullableUnresolvedAttribute unResolvedAttributeReference = new NullableUnresolvedAttribute(cassandraCql);
        Expression x$13 = functions$.MODULE$.lit(null).cast(((Expression)metaDataExpression).dataType()).expr();
        String x$14 = cassandraCql;
        ExprId x$15 = Alias$.MODULE$.apply$default$3(x$13, x$14);
        Seq x$16 = Alias$.MODULE$.apply$default$4(x$13, x$14);
        Option x$17 = Alias$.MODULE$.apply$default$5(x$13, x$14);
        Seq x$18 = Alias$.MODULE$.apply$default$6(x$13, x$14);
        Alias nullAttributeReference = new Alias(x$13, x$14, x$15, x$16, x$17, x$18);
        LogicalPlan metadataFunctionRemovedPlan = (LogicalPlan)plan.transformAllExpressions((PartialFunction)new scala.Serializable(metaDataExpression, unResolvedAttributeReference){
            public static final long serialVersionUID = 0L;
            private final CassandraMetadataFunction metaDataExpression$1;
            private final NullableUnresolvedAttribute unResolvedAttributeReference$1;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                void var3_8;
                A1 A1 = x2;
                if (A1 != null) {
                    A1 A12;
                    A1 A13 = A12 = A1;
                    CassandraMetadataFunction cassandraMetadataFunction = this.metaDataExpression$1;
                    if (!(A13 != null ? !A13.equals(cassandraMetadataFunction) : cassandraMetadataFunction != null)) {
                        NullableUnresolvedAttribute nullableUnresolvedAttribute = this.unResolvedAttributeReference$1;
                        return var3_8;
                    }
                }
                Object object = function1.apply(x2);
                return var3_8;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Expression x2) {
                Expression expression;
                Expression expression2 = x2;
                if (expression2 == null) return false;
                Expression expression3 = expression = expression2;
                CassandraMetadataFunction cassandraMetadataFunction = this.metaDataExpression$1;
                if (expression3 != null) {
                    if (!expression3.equals(cassandraMetadataFunction)) return false;
                    return true;
                }
                if (cassandraMetadataFunction == null) return true;
                return false;
            }
            {
                this.metaDataExpression$1 = metaDataExpression$1;
                this.unResolvedAttributeReference$1 = unResolvedAttributeReference$1;
            }
        });
        LogicalPlan cassandraSourceModifiedPlan = (LogicalPlan)metadataFunctionRemovedPlan.transform((PartialFunction)new scala.Serializable(cassandraColumnName, cassandraField2, cassandraAttributeReference2){
            public static final long serialVersionUID = 0L;
            private final String cassandraColumnName$1;
            private final StructField cassandraField$1;
            private final AttributeReference cassandraAttributeReference$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                CassandraTable cassandraTable;
                DataSourceV2Relation dataSourceV2Relation;
                Table table;
                A1 A1 = x3;
                if (A1 instanceof DataSourceV2Relation && (table = (dataSourceV2Relation = (DataSourceV2Relation)A1).table()) instanceof CassandraTable && (cassandraTable = (CassandraTable)table).tableDef().columnByName().contains((Object)this.cassandraColumnName$1)) {
                    Some x$1 = new Some((Object)cassandraTable.schema().add(this.cassandraField$1));
                    SparkSession x$2 = cassandraTable.copy$default$1();
                    CaseInsensitiveStringMap x$3 = cassandraTable.copy$default$2();
                    CassandraConnector x$4 = cassandraTable.copy$default$3();
                    String x$5 = cassandraTable.copy$default$4();
                    RelationMetadata x$6 = cassandraTable.copy$default$5();
                    CassandraTable modifiedCassandraTable = cassandraTable.copy(x$2, x$3, x$4, x$5, x$6, (Option<StructType>)x$1);
                    object = dataSourceV2Relation.copy((Table)modifiedCassandraTable, (Seq)dataSourceV2Relation.output().$colon$plus((Object)this.cassandraAttributeReference$1, Seq$.MODULE$.canBuildFrom()), dataSourceV2Relation.copy$default$3(), dataSourceV2Relation.copy$default$4(), dataSourceV2Relation.copy$default$5());
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x3) {
                CassandraTable cassandraTable;
                DataSourceV2Relation dataSourceV2Relation;
                Table table;
                LogicalPlan logicalPlan = x3;
                boolean bl = logicalPlan instanceof DataSourceV2Relation && (table = (dataSourceV2Relation = (DataSourceV2Relation)logicalPlan).table()) instanceof CassandraTable && (cassandraTable = (CassandraTable)table).tableDef().columnByName().contains((Object)this.cassandraColumnName$1);
                return bl;
            }
            {
                this.cassandraColumnName$1 = cassandraColumnName$1;
                this.cassandraField$1 = cassandraField$1;
                this.cassandraAttributeReference$1 = cassandraAttributeReference$1;
            }
        });
        LogicalPlan fixedPlan = (LogicalPlan)cassandraSourceModifiedPlan.transformDown((PartialFunction)new scala.Serializable(unResolvedAttributeReference, nullAttributeReference, cassandraAttributeReference2){
            public static final long serialVersionUID = 0L;
            public final NullableUnresolvedAttribute unResolvedAttributeReference$1;
            public final Alias nullAttributeReference$1;
            public final AttributeReference cassandraAttributeReference$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                A1 A1 = x4;
                Object object = A1.missingInput().contains((NamedExpression)this.unResolvedAttributeReference$1) ? A1.mapChildren((Function1 & Serializable & scala.Serializable)x$2 -> (LogicalPlan)x$2.transformUp((PartialFunction)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.4 $outer;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Project project;
                        A1 A1 = x1;
                        Object object = A1 instanceof Project ? (CassandraMetaDataRule$.org$apache$spark$sql$cassandra$CassandraMetaDataRule$$containsAnyReferenceToTTL$1((LogicalPlan)(project = (Project)A1), this.$outer.cassandraAttributeReference$1, this.$outer.nullAttributeReference$1, this.$outer.unResolvedAttributeReference$1) ? project.copy((Seq)project.projectList().$colon$plus((Object)((Object)this.$outer.unResolvedAttributeReference$1), Seq$.MODULE$.canBuildFrom()), project.child()) : project.copy((Seq)project.projectList().$colon$plus((Object)this.$outer.nullAttributeReference$1, Seq$.MODULE$.canBuildFrom()), project.child())) : function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x1) {
                        LogicalPlan logicalPlan = x1;
                        boolean bl = logicalPlan instanceof Project;
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })) : function1.apply(x4);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x4) {
                LogicalPlan logicalPlan = x4;
                boolean bl = logicalPlan.missingInput().contains((NamedExpression)this.unResolvedAttributeReference$1);
                return bl;
            }
            {
                this.unResolvedAttributeReference$1 = unResolvedAttributeReference$1;
                this.nullAttributeReference$1 = nullAttributeReference$1;
                this.cassandraAttributeReference$1 = cassandraAttributeReference$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.cassandra.CassandraMetaDataRule$$anonfun$4 org.apache.spark.sql.catalyst.plans.logical.LogicalPlan )}, serializedLambda);
            }
        });
        return fixedPlan;
    }

    public Seq<CassandraMetadataFunction> findMetadataExpressions(LogicalPlan logicalPlan) {
        return CassandraMetaDataRule$.org$apache$spark$sql$cassandra$CassandraMetaDataRule$$findMetadataExpressions$1(logicalPlan.expressions());
    }

    public LogicalPlan apply(LogicalPlan plan) {
        return (LogicalPlan)plan.transform((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1;
                A1 A12 = x1;
                if (A12 != null && CassandraMetaDataRule$.MODULE$.findMetadataExpressions(A1 = A12).nonEmpty()) {
                    Seq<CassandraMetadataFunction> metadataExpressions = CassandraMetaDataRule$.MODULE$.findMetadataExpressions(A1);
                    object = metadataExpressions.foldLeft(A1, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                        Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        LogicalPlan plan = (LogicalPlan)tuple2._1();
                        CassandraMetadataFunction expression = (CassandraMetadataFunction)tuple2._2();
                        LogicalPlan logicalPlan = CassandraMetaDataRule$.MODULE$.replaceMetadata(expression, plan);
                        return logicalPlan;
                    });
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan;
                LogicalPlan logicalPlan2 = x1;
                boolean bl = logicalPlan2 != null && CassandraMetaDataRule$.MODULE$.findMetadataExpressions(logicalPlan = logicalPlan2).nonEmpty();
                return bl;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan org.apache.spark.sql.cassandra.CassandraMetadataFunction )}, serializedLambda);
            }
        });
    }

    public static final boolean org$apache$spark$sql$cassandra$CassandraMetaDataRule$$containsAnyReferenceToTTL$1(LogicalPlan logicalPlan, AttributeReference cassandraAttributeReference$1, Alias nullAttributeReference$1, NullableUnresolvedAttribute unResolvedAttributeReference$1) {
        Seq references = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedExpression[]{cassandraAttributeReference$1, nullAttributeReference$1, unResolvedAttributeReference$1}));
        AttributeSet input = logicalPlan.inputSet();
        return references.exists((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)input.contains(elem)));
    }

    public static final Seq org$apache$spark$sql$cassandra$CassandraMetaDataRule$$findMetadataExpressions$1(Seq expressions) {
        return (Seq)((GenericTraversableTemplate)expressions.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof CassandraMetadataFunction) {
                    CassandraMetadataFunction cassandraMetadataFunction = (CassandraMetadataFunction)A1;
                    object = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CassandraMetadataFunction[]{cassandraMetadataFunction}));
                } else if (A1 != null) {
                    A1 A12 = A1;
                    object = CassandraMetaDataRule$.org$apache$spark$sql$cassandra$CassandraMetaDataRule$$findMetadataExpressions$1(A12.children());
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                boolean bl = expression instanceof CassandraMetadataFunction ? true : expression != null;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms());
    }

    private CassandraMetaDataRule$() {
        MODULE$ = this;
    }
}

