/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.cassandra;

import com.datastax.dse.driver.api.core.data.geometry.Geometry;
import com.datastax.dse.driver.api.core.data.time.DateRange;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.data.CqlDuration;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.spark.connector.CassandraRow$;
import com.datastax.spark.connector.CassandraRowMetadata;
import com.datastax.spark.connector.TupleValue;
import com.datastax.spark.connector.UDTValue;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.UUID;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.cassandra.CassandraSQLRow;
import org.apache.spark.sql.types.Decimal$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class CassandraSQLRow$
implements scala.Serializable {
    public static CassandraSQLRow$ MODULE$;
    private final CassandraSQLRow empty;

    static {
        new CassandraSQLRow$();
    }

    public CassandraSQLRow fromJavaDriverRow(Row row, CassandraRowMetadata metaData) {
        Object[] data = CassandraRow$.MODULE$.dataFromJavaDriverRow(row, metaData);
        return new CassandraSQLRow(metaData, (IndexedSeq<Object>)((IndexedSeq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(data)).map((Function1 & Serializable & scala.Serializable)value -> MODULE$.toSparkSqlType(value), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
    }

    public Object toSparkSqlType(Object value) {
        scala.Serializable sparkSqlType = new scala.Serializable(value){
            public static final long serialVersionUID = 0L;
            private final Object value$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Geometry) {
                    Geometry geometry = (Geometry)A1;
                    object = geometry.asWellKnownText();
                } else if (A1 instanceof java.util.Date) {
                    java.util.Date date = (java.util.Date)A1;
                    object = new Timestamp(date.getTime());
                } else if (A1 instanceof org.joda.time.LocalDate) {
                    org.joda.time.LocalDate localDate = (org.joda.time.LocalDate)A1;
                    object = new Date(localDate.toDateTimeAtStartOfDay().getMillis());
                } else if (A1 instanceof LocalDate) {
                    LocalDate localDate = (LocalDate)A1;
                    object = Date.valueOf(localDate);
                } else if (A1 instanceof LocalTime) {
                    LocalTime localTime = (LocalTime)A1;
                    object = BoxesRunTime.boxToLong((long)localTime.toNanoOfDay());
                } else if (A1 instanceof Duration) {
                    Duration duration = (Duration)A1;
                    object = BoxesRunTime.boxToLong((long)duration.toMillis());
                } else if (A1 instanceof CqlDuration) {
                    CqlDuration cqlDuration = (CqlDuration)A1;
                    object = TypeCodecs.DURATION.format((Object)cqlDuration);
                } else if (A1 instanceof Instant) {
                    Instant instant = (Instant)A1;
                    object = new Timestamp(instant.toEpochMilli());
                } else if (A1 instanceof BigInteger) {
                    BigInteger bigInteger = (BigInteger)A1;
                    object = Decimal$.MODULE$.apply(bigInteger.toString());
                } else if (A1 instanceof BigDecimal) {
                    BigDecimal bigDecimal = (BigDecimal)A1;
                    object = Decimal$.MODULE$.apply(bigDecimal);
                } else if (A1 instanceof InetAddress) {
                    InetAddress inetAddress = (InetAddress)A1;
                    object = inetAddress.getHostAddress();
                } else if (A1 instanceof UUID) {
                    UUID uUID = (UUID)A1;
                    object = uUID.toString();
                } else if (A1 instanceof Set) {
                    Set set = (Set)A1;
                    object = ((SetLike)set.map((Function1 & Serializable & scala.Serializable)value -> CassandraSQLRow$.MODULE$.toSparkSqlType(value), Set$.MODULE$.canBuildFrom())).toSeq();
                } else if (A1 instanceof List) {
                    List list = (List)A1;
                    object = list.map((Function1 & Serializable & scala.Serializable)value -> CassandraSQLRow$.MODULE$.toSparkSqlType(value), List$.MODULE$.canBuildFrom());
                } else if (A1 instanceof Map) {
                    Map map = (Map)A1;
                    object = map.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Object k = tuple2._1();
                        Object v = tuple2._2();
                        Tuple2 tuple22 = new Tuple2(CassandraSQLRow$.MODULE$.toSparkSqlType(k), CassandraSQLRow$.MODULE$.toSparkSqlType(v));
                        return tuple22;
                    }, Map$.MODULE$.canBuildFrom());
                } else if (A1 instanceof UDTValue) {
                    UDTValue uDTValue = (UDTValue)A1;
                    object = Row$.MODULE$.apply((Seq)uDTValue.columnValues().map((Function1 & Serializable & scala.Serializable)value -> CassandraSQLRow$.MODULE$.toSparkSqlType(value), IndexedSeq$.MODULE$.canBuildFrom()));
                } else if (A1 instanceof TupleValue) {
                    TupleValue tupleValue = (TupleValue)A1;
                    object = Row$.MODULE$.apply((Seq)tupleValue.values().map((Function1 & Serializable & scala.Serializable)value -> CassandraSQLRow$.MODULE$.toSparkSqlType(value), Seq$.MODULE$.canBuildFrom()));
                } else if (A1 instanceof DateRange) {
                    DateRange dateRange = (DateRange)A1;
                    object = dateRange.toString();
                } else {
                    object = this.value$1;
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof Geometry ? true : (object instanceof java.util.Date ? true : (object instanceof org.joda.time.LocalDate ? true : (object instanceof LocalDate ? true : (object instanceof LocalTime ? true : (object instanceof Duration ? true : (object instanceof CqlDuration ? true : (object instanceof Instant ? true : (object instanceof BigInteger ? true : (object instanceof BigDecimal ? true : (object instanceof InetAddress ? true : (object instanceof UUID ? true : (object instanceof Set ? true : (object instanceof List ? true : (object instanceof Map ? true : (object instanceof UDTValue ? true : (object instanceof TupleValue ? true : (object instanceof DateRange ? true : true)))))))))))))))));
                return bl;
            }
            {
                this.value$1 = value$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(java.lang.Object ), $anonfun$applyOrElse$2(java.lang.Object ), $anonfun$applyOrElse$3(scala.Tuple2 ), $anonfun$applyOrElse$4(java.lang.Object ), $anonfun$applyOrElse$5(java.lang.Object )}, serializedLambda);
            }
        };
        return sparkSqlType.apply(value);
    }

    public Object toUnsafeSqlType(Object value) {
        scala.Serializable sparkSqlType = new scala.Serializable(value){
            public static final long serialVersionUID = 0L;
            private final Object value$2;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Geometry) {
                    Geometry geometry = (Geometry)A1;
                    object = geometry.asWellKnownText();
                } else if (A1 instanceof CqlDuration) {
                    CqlDuration cqlDuration = (CqlDuration)A1;
                    object = TypeCodecs.DURATION.format((Object)cqlDuration);
                } else if (A1 instanceof java.util.Date) {
                    java.util.Date date = (java.util.Date)A1;
                    object = Timestamp.from(date.toInstant());
                } else if (A1 instanceof LocalDate) {
                    LocalDate localDate = (LocalDate)A1;
                    object = Date.valueOf(localDate);
                } else if (A1 instanceof org.joda.time.LocalDate) {
                    org.joda.time.LocalDate localDate = (org.joda.time.LocalDate)A1;
                    object = BoxesRunTime.boxToLong((long)LocalDate.of(localDate.getYear(), localDate.getMonthOfYear(), localDate.getDayOfMonth()).toEpochDay());
                } else if (A1 instanceof InetAddress) {
                    InetAddress inetAddress = (InetAddress)A1;
                    object = inetAddress.getHostAddress();
                } else if (A1 instanceof UUID) {
                    UUID uUID = (UUID)A1;
                    object = uUID.toString();
                } else if (A1 instanceof Set) {
                    Set set = (Set)A1;
                    object = ((SetLike)set.map((Function1 & Serializable & scala.Serializable)value -> CassandraSQLRow$.MODULE$.toUnsafeSqlType(value), Set$.MODULE$.canBuildFrom())).toSeq();
                } else if (A1 instanceof List) {
                    List list = (List)A1;
                    object = list.map((Function1 & Serializable & scala.Serializable)value -> CassandraSQLRow$.MODULE$.toUnsafeSqlType(value), List$.MODULE$.canBuildFrom());
                } else if (A1 instanceof Map) {
                    Map map = (Map)A1;
                    object = map.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Object k = tuple2._1();
                        Object v = tuple2._2();
                        Tuple2 tuple22 = new Tuple2(CassandraSQLRow$.MODULE$.toUnsafeSqlType(k), CassandraSQLRow$.MODULE$.toUnsafeSqlType(v));
                        return tuple22;
                    }, Map$.MODULE$.canBuildFrom());
                } else if (A1 instanceof UDTValue) {
                    UDTValue uDTValue = (UDTValue)A1;
                    object = new UDTValue(uDTValue.metaData(), (IndexedSeq)uDTValue.columnValues().map((Function1 & Serializable & scala.Serializable)value -> CassandraSQLRow$.MODULE$.toUnsafeSqlType(value), IndexedSeq$.MODULE$.canBuildFrom()));
                } else if (A1 instanceof TupleValue) {
                    TupleValue tupleValue = (TupleValue)A1;
                    object = new TupleValue((Seq)tupleValue.values().map((Function1 & Serializable & scala.Serializable)value -> CassandraSQLRow$.MODULE$.toUnsafeSqlType(value), Seq$.MODULE$.canBuildFrom()));
                } else if (A1 instanceof DateRange) {
                    DateRange dateRange = (DateRange)A1;
                    object = dateRange.toString();
                } else if (A1 instanceof LocalTime) {
                    LocalTime localTime = (LocalTime)A1;
                    object = Predef$.MODULE$.long2Long(localTime.toNanoOfDay());
                } else if (A1 instanceof Instant) {
                    Instant instant = (Instant)A1;
                    object = Timestamp.from(instant);
                } else {
                    object = this.value$2;
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof Geometry ? true : (object instanceof CqlDuration ? true : (object instanceof java.util.Date ? true : (object instanceof LocalDate ? true : (object instanceof org.joda.time.LocalDate ? true : (object instanceof InetAddress ? true : (object instanceof UUID ? true : (object instanceof Set ? true : (object instanceof List ? true : (object instanceof Map ? true : (object instanceof UDTValue ? true : (object instanceof TupleValue ? true : (object instanceof DateRange ? true : (object instanceof LocalTime ? true : (object instanceof Instant ? true : true))))))))))))));
                return bl;
            }
            {
                this.value$2 = value$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$6(java.lang.Object ), $anonfun$applyOrElse$7(java.lang.Object ), $anonfun$applyOrElse$8(scala.Tuple2 ), $anonfun$applyOrElse$9(java.lang.Object ), $anonfun$applyOrElse$10(java.lang.Object )}, serializedLambda);
            }
        };
        return sparkSqlType.apply(value);
    }

    public CassandraSQLRow empty() {
        return this.empty;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CassandraSQLRow$() {
        MODULE$ = this;
        this.empty = new CassandraSQLRow(null, (IndexedSeq<Object>)((IndexedSeq)package$.MODULE$.IndexedSeq().empty()));
    }
}

