/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.cassandra;

import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.util.Logging;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.cassandra.AnalyzedPredicates;
import org.apache.spark.sql.cassandra.CassandraPredicateRules;
import org.apache.spark.sql.cassandra.CassandraSourceRelation$;
import org.apache.spark.sql.cassandra.PredicateOps$FilterOps$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.In;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;

public final class InClausePredicateRules$
implements CassandraPredicateRules,
Logging {
    public static InClausePredicateRules$ MODULE$;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    static {
        new InClausePredicateRules$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    public long inCrossProductSize(Set<Filter> filters) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)filters.toSeq().collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Filter, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof In) {
                    In in = (In)A1;
                    object = BoxesRunTime.boxToInteger((int)in.values().length);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Filter x1) {
                Filter filter = x1;
                boolean bl = filter instanceof In;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())).product((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    private AnalyzedPredicates pushFiltersToSpark(AnalyzedPredicates predicates, Set<Filter> filters) {
        Set x$1 = (Set)predicates.handledBySpark().$plus$plus(filters);
        Set x$2 = (Set)predicates.handledByCassandra().$minus$minus(filters);
        return predicates.copy((Set<Filter>)x$2, (Set<Filter>)x$1);
    }

    private Set<Filter> columnsFilters(Set<Filter> filters, Seq<ColumnDef> columns) {
        return (Set)filters.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)columns.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)InClausePredicateRules$.$anonfun$columnsFilters$2(f, x$1)))));
    }

    private AnalyzedPredicates filterOutHugeInClausePredicates(AnalyzedPredicates predicates, TableDef tableDef, SparkConf sparkConf) {
        AnalyzedPredicates analyzedPredicates;
        long clusteringCartesianSize;
        long fullTableScanConversionThreshold = sparkConf.getLong(CassandraSourceRelation$.MODULE$.InClauseToFullTableScanConversionThreshold().name(), BoxesRunTime.unboxToLong((Object)CassandraSourceRelation$.MODULE$.InClauseToFullTableScanConversionThreshold().default()));
        Set inFilters = (Set)predicates.handledByCassandra().filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)PredicateOps$FilterOps$.MODULE$.isInPredicate(p)));
        Set<Filter> partitionColumnsFilters = this.columnsFilters((Set<Filter>)inFilters, (Seq<ColumnDef>)tableDef.partitionKey());
        Set<Filter> clusteringColumnsFilters = this.columnsFilters((Set<Filter>)inFilters, (Seq<ColumnDef>)tableDef.clusteringColumns());
        long partitionCartesianSize = this.inCrossProductSize(partitionColumnsFilters);
        if (partitionCartesianSize * (clusteringCartesianSize = this.inCrossProductSize(clusteringColumnsFilters)) < fullTableScanConversionThreshold) {
            analyzedPredicates = predicates;
        } else if (partitionCartesianSize < fullTableScanConversionThreshold) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(103).append("Number of key combinations in 'IN' clauses exceeds ").append(CassandraSourceRelation$.MODULE$.InClauseToFullTableScanConversionThreshold().name()).append(" ").append("(").append(fullTableScanConversionThreshold).append("), clustering columns filters are not pushed down.").toString());
            analyzedPredicates = this.pushFiltersToSpark(predicates, clusteringColumnsFilters);
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(157).append("Number of key combinations in 'IN' clauses exceeds ").append(CassandraSourceRelation$.MODULE$.InClauseToFullTableScanConversionThreshold().name()).append(" ").append("(").append(fullTableScanConversionThreshold).append("), partition key filters are not pushed down. This results in full table ").append("scan with Spark side filtering.").toString());
            analyzedPredicates = this.pushFiltersToSpark(predicates, (Set<Filter>)((Set)partitionColumnsFilters.$plus$plus(clusteringColumnsFilters)));
        }
        return analyzedPredicates;
    }

    @Override
    public AnalyzedPredicates apply(AnalyzedPredicates predicates, TableDef tableDef, SparkConf conf) {
        return this.filterOutHugeInClausePredicates(predicates, tableDef, conf);
    }

    public static final /* synthetic */ boolean $anonfun$columnsFilters$2(Filter f$1, ColumnDef x$1) {
        String string = x$1.columnName();
        String string2 = PredicateOps$FilterOps$.MODULE$.columnName(f$1);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private InClausePredicateRules$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

