/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.cassandra;

import com.datastax.oss.driver.api.core.AsyncPagingIterable;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.PagingIterable;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.data.GettableByIndex;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.CassandraConnector$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.util.Logging;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.format.DateTimeFormatter;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.cassandra.AnalyzedPredicates;
import org.apache.spark.sql.cassandra.Auto;
import org.apache.spark.sql.cassandra.CassandraPredicateRules;
import org.apache.spark.sql.cassandra.DseSearchOptimizationSetting;
import org.apache.spark.sql.cassandra.Off$;
import org.apache.spark.sql.cassandra.On$;
import org.apache.spark.sql.cassandra.SolrConstants$;
import org.apache.spark.sql.cassandra.SolrPredicateRules$SolrFilter$;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.xml.Elem;
import scala.xml.XML$;

@ScalaSignature(bytes="\u0006\u0001\t%e\u0001\u0002\u00192\u0001qB\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006I!\u0016\u0005\u00061\u0002!\t!\u0017\u0005\u00079\u0002!\t!M/\t\rq\u0003A\u0011IA\u0005\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'Aq!!\u0007\u0001\t\u0003\tY\u0002C\u0004\u0002&\u0001!\t!a\n\u0007\r\u0005u\u0002\u0001QA \u0011)\ti\u0005\u0003BK\u0002\u0013\u0005\u0011q\n\u0005\u000b\u0003#B!\u0011#Q\u0001\n\u0005\r\u0001BCA*\u0011\tU\r\u0011\"\u0001\u0002V!Q\u0011Q\f\u0005\u0003\u0012\u0003\u0006I!a\u0016\t\raCA\u0011AA0\u0011%\tI\u0007CA\u0001\n\u0003\tY\u0007C\u0005\u0002r!\t\n\u0011\"\u0001\u0002t!I\u0011\u0011\u0012\u0005\u0012\u0002\u0013\u0005\u00111\u0012\u0005\n\u0003\u001fC\u0011\u0011!C!\u0003#C\u0011\"!)\t\u0003\u0003%\t!a)\t\u0013\u0005-\u0006\"!A\u0005\u0002\u00055\u0006\"CA]\u0011\u0005\u0005I\u0011IA^\u0011%\tI\rCA\u0001\n\u0003\tY\rC\u0005\u0002P\"\t\t\u0011\"\u0011\u0002R\"I\u00111\u001b\u0005\u0002\u0002\u0013\u0005\u0013Q\u001b\u0005\n\u0003/D\u0011\u0011!C!\u00033<\u0011\"!8\u0001\u0003\u0003E\t!a8\u0007\u0013\u0005u\u0002!!A\t\u0002\u0005\u0005\bB\u0002-\u001b\t\u0003\ty\u000fC\u0005\u0002Tj\t\t\u0011\"\u0012\u0002V\"AALGA\u0001\n\u0003\u000b\t\u0010C\u0005\u0002xj\t\t\u0011\"!\u0002z\"9!1\u0002\u0001\u0005\n\t5\u0001b\u0002B\n\u0001\u0011%!Q\u0003\u0005\b\u00057\u0001A\u0011\u0002B\u000f\u0011\u001d\u0011\t\u0003\u0001C\u0001\u0005GAqAa\n\u0001\t\u0003\u0011I\u0003C\u0004\u00038\u0001!\tA!\u000f\t\u000f\t-\u0003\u0001\"\u0001\u0003N!I!1\f\u0001C\u0002\u0013%!Q\f\u0005\t\u0005C\u0002\u0001\u0015!\u0003\u0003`!I!1\r\u0001C\u0002\u0013%!Q\f\u0005\t\u0005K\u0002\u0001\u0015!\u0003\u0003`!I!q\r\u0001C\u0002\u0013%!Q\f\u0005\t\u0005S\u0002\u0001\u0015!\u0003\u0003`!I!1\u000e\u0001C\u0002\u0013%!Q\u000e\u0005\t\u0005{\u0002\u0001\u0015!\u0003\u0003p!9!q\u0010\u0001\u0005\n\u0005U\u0003b\u0002BA\u0001\u0011\u0005!1\u0011\u0002\u0013'>d'\u000f\u0015:fI&\u001c\u0017\r^3Sk2,7O\u0003\u00023g\u0005I1-Y:tC:$'/\u0019\u0006\u0003iU\n1a]9m\u0015\t1t'A\u0003ta\u0006\u00148N\u0003\u00029s\u00051\u0011\r]1dQ\u0016T\u0011AO\u0001\u0004_J<7\u0001A\n\u0005\u0001u\u001au\t\u0005\u0002?\u00036\tqHC\u0001A\u0003\u0015\u00198-\u00197b\u0013\t\u0011uH\u0001\u0004B]f\u0014VM\u001a\t\u0003\t\u0016k\u0011!M\u0005\u0003\rF\u0012qcQ1tg\u0006tGM]1Qe\u0016$\u0017nY1uKJ+H.Z:\u0011\u0005!\u0013V\"A%\u000b\u0005)[\u0015\u0001B;uS2T!\u0001T'\u0002\u0013\r|gN\\3di>\u0014(B\u0001\u001cO\u0015\ty\u0005+\u0001\u0005eCR\f7\u000f^1y\u0015\u0005\t\u0016aA2p[&\u00111+\u0013\u0002\b\u0019><w-\u001b8h\u0003e\u0019X-\u0019:dQ>\u0003H/[7ju\u0006$\u0018n\u001c8F]\u0006\u0014G.\u001a3\u0011\u0005\u00113\u0016BA,2\u0005q!5/Z*fCJ\u001c\u0007n\u00149uS6L'0\u0019;j_:\u001cV\r\u001e;j]\u001e\fa\u0001P5oSRtDC\u0001.\\!\t!\u0005\u0001C\u0003U\u0005\u0001\u0007Q+A\u0003baBd\u0017\u0010F\u0003_C\u000e\\\u0017\u000f\u0005\u0002E?&\u0011\u0001-\r\u0002\u0013\u0003:\fG.\u001f>fIB\u0013X\rZ5dCR,7\u000fC\u0003c\u0007\u0001\u0007a,\u0001\u0006qe\u0016$\u0017nY1uKNDQ\u0001Z\u0002A\u0002\u0015\f\u0001\u0002^1cY\u0016$UM\u001a\t\u0003M&l\u0011a\u001a\u0006\u0003Q.\u000b1aY9m\u0013\tQwM\u0001\u0005UC\ndW\rR3g\u0011\u0015a7\u00011\u0001n\u0003%\u0019\b/\u0019:l\u0007>tg\r\u0005\u0002o_6\tQ'\u0003\u0002qk\tI1\u000b]1sW\u000e{gN\u001a\u0005\u0006e\u000e\u0001\ra]\u0001\u0016O\u0016$8k\u001c7s\u0013:$W\r_3e\u0007>dW/\u001c8t!\u0015qD/Z7w\u0013\t)xHA\u0005Gk:\u001cG/[8oeA!qO`A\u0002\u001d\tAH\u0010\u0005\u0002z\u007f5\t!P\u0003\u0002|w\u00051AH]8pizJ!!` \u0002\rA\u0013X\rZ3g\u0013\ry\u0018\u0011\u0001\u0002\u0004'\u0016$(BA?@!\r9\u0018QA\u0005\u0005\u0003\u000f\t\tA\u0001\u0004TiJLgn\u001a\u000b\b=\u0006-\u0011QBA\b\u0011\u0015\u0011G\u00011\u0001_\u0011\u0015!G\u00011\u0001f\u0011\u0015aG\u00011\u0001n\u0003\u0001:W\r^*pYJLe\u000eZ3yK\u0012\u001cu\u000e\\;n]N4%o\\7T_2\u0014\b,\u0014'\u0015\u000bY\f)\"a\u0006\t\u000b\u0011,\u0001\u0019A3\t\u000b1,\u0001\u0019A7\u00021\u0005d'/Z1es\u000e{g\u000e^1j]N\u001cv\u000e\u001c:Rk\u0016\u0014\u0018\u0010\u0006\u0003\u0002\u001e\u0005\r\u0002c\u0001 \u0002 %\u0019\u0011\u0011E \u0003\u000f\t{w\u000e\\3b]\")!M\u0002a\u0001=\u0006\u0019\u0012n]\"p]Z,'\u000f^5cY\u0016$vnU8meR1\u0011QDA\u0015\u0003sAq!a\u000b\b\u0001\u0004\ti#\u0001\u0004gS2$XM\u001d\t\u0005\u0003_\t)$\u0004\u0002\u00022)\u0019\u00111G\u001a\u0002\u000fM|WO]2fg&!\u0011qGA\u0019\u0005\u00191\u0015\u000e\u001c;fe\"1\u00111H\u0004A\u0002Y\f1\"\u001b8eKb,GmQ8mg\nQ1k\u001c7s\r&dG/\u001a:\u0014\r!i\u0014\u0011IA$!\rq\u00141I\u0005\u0004\u0003\u000bz$a\u0002)s_\u0012,8\r\u001e\t\u0004}\u0005%\u0013bAA&\u007f\ta1+\u001a:jC2L'0\u00192mK\u0006I1o\u001c7s#V,'/_\u000b\u0003\u0003\u0007\t!b]8meF+XM]=!\u0003)\u0011XMZ3sK:\u001cWm]\u000b\u0003\u0003/\u0002RAPA-\u0003\u0007I1!a\u0017@\u0005\u0015\t%O]1z\u0003-\u0011XMZ3sK:\u001cWm\u001d\u0011\u0015\r\u0005\u0005\u0014QMA4!\r\t\u0019\u0007C\u0007\u0002\u0001!9\u0011QJ\u0007A\u0002\u0005\r\u0001bBA*\u001b\u0001\u0007\u0011qK\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0002b\u00055\u0014q\u000e\u0005\n\u0003\u001br\u0001\u0013!a\u0001\u0003\u0007A\u0011\"a\u0015\u000f!\u0003\u0005\r!a\u0016\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u000f\u0016\u0005\u0003\u0007\t9h\u000b\u0002\u0002zA!\u00111PAC\u001b\t\tiH\u0003\u0003\u0002\u0000\u0005\u0005\u0015!C;oG\",7m[3e\u0015\r\t\u0019iP\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAD\u0003{\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!$+\t\u0005]\u0013qO\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005M\u0005\u0003BAK\u0003?k!!a&\u000b\t\u0005e\u00151T\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u001e\u0006!!.\u0019<b\u0013\u0011\t9!a&\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u0015\u0006c\u0001 \u0002(&\u0019\u0011\u0011V \u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005=\u0016Q\u0017\t\u0004}\u0005E\u0016bAAZ\u007f\t\u0019\u0011I\\=\t\u0013\u0005]6#!AA\u0002\u0005\u0015\u0016a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002>B1\u0011qXAc\u0003_k!!!1\u000b\u0007\u0005\rw(\u0001\u0006d_2dWm\u0019;j_:LA!a2\u0002B\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ti\"!4\t\u0013\u0005]V#!AA\u0002\u0005=\u0016\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005\u0015\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005M\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0002\u001e\u0005m\u0007\"CA\\1\u0005\u0005\t\u0019AAX\u0003)\u0019v\u000e\u001c:GS2$XM\u001d\t\u0004\u0003GR2#\u0002\u000e\u0002d\u0006\u001d\u0003CCAs\u0003W\f\u0019!a\u0016\u0002b5\u0011\u0011q\u001d\u0006\u0004\u0003S|\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003[\f9OA\tBEN$(/Y2u\rVt7\r^5p]J\"\"!a8\u0015\r\u0005\u0005\u00141_A{\u0011\u001d\ti%\ba\u0001\u0003\u0007Aq!a\u0015\u001e\u0001\u0004\t9&A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005m(q\u0001\t\u0006}\u0005u(\u0011A\u0005\u0004\u0003\u007f|$AB(qi&|g\u000eE\u0004?\u0005\u0007\t\u0019!a\u0016\n\u0007\t\u0015qH\u0001\u0004UkBdWM\r\u0005\n\u0005\u0013q\u0012\u0011!a\u0001\u0003C\n1\u0001\u001f\u00131\u0003-!xnU8meZ\u000bG.^3\u0015\t\u0005\r!q\u0002\u0005\b\u0005#y\u0002\u0019AAX\u0003\u00151\u0018\r\\;f\u0003-!xnU8me\u001aKW\r\u001c3\u0015\t\u0005\r!q\u0003\u0005\b\u00053\u0001\u0003\u0019AA\u0002\u0003\u00151\u0017.\u001a7e\u0003E\u0019\u0018M\\5uSj,7k\u001c7s\r&,G\u000e\u001a\u000b\u0005\u0003'\u0013y\u0002C\u0004\u0003\u001a\u0005\u0002\r!a\u0001\u0002'\r|gN^3siR{7k\u001c7s\r&dG/\u001a:\u0015\t\u0005\u0005$Q\u0005\u0005\b\u0003W\u0011\u0003\u0019AA\u0017\u0003i9W\r\u001e)beRLG/[8o\u0017\u0016L(+Z:ue&\u001cG/[8o)\u0019\u0011YCa\r\u00036A!qO B\u0017!\u0011\tyCa\f\n\t\tE\u0012\u0011\u0007\u0002\b\u000bF,\u0018\r\u001c+p\u0011\u0015\u00117\u00051\u0001_\u0011\u0015!7\u00051\u0001f\u0003U1\u0017N\u001c3Vg\u0016dWm]:Jg:{GOT;mYN$bAa\u000f\u0003D\t%\u0003\u0003B<\u007f\u0005{\u0001B!a\f\u0003@%!!\u0011IA\u0019\u0005%I5OT8u\u001dVdG\u000eC\u0004\u0003F\u0011\u0002\rAa\u0012\u0002\u000f\u0019LG\u000e^3sgB!qO`A\u0017\u0011\u0015!G\u00051\u0001f\u0003I\u0019wN\u001c<feR$vnU8meF+XM]=\u0015\u0017y\u0013yE!\u0015\u0003T\t]#\u0011\f\u0005\u0006E\u0016\u0002\rA\u0018\u0005\u0006I\u0016\u0002\r!\u001a\u0005\u0007\u0005+*\u0003\u0019\u0001<\u0002#M|GN]%oI\u0016DX\r\u001a$jK2$7\u000fC\u0003UK\u0001\u0007Q\u000bC\u0003mK\u0001\u0007Q.A\nfg\u000e\f\u0007/\u00192mK^{'\u000f\u001a+pW\u0016t7/\u0006\u0002\u0003`A)a(!\u0017\u0002\u0014\u0006!Rm]2ba\u0006\u0014G.Z,pe\u0012$vn[3og\u0002\na\"Z:dCB\f'\r\\3DQ\u0006\u00148/A\bfg\u000e\f\u0007/\u00192mK\u000eC\u0017M]:!\u0003Q)7oY1qC\ndWm\u00165ji\u0016\u001c\b/Y2fg\u0006)Rm]2ba\u0006\u0014G.Z,iSR,7\u000f]1dKN\u0004\u0013AC3tG\u0006\u0004\u0018M\u00197fgV\u0011!q\u000e\t\u0005\u0005c\u0012I(\u0004\u0002\u0003t)!!Q\u000fB<\u0003\u0015\u0011XmZ3y\u0015\rQ\u00151T\u0005\u0005\u0005w\u0012\u0019HA\u0004QCR$XM\u001d8\u0002\u0017\u0015\u001c8-\u00199bE2,7\u000fI\u0001\u0012KN\u001c\u0017\r]1cY\u0016,e\u000e^5uS\u0016\u001c\u0018aE3tG\u0006\u0004XmU8me\u000e{g\u000eZ5uS>tG\u0003BA\u0002\u0005\u000bCqAa\"0\u0001\u0004\t\u0019!A\u0005d_:$\u0017\u000e^5p]\u0002")
public class SolrPredicateRules
implements CassandraPredicateRules,
Logging {
    private volatile SolrPredicateRules$SolrFilter$ SolrFilter$module;
    private final DseSearchOptimizationSetting searchOptimizationEnabled;
    private final String[] escapableWordTokens;
    private final String[] escapableChars;
    private final String[] escapableWhitespaces;
    private final Pattern escapables;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public SolrPredicateRules$SolrFilter$ SolrFilter() {
        if (this.SolrFilter$module == null) {
            this.SolrFilter$lzycompute$1();
        }
        return this.SolrFilter$module;
    }

    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    public AnalyzedPredicates apply(AnalyzedPredicates predicates, TableDef tableDef, SparkConf sparkConf, Function2<TableDef, SparkConf, scala.collection.immutable.Set<String>> getSolrIndexedColumns) {
        AnalyzedPredicates analyzedPredicates;
        scala.collection.immutable.Set<IsNotNull> uselessIsNotNulls = this.findUselessIsNotNulls((scala.collection.immutable.Set<Filter>)((scala.collection.immutable.Set)predicates.handledByCassandra().$plus$plus(predicates.handledBySpark())), tableDef);
        AnalyzedPredicates usefulPredicates = new AnalyzedPredicates(predicates.handledByCassandra(), (scala.collection.immutable.Set<Filter>)((scala.collection.immutable.Set)predicates.handledBySpark().$minus$minus(uselessIsNotNulls)));
        scala.collection.immutable.Set<EqualTo> pkRestriction = this.getPartitionKeyRestriction(usefulPredicates, tableDef);
        boolean primaryKeyRestrictionExists = pkRestriction.nonEmpty() && pkRestriction.subsetOf(usefulPredicates.handledByCassandra()) && usefulPredicates.handledBySpark().isEmpty();
        boolean solrEnabledOnTargetHosts = BoxesRunTime.unboxToBoolean(CassandraConnector$.MODULE$.apply(sparkConf).withSessionDo((Function1 & Serializable & scala.Serializable)session -> BoxesRunTime.boxToBoolean((boolean)SolrPredicateRules.$anonfun$apply$1(session))));
        Option failedRequirement = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToBoolean((!solrEnabledOnTargetHosts ? 1 : 0) != 0), (Object)"Search is not enabled on DSE Target nodes."), new Tuple2((Object)BoxesRunTime.boxToBoolean((!this.searchOptimizationEnabled.enabled() ? 1 : 0) != 0), (Object)"Automatic Search optimizations for Spark SQL are disabled."), new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)primaryKeyRestrictionExists), (Object)"There is a primary key restriction present"), new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)this.alreadyContainsSolrQuery(usefulPredicates)), (Object)"Manual Solr query (solr_query = xxx) present.")}))).collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    boolean bl = A1._1$mcZ$sp();
                    String reason = (String)A1._2();
                    if (bl) {
                        object = reason;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, String> x1) {
                boolean bl;
                Tuple2<Object, String> tuple2 = x1;
                boolean bl2 = tuple2 != null && (bl = tuple2._1$mcZ$sp());
                return bl2;
            }
        });
        Option option = failedRequirement;
        if (option instanceof Some) {
            Some some = (Some)option;
            String reasonForFailure = (String)some.value();
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(30).append("Not using Solr Optimizations. ").append(reasonForFailure).toString());
            analyzedPredicates = usefulPredicates;
        } else if (None$.MODULE$.equals(option)) {
            analyzedPredicates = this.convertToSolrQuery(usefulPredicates, tableDef, (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)getSolrIndexedColumns.apply((Object)tableDef, (Object)sparkConf)), this.searchOptimizationEnabled, sparkConf);
        } else {
            throw new MatchError((Object)option);
        }
        return analyzedPredicates;
    }

    @Override
    public AnalyzedPredicates apply(AnalyzedPredicates predicates, TableDef tableDef2, SparkConf sparkConf2) {
        return this.apply(predicates, tableDef2, sparkConf2, (Function2<TableDef, SparkConf, scala.collection.immutable.Set<String>>)(Function2 & Serializable & scala.Serializable)(tableDef, sparkConf) -> this.getSolrIndexedColumnsFromSolrXML((TableDef)tableDef, (SparkConf)sparkConf));
    }

    public scala.collection.immutable.Set<String> getSolrIndexedColumnsFromSolrXML(TableDef tableDef, SparkConf sparkConf) {
        scala.collection.immutable.Set set;
        Success success;
        String schema;
        String SelectSolrSchema = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(154).append("SELECT blobAsText(resource_value) FROM\n         |solr_admin.solr_resources\n         |where core_name = '").append(tableDef.keyspaceName()).append(".").append(tableDef.tableName()).append("'\n         |and resource_name = 'schema.xml.bak' ").toString())).stripMargin();
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ((GettableByIndex)((PagingIterable)CassandraConnector$.MODULE$.apply(sparkConf).withSessionDo((Function1 & Serializable & scala.Serializable)x$2 -> x$2.execute(SelectSolrSchema))).one()).getString(0));
        if (try_ instanceof Success && (schema = (String)(success = (Success)try_).value()) != null) {
            scala.collection.immutable.Set set2;
            String string = schema;
            Try try_2 = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                Elem schemaXML = (Elem)XML$.MODULE$.loadString(string);
                return ((TraversableOnce)((TraversableLike)((TraversableLike)((TraversableLike)((scala.xml.Node)((IterableLike)schemaXML.child().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SolrPredicateRules.$anonfun$getSolrIndexedColumnsFromSolrXML$5(x$3)))).head()).child().filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)SolrPredicateRules.$anonfun$getSolrIndexedColumnsFromSolrXML$6(x)))).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)SolrPredicateRules.$anonfun$getSolrIndexedColumnsFromSolrXML$7(x$4)))).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SolrPredicateRules.$anonfun$getSolrIndexedColumnsFromSolrXML$9(x$5)))).map((Function1 & Serializable & scala.Serializable)x$6 -> ((SeqLike)x$6.attribute("name").get()).toString(), Seq$.MODULE$.canBuildFrom())).toSet();
            });
            if (try_2 instanceof Success) {
                scala.collection.immutable.Set indexed;
                Success success2 = (Success)try_2;
                set2 = indexed = (scala.collection.immutable.Set)success2.value();
            } else if (try_2 instanceof Failure) {
                Failure failure = (Failure)try_2;
                Throwable e = failure.exception();
                set2 = this.solrIndexedFail$1(new java.lang.StringBuilder(32).append("Unable to parse schema.xml.bak: ").append(e).toString());
            } else {
                throw new MatchError((Object)try_2);
            }
            set = set2;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            set = this.solrIndexedFail$1(new java.lang.StringBuilder(28).append("Unable to access Solr Info: ").append(e).toString());
        } else {
            throw new MatchError((Object)try_);
        }
        return set;
    }

    public boolean alreadyContainsSolrQuery(AnalyzedPredicates predicates) {
        return ((TraversableOnce)predicates.handledByCassandra().$plus$plus(predicates.handledBySpark()).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Filter, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof EqualTo) {
                    EqualTo equalTo = (EqualTo)A1;
                    String column = equalTo.attribute();
                    Object value = equalTo.value();
                    String string = column;
                    String string2 = SolrConstants$.MODULE$.SolrQuery();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        object = new EqualTo(column, value);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Filter x1) {
                String column;
                Filter filter = x1;
                if (!(filter instanceof EqualTo)) return false;
                EqualTo equalTo = (EqualTo)filter;
                String string = column = equalTo.attribute();
                String string2 = SolrConstants$.MODULE$.SolrQuery();
                if (string != null) {
                    if (!string.equals(string2)) return false;
                    return true;
                }
                if (string2 == null) return true;
                return false;
            }
        }, Set$.MODULE$.canBuildFrom())).nonEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConvertibleToSolr(Filter filter, scala.collection.immutable.Set<String> indexedCols) {
        Not not;
        Filter child;
        IsNotNull isNotNull;
        String attr;
        IsNull isNull;
        String attr2;
        Filter filter2 = filter;
        if (filter2 instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter2;
            String attr3 = equalTo.attribute();
            Object value = equalTo.value();
            if (attr3 != null) {
                String string = attr3;
                if (value instanceof Object) {
                    return indexedCols.contains((Object)this.sanitizeSolrField(string));
                }
            }
        }
        if (filter2 instanceof EqualNullSafe) {
            EqualNullSafe equalNullSafe = (EqualNullSafe)filter2;
            String attr4 = equalNullSafe.attribute();
            Object value = equalNullSafe.value();
            if (attr4 != null) {
                String string = attr4;
                if (value instanceof Object) {
                    return indexedCols.contains((Object)this.sanitizeSolrField(string));
                }
            }
        }
        if (filter2 instanceof In) {
            In in = (In)filter2;
            String attr5 = in.attribute();
            Object[] values = in.values();
            if (attr5 != null) {
                String string = attr5;
                if (values != null) {
                    return indexedCols.contains((Object)this.sanitizeSolrField(string));
                }
            }
        }
        if (filter2 instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter2;
            String attr6 = greaterThan.attribute();
            Object value = greaterThan.value();
            if (attr6 != null) {
                String string = attr6;
                if (value instanceof Object) {
                    return indexedCols.contains((Object)this.sanitizeSolrField(string));
                }
            }
        }
        if (filter2 instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter2;
            String attr7 = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            if (attr7 != null) {
                String string = attr7;
                if (value instanceof Object) {
                    return indexedCols.contains((Object)this.sanitizeSolrField(string));
                }
            }
        }
        if (filter2 instanceof LessThan) {
            LessThan lessThan = (LessThan)filter2;
            String attr8 = lessThan.attribute();
            Object value = lessThan.value();
            if (attr8 != null) {
                String string = attr8;
                if (value instanceof Object) {
                    return indexedCols.contains((Object)this.sanitizeSolrField(string));
                }
            }
        }
        if (filter2 instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
            String attr9 = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            if (attr9 != null) {
                String string = attr9;
                if (value instanceof Object) {
                    return indexedCols.contains((Object)this.sanitizeSolrField(string));
                }
            }
        }
        if (filter2 instanceof IsNull && (attr2 = (isNull = (IsNull)filter2).attribute()) != null) {
            String string = attr2;
            return indexedCols.contains((Object)this.sanitizeSolrField(string));
        }
        if (filter2 instanceof IsNotNull && (attr = (isNotNull = (IsNotNull)filter2).attribute()) != null) {
            String string = attr;
            return indexedCols.contains((Object)this.sanitizeSolrField(string));
        }
        if (filter2 instanceof And) {
            And and = (And)filter2;
            Filter left = and.left();
            Filter right = and.right();
            if (left != null) {
                Filter filter3 = left;
                if (right != null) {
                    Filter filter4 = right;
                    if (!this.isConvertibleToSolr(filter3, indexedCols)) return false;
                    if (!this.isConvertibleToSolr(filter4, indexedCols)) return false;
                    return true;
                }
            }
        }
        if (filter2 instanceof Or) {
            Or or = (Or)filter2;
            Filter left = or.left();
            Filter right = or.right();
            if (left != null) {
                Filter filter5 = left;
                if (right != null) {
                    Filter filter6 = right;
                    if (!this.isConvertibleToSolr(filter5, indexedCols)) return false;
                    if (!this.isConvertibleToSolr(filter6, indexedCols)) return false;
                    return true;
                }
            }
        }
        if (filter2 instanceof Not && (child = (not = (Not)filter2).child()) != null) {
            Filter filter7 = child;
            return this.isConvertibleToSolr(filter7, indexedCols);
        }
        if (filter2 instanceof StringStartsWith) {
            StringStartsWith stringStartsWith = (StringStartsWith)filter2;
            String attr10 = stringStartsWith.attribute();
            String value = stringStartsWith.value();
            if (attr10 != null) {
                String string = attr10;
                if (value != null) {
                    return indexedCols.contains((Object)this.sanitizeSolrField(string));
                }
            }
        }
        if (filter2 instanceof StringEndsWith) {
            StringEndsWith stringEndsWith = (StringEndsWith)filter2;
            String attr11 = stringEndsWith.attribute();
            String value = stringEndsWith.value();
            if (attr11 != null) {
                String string = attr11;
                if (value != null) {
                    return indexedCols.contains((Object)this.sanitizeSolrField(string));
                }
            }
        }
        if (filter2 instanceof StringContains) {
            StringContains stringContains = (StringContains)filter2;
            String attr12 = stringContains.attribute();
            String value = stringContains.value();
            if (attr12 != null) {
                String string = attr12;
                if (value != null) {
                    return indexedCols.contains((Object)this.sanitizeSolrField(string));
                }
            }
        }
        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(20).append("Unknown Filter Type ").append(filter2).toString());
        return false;
    }

    private String toSolrValue(Object value) {
        String string;
        Object object = value;
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            string = DateTimeFormatter.ISO_INSTANT.format(timestamp.toInstant());
        } else {
            string = object.toString();
        }
        return StringEscapeUtils.escapeJson((String)this.escapeSolrCondition(string));
    }

    private String toSolrField(String field) {
        return this.toSolrValue(this.sanitizeSolrField(field));
    }

    private String sanitizeSolrField(String field) {
        String string;
        String string2 = field;
        String string3 = string2 != null && (string = string2).startsWith("`") && string.endsWith("`") && string.length() > 1 ? string.substring(1, string.length() - 1) : string2;
        return string3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SolrFilter convertToSolrFilter(Filter filter) {
        Not not;
        Filter child;
        IsNotNull isNotNull;
        String attr;
        IsNull isNull;
        String attr2;
        Filter filter2 = filter;
        if (filter2 instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter2;
            String attr3 = equalTo.attribute();
            Object value2 = equalTo.value();
            if (attr3 != null) {
                String string = attr3;
                if (value2 instanceof Object) {
                    Object object = value2;
                    return new SolrFilter(this, new java.lang.StringBuilder(1).append(this.toSolrField(string)).append(":").append(this.toSolrValue(object)).toString(), filter.references());
                }
            }
        }
        if (filter2 instanceof EqualNullSafe) {
            EqualNullSafe equalNullSafe = (EqualNullSafe)filter2;
            String attr4 = equalNullSafe.attribute();
            Object value3 = equalNullSafe.value();
            if (attr4 != null) {
                String string = attr4;
                if (value3 instanceof Object) {
                    Object object = value3;
                    return new SolrFilter(this, new java.lang.StringBuilder(1).append(this.toSolrField(string)).append(":").append(this.toSolrValue(object)).toString(), filter.references());
                }
            }
        }
        if (filter2 instanceof In) {
            In in = (In)filter2;
            String attr5 = in.attribute();
            Object[] values = in.values();
            if (attr5 != null) {
                String string = attr5;
                if (values != null) {
                    Object[] objectArray = values;
                    return new SolrFilter(this, new java.lang.StringBuilder(3).append(this.toSolrField(string)).append(":(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)objectArray).map((Function1 & Serializable & scala.Serializable)value -> this.toSolrValue(value), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(" ")).append(")").toString(), filter.references());
                }
            }
        }
        if (filter2 instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter2;
            String attr6 = greaterThan.attribute();
            Object value4 = greaterThan.value();
            if (attr6 != null) {
                String string = attr6;
                if (value4 instanceof Object) {
                    Object object = value4;
                    return new SolrFilter(this, new java.lang.StringBuilder(8).append(this.toSolrField(string)).append(":{").append(this.toSolrValue(object)).append(" TO *]").toString(), filter.references());
                }
            }
        }
        if (filter2 instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter2;
            String attr7 = greaterThanOrEqual.attribute();
            Object value5 = greaterThanOrEqual.value();
            if (attr7 != null) {
                String string = attr7;
                if (value5 instanceof Object) {
                    Object object = value5;
                    return new SolrFilter(this, new java.lang.StringBuilder(8).append(this.toSolrField(string)).append(":[").append(this.toSolrValue(object)).append(" TO *]").toString(), filter.references());
                }
            }
        }
        if (filter2 instanceof LessThan) {
            LessThan lessThan = (LessThan)filter2;
            String attr8 = lessThan.attribute();
            Object value6 = lessThan.value();
            if (attr8 != null) {
                String string = attr8;
                if (value6 instanceof Object) {
                    Object object = value6;
                    return new SolrFilter(this, new java.lang.StringBuilder(8).append(this.toSolrField(string)).append(":[* TO ").append(this.toSolrValue(object)).append("}").toString(), filter.references());
                }
            }
        }
        if (filter2 instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
            String attr9 = lessThanOrEqual.attribute();
            Object value7 = lessThanOrEqual.value();
            if (attr9 != null) {
                String string = attr9;
                if (value7 instanceof Object) {
                    Object object = value7;
                    return new SolrFilter(this, new java.lang.StringBuilder(8).append(this.toSolrField(string)).append(":[* TO ").append(this.toSolrValue(object)).append("]").toString(), filter.references());
                }
            }
        }
        if (filter2 instanceof IsNull && (attr2 = (isNull = (IsNull)filter2).attribute()) != null) {
            String string = attr2;
            return new SolrFilter(this, new java.lang.StringBuilder(10).append("-").append(this.toSolrField(string)).append(":[* TO *]").toString(), filter.references());
        }
        if (filter2 instanceof IsNotNull && (attr = (isNotNull = (IsNotNull)filter2).attribute()) != null) {
            String string = attr;
            return new SolrFilter(this, new java.lang.StringBuilder(2).append(this.toSolrField(string)).append(":*").toString(), filter.references());
        }
        if (filter2 instanceof And) {
            And and = (And)filter2;
            Filter left = and.left();
            Filter right = and.right();
            if (left != null) {
                Filter filter3 = left;
                if (right != null) {
                    Filter filter4 = right;
                    return new SolrFilter(this, new java.lang.StringBuilder(7).append("(").append(this.convertToSolrFilter(filter3).solrQuery()).append(" AND ").append(this.convertToSolrFilter(filter4).solrQuery()).append(")").toString(), filter.references());
                }
            }
        }
        if (filter2 instanceof Or) {
            Or or = (Or)filter2;
            Filter left = or.left();
            Filter right = or.right();
            if (left != null) {
                Filter filter5 = left;
                if (right != null) {
                    Filter filter6 = right;
                    return new SolrFilter(this, new java.lang.StringBuilder(6).append("(").append(this.convertToSolrFilter(filter5).solrQuery()).append(" OR ").append(this.convertToSolrFilter(filter6).solrQuery()).append(")").toString(), filter.references());
                }
            }
        }
        if (filter2 instanceof Not && (child = (not = (Not)filter2).child()) != null) {
            Filter filter7 = child;
            return new SolrFilter(this, new java.lang.StringBuilder(3).append("-(").append(this.convertToSolrFilter(filter7).solrQuery()).append(")").toString(), filter.references());
        }
        if (filter2 instanceof StringStartsWith) {
            StringStartsWith stringStartsWith = (StringStartsWith)filter2;
            String attr10 = stringStartsWith.attribute();
            String value8 = stringStartsWith.value();
            if (attr10 != null) {
                String string = attr10;
                if (value8 != null) {
                    String string2 = value8;
                    return new SolrFilter(this, new java.lang.StringBuilder(2).append(this.toSolrField(string)).append(":").append(this.toSolrValue(string2)).append("*").toString(), filter.references());
                }
            }
        }
        if (filter2 instanceof StringEndsWith) {
            StringEndsWith stringEndsWith = (StringEndsWith)filter2;
            String attr11 = stringEndsWith.attribute();
            String value9 = stringEndsWith.value();
            if (attr11 != null) {
                String string = attr11;
                if (value9 != null) {
                    String string3 = value9;
                    return new SolrFilter(this, new java.lang.StringBuilder(2).append(this.toSolrField(string)).append(":*").append(this.toSolrValue(string3)).toString(), filter.references());
                }
            }
        }
        if (!(filter2 instanceof StringContains)) throw new IllegalArgumentException(new java.lang.StringBuilder(20).append(filter2).append(" cannot be converted").toString());
        StringContains stringContains = (StringContains)filter2;
        String attr12 = stringContains.attribute();
        String value10 = stringContains.value();
        if (attr12 == null) throw new IllegalArgumentException(new java.lang.StringBuilder(20).append(filter2).append(" cannot be converted").toString());
        String string = attr12;
        if (value10 == null) throw new IllegalArgumentException(new java.lang.StringBuilder(20).append(filter2).append(" cannot be converted").toString());
        String string4 = value10;
        return new SolrFilter(this, new java.lang.StringBuilder(3).append(this.toSolrField(string)).append(":*").append(this.toSolrValue(string4)).append("*").toString(), filter.references());
    }

    public scala.collection.immutable.Set<EqualTo> getPartitionKeyRestriction(AnalyzedPredicates predicates, TableDef tableDef) {
        scala.collection.immutable.Set partitionKeyRestrictions;
        scala.collection.immutable.Set equalsRestrictions = (scala.collection.immutable.Set)predicates.handledByCassandra().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Filter, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                EqualTo equalTo;
                A1 A1 = x1;
                Object object = A1 instanceof EqualTo ? (equalTo = (EqualTo)A1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Filter x1) {
                Filter filter = x1;
                boolean bl = filter instanceof EqualTo;
                return bl;
            }
        }, Set$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set partitionKeyColumnNames = ((TraversableOnce)tableDef.partitionKey().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.columnName(), Seq$.MODULE$.canBuildFrom())).toSet();
        boolean partitionKeyFullyRestricted = ((SetLike)partitionKeyColumnNames.$minus$minus((GenTraversableOnce)(partitionKeyRestrictions = (scala.collection.immutable.Set)equalsRestrictions.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SolrPredicateRules.$anonfun$getPartitionKeyRestriction$2(partitionKeyColumnNames, x0$1)))).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.attribute(), Set$.MODULE$.canBuildFrom()))).isEmpty();
        return partitionKeyFullyRestricted ? partitionKeyRestrictions : Predef$.MODULE$.Set().empty();
    }

    public scala.collection.immutable.Set<IsNotNull> findUselessIsNotNulls(scala.collection.immutable.Set<Filter> filters, TableDef tableDef) {
        IndexedSeq primaryKeyColumnNames = (IndexedSeq)tableDef.primaryKey().map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.columnName(), IndexedSeq$.MODULE$.canBuildFrom());
        Map isNotNullColumns = ((TraversableOnce)filters.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Filter, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof IsNotNull) {
                    IsNotNull isNotNull = (IsNotNull)A1;
                    String attr = isNotNull.attribute();
                    object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)attr), (Object)new IsNotNull(attr));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Filter x1) {
                Filter filter = x1;
                boolean bl = filter instanceof IsNotNull;
                return bl;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Set restrictedColumns = (scala.collection.immutable.Set)filters.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Filter, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof LessThan) {
                    LessThan lessThan = (LessThan)A1;
                    String attr = lessThan.attribute();
                    object = attr;
                } else if (A1 instanceof LessThanOrEqual) {
                    LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)A1;
                    String attr = lessThanOrEqual.attribute();
                    object = attr;
                } else if (A1 instanceof GreaterThan) {
                    GreaterThan greaterThan = (GreaterThan)A1;
                    String attr = greaterThan.attribute();
                    object = attr;
                } else if (A1 instanceof GreaterThanOrEqual) {
                    GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)A1;
                    String attr = greaterThanOrEqual.attribute();
                    object = attr;
                } else if (A1 instanceof EqualNullSafe) {
                    EqualNullSafe equalNullSafe = (EqualNullSafe)A1;
                    String attr = equalNullSafe.attribute();
                    object = attr;
                } else if (A1 instanceof EqualTo) {
                    EqualTo equalTo = (EqualTo)A1;
                    String attr = equalTo.attribute();
                    object = attr;
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Filter x2) {
                Filter filter = x2;
                boolean bl = filter instanceof LessThan ? true : (filter instanceof LessThanOrEqual ? true : (filter instanceof GreaterThan ? true : (filter instanceof GreaterThanOrEqual ? true : (filter instanceof EqualNullSafe ? true : filter instanceof EqualTo))));
                return bl;
            }
        }, Set$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set uselessIsNotNulls = ((TraversableOnce)((TraversableLike)primaryKeyColumnNames.$plus$plus((GenTraversableOnce)restrictedColumns, IndexedSeq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)attr -> Option$.MODULE$.option2Iterable(isNotNullColumns.get(attr)), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(45).append("Found isNotNulls ").append(uselessIsNotNulls).append(" that are already not needed").toString());
        return uselessIsNotNulls;
    }

    public AnalyzedPredicates convertToSolrQuery(AnalyzedPredicates predicates, TableDef tableDef, scala.collection.immutable.Set<String> solrIndexedFields, DseSearchOptimizationSetting searchOptimizationEnabled, SparkConf sparkConf) {
        AnalyzedPredicates analyzedPredicates;
        scala.collection.immutable.Set possibleSolrPredicates;
        Tuple2 tuple2;
        scala.collection.immutable.Set allPredicates = (scala.collection.immutable.Set)predicates.handledByCassandra().$plus$plus(predicates.handledBySpark());
        scala.collection.immutable.Set<EqualTo> pkRestriction = this.getPartitionKeyRestriction(predicates, tableDef);
        if (pkRestriction.nonEmpty()) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(60).append("Partition restriction being withheld from Solr Conversion:  ").append(pkRestriction).toString());
        }
        if ((tuple2 = (possibleSolrPredicates = (scala.collection.immutable.Set)allPredicates.$minus$minus(pkRestriction)).partition((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)this.isConvertibleToSolr(x$10, (scala.collection.immutable.Set<String>)solrIndexedFields)))) == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Set solrConvertibleFilters = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set sparkFilters = (scala.collection.immutable.Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)solrConvertibleFilters, (Object)sparkFilters);
        Tuple2 tuple23 = tuple22;
        scala.collection.immutable.Set solrConvertibleFilters2 = (scala.collection.immutable.Set)tuple23._1();
        scala.collection.immutable.Set sparkFilters2 = (scala.collection.immutable.Set)tuple23._2();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(30).append("Converting ").append(solrConvertibleFilters2).append(" to Solr Predicates").toString());
        scala.collection.immutable.Set solrFilters = (scala.collection.immutable.Set)solrConvertibleFilters2.map((Function1 & Serializable & scala.Serializable)filter -> this.convertToSolrFilter((Filter)filter), Set$.MODULE$.canBuildFrom());
        String combinedFilterQuery = ((TraversableOnce)solrFilters.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SolrFilter solrFilter = x0$1;
            if (solrFilter == null) {
                throw new MatchError((Object)solrFilter);
            }
            String query = solrFilter.solrQuery();
            String string = new java.lang.StringBuilder(2).append("\"").append(query).append("\"").toString();
            return string;
        }, Set$.MODULE$.canBuildFrom())).mkString(", ");
        String solrString = new java.lang.StringBuilder(20).append("{\"q\":\"*:*\", \"fq\":[").append(combinedFilterQuery).append("]}").toString();
        String FaultTolerant = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"shards.failover\": false", "\"shards.tolerant\": true"}))).mkString(",");
        String solrStringNoFailoverTolerant = new java.lang.StringBuilder(22).append("{\"q\":\"*:*\", \"fq\":[").append(combinedFilterQuery).append("], ").append(FaultTolerant).append("}").toString();
        EqualTo combinedSolrFilter = new EqualTo(SolrConstants$.MODULE$.SolrQuery(), (Object)solrString);
        AnalyzedPredicates optimizedPredicates = new AnalyzedPredicates((scala.collection.immutable.Set<Filter>)((scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filter[]{combinedSolrFilter}))).$plus$plus(pkRestriction)), (scala.collection.immutable.Set<Filter>)sparkFilters2);
        if (solrConvertibleFilters2.isEmpty()) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No Solr Convertible Filters Found");
            analyzedPredicates = predicates;
        } else {
            AnalyzedPredicates analyzedPredicates2;
            DseSearchOptimizationSetting dseSearchOptimizationSetting = searchOptimizationEnabled;
            if (dseSearchOptimizationSetting instanceof Auto) {
                AnalyzedPredicates analyzedPredicates3;
                double queryRatio;
                Auto auto = (Auto)dseSearchOptimizationSetting;
                double ratio = auto.ratio();
                CassandraConnector conn = CassandraConnector$.MODULE$.apply(sparkConf);
                String request = new java.lang.StringBuilder(45).append("SELECT COUNT(*) from \"").append(tableDef.keyspaceName()).append("\".\"").append(tableDef.tableName()).append("\" where solr_query=?").toString();
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Checking total number of records");
                Tuple2 tuple24 = (Tuple2)conn.withSessionDo((Function1 & Serializable & scala.Serializable)session -> {
                    DriverExecutionProfile pagingDisabled = session.getContext().getConfig().getDefaultProfile().withInt((DriverOption)DefaultDriverOption.REQUEST_PAGE_SIZE, -1);
                    SimpleStatement totalRequest = (SimpleStatement)SimpleStatement.newInstance((String)request, (Object[])new Object[]{new java.lang.StringBuilder(13).append("{\"q\":\"*:*\", ").append(FaultTolerant).append("}").toString()}).setExecutionProfile(pagingDisabled);
                    SimpleStatement queryRequest = (SimpleStatement)SimpleStatement.newInstance((String)request, (Object[])new Object[]{solrStringNoFailoverTolerant}).setExecutionProfile(pagingDisabled);
                    CompletionStage totalFuture = session.executeAsync((Statement)totalRequest);
                    CompletionStage queryFuture = session.executeAsync((Statement)queryRequest);
                    return new Tuple2.mcJJ.sp(((GettableByIndex)((AsyncPagingIterable)totalFuture.toCompletableFuture().get(5L, TimeUnit.SECONDS)).one()).getLong(0), ((GettableByIndex)((AsyncPagingIterable)queryFuture.toCompletableFuture().get(5L, TimeUnit.SECONDS)).one()).getLong(0));
                });
                if (tuple24 == null) {
                    throw new MatchError((Object)tuple24);
                }
                long totalRecords = tuple24._1$mcJ$sp();
                long queryRecords = tuple24._2$mcJ$sp();
                long l = totalRecords;
                long l2 = queryRecords;
                Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(l, l2);
                Tuple2.mcJJ.sp sp3 = sp2;
                long totalRecords2 = sp3._1$mcJ$sp();
                long queryRecords2 = sp3._2$mcJ$sp();
                double d = queryRatio = totalRecords2 == 0L ? 0.0 : (double)queryRecords2 / (double)totalRecords2;
                if (queryRatio > ratio) {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(107).append("Requesting ").append(queryRatio).append(" of the total records. Required to be less than ").append(ratio).append(" for DSE Search, falling back to Full Table Scan").toString());
                    analyzedPredicates3 = predicates;
                } else {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(80).append("Requesting ").append(queryRatio).append(" of the total records. Less than ").append(ratio).append(", using DSE Search Optimized request").toString());
                    analyzedPredicates3 = optimizedPredicates;
                }
                analyzedPredicates2 = analyzedPredicates3;
            } else if (On$.MODULE$.equals(dseSearchOptimizationSetting)) {
                this.logDebug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> SolrPredicateRules.$anonfun$convertToSolrQuery$11(solrConvertibleFilters2, (Filter)combinedSolrFilter)));
                analyzedPredicates2 = optimizedPredicates;
            } else if (Off$.MODULE$.equals(dseSearchOptimizationSetting)) {
                analyzedPredicates2 = predicates;
            } else {
                throw new MatchError((Object)dseSearchOptimizationSetting);
            }
            analyzedPredicates = analyzedPredicates2;
        }
        return analyzedPredicates;
    }

    private String[] escapableWordTokens() {
        return this.escapableWordTokens;
    }

    private String[] escapableChars() {
        return this.escapableChars;
    }

    private String[] escapableWhitespaces() {
        return this.escapableWhitespaces;
    }

    private Pattern escapables() {
        return this.escapables;
    }

    private String[] escapableEntities() {
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[][]{this.escapableWordTokens(), this.escapableChars(), this.escapableWhitespaces()})).flatten((Function1 & Serializable & scala.Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(String.class));
    }

    public String escapeSolrCondition(String condition) {
        Matcher matcher = this.escapables().matcher(condition);
        StringBuilder escaped = package$.MODULE$.StringBuilder().newBuilder();
        int firstUnprocessedCharPosition = 0;
        while (matcher.find()) {
            escaped.append(condition.substring(firstUnprocessedCharPosition, matcher.start()));
            firstUnprocessedCharPosition = matcher.end();
            escaped.append("\\");
            escaped.append(matcher.group());
        }
        escaped.append(condition.substring(firstUnprocessedCharPosition, condition.length()));
        return escaped.toString();
    }

    private final void SolrFilter$lzycompute$1() {
        SolrPredicateRules solrPredicateRules = this;
        synchronized (solrPredicateRules) {
            if (this.SolrFilter$module == null) {
                this.SolrFilter$module = new SolrPredicateRules$SolrFilter$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$apply$2(Node host) {
        NodeDistance nodeDistance = host.getDistance();
        NodeDistance nodeDistance2 = NodeDistance.IGNORED;
        return nodeDistance == null ? nodeDistance2 != null : !nodeDistance.equals(nodeDistance2);
    }

    public static final /* synthetic */ boolean $anonfun$apply$4(Object x$1) {
        return ((Set)x$1).contains("Search");
    }

    public static final /* synthetic */ boolean $anonfun$apply$3(Node host) {
        Option workloads = Option$.MODULE$.apply(host.getExtras().get("DSE_WORKLOADS"));
        return workloads.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SolrPredicateRules.$anonfun$apply$4(x$1)));
    }

    public static final /* synthetic */ boolean $anonfun$apply$1(CqlSession session) {
        Iterable hosts = (Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(session.getMetadata().getNodes().values()).asScala();
        Iterable possibleHosts = (Iterable)hosts.filter((Function1 & Serializable & scala.Serializable)host -> BoxesRunTime.boxToBoolean((boolean)SolrPredicateRules.$anonfun$apply$2(host)));
        return possibleHosts.forall((Function1 & Serializable & scala.Serializable)host -> BoxesRunTime.boxToBoolean((boolean)SolrPredicateRules.$anonfun$apply$3(host)));
    }

    private final scala.collection.immutable.Set solrIndexedFail$1(String str) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(37).append("Retrieval of Solr Index Info Failed: ").append(str).toString());
        return Predef$.MODULE$.Set().empty();
    }

    public static final /* synthetic */ boolean $anonfun$getSolrIndexedColumnsFromSolrXML$5(scala.xml.Node x$3) {
        String string = x$3.label();
        String string2 = "fields";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getSolrIndexedColumnsFromSolrXML$6(scala.xml.Node x) {
        String string = x.label();
        String string2 = "field";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getSolrIndexedColumnsFromSolrXML$7(scala.xml.Node x$4) {
        return !new StringOps(Predef$.MODULE$.augmentString((String)x$4.attributes().asAttrMap().getOrElse((Object)"multiValued", (Function0 & Serializable & scala.Serializable)() -> "false"))).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$getSolrIndexedColumnsFromSolrXML$9(scala.xml.Node x$5) {
        return new StringOps(Predef$.MODULE$.augmentString((String)x$5.attributes().asAttrMap().getOrElse((Object)"indexed", (Function0 & Serializable & scala.Serializable)() -> "false"))).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionKeyRestriction$2(scala.collection.immutable.Set partitionKeyColumnNames$1, EqualTo x0$1) {
        EqualTo equalTo = x0$1;
        if (equalTo == null) {
            throw new MatchError((Object)equalTo);
        }
        String attr = equalTo.attribute();
        boolean bl = partitionKeyColumnNames$1.contains((Object)attr);
        return bl;
    }

    public static final /* synthetic */ String $anonfun$convertToSolrQuery$11(scala.collection.immutable.Set solrConvertibleFilters$1, Filter combinedSolrFilter$1) {
        return new java.lang.StringBuilder(14).append("Converted ").append(solrConvertibleFilters$1).append(" to ").append(combinedSolrFilter$1).toString();
    }

    public SolrPredicateRules(DseSearchOptimizationSetting searchOptimizationEnabled) {
        this.searchOptimizationEnabled = searchOptimizationEnabled;
        Logging.$init$((Logging)this);
        this.escapableWordTokens = (String[])((Object[])new String[]{"AND", "OR", "NOT"});
        this.escapableChars = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])"\\+-!():^[]\"{}~*?|&;/".split(""))).map((Function1 & Serializable & scala.Serializable)ch -> Pattern.quote(ch), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        this.escapableWhitespaces = (String[])((Object[])new String[]{"\\s"});
        this.escapables = Pattern.compile(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.escapableEntities())).mkString("|"));
    }

    public class SolrFilter
    implements Product,
    scala.Serializable {
        private final String solrQuery;
        private final String[] references;
        public final /* synthetic */ SolrPredicateRules $outer;

        public String solrQuery() {
            return this.solrQuery;
        }

        public String[] references() {
            return this.references;
        }

        public SolrFilter copy(String solrQuery, String[] references) {
            return new SolrFilter(this.org$apache$spark$sql$cassandra$SolrPredicateRules$SolrFilter$$$outer(), solrQuery, references);
        }

        public String copy$default$1() {
            return this.solrQuery();
        }

        public String[] copy$default$2() {
            return this.references();
        }

        public String productPrefix() {
            return "SolrFilter";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            String[] stringArray;
            int n = x$1;
            switch (n) {
                case 0: {
                    stringArray = this.solrQuery();
                    break;
                }
                case 1: {
                    stringArray = this.references();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return stringArray;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SolrFilter;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SolrFilter)) return false;
            if (((SolrFilter)object).org$apache$spark$sql$cassandra$SolrPredicateRules$SolrFilter$$$outer() != this.org$apache$spark$sql$cassandra$SolrPredicateRules$SolrFilter$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            SolrFilter solrFilter = (SolrFilter)x$1;
            String string = this.solrQuery();
            String string2 = solrFilter.solrQuery();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.references() != solrFilter.references()) return false;
            if (!solrFilter.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ SolrPredicateRules org$apache$spark$sql$cassandra$SolrPredicateRules$SolrFilter$$$outer() {
            return this.$outer;
        }

        public SolrFilter(SolrPredicateRules $outer, String solrQuery, String[] references) {
            this.solrQuery = solrQuery;
            this.references = references;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

