/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.cassandra;

import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.types.ColumnType;
import com.datastax.spark.connector.types.TimeUUIDType$;
import com.datastax.spark.connector.util.Logging;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.cassandra.AnalyzedPredicates;
import org.apache.spark.sql.cassandra.CassandraPredicateRules;
import org.apache.spark.sql.cassandra.PredicateOps$FilterOps$;
import org.apache.spark.sql.sources.Filter;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class TimeUUIDPredicateRules$
implements CassandraPredicateRules,
Logging {
    public static TimeUUIDPredicateRules$ MODULE$;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    static {
        new TimeUUIDPredicateRules$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    private boolean isTimeUUIDNonEqualPredicate(TableDef tableDef, Filter predicate) {
        boolean bl;
        if (PredicateOps$FilterOps$.MODULE$.isSingleColumnPredicate(predicate)) {
            String columnName = PredicateOps$FilterOps$.MODULE$.columnName(predicate);
            boolean isRange = PredicateOps$FilterOps$.MODULE$.isRangePredicate(predicate);
            boolean isTimeUUID = tableDef.columnByName().get((Object)columnName).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TimeUUIDPredicateRules$.$anonfun$isTimeUUIDNonEqualPredicate$1(x$1)));
            bl = isRange && isTimeUUID;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public AnalyzedPredicates apply(AnalyzedPredicates predicates, TableDef tableDef, SparkConf conf) {
        Set unhandledTimeUUIDNonEqual = (Set)predicates.handledBySpark().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TimeUUIDPredicateRules$.MODULE$.isTimeUUIDNonEqualPredicate(tableDef, x$2)));
        Predef$.MODULE$.require(unhandledTimeUUIDNonEqual.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(568).append("\n         | You are attempting to do a non-equality comparison on a TimeUUID column in Spark.\n         | Spark can only compare TimeUUIDs Lexically which means that the comparison will be\n         | different than the comparison done in C* which is done based on the Time Portion of\n         | TimeUUID. This will in almost all cases lead to incorrect results. If possible restrict\n         | doing a TimeUUID comparison only to columns which can be pushed down to Cassandra.\n         | https://datastax-oss.atlassian.net/browse/SPARKC-405.\n         |\n         | ").append(unhandledTimeUUIDNonEqual).append("\n    ").toString())).stripMargin());
        return predicates;
    }

    public static final /* synthetic */ boolean $anonfun$isTimeUUIDNonEqualPredicate$1(ColumnDef x$1) {
        ColumnType columnType = x$1.columnType();
        TimeUUIDType$ timeUUIDType$ = TimeUUIDType$.MODULE$;
        return !(columnType != null ? !columnType.equals(timeUUIDType$) : timeUUIDType$ != null);
    }

    private TimeUUIDPredicateRules$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

