/*
 * Decompiled with CFR 0.152.
 */
package greycat;

import greycat.Constants;
import greycat.Graph;
import greycat.internal.BlackHoleStorage;
import greycat.internal.CoreGraph;
import greycat.internal.ReadOnlyStorage;
import greycat.plugin.Plugin;
import greycat.plugin.Scheduler;
import greycat.plugin.Storage;
import greycat.scheduler.TrampolineScheduler;

public class GraphBuilder {
    private Storage _storage = null;
    private Scheduler _scheduler = null;
    private Plugin[] _plugins = null;
    private long _memorySize = -1L;
    private boolean _readOnly = false;
    private boolean _deepPriority = true;

    public static GraphBuilder newBuilder() {
        return new GraphBuilder();
    }

    public GraphBuilder withStorage(Storage storage) {
        this._storage = storage;
        return this;
    }

    public GraphBuilder withReadOnlyStorage(Storage storage) {
        this._storage = storage;
        this._readOnly = true;
        return this;
    }

    public GraphBuilder withMemorySize(long numberOfElements) {
        this._memorySize = numberOfElements;
        return this;
    }

    public GraphBuilder withScheduler(Scheduler scheduler) {
        this._scheduler = scheduler;
        return this;
    }

    public GraphBuilder withPlugin(Plugin plugin) {
        if (this._plugins == null) {
            this._plugins = new Plugin[1];
            this._plugins[0] = plugin;
        } else {
            Plugin[] _plugins2 = new Plugin[this._plugins.length + 1];
            System.arraycopy(this._plugins, 0, _plugins2, 0, this._plugins.length);
            _plugins2[this._plugins.length] = plugin;
            this._plugins = _plugins2;
        }
        return this;
    }

    public GraphBuilder withDeepWorld() {
        this._deepPriority = Constants.DEEP_WORLD;
        return this;
    }

    public GraphBuilder withWideWorld() {
        this._deepPriority = Constants.WIDE_WORLD;
        return this;
    }

    public Graph build() {
        if (this._storage == null) {
            this._storage = new BlackHoleStorage();
        }
        if (this._readOnly) {
            this._storage = new ReadOnlyStorage(this._storage);
        }
        if (this._scheduler == null) {
            this._scheduler = new TrampolineScheduler();
        }
        if (this._memorySize == -1L) {
            this._memorySize = 100000L;
        }
        return new CoreGraph(this._storage, this._memorySize, this._scheduler, this._plugins, this._deepPriority);
    }
}

