/*
 * Decompiled with CFR 0.152.
 */
package greycat.base;

import greycat.Callback;
import greycat.Constants;
import greycat.Graph;
import greycat.Node;
import greycat.plugin.NodeDeclaration;
import greycat.plugin.NodeState;
import greycat.plugin.NodeStateCallback;
import greycat.plugin.Resolver;
import greycat.struct.LongLongArrayMap;
import greycat.struct.LongLongArrayMapCallBack;
import greycat.struct.LongLongMap;
import greycat.struct.LongLongMapCallBack;
import greycat.struct.Relation;
import greycat.struct.RelationIndexed;
import greycat.struct.StringIntMap;
import greycat.struct.StringLongMapCallBack;
import java.lang.reflect.Field;
import java.util.HashSet;
import sun.misc.Unsafe;

public class BaseNode
implements Node {
    private static Unsafe unsafe;
    private final long _world;
    private final long _time;
    private final long _id;
    private final Graph _graph;
    protected final Resolver _resolver;
    public volatile long _index_worldOrder = -1L;
    public volatile long _index_superTimeTree = -1L;
    public volatile long _index_timeTree = -1L;
    public volatile long _index_stateChunk = -1L;
    public volatile long _world_magic = -1L;
    public volatile long _super_time_magic = -1L;
    public volatile long _time_magic = -1L;
    public volatile boolean _dead = false;
    private volatile int _lock;
    private static final long _lockOffset;

    public BaseNode(long p_world, long p_time, long p_id, Graph p_graph) {
        this._world = p_world;
        this._time = p_time;
        this._id = p_id;
        this._graph = p_graph;
        this._resolver = p_graph.resolver();
    }

    public final void cacheLock() {
        while (!unsafe.compareAndSwapInt(this, _lockOffset, 0, 1)) {
        }
    }

    public final void cacheUnlock() {
        this._lock = 0;
    }

    public void init() {
    }

    @Override
    public final String nodeTypeName() {
        NodeDeclaration declaration = this.graph().nodeRegistry().declarationByHash(this._resolver.typeCode(this));
        if (declaration != null) {
            return declaration.name();
        }
        return null;
    }

    protected final NodeState unphasedState() {
        return this._resolver.resolveState(this);
    }

    protected final NodeState phasedState() {
        return this._resolver.alignState(this);
    }

    protected final NodeState newState(long time) {
        return this._resolver.newState(this, this._world, time);
    }

    @Override
    public final Graph graph() {
        return this._graph;
    }

    @Override
    public final long world() {
        return this._world;
    }

    @Override
    public final long time() {
        return this._time;
    }

    @Override
    public final long id() {
        return this._id;
    }

    @Override
    public Object get(String name) {
        NodeState resolved = this._resolver.resolveState(this);
        if (resolved != null) {
            return resolved.getAt(this._resolver.stringToHash(name, false));
        }
        return null;
    }

    @Override
    public Object getAt(int propIndex) {
        return this._resolver.resolveState(this).getAt(propIndex);
    }

    @Override
    public Node forceSet(String name, byte type, Object value) {
        return this.forceSetAt(this._resolver.stringToHash(name, true), type, value);
    }

    @Override
    public Node forceSetAt(int index, byte type, Object value) {
        NodeState preciseState = this._resolver.alignState(this);
        if (preciseState == null) {
            throw new RuntimeException("Cache miss error");
        }
        preciseState.setAt(index, type, value);
        return this;
    }

    @Override
    public Node setAt(int index, byte type, Object value) {
        boolean isDiff;
        NodeState unPhasedState = this._resolver.resolveState(this);
        boolean bl = isDiff = type != unPhasedState.typeAt(index);
        if (!isDiff) {
            boolean bl2 = isDiff = !this.isEquals(unPhasedState.getAt(index), value, type);
        }
        if (isDiff) {
            NodeState preciseState = this._resolver.alignState(this);
            if (preciseState != null) {
                preciseState.setAt(index, type, value);
            } else {
                throw new RuntimeException("Cache miss error");
            }
        }
        return this;
    }

    @Override
    public Node set(String name, byte type, Object value) {
        int hashed = this._resolver.stringToHash(name, true);
        return this.setAt(hashed, type, value);
    }

    private boolean isEquals(Object obj1, Object obj2, byte type) {
        switch (type) {
            case 1: {
                return ((Boolean)obj1).booleanValue() == ((Boolean)obj2).booleanValue();
            }
            case 5: {
                return ((Double)obj1).doubleValue() == ((Double)obj2).doubleValue();
            }
            case 4: {
                return ((Integer)obj1).intValue() == ((Integer)obj2).intValue();
            }
            case 3: {
                return ((Long)obj1).longValue() == ((Long)obj2).longValue();
            }
            case 2: {
                return ((String)obj1).equals((String)obj2);
            }
            case 6: {
                double[] obj1_ar_d = (double[])obj1;
                double[] obj2_ar_d = (double[])obj2;
                if (obj1_ar_d.length != obj2_ar_d.length) {
                    return false;
                }
                for (int i = 0; i < obj1_ar_d.length; ++i) {
                    if (obj1_ar_d[i] == obj2_ar_d[i]) continue;
                    return false;
                }
                return true;
            }
            case 8: {
                int[] obj1_ar_i = (int[])obj1;
                int[] obj2_ar_i = (int[])obj2;
                if (obj1_ar_i.length != obj2_ar_i.length) {
                    return false;
                }
                for (int i = 0; i < obj1_ar_i.length; ++i) {
                    if (obj1_ar_i[i] == obj2_ar_i[i]) continue;
                    return false;
                }
                return true;
            }
            case 7: {
                long[] obj1_ar_l = (long[])obj1;
                long[] obj2_ar_l = (long[])obj2;
                if (obj1_ar_l.length != obj2_ar_l.length) {
                    return false;
                }
                for (int i = 0; i < obj1_ar_l.length; ++i) {
                    if (obj1_ar_l[i] == obj2_ar_l[i]) continue;
                    return false;
                }
                return true;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                throw new RuntimeException("Bad API usage: set can't be used with complex type, please use getOrCreate instead.");
            }
        }
        throw new RuntimeException("Not managed type " + type);
    }

    @Override
    public final Object getOrCreate(String name, byte type) {
        return this.getOrCreateAt(this._resolver.stringToHash(name, true), type);
    }

    @Override
    public Object getOrCreateAt(int index, byte type) {
        NodeState preciseState = this._resolver.alignState(this);
        if (preciseState != null) {
            return preciseState.getOrCreateAt(index, type);
        }
        throw new RuntimeException("Cache miss error");
    }

    @Override
    public <A> A getWithDefault(String key, A defaultValue) {
        return this._resolver.alignState(this).getWithDefault(key, defaultValue);
    }

    @Override
    public <A> A getAtWithDefault(int key, A defaultValue) {
        return this._resolver.alignState(this).getAtWithDefault(key, defaultValue);
    }

    @Override
    public byte type(String name) {
        NodeState resolved = this._resolver.resolveState(this);
        if (resolved != null) {
            return resolved.typeAt(this._resolver.stringToHash(name, false));
        }
        return -1;
    }

    @Override
    public byte typeAt(int index) {
        NodeState resolved = this._resolver.resolveState(this);
        if (resolved != null) {
            return resolved.typeAt(index);
        }
        return -1;
    }

    @Override
    public final Node remove(String name) {
        return this.set(name, (byte)4, null);
    }

    @Override
    public final Node removeAt(int index) {
        return this.setAt(index, (byte)4, null);
    }

    @Override
    public final void relation(String relationName, Callback<Node[]> callback) {
        this.relationAt(this._resolver.stringToHash(relationName, false), callback);
    }

    @Override
    public void relationAt(int relationIndex, final Callback<Node[]> callback) {
        if (callback == null) {
            return;
        }
        NodeState resolved = this._resolver.resolveState(this);
        if (resolved != null) {
            switch (resolved.typeAt(relationIndex)) {
                case 13: {
                    Relation relation = (Relation)resolved.getAt(relationIndex);
                    if (relation == null || relation.size() == 0) {
                        callback.on(new Node[0]);
                        break;
                    }
                    int relSize = relation.size();
                    long[] ids = new long[relSize];
                    for (int i = 0; i < relSize; ++i) {
                        ids[i] = relation.get(i);
                    }
                    this._resolver.lookupAll(this._world, this._time, ids, new Callback<Node[]>(){

                        @Override
                        public void on(Node[] result) {
                            callback.on(result);
                        }
                    });
                    break;
                }
                case 14: {
                    RelationIndexed relation_indexed = (RelationIndexed)resolved.getAt(relationIndex);
                    if (relation_indexed == null || relation_indexed.size() == 0) {
                        callback.on(new Node[0]);
                        break;
                    }
                    this._resolver.lookupAll(this._world, this._time, relation_indexed.all(), new Callback<Node[]>(){

                        @Override
                        public void on(Node[] result) {
                            callback.on(result);
                        }
                    });
                    break;
                }
                default: {
                    callback.on(new Node[0]);
                    break;
                }
            }
        } else {
            callback.on(new Node[0]);
        }
    }

    @Override
    public final Node addToRelation(String relationName, Node relatedNode, String ... attributes) {
        return this.addToRelationAt(this._resolver.stringToHash(relationName, true), relatedNode, attributes);
    }

    @Override
    public Node addToRelationAt(int relationIndex, Node relatedNode, String ... attributes) {
        if (relatedNode != null) {
            NodeState preciseState = this._resolver.alignState(this);
            if (preciseState != null) {
                boolean attributesNotEmpty;
                boolean bl = attributesNotEmpty = attributes != null && attributes.length > 0;
                if (attributesNotEmpty) {
                    RelationIndexed indexedRel = (RelationIndexed)preciseState.getOrCreateAt(relationIndex, (byte)14);
                    indexedRel.add(relatedNode, attributes);
                } else {
                    Relation relationArray = (Relation)preciseState.getOrCreateAt(relationIndex, (byte)13);
                    relationArray.add(relatedNode.id());
                }
            } else {
                throw new RuntimeException("Cache miss error");
            }
        }
        return this;
    }

    @Override
    public final Node removeFromRelation(String relationName, Node relatedNode, String ... attributes) {
        return this.removeFromRelationAt(this._resolver.stringToHash(relationName, false), relatedNode, attributes);
    }

    @Override
    public Node removeFromRelationAt(int relationIndex, Node relatedNode, String ... attributes) {
        if (relatedNode != null) {
            NodeState preciseState = this._resolver.alignState(this);
            if (preciseState != null) {
                boolean attributesNotEmpty;
                boolean bl = attributesNotEmpty = attributes != null && attributes.length > 0;
                if (attributesNotEmpty) {
                    RelationIndexed indexedRel = (RelationIndexed)preciseState.getOrCreateAt(relationIndex, (byte)14);
                    indexedRel.remove(relatedNode, attributes);
                } else {
                    Relation relationArray = (Relation)preciseState.getOrCreateAt(relationIndex, (byte)13);
                    relationArray.remove(relatedNode.id());
                }
            } else {
                throw new RuntimeException("Cache miss error");
            }
        }
        return this;
    }

    @Override
    public final void free() {
        this._resolver.freeNode(this);
    }

    @Override
    public final long timeDephasing() {
        NodeState state = this._resolver.resolveState(this);
        if (state != null) {
            return this._time - state.time();
        }
        throw new RuntimeException("Cache miss error");
    }

    @Override
    public final long lastModification() {
        NodeState state = this._resolver.resolveState(this);
        if (state != null) {
            return state.time();
        }
        throw new RuntimeException("Cache miss error");
    }

    @Override
    public final Node rephase() {
        this._resolver.alignState(this);
        return this;
    }

    @Override
    public final void timepoints(long beginningOfSearch, long endOfSearch, Callback<long[]> callback) {
        this._resolver.resolveTimepoints(this, beginningOfSearch, endOfSearch, callback);
    }

    @Override
    public final <A extends Node> void travelInTime(long targetTime, Callback<A> callback) {
        this._resolver.lookup(this._world, targetTime, this._id, callback);
    }

    @Override
    public final Node setTimeSensitivity(long deltaTime, long offset) {
        this._resolver.setTimeSensitivity(this, deltaTime, offset);
        return this;
    }

    @Override
    public final long[] timeSensitivity() {
        return this._resolver.getTimeSensitivity(this);
    }

    public String toString() {
        final StringBuilder builder = new StringBuilder();
        final boolean[] isFirst = new boolean[]{true};
        builder.append("{\"world\":");
        builder.append(this.world());
        builder.append(",\"time\":");
        builder.append(this.time());
        builder.append(",\"id\":");
        builder.append(this.id());
        NodeState state = this._resolver.resolveState(this);
        if (state != null) {
            state.each(new NodeStateCallback(){

                @Override
                public void on(int attributeKey, byte elemType, Object elem) {
                    if (elem != null) {
                        String resolveName = BaseNode.this._resolver.hashToString(attributeKey);
                        if (resolveName == null) {
                            resolveName = attributeKey + "";
                        }
                        switch (elemType) {
                            case 1: {
                                builder.append(",\"");
                                builder.append(resolveName);
                                builder.append("\":");
                                if (((Boolean)elem).booleanValue()) {
                                    builder.append("1");
                                    break;
                                }
                                builder.append("0");
                                break;
                            }
                            case 2: {
                                builder.append(",\"");
                                builder.append(resolveName);
                                builder.append("\":");
                                builder.append("\"");
                                builder.append(elem);
                                builder.append("\"");
                                break;
                            }
                            case 3: {
                                builder.append(",\"");
                                builder.append(resolveName);
                                builder.append("\":");
                                builder.append(elem);
                                break;
                            }
                            case 4: {
                                builder.append(",\"");
                                builder.append(resolveName);
                                builder.append("\":");
                                builder.append(elem);
                                break;
                            }
                            case 5: {
                                if (Constants.isNaN((Double)elem)) break;
                                builder.append(",\"");
                                builder.append(resolveName);
                                builder.append("\":");
                                builder.append(elem);
                                break;
                            }
                            case 6: {
                                builder.append(",\"");
                                builder.append(resolveName);
                                builder.append("\":");
                                builder.append("[");
                                double[] castedArr = (double[])elem;
                                for (int j = 0; j < castedArr.length; ++j) {
                                    if (j != 0) {
                                        builder.append(",");
                                    }
                                    builder.append(castedArr[j]);
                                }
                                builder.append("]");
                                break;
                            }
                            case 13: {
                                builder.append(",\"");
                                builder.append(resolveName);
                                builder.append("\":");
                                builder.append("[");
                                Relation castedRelArr = (Relation)elem;
                                for (int j = 0; j < castedRelArr.size(); ++j) {
                                    if (j != 0) {
                                        builder.append(",");
                                    }
                                    builder.append(castedRelArr.get(j));
                                }
                                builder.append("]");
                                break;
                            }
                            case 7: {
                                builder.append(",\"");
                                builder.append(resolveName);
                                builder.append("\":");
                                builder.append("[");
                                long[] castedArr2 = (long[])elem;
                                for (int j = 0; j < castedArr2.length; ++j) {
                                    if (j != 0) {
                                        builder.append(",");
                                    }
                                    builder.append(castedArr2[j]);
                                }
                                builder.append("]");
                                break;
                            }
                            case 8: {
                                builder.append(",\"");
                                builder.append(resolveName);
                                builder.append("\":");
                                builder.append("[");
                                int[] castedArr3 = (int[])elem;
                                for (int j = 0; j < castedArr3.length; ++j) {
                                    if (j != 0) {
                                        builder.append(",");
                                    }
                                    builder.append(castedArr3[j]);
                                }
                                builder.append("]");
                                break;
                            }
                            case 10: {
                                builder.append(",\"");
                                builder.append(resolveName);
                                builder.append("\":");
                                builder.append("{");
                                LongLongMap castedMapL2L = (LongLongMap)elem;
                                isFirst[0] = true;
                                castedMapL2L.each(new LongLongMapCallBack(){

                                    @Override
                                    public void on(long key, long value) {
                                        if (!isFirst[0]) {
                                            builder.append(",");
                                        } else {
                                            isFirst[0] = false;
                                        }
                                        builder.append("\"");
                                        builder.append(key);
                                        builder.append("\":");
                                        builder.append(value);
                                    }
                                });
                                builder.append("}");
                                break;
                            }
                            case 11: 
                            case 14: {
                                builder.append(",\"");
                                builder.append(resolveName);
                                builder.append("\":");
                                builder.append("{");
                                LongLongArrayMap castedMapL2LA = (LongLongArrayMap)elem;
                                isFirst[0] = true;
                                final HashSet keys = new HashSet();
                                castedMapL2LA.each(new LongLongArrayMapCallBack(){

                                    @Override
                                    public void on(long key, long value) {
                                        keys.add(key);
                                    }
                                });
                                Long[] flatKeys = keys.toArray(new Long[keys.size()]);
                                for (int i = 0; i < flatKeys.length; ++i) {
                                    long[] values = castedMapL2LA.get(flatKeys[i]);
                                    if (!isFirst[0]) {
                                        builder.append(",");
                                    } else {
                                        isFirst[0] = false;
                                    }
                                    builder.append("\"");
                                    builder.append(flatKeys[i]);
                                    builder.append("\":[");
                                    for (int j = 0; j < values.length; ++j) {
                                        if (j != 0) {
                                            builder.append(",");
                                        }
                                        builder.append(values[j]);
                                    }
                                    builder.append("]");
                                }
                                builder.append("}");
                                break;
                            }
                            case 12: {
                                builder.append(",\"");
                                builder.append(resolveName);
                                builder.append("\":");
                                builder.append("{");
                                StringIntMap castedMapS2L = (StringIntMap)elem;
                                isFirst[0] = true;
                                castedMapS2L.each(new StringLongMapCallBack(){

                                    @Override
                                    public void on(String key, long value) {
                                        if (!isFirst[0]) {
                                            builder.append(",");
                                        } else {
                                            isFirst[0] = false;
                                        }
                                        builder.append("\"");
                                        builder.append(key);
                                        builder.append("\":");
                                        builder.append(value);
                                    }
                                });
                                builder.append("}");
                                break;
                            }
                        }
                    }
                }
            });
            builder.append("}");
        }
        return builder.toString();
    }

    static {
        if (unsafe == null) {
            try {
                Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafe.setAccessible(true);
                unsafe = (Unsafe)theUnsafe.get(null);
            }
            catch (Exception e) {
                throw new RuntimeException("ERROR: unsafe operations are not available");
            }
        }
        try {
            _lockOffset = unsafe.objectFieldOffset(BaseNode.class.getDeclaredField("_lock"));
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }
}

