/*
 * Decompiled with CFR 0.152.
 */
package greycat.base;

import greycat.Node;
import greycat.TaskResult;
import greycat.TaskResultIterator;
import greycat.base.BaseNode;
import greycat.base.BaseTaskResultIterator;
import greycat.internal.heap.HeapBuffer;
import greycat.internal.task.TaskHelper;
import java.util.ArrayList;

public class BaseTaskResult<A>
implements TaskResult<A> {
    private Object[] _backend;
    private int _capacity = 0;
    private int _size = 0;
    Exception _exception = null;
    String _output = null;

    @Override
    public Object[] asArray() {
        Object[] flat = new Object[this._size];
        if (this._backend != null) {
            System.arraycopy(this._backend, 0, flat, 0, this._size);
        }
        return flat;
    }

    @Override
    public Exception exception() {
        return this._exception;
    }

    @Override
    public String output() {
        return this._output;
    }

    @Override
    public final TaskResult<A> setException(Exception e) {
        this._exception = e;
        return this;
    }

    @Override
    public final TaskResult<A> setOutput(String output) {
        this._output = output;
        return this;
    }

    @Override
    public TaskResult<A> fillWith(TaskResult<A> source) {
        if (source != null) {
            this._backend = source.asArray();
            this._capacity = this._backend.length;
            this._size = this._backend.length;
        }
        return this;
    }

    public BaseTaskResult(Object toWrap, boolean protect) {
        if (toWrap instanceof Object[]) {
            Object[] castedToWrap = (Object[])toWrap;
            this._capacity = this._size = ((Object[])toWrap).length;
            this._backend = new Object[this._size];
            if (protect) {
                for (int i = 0; i < this._size; ++i) {
                    Object loopObj = castedToWrap[i];
                    if (loopObj instanceof BaseNode) {
                        Node loopNode = (Node)loopObj;
                        this._backend[i] = loopNode.graph().cloneNode(loopNode);
                        continue;
                    }
                    this._backend[i] = loopObj;
                }
            } else {
                System.arraycopy(castedToWrap, 0, this._backend, 0, this._size);
            }
        } else if (toWrap instanceof long[]) {
            long[] castedOther = (long[])toWrap;
            this._backend = new Object[castedOther.length];
            for (int i = 0; i < castedOther.length; ++i) {
                this._backend[i] = castedOther[i];
            }
            this._size = this._capacity = this._backend.length;
        } else if (toWrap instanceof int[]) {
            int[] castedOther = (int[])toWrap;
            this._backend = new Object[castedOther.length];
            for (int i = 0; i < castedOther.length; ++i) {
                this._backend[i] = castedOther[i];
            }
            this._size = this._capacity = this._backend.length;
        } else if (toWrap instanceof double[]) {
            double[] castedOther = (double[])toWrap;
            this._backend = new Object[castedOther.length];
            for (int i = 0; i < castedOther.length; ++i) {
                this._backend[i] = castedOther[i];
            }
            this._size = this._capacity = this._backend.length;
        } else if (toWrap instanceof ArrayList) {
            ArrayList castedOtherList = (ArrayList)toWrap;
            this._backend = new Object[castedOtherList.size()];
            for (int i = 0; i < castedOtherList.size(); ++i) {
                this._backend[i] = castedOtherList.get(i);
            }
            this._size = this._capacity = this._backend.length;
        } else if (toWrap instanceof BaseTaskResult) {
            BaseTaskResult other = (BaseTaskResult)toWrap;
            this._size = other._size;
            this._capacity = other._capacity;
            if (other._backend != null) {
                this._backend = new Object[other._backend.length];
                if (protect) {
                    for (int i = 0; i < this._size; ++i) {
                        Object loopObj = other._backend[i];
                        if (loopObj instanceof BaseNode) {
                            Node loopNode = (Node)loopObj;
                            this._backend[i] = loopNode.graph().cloneNode(loopNode);
                            continue;
                        }
                        this._backend[i] = loopObj;
                    }
                } else {
                    System.arraycopy(other._backend, 0, this._backend, 0, this._size);
                }
            }
        } else if (toWrap != null) {
            this._backend = new Object[1];
            this._capacity = 1;
            this._size = 1;
            if (toWrap instanceof BaseNode) {
                Node toWrapNode = (Node)toWrap;
                this._backend[0] = protect ? toWrapNode.graph().cloneNode(toWrapNode) : toWrapNode;
            } else {
                this._backend[0] = toWrap;
            }
        }
    }

    @Override
    public TaskResultIterator iterator() {
        return new BaseTaskResultIterator(this._backend);
    }

    @Override
    public A get(int index) {
        if (index < this._size) {
            return (A)this._backend[index];
        }
        return null;
    }

    @Override
    public TaskResult<A> set(int index, A input) {
        if (index >= this._capacity) {
            this.extendTil(index);
        }
        this._backend[index] = input;
        if (index >= this._size) {
            ++this._size;
        }
        return this;
    }

    @Override
    public TaskResult<A> allocate(int index) {
        if (index >= this._capacity) {
            if (this._backend == null) {
                this._backend = new Object[index];
                this._capacity = index;
            } else {
                throw new RuntimeException("Not implemented yet!!!");
            }
        }
        return this;
    }

    @Override
    public TaskResult<A> add(A input) {
        if (this._size >= this._capacity) {
            this.extendTil(this._size);
        }
        this.set(this._size, input);
        return this;
    }

    @Override
    public TaskResult<A> clear() {
        this._backend = null;
        this._capacity = 0;
        this._size = 0;
        return this;
    }

    @Override
    public TaskResult<A> clone() {
        return new BaseTaskResult<A>(this, true);
    }

    @Override
    public void free() {
        for (int i = 0; i < this._capacity; ++i) {
            if (!(this._backend[i] instanceof BaseNode)) continue;
            ((Node)this._backend[i]).free();
        }
    }

    @Override
    public int size() {
        return this._size;
    }

    private synchronized void extendTil(int index) {
        if (this._capacity <= index) {
            int newCapacity = this._capacity * 2;
            if (newCapacity <= index) {
                newCapacity = index + 1;
            }
            Object[] extendedBackend = new Object[newCapacity];
            if (this._backend != null) {
                System.arraycopy(this._backend, 0, extendedBackend, 0, this._size);
            }
            this._backend = extendedBackend;
            this._capacity = newCapacity;
        }
    }

    public String toString() {
        return this.toJson(true);
    }

    private String toJson(boolean withContent) {
        HeapBuffer builder = new HeapBuffer();
        boolean isFirst = true;
        builder.writeString("{");
        if (this._exception != null) {
            isFirst = false;
            builder.writeString("\"error\":");
            TaskHelper.serializeString(this._exception.getMessage(), builder, false);
        }
        if (this._output != null) {
            if (!isFirst) {
                builder.writeString(",");
            } else {
                isFirst = false;
            }
            builder.writeString("\"output\":");
            TaskHelper.serializeString(this._output, builder, false);
        }
        if (this._size > 0) {
            if (!isFirst) {
                builder.writeString(",");
            }
            builder.writeString("\"result\":[");
            for (int i = 0; i < this._size; ++i) {
                String saved;
                Object loop;
                if (i != 0) {
                    builder.writeString(",");
                }
                if ((loop = this._backend[i]) == null || (saved = loop.toString()).length() <= 0) continue;
                if (saved.charAt(0) == '{' || saved.charAt(0) == '[') {
                    builder.writeString(saved);
                    continue;
                }
                TaskHelper.serializeString(saved, builder, false);
            }
            builder.writeString("]");
        }
        builder.writeString("}");
        return ((Object)builder).toString();
    }
}

