/*
 * Decompiled with CFR 0.152.
 */
package greycat.base;

import greycat.TaskResultIterator;
import greycat.utility.Tuple;
import java.util.concurrent.atomic.AtomicInteger;

class BaseTaskResultIterator<A>
implements TaskResultIterator<A> {
    private final Object[] _backend;
    private final int _size;
    private final AtomicInteger _current = new AtomicInteger(0);

    BaseTaskResultIterator(Object[] p_backend) {
        this._backend = p_backend != null ? p_backend : new Object[0];
        this._size = this._backend.length;
    }

    @Override
    public final A next() {
        int cursor = this._current.getAndIncrement();
        if (cursor < this._size) {
            return (A)this._backend[cursor];
        }
        return null;
    }

    @Override
    public final Tuple<Integer, A> nextWithIndex() {
        int cursor = this._current.getAndIncrement();
        if (cursor < this._size) {
            if (this._backend[cursor] != null) {
                return new Tuple<Integer, Object>(cursor, this._backend[cursor]);
            }
            return null;
        }
        return null;
    }
}

