/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal;

import greycat.Callback;
import greycat.DeferCounter;
import greycat.plugin.Job;
import java.util.concurrent.atomic.AtomicInteger;

public class CoreDeferCounter
implements DeferCounter {
    private final AtomicInteger _nb_down;
    private final int _counter;
    private Job _end;

    public CoreDeferCounter(int nb) {
        this._counter = nb;
        this._nb_down = new AtomicInteger(0);
    }

    @Override
    public void count() {
        int next;
        int previous;
        while (!this._nb_down.compareAndSet(previous = this._nb_down.get(), next = previous + 1)) {
        }
        if (next == this._counter && this._end != null) {
            this._end.run();
        }
    }

    @Override
    public int getCount() {
        return this._nb_down.get();
    }

    @Override
    public void then(Job p_callback) {
        this._end = p_callback;
        if (this._nb_down.get() == this._counter && p_callback != null) {
            p_callback.run();
        }
    }

    @Override
    public Callback wrap() {
        return new Callback(){

            public void on(Object result) {
                CoreDeferCounter.this.count();
            }
        };
    }
}

