/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal;

import greycat.Callback;
import greycat.DeferCounterSync;
import greycat.plugin.Job;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;

public class CoreDeferCounterSync
implements DeferCounterSync {
    private final AtomicInteger _nb_down;
    private final int _counter;
    private final CountDownLatch _latch;
    private Job _end;
    private Object _result = null;

    public CoreDeferCounterSync(int nb) {
        this._counter = nb;
        this._nb_down = new AtomicInteger(0);
        this._latch = new CountDownLatch(nb);
    }

    @Override
    public void count() {
        int next;
        int previous;
        this._latch.countDown();
        while (!this._nb_down.compareAndSet(previous = this._nb_down.get(), next = previous + 1)) {
        }
        if (next == this._counter && this._end != null) {
            this._end.run();
        }
    }

    @Override
    public int getCount() {
        return this._nb_down.get();
    }

    @Override
    public void then(Job p_callback) {
        this._end = p_callback;
        if (this._nb_down.get() == this._counter && p_callback != null) {
            p_callback.run();
        }
    }

    @Override
    public Callback wrap() {
        return new Callback(){

            public void on(Object result) {
                CoreDeferCounterSync.this._result = result;
                CoreDeferCounterSync.this.count();
            }
        };
    }

    @Override
    public Object waitResult() {
        if (this._nb_down.get() == this._counter) {
            return this._result;
        }
        try {
            this._latch.await();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this._result;
    }
}

