/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal;

import greycat.Callback;
import greycat.DeferCounter;
import greycat.DeferCounterSync;
import greycat.Graph;
import greycat.Node;
import greycat.NodeIndex;
import greycat.Query;
import greycat.TaskHook;
import greycat.base.BaseNode;
import greycat.chunk.ChunkSpace;
import greycat.chunk.GenChunk;
import greycat.chunk.StateChunk;
import greycat.chunk.WorldOrderChunk;
import greycat.internal.CoreConstants;
import greycat.internal.CoreDeferCounter;
import greycat.internal.CoreDeferCounterSync;
import greycat.internal.CoreNodeIndex;
import greycat.internal.CoreNodeRegistry;
import greycat.internal.CoreQuery;
import greycat.internal.MWResolver;
import greycat.internal.heap.HeapMemoryFactory;
import greycat.internal.task.CoreActionRegistry;
import greycat.internal.task.CoreTask;
import greycat.internal.tree.KDTreeNode;
import greycat.internal.tree.NDTreeNode;
import greycat.plugin.ActionRegistry;
import greycat.plugin.MemoryFactory;
import greycat.plugin.NodeDeclaration;
import greycat.plugin.NodeFactory;
import greycat.plugin.NodeRegistry;
import greycat.plugin.Plugin;
import greycat.plugin.Resolver;
import greycat.plugin.Scheduler;
import greycat.plugin.Storage;
import greycat.struct.Buffer;
import greycat.struct.BufferIterator;
import greycat.struct.LongLongMap;
import greycat.struct.LongLongMapCallBack;
import greycat.utility.Base64;
import greycat.utility.HashHelper;
import greycat.utility.KeyHelper;
import java.util.concurrent.atomic.AtomicBoolean;

public class CoreGraph
implements Graph {
    private final Storage _storage;
    private final ChunkSpace _space;
    private final Scheduler _scheduler;
    private final Resolver _resolver;
    private final AtomicBoolean _isConnected;
    private final AtomicBoolean _lock;
    private final Plugin[] _plugins;
    private Short _prefix = null;
    private GenChunk _nodeKeyCalculator = null;
    private GenChunk _worldKeyCalculator = null;
    private final ActionRegistry _actionRegistry = new CoreActionRegistry();
    private final NodeRegistry _nodeRegistry = new CoreNodeRegistry();
    private MemoryFactory _memoryFactory = new HeapMemoryFactory();
    private TaskHook[] _taskHooks;

    public CoreGraph(Storage p_storage, long memorySize, Scheduler p_scheduler, Plugin[] p_plugins, boolean deepPriority) {
        this._isConnected = new AtomicBoolean(false);
        this._lock = new AtomicBoolean(false);
        this._plugins = p_plugins;
        CoreGraph selfPointer = this;
        TaskHook[] temp_hooks = new TaskHook[]{};
        if (p_plugins != null) {
            for (int i = 0; i < p_plugins.length; ++i) {
                Plugin loopPlugin = p_plugins[i];
                loopPlugin.start(this);
            }
        }
        this._taskHooks = temp_hooks;
        this._storage = p_storage;
        this._space = this._memoryFactory.newSpace(memorySize, selfPointer, deepPriority);
        this._resolver = new MWResolver(this._storage, this._space, selfPointer);
        this._scheduler = p_scheduler;
        CoreTask.fillDefault(this._actionRegistry);
        this._nodeRegistry.declaration("NodeIndex").setFactory(new NodeFactory(){

            @Override
            public Node create(long world, long time, long id, Graph graph) {
                return new CoreNodeIndex(world, time, id, graph);
            }
        });
        this._nodeRegistry.declaration(KDTreeNode.NAME).setFactory(new NodeFactory(){

            @Override
            public Node create(long world, long time, long id, Graph graph) {
                return new KDTreeNode(world, time, id, graph);
            }
        });
        this._nodeRegistry.declaration(NDTreeNode.NAME).setFactory(new NodeFactory(){

            @Override
            public Node create(long world, long time, long id, Graph graph) {
                return new NDTreeNode(world, time, id, graph);
            }
        });
    }

    @Override
    public long fork(long world) {
        long childWorld = this._worldKeyCalculator.newKey();
        this._resolver.initWorld(world, childWorld);
        return childWorld;
    }

    @Override
    public Node newNode(long world, long time) {
        if (!this._isConnected.get()) {
            throw new RuntimeException("Please connect your graph, prior to any usage of it");
        }
        BaseNode newNode = new BaseNode(world, time, this._nodeKeyCalculator.newKey(), this);
        this._resolver.initNode(newNode, 0x1FFFFFFFFFFFFFL);
        return newNode;
    }

    @Override
    public Node newTypedNode(long world, long time, String nodeType) {
        BaseNode newNode;
        if (nodeType == null) {
            throw new RuntimeException("nodeType should not be null");
        }
        if (!this._isConnected.get()) {
            throw new RuntimeException("Please connect your graph, prior to any usage of it");
        }
        int extraCode = this._resolver.stringToHash(nodeType, false);
        NodeFactory resolvedFactory = this.factoryByCode(extraCode);
        if (resolvedFactory == null) {
            System.out.println("WARNING: UnKnow NodeType " + nodeType + ", missing plugin configuration in the builder ? Using generic node as a fallback");
            newNode = new BaseNode(world, time, this._nodeKeyCalculator.newKey(), this);
        } else {
            newNode = (BaseNode)resolvedFactory.create(world, time, this._nodeKeyCalculator.newKey(), this);
        }
        this._resolver.initNode(newNode, extraCode);
        return newNode;
    }

    @Override
    public Node cloneNode(Node origin) {
        if (origin == null) {
            throw new RuntimeException("origin node should not be null");
        }
        if (!this._isConnected.get()) {
            throw new RuntimeException("Please connect your graph, prior to any usage of it");
        }
        BaseNode casted = (BaseNode)origin;
        casted.cacheLock();
        if (casted._dead) {
            casted.cacheUnlock();
            throw new RuntimeException(CoreConstants.DEAD_NODE_ERROR + " node id: " + casted.id());
        }
        this._space.mark(casted._index_stateChunk);
        this._space.mark(casted._index_superTimeTree);
        this._space.mark(casted._index_timeTree);
        this._space.mark(casted._index_worldOrder);
        WorldOrderChunk worldOrderChunk = (WorldOrderChunk)this._space.get(casted._index_worldOrder);
        NodeFactory resolvedFactory = this.factoryByCode((int)worldOrderChunk.extra());
        BaseNode newNode = resolvedFactory == null ? new BaseNode(origin.world(), origin.time(), origin.id(), this) : (BaseNode)resolvedFactory.create(origin.world(), origin.time(), origin.id(), this);
        newNode._index_stateChunk = casted._index_stateChunk;
        newNode._index_timeTree = casted._index_timeTree;
        newNode._index_superTimeTree = casted._index_superTimeTree;
        newNode._index_worldOrder = casted._index_worldOrder;
        newNode._world_magic = casted._world_magic;
        newNode._super_time_magic = casted._super_time_magic;
        newNode._time_magic = casted._time_magic;
        casted.cacheUnlock();
        return newNode;
    }

    NodeFactory factoryByCode(int code) {
        NodeDeclaration declaration = this._nodeRegistry.declarationByHash(code);
        if (declaration != null) {
            return declaration.factory();
        }
        return null;
    }

    @Override
    public TaskHook[] taskHooks() {
        return this._taskHooks;
    }

    @Override
    public ActionRegistry actionRegistry() {
        return this._actionRegistry;
    }

    @Override
    public NodeRegistry nodeRegistry() {
        return this._nodeRegistry;
    }

    @Override
    public final Graph setMemoryFactory(MemoryFactory factory) {
        if (this._isConnected.get()) {
            throw new RuntimeException("Memory factory cannot be changed after connection !");
        }
        this._memoryFactory = factory;
        return this;
    }

    @Override
    public final synchronized Graph addGlobalTaskHook(TaskHook newTaskHook) {
        if (this._taskHooks == null) {
            this._taskHooks = new TaskHook[1];
            this._taskHooks[0] = newTaskHook;
        } else {
            TaskHook[] temp_temp_hooks = new TaskHook[this._taskHooks.length + 1];
            System.arraycopy(this._taskHooks, 0, temp_temp_hooks, 0, this._taskHooks.length);
            temp_temp_hooks[this._taskHooks.length] = newTaskHook;
            this._taskHooks = temp_temp_hooks;
        }
        return this;
    }

    @Override
    public <A extends Node> void lookup(long world, long time, long id, Callback<A> callback) {
        if (!this._isConnected.get()) {
            throw new RuntimeException("Please connect your graph, prior to any usage of it");
        }
        this._resolver.lookup(world, time, id, callback);
    }

    @Override
    public void lookupBatch(long[] worlds, long[] times, long[] ids, Callback<Node[]> callback) {
        if (!this._isConnected.get()) {
            throw new RuntimeException("Please connect your graph, prior to any usage of it");
        }
        this._resolver.lookupBatch(worlds, times, ids, callback);
    }

    @Override
    public void lookupAll(long world, long time, long[] ids, Callback<Node[]> callback) {
        if (!this._isConnected.get()) {
            throw new RuntimeException("Please connect your graph, prior to any usage of it");
        }
        this._resolver.lookupAll(world, time, ids, callback);
    }

    @Override
    public void lookupTimes(long world, long from, long to, long id, Callback<Node[]> callback) {
        if (!this._isConnected.get()) {
            throw new RuntimeException("Please connect your graph, prior to any usage of it");
        }
        this._resolver.lookupTimes(world, from, to, id, callback);
    }

    @Override
    public void lookupAllTimes(long world, long from, long to, long[] ids, Callback<Node[]> callback) {
        if (!this._isConnected.get()) {
            throw new RuntimeException("Please connect your graph, prior to any usage of it");
        }
        this._resolver.lookupAllTimes(world, from, to, ids, callback);
    }

    @Override
    public void save(Callback<Boolean> callback) {
        this._space.save(callback);
    }

    @Override
    public void connect(final Callback<Boolean> callback) {
        final CoreGraph selfPointer = this;
        while (selfPointer._lock.compareAndSet(false, true)) {
        }
        if (this._isConnected.compareAndSet(false, true)) {
            selfPointer._scheduler.start();
            selfPointer._storage.connect(selfPointer, new Callback<Boolean>(){

                @Override
                public void on(Boolean connection) {
                    selfPointer._storage.lock(new Callback<Buffer>(){

                        @Override
                        public void on(Buffer prefixBuf) {
                            CoreGraph.this._prefix = (short)Base64.decodeToIntWithBounds(prefixBuf, 0L, prefixBuf.length());
                            prefixBuf.free();
                            final Buffer connectionKeys = selfPointer.newBuffer();
                            KeyHelper.keyToBuffer(connectionKeys, (byte)3, -9007199254740990L, 0x1FFFFFFFFFFFFFL, CoreGraph.this._prefix.shortValue());
                            connectionKeys.write((byte)35);
                            KeyHelper.keyToBuffer(connectionKeys, (byte)3, 0x1FFFFFFFFFFFFEL, 0x1FFFFFFFFFFFFFL, CoreGraph.this._prefix.shortValue());
                            connectionKeys.write((byte)35);
                            KeyHelper.keyToBuffer(connectionKeys, (byte)2, 0L, 0L, 0x1FFFFFFFFFFFFFL);
                            connectionKeys.write((byte)35);
                            KeyHelper.keyToBuffer(connectionKeys, (byte)0, CoreConstants.GLOBAL_DICTIONARY_KEY[0], CoreConstants.GLOBAL_DICTIONARY_KEY[1], CoreConstants.GLOBAL_DICTIONARY_KEY[2]);
                            connectionKeys.write((byte)35);
                            selfPointer._storage.get(connectionKeys, new Callback<Buffer>(){

                                @Override
                                public void on(Buffer payloads) {
                                    connectionKeys.free();
                                    if (payloads != null) {
                                        BufferIterator it = payloads.iterator();
                                        Buffer view1 = it.next();
                                        Buffer view2 = it.next();
                                        Buffer view3 = it.next();
                                        Buffer view4 = it.next();
                                        Boolean noError = true;
                                        try {
                                            WorldOrderChunk globalWorldOrder = (WorldOrderChunk)selfPointer._space.createAndMark((byte)2, 0L, 0L, 0x1FFFFFFFFFFFFFL);
                                            if (view3.length() > 0L) {
                                                globalWorldOrder.load(view3);
                                            }
                                            StateChunk globalDictionaryChunk = (StateChunk)selfPointer._space.createAndMark((byte)0, CoreConstants.GLOBAL_DICTIONARY_KEY[0], CoreConstants.GLOBAL_DICTIONARY_KEY[1], CoreConstants.GLOBAL_DICTIONARY_KEY[2]);
                                            if (view4.length() > 0L) {
                                                globalDictionaryChunk.load(view4);
                                            }
                                            selfPointer._worldKeyCalculator = (GenChunk)selfPointer._space.createAndMark((byte)3, 0x1FFFFFFFFFFFFEL, 0x1FFFFFFFFFFFFFL, CoreGraph.this._prefix.shortValue());
                                            if (view2.length() > 0L) {
                                                selfPointer._worldKeyCalculator.load(view2);
                                            }
                                            selfPointer._nodeKeyCalculator = (GenChunk)selfPointer._space.createAndMark((byte)3, -9007199254740990L, 0x1FFFFFFFFFFFFFL, CoreGraph.this._prefix.shortValue());
                                            if (view1.length() > 0L) {
                                                selfPointer._nodeKeyCalculator.load(view1);
                                            }
                                            selfPointer._resolver.init();
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                            noError = false;
                                        }
                                        payloads.free();
                                        selfPointer._lock.set(true);
                                        if (HashHelper.isDefined(callback)) {
                                            callback.on(noError);
                                        }
                                    } else {
                                        selfPointer._lock.set(true);
                                        if (HashHelper.isDefined(callback)) {
                                            callback.on(false);
                                        }
                                    }
                                }
                            });
                        }
                    });
                }
            });
        } else {
            selfPointer._lock.set(true);
            if (HashHelper.isDefined(callback)) {
                callback.on(null);
            }
        }
    }

    public void disconnect(final Callback callback) {
        while (this._lock.compareAndSet(false, true)) {
        }
        if (this._isConnected.compareAndSet(true, false)) {
            final CoreGraph selfPointer = this;
            selfPointer._scheduler.stop();
            if (this._plugins != null) {
                for (int i = 0; i < this._plugins.length; ++i) {
                    this._plugins[i].stop();
                }
            }
            this.save(new Callback<Boolean>(){

                @Override
                public void on(Boolean result) {
                    ChunkSpace space = selfPointer._space;
                    space.free(CoreGraph.this._nodeKeyCalculator);
                    space.free(CoreGraph.this._worldKeyCalculator);
                    selfPointer._resolver.free();
                    space.freeAll();
                    if (selfPointer._storage != null) {
                        final Buffer prefixBuf = selfPointer.newBuffer();
                        Base64.encodeIntToBuffer(selfPointer._prefix.shortValue(), prefixBuf);
                        selfPointer._storage.unlock(prefixBuf, new Callback<Boolean>(){

                            @Override
                            public void on(Boolean result) {
                                prefixBuf.free();
                                selfPointer._storage.disconnect(new Callback<Boolean>(){

                                    @Override
                                    public void on(Boolean result) {
                                        selfPointer._lock.set(true);
                                        if (HashHelper.isDefined(callback)) {
                                            callback.on(result);
                                        }
                                    }
                                });
                            }
                        });
                    } else {
                        selfPointer._lock.set(true);
                        if (HashHelper.isDefined(callback)) {
                            callback.on(result);
                        }
                    }
                }
            });
        } else {
            this._lock.set(true);
            if (HashHelper.isDefined(callback)) {
                callback.on(null);
            }
        }
    }

    @Override
    public Buffer newBuffer() {
        return this._memoryFactory.newBuffer();
    }

    @Override
    public Query newQuery() {
        return new CoreQuery(this, this._resolver);
    }

    @Override
    public synchronized void index(long world, long time, String name, Callback<NodeIndex> callback) {
        this.internal_index(world, time, name, false, callback);
    }

    @Override
    public synchronized void indexIfExists(long world, long time, String name, Callback<NodeIndex> callback) {
        this.internal_index(world, time, name, true, callback);
    }

    private void internal_index(final long world, final long time, String name, final boolean ifExists, final Callback<NodeIndex> callback) {
        final CoreGraph selfPointer = this;
        final long indexNameCoded = this._resolver.stringToHash(name, true);
        this._resolver.lookup(world, time, 0x1FFFFFFFFFFFFEL, new Callback<Node>(){

            @Override
            public void on(Node globalIndexNodeUnsafe) {
                if (ifExists && globalIndexNodeUnsafe == null) {
                    callback.on(null);
                } else {
                    LongLongMap globalIndexContent;
                    if (globalIndexNodeUnsafe == null) {
                        globalIndexNodeUnsafe = new BaseNode(world, time, 0x1FFFFFFFFFFFFEL, selfPointer);
                        selfPointer._resolver.initNode(globalIndexNodeUnsafe, 0x1FFFFFFFFFFFFFL);
                        globalIndexContent = (LongLongMap)globalIndexNodeUnsafe.getOrCreate("index", (byte)10);
                    } else {
                        globalIndexContent = (LongLongMap)globalIndexNodeUnsafe.get("index");
                    }
                    long indexId = globalIndexContent.get(indexNameCoded);
                    globalIndexNodeUnsafe.free();
                    if (indexId == 0x1FFFFFFFFFFFFFL) {
                        if (ifExists) {
                            callback.on(null);
                        } else {
                            NodeIndex newIndexNode = (NodeIndex)selfPointer.newTypedNode(world, time, "NodeIndex");
                            indexId = newIndexNode.id();
                            globalIndexContent.put(indexNameCoded, indexId);
                            callback.on(newIndexNode);
                        }
                    } else {
                        selfPointer._resolver.lookup(world, time, indexId, callback);
                    }
                }
            }
        });
    }

    @Override
    public void indexNames(long world, long time, final Callback<String[]> callback) {
        final CoreGraph selfPointer = this;
        this._resolver.lookup(world, time, 0x1FFFFFFFFFFFFEL, new Callback<Node>(){

            @Override
            public void on(Node globalIndexNodeUnsafe) {
                if (globalIndexNodeUnsafe == null) {
                    callback.on(new String[0]);
                } else {
                    LongLongMap globalIndexContent = (LongLongMap)globalIndexNodeUnsafe.get("index");
                    if (globalIndexContent == null) {
                        globalIndexNodeUnsafe.free();
                        callback.on(new String[0]);
                    } else {
                        final String[] result = new String[globalIndexContent.size()];
                        final int[] resultIndex = new int[]{0};
                        globalIndexContent.each(new LongLongMapCallBack(){

                            @Override
                            public void on(long key, long value) {
                                result[resultIndex[0]] = selfPointer._resolver.hashToString((int)key);
                                resultIndex[0] = resultIndex[0] + 1;
                            }
                        });
                        globalIndexNodeUnsafe.free();
                        callback.on(result);
                    }
                }
            }
        });
    }

    @Override
    public DeferCounter newCounter(int expectedCountCalls) {
        return new CoreDeferCounter(expectedCountCalls);
    }

    @Override
    public DeferCounterSync newSyncCounter(int expectedCountCalls) {
        return new CoreDeferCounterSync(expectedCountCalls);
    }

    @Override
    public Resolver resolver() {
        return this._resolver;
    }

    @Override
    public Scheduler scheduler() {
        return this._scheduler;
    }

    @Override
    public ChunkSpace space() {
        return this._space;
    }

    @Override
    public Storage storage() {
        return this._storage;
    }

    @Override
    public void freeNodes(Node[] nodes) {
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                if (nodes[i] == null) continue;
                nodes[i].free();
            }
        }
    }
}

