/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal;

import greycat.Graph;
import greycat.Query;
import greycat.plugin.Resolver;
import greycat.struct.Buffer;
import greycat.utility.Base64;
import greycat.utility.HashHelper;

public class CoreQuery
implements Query {
    private final Resolver _resolver;
    private final Graph _graph;
    private int capacity = 1;
    private int[] _attributes = new int[this.capacity];
    private String[] _values = new String[this.capacity];
    private int size = 0;
    private Long _hash;
    private long _world = 0x1FFFFFFFFFFFFFL;
    private long _time = 0x1FFFFFFFFFFFFFL;

    public CoreQuery(Graph graph, Resolver p_resolver) {
        this._graph = graph;
        this._resolver = p_resolver;
        this._hash = null;
    }

    @Override
    public final long world() {
        return this._world;
    }

    @Override
    public final Query setWorld(long p_world) {
        this._world = p_world;
        return this;
    }

    @Override
    public final long time() {
        return this._time;
    }

    @Override
    public final Query setTime(long p_time) {
        this._time = p_time;
        return this;
    }

    @Override
    public Query add(String attributeName, String value) {
        this.internal_add(this._resolver.stringToHash(attributeName.trim(), false), value);
        return this;
    }

    @Override
    public long hash() {
        if (this._hash == null) {
            this.compute();
        }
        return this._hash;
    }

    @Override
    public int[] attributes() {
        return this._attributes;
    }

    @Override
    public Object[] values() {
        return this._values;
    }

    private void internal_add(int att, String val) {
        if (this.size == this.capacity) {
            int temp_capacity = this.capacity * 2;
            int[] temp_attributes = new int[temp_capacity];
            String[] temp_values = new String[temp_capacity];
            System.arraycopy(this._attributes, 0, temp_attributes, 0, this.capacity);
            System.arraycopy(this._values, 0, temp_values, 0, this.capacity);
            this._attributes = temp_attributes;
            this._values = temp_values;
            this.capacity = temp_capacity;
        }
        this._attributes[this.size] = att;
        this._values[this.size] = val;
        ++this.size;
    }

    private void compute() {
        for (int i = this.size - 1; i >= 0; --i) {
            for (int j = 1; j <= i; ++j) {
                if (this._attributes[j - 1] <= this._attributes[j]) continue;
                int tempK = this._attributes[j - 1];
                String tempV = this._values[j - 1];
                this._attributes[j - 1] = this._attributes[j];
                this._values[j - 1] = this._values[j];
                this._attributes[j] = tempK;
                this._values[j] = tempV;
            }
        }
        Buffer buf = this._graph.newBuffer();
        for (int i = 0; i < this.size; ++i) {
            Base64.encodeLongToBuffer(this._attributes[i], buf);
            String loopValue = this._values[i];
            if (loopValue == null) continue;
            Base64.encodeStringToBuffer(this._values[i], buf);
        }
        this._hash = HashHelper.hashBytes(buf.data());
        buf.free();
    }
}

