/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal;

import greycat.Callback;
import greycat.Graph;
import greycat.Node;
import greycat.base.BaseNode;
import greycat.chunk.Chunk;
import greycat.chunk.ChunkSpace;
import greycat.chunk.StateChunk;
import greycat.chunk.TimeTreeChunk;
import greycat.chunk.TreeWalker;
import greycat.chunk.WorldOrderChunk;
import greycat.internal.CoreConstants;
import greycat.internal.CoreGraph;
import greycat.plugin.NodeFactory;
import greycat.plugin.NodeState;
import greycat.plugin.Resolver;
import greycat.plugin.Storage;
import greycat.struct.Buffer;
import greycat.struct.BufferIterator;
import greycat.struct.LongLongMap;
import greycat.struct.StringIntMap;
import greycat.utility.HashHelper;
import greycat.utility.KeyHelper;

final class MWResolver
implements Resolver {
    private final Storage _storage;
    private final ChunkSpace _space;
    private final Graph _graph;
    private StateChunk dictionary;
    private WorldOrderChunk globalWorldOrderChunk;
    private static int KEY_SIZE = 3;

    public MWResolver(Storage p_storage, ChunkSpace p_space, Graph p_graph) {
        this._space = p_space;
        this._storage = p_storage;
        this._graph = p_graph;
    }

    @Override
    public final void init() {
        this.dictionary = (StateChunk)this._space.getAndMark((byte)0, CoreConstants.GLOBAL_DICTIONARY_KEY[0], CoreConstants.GLOBAL_DICTIONARY_KEY[1], CoreConstants.GLOBAL_DICTIONARY_KEY[2]);
        this.globalWorldOrderChunk = (WorldOrderChunk)this._space.getAndMark((byte)2, 0L, 0L, 0x1FFFFFFFFFFFFFL);
    }

    @Override
    public final void free() {
        if (this.dictionary != null) {
            this._space.free(this.dictionary);
        }
        if (this.globalWorldOrderChunk != null) {
            this._space.free(this.globalWorldOrderChunk);
        }
    }

    @Override
    public final int typeCode(Node node) {
        BaseNode casted = (BaseNode)node;
        WorldOrderChunk worldOrderChunk = (WorldOrderChunk)this._space.get(casted._index_worldOrder);
        if (worldOrderChunk == null) {
            return -1;
        }
        return (int)worldOrderChunk.extra();
    }

    @Override
    public final void initNode(Node node, long codeType) {
        BaseNode casted = (BaseNode)node;
        StateChunk cacheEntry = (StateChunk)this._space.createAndMark((byte)0, node.world(), node.time(), node.id());
        this._space.notifyUpdate(cacheEntry.index());
        TimeTreeChunk superTimeTree = (TimeTreeChunk)this._space.createAndMark((byte)1, node.world(), 0x1FFFFFFFFFFFFFL, node.id());
        superTimeTree.insert(node.time());
        TimeTreeChunk timeTree = (TimeTreeChunk)this._space.createAndMark((byte)1, node.world(), node.time(), node.id());
        timeTree.insert(node.time());
        WorldOrderChunk objectWorldOrder = (WorldOrderChunk)this._space.createAndMark((byte)2, 0L, 0L, node.id());
        objectWorldOrder.put(node.world(), node.time());
        if (codeType != 0x1FFFFFFFFFFFFFL) {
            objectWorldOrder.setExtra(codeType);
        }
        casted._index_stateChunk = cacheEntry.index();
        casted._index_timeTree = timeTree.index();
        casted._index_superTimeTree = superTimeTree.index();
        casted._index_worldOrder = objectWorldOrder.index();
        casted._world_magic = -1L;
        casted._super_time_magic = -1L;
        casted._time_magic = -1L;
        casted.init();
    }

    @Override
    public final void initWorld(long parentWorld, long childWorld) {
        this.globalWorldOrderChunk.put(childWorld, parentWorld);
    }

    @Override
    public final void freeNode(Node node) {
        BaseNode casted = (BaseNode)node;
        casted.cacheLock();
        if (!casted._dead) {
            this._space.unmark(casted._index_stateChunk);
            this._space.unmark(casted._index_timeTree);
            this._space.unmark(casted._index_superTimeTree);
            this._space.unmark(casted._index_worldOrder);
            casted._dead = true;
        }
        casted.cacheUnlock();
    }

    @Override
    public final void externalLock(Node node) {
        BaseNode casted = (BaseNode)node;
        WorldOrderChunk worldOrderChunk = (WorldOrderChunk)this._space.get(casted._index_worldOrder);
        worldOrderChunk.externalLock();
    }

    @Override
    public final void externalUnlock(Node node) {
        BaseNode casted = (BaseNode)node;
        WorldOrderChunk worldOrderChunk = (WorldOrderChunk)this._space.get(casted._index_worldOrder);
        worldOrderChunk.externalUnlock();
    }

    @Override
    public final void setTimeSensitivity(Node node, long deltaTime, long offset) {
        BaseNode casted = (BaseNode)node;
        TimeTreeChunk superTimeTree = (TimeTreeChunk)this._space.get(casted._index_superTimeTree);
        superTimeTree.setExtra(deltaTime);
        superTimeTree.setExtra2(offset);
    }

    @Override
    public long[] getTimeSensitivity(Node node) {
        BaseNode casted = (BaseNode)node;
        long[] result = new long[2];
        TimeTreeChunk superTimeTree = (TimeTreeChunk)this._space.get(casted._index_superTimeTree);
        result[0] = superTimeTree.extra();
        result[1] = superTimeTree.extra2();
        return result;
    }

    @Override
    public final <A extends Node> void lookup(final long world, final long time, final long id, final Callback<A> callback) {
        final MWResolver selfPointer = this;
        selfPointer._space.getOrLoadAndMark((byte)2, 0L, 0L, id, new Callback<Chunk>(){

            @Override
            public void on(final Chunk theNodeWorldOrder) {
                if (theNodeWorldOrder == null) {
                    callback.on(null);
                } else {
                    final long closestWorld = selfPointer.resolve_world(MWResolver.this.globalWorldOrderChunk, (WorldOrderChunk)theNodeWorldOrder, time, world);
                    selfPointer._space.getOrLoadAndMark((byte)1, closestWorld, 0x1FFFFFFFFFFFFFL, id, new Callback<Chunk>(){

                        @Override
                        public void on(final Chunk theNodeSuperTimeTree) {
                            if (theNodeSuperTimeTree == null) {
                                selfPointer._space.unmark(theNodeWorldOrder.index());
                                callback.on(null);
                            } else {
                                long closestSuperTime = ((TimeTreeChunk)theNodeSuperTimeTree).previousOrEqual(time);
                                if (closestSuperTime == 0x1FFFFFFFFFFFFFL) {
                                    selfPointer._space.unmark(theNodeSuperTimeTree.index());
                                    selfPointer._space.unmark(theNodeWorldOrder.index());
                                    callback.on(null);
                                    return;
                                }
                                selfPointer._space.getOrLoadAndMark((byte)1, closestWorld, closestSuperTime, id, new Callback<Chunk>(){

                                    @Override
                                    public void on(final Chunk theNodeTimeTree) {
                                        if (theNodeTimeTree == null) {
                                            selfPointer._space.unmark(theNodeSuperTimeTree.index());
                                            selfPointer._space.unmark(theNodeWorldOrder.index());
                                            callback.on(null);
                                        } else {
                                            final long closestTime = ((TimeTreeChunk)theNodeTimeTree).previousOrEqual(time);
                                            if (closestTime == 0x1FFFFFFFFFFFFFL) {
                                                selfPointer._space.unmark(theNodeTimeTree.index());
                                                selfPointer._space.unmark(theNodeSuperTimeTree.index());
                                                selfPointer._space.unmark(theNodeWorldOrder.index());
                                                callback.on(null);
                                                return;
                                            }
                                            selfPointer._space.getOrLoadAndMark((byte)0, closestWorld, closestTime, id, new Callback<Chunk>(){

                                                @Override
                                                public void on(Chunk theObjectChunk) {
                                                    if (theObjectChunk == null) {
                                                        selfPointer._space.unmark(theNodeTimeTree.index());
                                                        selfPointer._space.unmark(theNodeSuperTimeTree.index());
                                                        selfPointer._space.unmark(theNodeWorldOrder.index());
                                                        callback.on(null);
                                                    } else {
                                                        WorldOrderChunk castedNodeWorldOrder = (WorldOrderChunk)theNodeWorldOrder;
                                                        int extraCode = (int)castedNodeWorldOrder.extra();
                                                        NodeFactory resolvedFactory = null;
                                                        if (extraCode != -1) {
                                                            resolvedFactory = ((CoreGraph)selfPointer._graph).factoryByCode(extraCode);
                                                        }
                                                        BaseNode resolvedNode = resolvedFactory == null ? new BaseNode(world, time, id, selfPointer._graph) : (BaseNode)resolvedFactory.create(world, time, id, selfPointer._graph);
                                                        resolvedNode._dead = false;
                                                        resolvedNode._index_stateChunk = theObjectChunk.index();
                                                        resolvedNode._index_superTimeTree = theNodeSuperTimeTree.index();
                                                        resolvedNode._index_timeTree = theNodeTimeTree.index();
                                                        resolvedNode._index_worldOrder = theNodeWorldOrder.index();
                                                        if (closestWorld == world && closestTime == time) {
                                                            resolvedNode._world_magic = -1L;
                                                            resolvedNode._super_time_magic = -1L;
                                                            resolvedNode._time_magic = -1L;
                                                        } else {
                                                            resolvedNode._world_magic = ((WorldOrderChunk)theNodeWorldOrder).magic();
                                                            resolvedNode._super_time_magic = ((TimeTreeChunk)theNodeSuperTimeTree).magic();
                                                            resolvedNode._time_magic = ((TimeTreeChunk)theNodeTimeTree).magic();
                                                        }
                                                        if (callback != null) {
                                                            BaseNode casted = resolvedNode;
                                                            callback.on(casted);
                                                        }
                                                    }
                                                }
                                            });
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    public void lookupBatch(final long[] worlds, final long[] times, final long[] ids, final Callback<Node[]> callback) {
        final int idsSize = ids.length;
        if (worlds.length != times.length || times.length != idsSize) {
            throw new RuntimeException("Bad API usage");
        }
        final MWResolver selfPointer = this;
        final Node[] finalResult = new Node[idsSize];
        for (int i = 0; i < idsSize; ++i) {
            finalResult[i] = null;
        }
        final boolean[] isEmpty = new boolean[]{true};
        final long[] keys = new long[idsSize * 4];
        for (int i = 0; i < idsSize; ++i) {
            isEmpty[0] = false;
            keys[i * 4] = 2L;
            keys[i * 4 + 1] = 0L;
            keys[i * 4 + 2] = 0L;
            keys[i * 4 + 3] = ids[i];
        }
        if (isEmpty[0]) {
            this.lookupAll_end(finalResult, callback, idsSize, null, null, null, null);
        } else {
            selfPointer._space.getOrLoadAndMarkAll(keys, new Callback<Chunk[]>(){

                @Override
                public void on(final Chunk[] theNodeWorldOrders) {
                    if (theNodeWorldOrders == null) {
                        MWResolver.this.lookupAll_end(finalResult, callback, idsSize, null, null, null, null);
                    } else {
                        isEmpty[0] = true;
                        for (int i = 0; i < idsSize; ++i) {
                            if (theNodeWorldOrders[i] != null) {
                                isEmpty[0] = false;
                                keys[i * 4] = 1L;
                                keys[i * 4 + 1] = selfPointer.resolve_world(MWResolver.this.globalWorldOrderChunk, (WorldOrderChunk)theNodeWorldOrders[i], times[i], worlds[i]);
                                keys[i * 4 + 2] = 0x1FFFFFFFFFFFFFL;
                                continue;
                            }
                            keys[i * 4] = -1L;
                        }
                        if (isEmpty[0]) {
                            MWResolver.this.lookupAll_end(finalResult, callback, idsSize, theNodeWorldOrders, null, null, null);
                        } else {
                            selfPointer._space.getOrLoadAndMarkAll(keys, new Callback<Chunk[]>(){

                                @Override
                                public void on(final Chunk[] theNodeSuperTimeTrees) {
                                    if (theNodeSuperTimeTrees == null) {
                                        MWResolver.this.lookupAll_end(finalResult, callback, idsSize, theNodeWorldOrders, null, null, null);
                                    } else {
                                        isEmpty[0] = true;
                                        for (int i = 0; i < idsSize; ++i) {
                                            if (theNodeSuperTimeTrees[i] != null) {
                                                long closestSuperTime = ((TimeTreeChunk)theNodeSuperTimeTrees[i]).previousOrEqual(times[i]);
                                                if (closestSuperTime == 0x1FFFFFFFFFFFFFL) {
                                                    keys[i * 4] = -1L;
                                                    continue;
                                                }
                                                isEmpty[0] = false;
                                                keys[i * 4 + 2] = closestSuperTime;
                                                continue;
                                            }
                                            keys[i * 4] = -1L;
                                        }
                                        if (isEmpty[0]) {
                                            MWResolver.this.lookupAll_end(finalResult, callback, idsSize, theNodeWorldOrders, theNodeSuperTimeTrees, null, null);
                                        } else {
                                            selfPointer._space.getOrLoadAndMarkAll(keys, new Callback<Chunk[]>(){

                                                @Override
                                                public void on(final Chunk[] theNodeTimeTrees) {
                                                    if (theNodeTimeTrees == null) {
                                                        MWResolver.this.lookupAll_end(finalResult, callback, idsSize, theNodeWorldOrders, theNodeSuperTimeTrees, null, null);
                                                    } else {
                                                        isEmpty[0] = true;
                                                        for (int i = 0; i < idsSize; ++i) {
                                                            if (theNodeTimeTrees[i] != null) {
                                                                long closestTime = ((TimeTreeChunk)theNodeTimeTrees[i]).previousOrEqual(times[i]);
                                                                if (closestTime == 0x1FFFFFFFFFFFFFL) {
                                                                    keys[i * 4] = -1L;
                                                                    continue;
                                                                }
                                                                isEmpty[0] = false;
                                                                keys[i * 4] = 0L;
                                                                keys[i * 4 + 2] = closestTime;
                                                                continue;
                                                            }
                                                            keys[i * 4] = -1L;
                                                        }
                                                        if (isEmpty[0]) {
                                                            MWResolver.this.lookupAll_end(finalResult, callback, idsSize, theNodeWorldOrders, theNodeSuperTimeTrees, theNodeTimeTrees, null);
                                                        } else {
                                                            selfPointer._space.getOrLoadAndMarkAll(keys, new Callback<Chunk[]>(){

                                                                @Override
                                                                public void on(Chunk[] theObjectChunks) {
                                                                    if (theObjectChunks == null) {
                                                                        MWResolver.this.lookupAll_end(finalResult, callback, idsSize, theNodeWorldOrders, theNodeSuperTimeTrees, theNodeTimeTrees, null);
                                                                    } else {
                                                                        for (int i = 0; i < idsSize; ++i) {
                                                                            if (theObjectChunks[i] == null) continue;
                                                                            WorldOrderChunk castedNodeWorldOrder = (WorldOrderChunk)theNodeWorldOrders[i];
                                                                            int extraCode = (int)castedNodeWorldOrder.extra();
                                                                            NodeFactory resolvedFactory = null;
                                                                            if (extraCode != -1) {
                                                                                resolvedFactory = ((CoreGraph)selfPointer._graph).factoryByCode(extraCode);
                                                                            }
                                                                            BaseNode resolvedNode = resolvedFactory == null ? new BaseNode(worlds[i], times[i], ids[i], selfPointer._graph) : (BaseNode)resolvedFactory.create(worlds[i], times[i], ids[i], selfPointer._graph);
                                                                            resolvedNode._dead = false;
                                                                            resolvedNode._index_stateChunk = theObjectChunks[i].index();
                                                                            resolvedNode._index_superTimeTree = theNodeSuperTimeTrees[i].index();
                                                                            resolvedNode._index_timeTree = theNodeTimeTrees[i].index();
                                                                            resolvedNode._index_worldOrder = theNodeWorldOrders[i].index();
                                                                            if (theObjectChunks[i].world() == worlds[i] && theObjectChunks[i].time() == times[i]) {
                                                                                resolvedNode._world_magic = -1L;
                                                                                resolvedNode._super_time_magic = -1L;
                                                                                resolvedNode._time_magic = -1L;
                                                                            } else {
                                                                                resolvedNode._world_magic = ((WorldOrderChunk)theNodeWorldOrders[i]).magic();
                                                                                resolvedNode._super_time_magic = ((TimeTreeChunk)theNodeSuperTimeTrees[i]).magic();
                                                                                resolvedNode._time_magic = ((TimeTreeChunk)theNodeTimeTrees[i]).magic();
                                                                            }
                                                                            finalResult[i] = resolvedNode;
                                                                        }
                                                                        MWResolver.this.lookupAll_end(finalResult, callback, idsSize, theNodeWorldOrders, theNodeSuperTimeTrees, theNodeTimeTrees, theObjectChunks);
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    }
                                                }
                                            });
                                        }
                                    }
                                }
                            });
                        }
                    }
                }
            });
        }
    }

    @Override
    public void lookupTimes(long world, long from, long to, long id, final Callback<Node[]> callback) {
        MWResolver selfPointer = this;
        try {
            selfPointer._space.getOrLoadAndMark((byte)2, 0L, 0L, id, new Callback<Chunk>(){

                @Override
                public void on(Chunk theNodeWorldOrder) {
                    if (theNodeWorldOrder == null) {
                        callback.on(null);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void lookupAll_end(Node[] finalResult, Callback<Node[]> callback, int sizeIds, Chunk[] worldOrders, Chunk[] superTimes, Chunk[] times, Chunk[] chunks) {
        if (worldOrders != null || superTimes != null || times != null || chunks != null) {
            for (int i = 0; i < sizeIds; ++i) {
                if (finalResult[i] != null) continue;
                if (worldOrders != null && worldOrders[i] != null) {
                    this._space.unmark(worldOrders[i].index());
                }
                if (superTimes != null && superTimes[i] != null) {
                    this._space.unmark(superTimes[i].index());
                }
                if (times != null && times[i] != null) {
                    this._space.unmark(times[i].index());
                }
                if (chunks == null || chunks[i] == null) continue;
                this._space.unmark(chunks[i].index());
            }
        }
        callback.on(finalResult);
    }

    @Override
    public final void lookupAll(final long world, final long time, final long[] ids, final Callback<Node[]> callback) {
        final MWResolver selfPointer = this;
        final int idsSize = ids.length;
        final Node[] finalResult = new Node[idsSize];
        for (int i = 0; i < idsSize; ++i) {
            finalResult[i] = null;
        }
        final boolean[] isEmpty = new boolean[]{true};
        final long[] keys = new long[idsSize * 4];
        for (int i = 0; i < idsSize; ++i) {
            isEmpty[0] = false;
            keys[i * 4] = 2L;
            keys[i * 4 + 1] = 0L;
            keys[i * 4 + 2] = 0L;
            keys[i * 4 + 3] = ids[i];
        }
        if (isEmpty[0]) {
            this.lookupAll_end(finalResult, callback, idsSize, null, null, null, null);
        } else {
            selfPointer._space.getOrLoadAndMarkAll(keys, new Callback<Chunk[]>(){

                @Override
                public void on(final Chunk[] theNodeWorldOrders) {
                    if (theNodeWorldOrders == null) {
                        MWResolver.this.lookupAll_end(finalResult, callback, idsSize, null, null, null, null);
                    } else {
                        isEmpty[0] = true;
                        for (int i = 0; i < idsSize; ++i) {
                            if (theNodeWorldOrders[i] != null) {
                                isEmpty[0] = false;
                                keys[i * 4] = 1L;
                                keys[i * 4 + 1] = selfPointer.resolve_world(MWResolver.this.globalWorldOrderChunk, (WorldOrderChunk)theNodeWorldOrders[i], time, world);
                                keys[i * 4 + 2] = 0x1FFFFFFFFFFFFFL;
                                continue;
                            }
                            keys[i * 4] = -1L;
                        }
                        if (isEmpty[0]) {
                            MWResolver.this.lookupAll_end(finalResult, callback, idsSize, theNodeWorldOrders, null, null, null);
                        } else {
                            selfPointer._space.getOrLoadAndMarkAll(keys, new Callback<Chunk[]>(){

                                @Override
                                public void on(final Chunk[] theNodeSuperTimeTrees) {
                                    if (theNodeSuperTimeTrees == null) {
                                        MWResolver.this.lookupAll_end(finalResult, callback, idsSize, theNodeWorldOrders, null, null, null);
                                    } else {
                                        isEmpty[0] = true;
                                        for (int i = 0; i < idsSize; ++i) {
                                            if (theNodeSuperTimeTrees[i] != null) {
                                                long closestSuperTime = ((TimeTreeChunk)theNodeSuperTimeTrees[i]).previousOrEqual(time);
                                                if (closestSuperTime == 0x1FFFFFFFFFFFFFL) {
                                                    keys[i * 4] = -1L;
                                                    continue;
                                                }
                                                isEmpty[0] = false;
                                                keys[i * 4 + 2] = closestSuperTime;
                                                continue;
                                            }
                                            keys[i * 4] = -1L;
                                        }
                                        if (isEmpty[0]) {
                                            MWResolver.this.lookupAll_end(finalResult, callback, idsSize, theNodeWorldOrders, theNodeSuperTimeTrees, null, null);
                                        } else {
                                            selfPointer._space.getOrLoadAndMarkAll(keys, new Callback<Chunk[]>(){

                                                @Override
                                                public void on(final Chunk[] theNodeTimeTrees) {
                                                    if (theNodeTimeTrees == null) {
                                                        MWResolver.this.lookupAll_end(finalResult, callback, idsSize, theNodeWorldOrders, theNodeSuperTimeTrees, null, null);
                                                    } else {
                                                        isEmpty[0] = true;
                                                        for (int i = 0; i < idsSize; ++i) {
                                                            if (theNodeTimeTrees[i] != null) {
                                                                long closestTime = ((TimeTreeChunk)theNodeTimeTrees[i]).previousOrEqual(time);
                                                                if (closestTime == 0x1FFFFFFFFFFFFFL) {
                                                                    keys[i * 4] = -1L;
                                                                    continue;
                                                                }
                                                                isEmpty[0] = false;
                                                                keys[i * 4] = 0L;
                                                                keys[i * 4 + 2] = closestTime;
                                                                continue;
                                                            }
                                                            keys[i * 4] = -1L;
                                                        }
                                                        if (isEmpty[0]) {
                                                            MWResolver.this.lookupAll_end(finalResult, callback, idsSize, theNodeWorldOrders, theNodeSuperTimeTrees, theNodeTimeTrees, null);
                                                        } else {
                                                            selfPointer._space.getOrLoadAndMarkAll(keys, new Callback<Chunk[]>(){

                                                                @Override
                                                                public void on(Chunk[] theObjectChunks) {
                                                                    if (theObjectChunks == null) {
                                                                        MWResolver.this.lookupAll_end(finalResult, callback, idsSize, theNodeWorldOrders, theNodeSuperTimeTrees, theNodeTimeTrees, null);
                                                                    } else {
                                                                        for (int i = 0; i < idsSize; ++i) {
                                                                            if (theObjectChunks[i] == null) continue;
                                                                            WorldOrderChunk castedNodeWorldOrder = (WorldOrderChunk)theNodeWorldOrders[i];
                                                                            int extraCode = (int)castedNodeWorldOrder.extra();
                                                                            NodeFactory resolvedFactory = null;
                                                                            if (extraCode != -1) {
                                                                                resolvedFactory = ((CoreGraph)selfPointer._graph).factoryByCode(extraCode);
                                                                            }
                                                                            BaseNode resolvedNode = resolvedFactory == null ? new BaseNode(world, time, ids[i], selfPointer._graph) : (BaseNode)resolvedFactory.create(world, time, ids[i], selfPointer._graph);
                                                                            resolvedNode._dead = false;
                                                                            resolvedNode._index_stateChunk = theObjectChunks[i].index();
                                                                            resolvedNode._index_superTimeTree = theNodeSuperTimeTrees[i].index();
                                                                            resolvedNode._index_timeTree = theNodeTimeTrees[i].index();
                                                                            resolvedNode._index_worldOrder = theNodeWorldOrders[i].index();
                                                                            if (theObjectChunks[i].world() == world && theObjectChunks[i].time() == time) {
                                                                                resolvedNode._world_magic = -1L;
                                                                                resolvedNode._super_time_magic = -1L;
                                                                                resolvedNode._time_magic = -1L;
                                                                            } else {
                                                                                resolvedNode._world_magic = ((WorldOrderChunk)theNodeWorldOrders[i]).magic();
                                                                                resolvedNode._super_time_magic = ((TimeTreeChunk)theNodeSuperTimeTrees[i]).magic();
                                                                                resolvedNode._time_magic = ((TimeTreeChunk)theNodeTimeTrees[i]).magic();
                                                                            }
                                                                            finalResult[i] = resolvedNode;
                                                                        }
                                                                        MWResolver.this.lookupAll_end(finalResult, callback, idsSize, theNodeWorldOrders, theNodeSuperTimeTrees, theNodeTimeTrees, theObjectChunks);
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    }
                                                }
                                            });
                                        }
                                    }
                                }
                            });
                        }
                    }
                }
            });
        }
    }

    @Override
    public void lookupAllTimes(long world, long from, long to, long[] ids, Callback<Node[]> callback) {
    }

    private long resolve_world(LongLongMap globalWorldOrder, LongLongMap nodeWorldOrder, long timeToResolve, long originWorld) {
        if (globalWorldOrder == null || nodeWorldOrder == null) {
            return originWorld;
        }
        long currentUniverse = originWorld;
        long previousUniverse = 0x1FFFFFFFFFFFFFL;
        long divergenceTime = nodeWorldOrder.get(currentUniverse);
        while (currentUniverse != previousUniverse) {
            if (divergenceTime != 0x1FFFFFFFFFFFFFL && divergenceTime <= timeToResolve) {
                return currentUniverse;
            }
            previousUniverse = currentUniverse;
            currentUniverse = globalWorldOrder.get(currentUniverse);
            divergenceTime = nodeWorldOrder.get(currentUniverse);
        }
        return originWorld;
    }

    private void getOrLoadAndMarkAll(final byte[] types, final long[] keys, final Callback<Chunk[]> callback) {
        int nbKeys = keys.length / KEY_SIZE;
        boolean[] toLoadIndexes = new boolean[nbKeys];
        int nbElem = 0;
        final Chunk[] result = new Chunk[nbKeys];
        for (int i = 0; i < nbKeys; ++i) {
            if (keys[i * KEY_SIZE] == CoreConstants.NULL_KEY[0] && keys[i * KEY_SIZE + 1] == CoreConstants.NULL_KEY[1] && keys[i * KEY_SIZE + 2] == CoreConstants.NULL_KEY[2]) {
                toLoadIndexes[i] = false;
                result[i] = null;
                continue;
            }
            result[i] = this._space.getAndMark(types[i], keys[i * KEY_SIZE], keys[i * KEY_SIZE + 1], keys[i * KEY_SIZE + 2]);
            if (result[i] == null) {
                toLoadIndexes[i] = true;
                ++nbElem;
                continue;
            }
            toLoadIndexes[i] = false;
        }
        if (nbElem == 0) {
            callback.on(result);
        } else {
            final Buffer keysToLoad = this._graph.newBuffer();
            final int[] reverseIndex = new int[nbElem];
            int lastInsertedIndex = 0;
            for (int i = 0; i < nbKeys; ++i) {
                if (!toLoadIndexes[i]) continue;
                reverseIndex[lastInsertedIndex] = i;
                if (lastInsertedIndex != 0) {
                    keysToLoad.write((byte)35);
                }
                KeyHelper.keyToBuffer(keysToLoad, types[i], keys[i * KEY_SIZE], keys[i * KEY_SIZE + 1], keys[i * KEY_SIZE + 2]);
                ++lastInsertedIndex;
            }
            final MWResolver selfPointer = this;
            this._storage.get(keysToLoad, new Callback<Buffer>(){

                @Override
                public void on(Buffer fromDbBuffers) {
                    keysToLoad.free();
                    BufferIterator it = fromDbBuffers.iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        int reversedIndex = reverseIndex[i];
                        Buffer view = it.next();
                        if (view.length() > 0L) {
                            result[reversedIndex] = selfPointer._space.createAndMark(types[reversedIndex], keys[reversedIndex * KEY_SIZE], keys[reversedIndex * KEY_SIZE + 1], keys[reversedIndex * KEY_SIZE + 2]);
                            result[reversedIndex].load(view);
                        } else {
                            result[reversedIndex] = null;
                        }
                        ++i;
                    }
                    fromDbBuffers.free();
                    callback.on(result);
                }
            });
        }
    }

    @Override
    public final NodeState resolveState(Node node) {
        return this.internal_resolveState(node, true);
    }

    private StateChunk internal_resolveState(Node node, boolean safe) {
        BaseNode castedNode = (BaseNode)node;
        StateChunk stateResult = null;
        if (safe) {
            castedNode.cacheLock();
        }
        if (castedNode._dead) {
            if (safe) {
                castedNode.cacheUnlock();
            }
            throw new RuntimeException(CoreConstants.DEAD_NODE_ERROR + " node id: " + node.id());
        }
        if (castedNode._world_magic == -1L && castedNode._time_magic == -1L && castedNode._super_time_magic == -1L) {
            stateResult = (StateChunk)this._space.get(castedNode._index_stateChunk);
        } else {
            WorldOrderChunk nodeWorldOrder = (WorldOrderChunk)this._space.get(castedNode._index_worldOrder);
            TimeTreeChunk nodeSuperTimeTree = (TimeTreeChunk)this._space.get(castedNode._index_superTimeTree);
            TimeTreeChunk nodeTimeTree = (TimeTreeChunk)this._space.get(castedNode._index_timeTree);
            if (nodeWorldOrder != null && nodeSuperTimeTree != null && nodeTimeTree != null) {
                if (castedNode._world_magic == nodeWorldOrder.magic() && castedNode._super_time_magic == nodeSuperTimeTree.magic() && castedNode._time_magic == nodeTimeTree.magic()) {
                    stateResult = (StateChunk)this._space.get(castedNode._index_stateChunk);
                } else {
                    StateChunk tempNodeState;
                    TimeTreeChunk tempNodeTimeTree;
                    long resolvedSuperTime;
                    TimeTreeChunk tempNodeSuperTimeTree;
                    if (safe) {
                        nodeWorldOrder.lock();
                    }
                    long nodeTime = castedNode.time();
                    long nodeId = castedNode.id();
                    long nodeWorld = castedNode.world();
                    long resolvedWorld = this.resolve_world(this.globalWorldOrderChunk, nodeWorldOrder, nodeTime, nodeWorld);
                    if (resolvedWorld != nodeSuperTimeTree.world() && (tempNodeSuperTimeTree = (TimeTreeChunk)this._space.getAndMark((byte)1, resolvedWorld, 0x1FFFFFFFFFFFFFL, nodeId)) != null) {
                        this._space.unmark(nodeSuperTimeTree.index());
                        nodeSuperTimeTree = tempNodeSuperTimeTree;
                    }
                    if ((resolvedSuperTime = nodeSuperTimeTree.previousOrEqual(nodeTime)) != nodeTimeTree.time() && (tempNodeTimeTree = (TimeTreeChunk)this._space.getAndMark((byte)1, resolvedWorld, resolvedSuperTime, nodeId)) != null) {
                        this._space.unmark(nodeTimeTree.index());
                        nodeTimeTree = tempNodeTimeTree;
                    }
                    long resolvedTime = nodeTimeTree.previousOrEqual(nodeTime);
                    if (resolvedWorld == nodeWorld && resolvedTime == nodeTime) {
                        castedNode._world_magic = -1L;
                        castedNode._time_magic = -1L;
                        castedNode._super_time_magic = -1L;
                    } else {
                        castedNode._world_magic = nodeWorldOrder.magic();
                        castedNode._time_magic = nodeTimeTree.magic();
                        castedNode._super_time_magic = nodeSuperTimeTree.magic();
                        castedNode._index_superTimeTree = nodeSuperTimeTree.index();
                        castedNode._index_timeTree = nodeTimeTree.index();
                    }
                    stateResult = (StateChunk)this._space.get(castedNode._index_stateChunk);
                    if ((resolvedWorld != stateResult.world() || resolvedTime != stateResult.time()) && (tempNodeState = (StateChunk)this._space.getAndMark((byte)0, resolvedWorld, resolvedTime, nodeId)) != null) {
                        this._space.unmark(stateResult.index());
                        stateResult = tempNodeState;
                    }
                    castedNode._index_stateChunk = stateResult.index();
                    if (safe) {
                        nodeWorldOrder.unlock();
                    }
                }
            }
        }
        if (safe) {
            castedNode.cacheUnlock();
        }
        return stateResult;
    }

    @Override
    public final NodeState alignState(Node node) {
        StateChunk clonedState;
        StateChunk currentEntry;
        BaseNode castedNode = (BaseNode)node;
        castedNode.cacheLock();
        if (castedNode._dead) {
            castedNode.cacheUnlock();
            throw new RuntimeException(CoreConstants.DEAD_NODE_ERROR + " node id: " + node.id());
        }
        if (castedNode._world_magic == -1L && castedNode._time_magic == -1L && castedNode._super_time_magic == -1L && (currentEntry = (StateChunk)this._space.get(castedNode._index_stateChunk)) != null) {
            castedNode.cacheUnlock();
            return currentEntry;
        }
        WorldOrderChunk nodeWorldOrder = (WorldOrderChunk)this._space.get(castedNode._index_worldOrder);
        if (nodeWorldOrder == null) {
            castedNode.cacheUnlock();
            return null;
        }
        nodeWorldOrder.lock();
        StateChunk previouStateChunk = this.internal_resolveState(node, false);
        long previousTime = previouStateChunk.time();
        long previousWorld = previouStateChunk.world();
        if (castedNode._world_magic == -1L && castedNode._time_magic == -1L && castedNode._super_time_magic == -1L) {
            nodeWorldOrder.unlock();
            castedNode.cacheUnlock();
            return previouStateChunk;
        }
        long nodeWorld = node.world();
        long nodeTime = node.time();
        long nodeId = node.id();
        TimeTreeChunk superTimeTree = (TimeTreeChunk)this._space.get(castedNode._index_superTimeTree);
        long timeSensitivity = superTimeTree.extra();
        if (timeSensitivity != 0L && timeSensitivity != 0x1FFFFFFFFFFFFFL) {
            if (timeSensitivity < 0L) {
                nodeTime = previousTime;
            } else {
                long timeSensitivityOffset = superTimeTree.extra2();
                if (timeSensitivityOffset == 0x1FFFFFFFFFFFFFL) {
                    timeSensitivityOffset = 0L;
                }
                nodeTime = nodeTime - nodeTime % timeSensitivity + timeSensitivityOffset;
            }
        }
        if (nodeTime != previousTime || nodeWorld != previousWorld) {
            clonedState = (StateChunk)this._space.createAndMark((byte)0, nodeWorld, nodeTime, nodeId);
            clonedState.loadFrom(previouStateChunk);
            castedNode._index_stateChunk = clonedState.index();
            this._space.unmark(previouStateChunk.index());
        } else {
            clonedState = previouStateChunk;
        }
        castedNode._world_magic = -1L;
        castedNode._super_time_magic = -1L;
        castedNode._time_magic = -1L;
        if (previousWorld == nodeWorld || nodeWorldOrder.get(nodeWorld) != 0x1FFFFFFFFFFFFFL) {
            long threshold;
            TimeTreeChunk timeTree = (TimeTreeChunk)this._space.get(castedNode._index_timeTree);
            long superTreeSize = superTimeTree.size();
            if (superTreeSize > (threshold = 2000L)) {
                threshold = 20000L;
            }
            if (superTreeSize > threshold) {
                threshold = 200000L;
            }
            if (superTreeSize > threshold) {
                threshold = 2000000L;
            }
            timeTree.insert(nodeTime);
            if ((long)timeTree.size() == threshold) {
                TimeTreeChunk rightTree;
                final long[] medianPoint = new long[]{-1L};
                timeTree.range(-9007199254740990L, 0x1FFFFFFFFFFFFEL, timeTree.size() / 2, new TreeWalker(){

                    @Override
                    public void elem(long t) {
                        medianPoint[0] = t;
                    }
                });
                final TimeTreeChunk finalRightTree = rightTree = (TimeTreeChunk)this._space.createAndMark((byte)1, nodeWorld, medianPoint[0], nodeId);
                timeTree.range(-9007199254740990L, 0x1FFFFFFFFFFFFEL, timeTree.size() / 2, new TreeWalker(){

                    @Override
                    public void elem(long t) {
                        finalRightTree.unsafe_insert(t);
                    }
                });
                this._space.notifyUpdate(finalRightTree.index());
                superTimeTree.insert(medianPoint[0]);
                timeTree.clearAt(medianPoint[0]);
                if (nodeTime < medianPoint[0]) {
                    this._space.unmark(rightTree.index());
                } else {
                    castedNode._index_timeTree = finalRightTree.index();
                    this._space.unmark(timeTree.index());
                }
            }
        } else {
            TimeTreeChunk newSuperTimeTree = (TimeTreeChunk)this._space.createAndMark((byte)1, nodeWorld, 0x1FFFFFFFFFFFFFL, nodeId);
            newSuperTimeTree.insert(nodeTime);
            TimeTreeChunk newTimeTree = (TimeTreeChunk)this._space.createAndMark((byte)1, nodeWorld, nodeTime, nodeId);
            newTimeTree.insert(nodeTime);
            nodeWorldOrder.put(nodeWorld, nodeTime);
            this._space.unmark(castedNode._index_timeTree);
            this._space.unmark(castedNode._index_superTimeTree);
            castedNode._index_timeTree = newTimeTree.index();
            castedNode._index_superTimeTree = newSuperTimeTree.index();
        }
        nodeWorldOrder.unlock();
        castedNode.cacheUnlock();
        return clonedState;
    }

    @Override
    public NodeState newState(Node node, long world, long time) {
        BaseNode castedNode = (BaseNode)node;
        castedNode.cacheLock();
        BaseNode fakeNode = new BaseNode(world, time, node.id(), node.graph());
        fakeNode._index_worldOrder = castedNode._index_worldOrder;
        fakeNode._index_superTimeTree = castedNode._index_superTimeTree;
        fakeNode._index_timeTree = castedNode._index_timeTree;
        fakeNode._index_stateChunk = castedNode._index_stateChunk;
        fakeNode._time_magic = castedNode._time_magic;
        fakeNode._super_time_magic = castedNode._super_time_magic;
        fakeNode._world_magic = castedNode._world_magic;
        NodeState resolved = this.alignState(fakeNode);
        castedNode._index_worldOrder = fakeNode._index_worldOrder;
        castedNode._index_superTimeTree = fakeNode._index_superTimeTree;
        castedNode._index_timeTree = fakeNode._index_timeTree;
        castedNode._index_stateChunk = fakeNode._index_stateChunk;
        castedNode._time_magic = fakeNode._time_magic;
        castedNode._super_time_magic = fakeNode._super_time_magic;
        castedNode._world_magic = fakeNode._world_magic;
        castedNode.cacheUnlock();
        return resolved;
    }

    @Override
    public void resolveTimepoints(final Node node, final long beginningOfSearch, final long endOfSearch, final Callback<long[]> callback) {
        final MWResolver selfPointer = this;
        this._space.getOrLoadAndMark((byte)2, 0L, 0L, node.id(), new Callback<Chunk>(){

            @Override
            public void on(Chunk resolved) {
                if (resolved == null) {
                    callback.on(new long[0]);
                    return;
                }
                WorldOrderChunk objectWorldOrder = (WorldOrderChunk)resolved;
                int[] collectionSize = new int[]{8};
                long[][] collectedWorlds = new long[][]{new long[collectionSize[0]]};
                int collectedIndex = 0;
                long currentWorld = node.world();
                while (currentWorld != 0x1FFFFFFFFFFFFFL) {
                    long divergenceTimepoint = objectWorldOrder.get(currentWorld);
                    if (divergenceTimepoint != 0x1FFFFFFFFFFFFFL) {
                        if (divergenceTimepoint <= beginningOfSearch) {
                            collectedWorlds[0][collectedIndex] = currentWorld;
                            ++collectedIndex;
                            break;
                        }
                        if (divergenceTimepoint > endOfSearch) {
                            currentWorld = selfPointer.globalWorldOrderChunk.get(currentWorld);
                            continue;
                        }
                        collectedWorlds[0][collectedIndex] = currentWorld;
                        if (++collectedIndex == collectionSize[0]) {
                            long[] temp_collectedWorlds = new long[collectionSize[0] * 2];
                            System.arraycopy(collectedWorlds[0], 0, temp_collectedWorlds, 0, collectionSize[0]);
                            collectedWorlds[0] = temp_collectedWorlds;
                            collectionSize[0] = collectionSize[0] * 2;
                        }
                        currentWorld = selfPointer.globalWorldOrderChunk.get(currentWorld);
                        continue;
                    }
                    currentWorld = selfPointer.globalWorldOrderChunk.get(currentWorld);
                }
                selfPointer.resolveTimepointsFromWorlds(objectWorldOrder, node, beginningOfSearch, endOfSearch, collectedWorlds[0], collectedIndex, callback);
            }
        });
    }

    private void resolveTimepointsFromWorlds(final WorldOrderChunk objectWorldOrder, final Node node, final long beginningOfSearch, final long endOfSearch, final long[] collectedWorlds, final int collectedWorldsSize, final Callback<long[]> callback) {
        final MWResolver selfPointer = this;
        long[] timeTreeKeys = new long[collectedWorldsSize * 3];
        byte[] types = new byte[collectedWorldsSize];
        for (int i = 0; i < collectedWorldsSize; ++i) {
            timeTreeKeys[i * 3] = collectedWorlds[i];
            timeTreeKeys[i * 3 + 1] = 0x1FFFFFFFFFFFFFL;
            timeTreeKeys[i * 3 + 2] = node.id();
            types[i] = 1;
        }
        this.getOrLoadAndMarkAll(types, timeTreeKeys, new Callback<Chunk[]>(){

            @Override
            public void on(Chunk[] superTimeTrees) {
                if (superTimeTrees == null) {
                    selfPointer._space.unmark(objectWorldOrder.index());
                    callback.on(new long[0]);
                } else {
                    final int[] collectedSize = new int[]{8};
                    final long[][] collectedSuperTimes = new long[][]{new long[collectedSize[0]]};
                    final long[][] collectedSuperTimesAssociatedWorlds = new long[][]{new long[collectedSize[0]]};
                    final int[] insert_index = new int[]{0};
                    long previousDivergenceTime = endOfSearch;
                    for (int i = 0; i < collectedWorldsSize; ++i) {
                        final TimeTreeChunk timeTree = (TimeTreeChunk)superTimeTrees[i];
                        if (timeTree != null) {
                            long currentDivergenceTime = objectWorldOrder.get(collectedWorlds[i]);
                            final long finalPreviousDivergenceTime = previousDivergenceTime;
                            timeTree.range(currentDivergenceTime, previousDivergenceTime, 0x1FFFFFFFFFFFFEL, new TreeWalker(){

                                @Override
                                public void elem(long t) {
                                    if (t != finalPreviousDivergenceTime) {
                                        collectedSuperTimes[0][insert_index[0]] = t;
                                        collectedSuperTimesAssociatedWorlds[0][insert_index[0]] = timeTree.world();
                                        insert_index[0] = insert_index[0] + 1;
                                        if (collectedSize[0] == insert_index[0]) {
                                            long[] temp_collectedSuperTimes = new long[collectedSize[0] * 2];
                                            long[] temp_collectedSuperTimesAssociatedWorlds = new long[collectedSize[0] * 2];
                                            System.arraycopy(collectedSuperTimes[0], 0, temp_collectedSuperTimes, 0, collectedSize[0]);
                                            System.arraycopy(collectedSuperTimesAssociatedWorlds[0], 0, temp_collectedSuperTimesAssociatedWorlds, 0, collectedSize[0]);
                                            collectedSuperTimes[0] = temp_collectedSuperTimes;
                                            collectedSuperTimesAssociatedWorlds[0] = temp_collectedSuperTimesAssociatedWorlds;
                                            collectedSize[0] = collectedSize[0] * 2;
                                        }
                                    }
                                }
                            });
                            previousDivergenceTime = currentDivergenceTime;
                        }
                        selfPointer._space.unmark(timeTree.index());
                    }
                    selfPointer.resolveTimepointsFromSuperTimes(objectWorldOrder, node, beginningOfSearch, endOfSearch, collectedSuperTimesAssociatedWorlds[0], collectedSuperTimes[0], insert_index[0], callback);
                }
            }
        });
    }

    private void resolveTimepointsFromSuperTimes(final WorldOrderChunk objectWorldOrder, Node node, final long beginningOfSearch, final long endOfSearch, final long[] collectedWorlds, long[] collectedSuperTimes, final int collectedSize, final Callback<long[]> callback) {
        final MWResolver selfPointer = this;
        long[] timeTreeKeys = new long[collectedSize * 3];
        byte[] types = new byte[collectedSize];
        for (int i = 0; i < collectedSize; ++i) {
            timeTreeKeys[i * 3] = collectedWorlds[i];
            timeTreeKeys[i * 3 + 1] = collectedSuperTimes[i];
            timeTreeKeys[i * 3 + 2] = node.id();
            types[i] = 1;
        }
        this.getOrLoadAndMarkAll(types, timeTreeKeys, new Callback<Chunk[]>(){

            @Override
            public void on(Chunk[] timeTrees) {
                if (timeTrees == null) {
                    selfPointer._space.unmark(objectWorldOrder.index());
                    callback.on(new long[0]);
                } else {
                    final int[] collectedTimesSize = new int[]{8};
                    final long[][] collectedTimes = new long[][]{new long[collectedTimesSize[0]]};
                    final int[] insert_index = new int[]{0};
                    long previousDivergenceTime = endOfSearch;
                    for (int i = 0; i < collectedSize; ++i) {
                        TimeTreeChunk timeTree = (TimeTreeChunk)timeTrees[i];
                        if (timeTree != null) {
                            long currentDivergenceTime = objectWorldOrder.get(collectedWorlds[i]);
                            if (currentDivergenceTime < beginningOfSearch) {
                                currentDivergenceTime = beginningOfSearch;
                            }
                            final long finalPreviousDivergenceTime = previousDivergenceTime;
                            timeTree.range(currentDivergenceTime, previousDivergenceTime, 0x1FFFFFFFFFFFFEL, new TreeWalker(){

                                @Override
                                public void elem(long t) {
                                    if (t != finalPreviousDivergenceTime) {
                                        collectedTimes[0][insert_index[0]] = t;
                                        insert_index[0] = insert_index[0] + 1;
                                        if (collectedTimesSize[0] == insert_index[0]) {
                                            long[] temp_collectedTimes = new long[collectedTimesSize[0] * 2];
                                            System.arraycopy(collectedTimes[0], 0, temp_collectedTimes, 0, collectedTimesSize[0]);
                                            collectedTimes[0] = temp_collectedTimes;
                                            collectedTimesSize[0] = collectedTimesSize[0] * 2;
                                        }
                                    }
                                }
                            });
                            if (i < collectedSize - 1 && collectedWorlds[i + 1] != collectedWorlds[i]) {
                                previousDivergenceTime = currentDivergenceTime;
                            }
                        }
                        selfPointer._space.unmark(timeTree.index());
                    }
                    if (insert_index[0] != collectedTimesSize[0]) {
                        long[] tempTimeline = new long[insert_index[0]];
                        System.arraycopy(collectedTimes[0], 0, tempTimeline, 0, insert_index[0]);
                        collectedTimes[0] = tempTimeline;
                    }
                    selfPointer._space.unmark(objectWorldOrder.index());
                    callback.on(collectedTimes[0]);
                }
            }
        });
    }

    @Override
    public int stringToHash(String name, boolean insertIfNotExists) {
        int hash = HashHelper.hash(name);
        if (insertIfNotExists) {
            StringIntMap dictionaryIndex = (StringIntMap)this.dictionary.getAt(0);
            if (dictionaryIndex == null) {
                dictionaryIndex = (StringIntMap)this.dictionary.getOrCreateAt(0, (byte)12);
            }
            if (!dictionaryIndex.containsHash(hash)) {
                dictionaryIndex.put(name, hash);
            }
        }
        return hash;
    }

    @Override
    public String hashToString(int key) {
        StringIntMap dictionaryIndex = (StringIntMap)this.dictionary.getAt(0);
        if (dictionaryIndex != null) {
            return dictionaryIndex.getByHash(key);
        }
        return null;
    }
}

