/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.heap;

import sun.misc.Unsafe;

public class HeapAtomicByteArray {
    private static final Unsafe unsafe = greycat.utility.Unsafe.getUnsafe();
    private static final int base = unsafe.arrayBaseOffset(byte[].class);
    private static final int scale = unsafe.arrayIndexScale(byte[].class);
    private final byte[] _back;

    HeapAtomicByteArray(int initialSize) {
        this._back = new byte[initialSize];
    }

    public byte get(int index) {
        return unsafe.getByteVolatile(this._back, base + index * scale);
    }

    public void set(int index, byte value) {
        unsafe.putByteVolatile(this._back, base + index * scale, value);
    }
}

