/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.heap;

import greycat.struct.Buffer;
import greycat.struct.BufferIterator;
import greycat.utility.DefaultBufferIterator;

public class HeapBuffer
implements Buffer {
    private byte[] buffer;
    private int writeCursor;

    @Override
    public final byte[] slice(long initPos, long endPos) {
        int newSize = (int)(endPos - initPos + 1L);
        byte[] newResult = new byte[newSize];
        System.arraycopy(this.buffer, (int)initPos, newResult, 0, newSize);
        return newResult;
    }

    @Override
    public final void write(byte b) {
        if (this.buffer == null) {
            this.buffer = new byte[8];
            this.buffer[0] = b;
            this.writeCursor = 1;
        } else if (this.writeCursor == this.buffer.length) {
            byte[] temp = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, temp, 0, this.buffer.length);
            temp[this.writeCursor] = b;
            ++this.writeCursor;
            this.buffer = temp;
        } else {
            this.buffer[this.writeCursor] = b;
            ++this.writeCursor;
        }
    }

    private long getNewSize(long old, long target) {
        while (old < target) {
            old *= 2L;
        }
        return old;
    }

    @Override
    public final void writeAll(byte[] bytes) {
        if (this.buffer == null) {
            int initSize = (int)this.getNewSize(8L, bytes.length);
            this.buffer = new byte[initSize];
            System.arraycopy(bytes, 0, this.buffer, 0, bytes.length);
            this.writeCursor = bytes.length;
        } else if (this.writeCursor + bytes.length > this.buffer.length) {
            int newSize = (int)this.getNewSize(this.buffer.length, this.buffer.length + bytes.length);
            int closePowerOfTwo = (int)Math.pow(2.0, Math.ceil(Math.log(newSize) / Math.log(2.0)));
            byte[] tmp = new byte[closePowerOfTwo];
            System.arraycopy(this.buffer, 0, tmp, 0, this.buffer.length);
            System.arraycopy(bytes, 0, tmp, this.writeCursor, bytes.length);
            this.buffer = tmp;
            this.writeCursor += bytes.length;
        } else {
            System.arraycopy(bytes, 0, this.buffer, this.writeCursor, bytes.length);
            this.writeCursor += bytes.length;
        }
    }

    @Override
    public final void writeString(String input) {
        this.writeAll(input.getBytes());
    }

    @Override
    public final void writeChar(char input) {
        this.write((byte)input);
    }

    @Override
    public final byte read(long position) {
        return this.buffer[(int)position];
    }

    @Override
    public final byte[] data() {
        byte[] copy = new byte[this.writeCursor];
        if (this.buffer != null) {
            System.arraycopy(this.buffer, 0, copy, 0, this.writeCursor);
        }
        return copy;
    }

    @Override
    public final long length() {
        return this.writeCursor;
    }

    @Override
    public final void free() {
        this.buffer = null;
    }

    @Override
    public final BufferIterator iterator() {
        return new DefaultBufferIterator(this);
    }

    @Override
    public final void removeLast() {
        --this.writeCursor;
    }

    public final String toString() {
        return new String(this.data());
    }
}

