/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.heap;

import greycat.Callback;
import greycat.Graph;
import greycat.chunk.Chunk;
import greycat.chunk.ChunkSpace;
import greycat.chunk.Stack;
import greycat.internal.heap.HeapAtomicByteArray;
import greycat.internal.heap.HeapEGraph;
import greycat.internal.heap.HeapFixedStack;
import greycat.internal.heap.HeapGenChunk;
import greycat.internal.heap.HeapStateChunk;
import greycat.internal.heap.HeapTimeTreeChunk;
import greycat.internal.heap.HeapWorldOrderChunk;
import greycat.struct.Buffer;
import greycat.struct.BufferIterator;
import greycat.struct.EGraph;
import greycat.utility.HashHelper;
import greycat.utility.KeyHelper;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class HeapChunkSpace
implements ChunkSpace {
    private static final int HASH_LOAD_FACTOR = 4;
    private final int _maxEntries;
    private final int _hashEntries;
    private final Stack _lru;
    private final Stack _dirtiesStack;
    private final AtomicIntegerArray _hashNext;
    private final AtomicIntegerArray _hash;
    private final AtomicLongArray _chunkWorlds;
    private final AtomicLongArray _chunkTimes;
    private final AtomicLongArray _chunkIds;
    private final HeapAtomicByteArray _chunkTypes;
    private final AtomicReferenceArray<Chunk> _chunkValues;
    private final AtomicLongArray _chunkMarks;
    private final Graph _graph;
    private final boolean _deep_priority;

    @Override
    public final Graph graph() {
        return this._graph;
    }

    final long worldByIndex(long index) {
        return this._chunkWorlds.get((int)index);
    }

    final long timeByIndex(long index) {
        return this._chunkTimes.get((int)index);
    }

    final long idByIndex(long index) {
        return this._chunkIds.get((int)index);
    }

    public HeapChunkSpace(int initialCapacity, Graph p_graph, boolean deepWorldPriority) {
        int i;
        this._deep_priority = deepWorldPriority;
        this._graph = p_graph;
        this._maxEntries = initialCapacity;
        this._hashEntries = initialCapacity * 4;
        this._lru = new HeapFixedStack(initialCapacity, true);
        this._dirtiesStack = new HeapFixedStack(initialCapacity, false);
        this._hashNext = new AtomicIntegerArray(initialCapacity);
        this._hash = new AtomicIntegerArray(this._hashEntries);
        for (i = 0; i < initialCapacity; ++i) {
            this._hashNext.set(i, -1);
        }
        for (i = 0; i < this._hashEntries; ++i) {
            this._hash.set(i, -1);
        }
        this._chunkValues = new AtomicReferenceArray(initialCapacity);
        this._chunkWorlds = new AtomicLongArray(this._maxEntries);
        this._chunkTimes = new AtomicLongArray(this._maxEntries);
        this._chunkIds = new AtomicLongArray(this._maxEntries);
        this._chunkTypes = new HeapAtomicByteArray(this._maxEntries);
        this._chunkMarks = new AtomicLongArray(this._maxEntries);
        for (i = 0; i < this._maxEntries; ++i) {
            this._chunkMarks.set(i, 0L);
        }
    }

    @Override
    public final Chunk getAndMark(byte type, long world, long time, long id) {
        int index = this._deep_priority ? (int)HashHelper.tripleHash(type, world, time, id, this._hashEntries) : (int)HashHelper.simpleTripleHash(type, world, time, id, this._hashEntries);
        int m = this._hash.get(index);
        int found = -1;
        while (m != -1) {
            if (this._chunkTypes.get(m) == type && this._chunkWorlds.get(m) == world && this._chunkTimes.get(m) == time && this._chunkIds.get(m) == id) {
                if (this.mark(m) <= 0L) break;
                found = m;
                break;
            }
            m = this._hashNext.get(m);
        }
        if (found != -1) {
            return this._chunkValues.get(found);
        }
        return null;
    }

    @Override
    public final Chunk get(long index) {
        return this._chunkValues.get((int)index);
    }

    @Override
    public final void getOrLoadAndMark(final byte type, final long world, final long time, final long id, final Callback<Chunk> callback) {
        Chunk fromMemory = this.getAndMark(type, world, time, id);
        if (fromMemory != null) {
            callback.on(fromMemory);
        } else {
            final Buffer keys = this.graph().newBuffer();
            KeyHelper.keyToBuffer(keys, type, world, time, id);
            this.graph().storage().get(keys, new Callback<Buffer>(){

                @Override
                public void on(Buffer result) {
                    if (result != null && result.length() > 0L) {
                        Chunk loadedChunk = HeapChunkSpace.this.createAndMark(type, world, time, id);
                        loadedChunk.load(result);
                        result.free();
                        callback.on(loadedChunk);
                    } else {
                        keys.free();
                        callback.on(null);
                    }
                }
            });
        }
    }

    @Override
    public final void getOrLoadAndMarkAll(final long[] keys, final Callback<Chunk[]> callback) {
        int querySize = keys.length / 4;
        final Chunk[] finalResult = new Chunk[querySize];
        int[] reverse = null;
        int reverseIndex = 0;
        Buffer toLoadKeys = null;
        for (int i = 0; i < querySize; ++i) {
            int offset = i * 4;
            byte loopType = (byte)keys[offset];
            if (loopType != -1) {
                Chunk fromMemory = this.getAndMark((byte)keys[offset], keys[offset + 1], keys[offset + 2], keys[offset + 3]);
                if (fromMemory != null) {
                    finalResult[i] = fromMemory;
                    continue;
                }
                if (reverse == null) {
                    reverse = new int[querySize];
                    toLoadKeys = this.graph().newBuffer();
                }
                reverse[reverseIndex] = i;
                if (reverseIndex != 0) {
                    toLoadKeys.write((byte)35);
                }
                KeyHelper.keyToBuffer(toLoadKeys, (byte)keys[offset], keys[offset + 1], keys[offset + 2], keys[offset + 3]);
                ++reverseIndex;
                continue;
            }
            finalResult[i] = null;
        }
        if (reverse != null) {
            final int[] finalReverse = reverse;
            this.graph().storage().get(toLoadKeys, new Callback<Buffer>(){

                @Override
                public void on(Buffer loadAllResult) {
                    BufferIterator it = loadAllResult.iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        Buffer view = it.next();
                        int reversedIndex = finalReverse[i];
                        int reversedOffset = reversedIndex * 4;
                        if (view.length() > 0L) {
                            Chunk loadedChunk = HeapChunkSpace.this.createAndMark((byte)keys[reversedOffset], keys[reversedOffset + 1], keys[reversedOffset + 2], keys[reversedOffset + 3]);
                            loadedChunk.load(view);
                            finalResult[reversedIndex] = loadedChunk;
                        } else {
                            finalResult[reversedIndex] = null;
                        }
                        ++i;
                    }
                    loadAllResult.free();
                    callback.on(finalResult);
                }
            });
        } else {
            callback.on(finalResult);
        }
    }

    @Override
    public final long mark(long index) {
        long after;
        long before;
        int castedIndex = (int)index;
        while (!this._chunkMarks.compareAndSet(castedIndex, before, after = (before = this._chunkMarks.get(castedIndex)) != -1L ? before + 1L : before)) {
        }
        if (before == 0L && after == 1L) {
            this._lru.dequeue(index);
        }
        return after;
    }

    @Override
    public final void unmark(long index) {
        long after;
        long before;
        int castedIndex = (int)index;
        do {
            if ((before = this._chunkMarks.get(castedIndex)) > 0L) {
                after = before - 1L;
                continue;
            }
            System.err.println("WARNING: DOUBLE UNMARK");
            after = before;
        } while (!this._chunkMarks.compareAndSet(castedIndex, before, after));
        if (before == 1L && after == 0L) {
            this._lru.enqueue(index);
        }
    }

    @Override
    public final void free(Chunk chunk) {
    }

    @Override
    public final synchronized Chunk createAndMark(byte type, long world, long time, long id) {
        int temp_victim;
        int entry = -1;
        int hashIndex = this._deep_priority ? (int)HashHelper.tripleHash(type, world, time, id, this._hashEntries) : (int)HashHelper.simpleTripleHash(type, world, time, id, this._hashEntries);
        int m = this._hash.get(hashIndex);
        while (m >= 0) {
            if (type == this._chunkTypes.get(m) && world == this._chunkWorlds.get(m) && time == this._chunkTimes.get(m) && id == this._chunkIds.get(m)) {
                entry = m;
                break;
            }
            m = this._hashNext.get(m);
        }
        if (entry != -1) {
            long after;
            long previous;
            while (!this._chunkMarks.compareAndSet(entry, previous, after = (previous = this._chunkMarks.get(entry)) != -1L ? previous + 1L : previous)) {
            }
            if (after == previous + 1L) {
                return this._chunkValues.get(entry);
            }
        }
        int currentVictimIndex = -1;
        while (currentVictimIndex == -1 && (temp_victim = (int)this._lru.dequeueTail()) != -1) {
            if (!this._chunkMarks.compareAndSet(temp_victim, 0L, -1L)) continue;
            currentVictimIndex = temp_victim;
        }
        if (currentVictimIndex == -1) {
            throw new RuntimeException("GreyCat crashed, cache is full, please avoid to much retention of nodes or augment cache capacity! available:" + this.available());
        }
        Chunk toInsert = null;
        switch (type) {
            case 0: {
                toInsert = new HeapStateChunk(this, currentVictimIndex);
                break;
            }
            case 2: {
                toInsert = new HeapWorldOrderChunk(this, currentVictimIndex);
                break;
            }
            case 1: {
                toInsert = new HeapTimeTreeChunk(this, currentVictimIndex);
                break;
            }
            case 3: {
                toInsert = new HeapGenChunk(this, id, currentVictimIndex);
            }
        }
        if (this._chunkValues.get(currentVictimIndex) != null) {
            long victimWorld = this._chunkWorlds.get(currentVictimIndex);
            long victimTime = this._chunkTimes.get(currentVictimIndex);
            long victimObj = this._chunkIds.get(currentVictimIndex);
            byte victimType = this._chunkTypes.get(currentVictimIndex);
            int indexVictim = this._deep_priority ? (int)HashHelper.tripleHash(victimType, victimWorld, victimTime, victimObj, this._hashEntries) : (int)HashHelper.simpleTripleHash(victimType, victimWorld, victimTime, victimObj, this._hashEntries);
            m = this._hash.get(indexVictim);
            int last = -1;
            while (m >= 0 && (victimType != this._chunkTypes.get(m) || victimWorld != this._chunkWorlds.get(m) || victimTime != this._chunkTimes.get(m) || victimObj != this._chunkIds.get(m))) {
                last = m;
                m = this._hashNext.get(m);
            }
            if (last == -1) {
                int previousNext = this._hashNext.get(m);
                this._hash.set(indexVictim, previousNext);
            } else if (m == -1) {
                this._hashNext.set(last, -1);
            } else {
                this._hashNext.set(last, this._hashNext.get(m));
            }
            this._hashNext.set(m, -1);
        }
        this._chunkValues.set(currentVictimIndex, toInsert);
        this._chunkMarks.set(currentVictimIndex, 1L);
        this._chunkTypes.set(currentVictimIndex, type);
        this._chunkWorlds.set(currentVictimIndex, world);
        this._chunkTimes.set(currentVictimIndex, time);
        this._chunkIds.set(currentVictimIndex, id);
        this._hashNext.set(currentVictimIndex, this._hash.get(hashIndex));
        this._hash.set(hashIndex, currentVictimIndex);
        return toInsert;
    }

    @Override
    public final void notifyUpdate(long index) {
        if (this._dirtiesStack.enqueue(index)) {
            this.mark(index);
        }
    }

    @Override
    public final synchronized void save(final Callback<Boolean> callback) {
        final Buffer stream = this._graph.newBuffer();
        boolean isFirst = true;
        while (this._dirtiesStack.size() != 0L) {
            int tail = (int)this._dirtiesStack.dequeueTail();
            Chunk loopChunk = this._chunkValues.get(tail);
            if (isFirst) {
                isFirst = false;
            } else {
                stream.write((byte)35);
            }
            KeyHelper.keyToBuffer(stream, this._chunkTypes.get(tail), this._chunkWorlds.get(tail), this._chunkTimes.get(tail), this._chunkIds.get(tail));
            stream.write((byte)35);
            try {
                loopChunk.save(stream);
                this.unmark(tail);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.graph().storage().put(stream, new Callback<Boolean>(){

            @Override
            public void on(Boolean result) {
                stream.free();
                if (callback != null) {
                    callback.on(result);
                }
            }
        });
    }

    @Override
    public final void clear() {
    }

    @Override
    public final void freeAll() {
    }

    @Override
    public final long available() {
        return this._lru.size();
    }

    @Override
    public EGraph newVolatileGraph() {
        return new HeapEGraph(null, null, this._graph);
    }

    public final void printMarked() {
        block6: for (int i = 0; i < this._chunkValues.length(); ++i) {
            if (this._chunkValues.get(i) == null || this._chunkMarks.get(i) == 0L) continue;
            switch (this._chunkTypes.get(i)) {
                case 0: {
                    System.out.println("STATE(" + this._chunkWorlds.get(i) + "," + this._chunkTimes.get(i) + "," + this._chunkIds.get(i) + ")->marks->" + this._chunkMarks.get(i));
                    continue block6;
                }
                case 1: {
                    System.out.println("TIME_TREE(" + this._chunkWorlds.get(i) + "," + this._chunkTimes.get(i) + "," + this._chunkIds.get(i) + ")->marks->" + this._chunkMarks.get(i));
                    continue block6;
                }
                case 2: {
                    System.out.println("WORLD_ORDER(" + this._chunkWorlds.get(i) + "," + this._chunkTimes.get(i) + "," + this._chunkIds.get(i) + ")->marks->" + this._chunkMarks.get(i));
                    continue block6;
                }
                case 3: {
                    System.out.println("GENERATOR(" + this._chunkWorlds.get(i) + "," + this._chunkTimes.get(i) + "," + this._chunkIds.get(i) + ")->marks->" + this._chunkMarks.get(i));
                }
            }
        }
    }
}

