/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.heap;

import greycat.internal.heap.HeapContainer;
import greycat.struct.Buffer;
import greycat.struct.DMatrix;
import greycat.utility.Base64;
import java.util.Arrays;

class HeapDMatrix
implements DMatrix {
    private static final int INDEX_ROWS = 0;
    private static final int INDEX_COLUMNS = 1;
    private static final int INDEX_MAX_COLUMN = 2;
    private static final int INDEX_OFFSET = 3;
    private final HeapContainer parent;
    private double[] backend = null;
    private boolean aligned = true;

    HeapDMatrix(HeapContainer p_parent, HeapDMatrix origin) {
        this.parent = p_parent;
        if (origin != null) {
            this.aligned = false;
            this.backend = origin.backend;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DMatrix init(int rows, int columns) {
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            this.internal_init(rows, columns);
        }
        this.parent.declareDirty();
        return this;
    }

    private void internal_init(int rows, int columns) {
        this.backend = new double[rows * columns + 3];
        this.backend[0] = rows;
        this.backend[1] = columns;
        this.backend[2] = columns;
        this.aligned = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DMatrix appendColumn(double[] newColumn) {
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            this.internal_appendColumn(newColumn);
            this.parent.declareDirty();
        }
        return this;
    }

    private void internal_appendColumn(double[] newColumn) {
        int nbMaxColumn;
        int nbColumns;
        int nbRows;
        if (this.backend == null) {
            nbRows = newColumn.length;
            nbColumns = 8;
            nbMaxColumn = 0;
            this.backend = new double[nbRows * nbColumns + 3];
            this.backend[0] = nbRows;
            this.backend[1] = nbColumns;
            this.backend[2] = nbMaxColumn;
        } else {
            nbColumns = (int)this.backend[1];
            nbRows = (int)this.backend[0];
            nbMaxColumn = (int)this.backend[2];
        }
        if (!this.aligned || nbMaxColumn == nbColumns) {
            if (nbMaxColumn == nbColumns) {
                this.backend[1] = nbColumns *= 2;
                int newLength = nbColumns * nbRows + 3;
                double[] next_backend = new double[newLength];
                System.arraycopy(this.backend, 0, next_backend, 0, this.backend.length);
                this.backend = next_backend;
                this.aligned = true;
            } else {
                double[] next_backend = new double[this.backend.length];
                System.arraycopy(this.backend, 0, next_backend, 0, this.backend.length);
                this.backend = next_backend;
                this.aligned = true;
            }
        }
        System.arraycopy(newColumn, 0, this.backend, nbMaxColumn * nbRows + 3, newColumn.length);
        this.backend[2] = nbMaxColumn + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DMatrix fill(double value) {
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            this.internal_fill(value);
        }
        return this;
    }

    private void internal_fill(double value) {
        if (this.backend != null) {
            if (!this.aligned) {
                double[] next_backend = new double[this.backend.length];
                System.arraycopy(this.backend, 0, next_backend, 0, this.backend.length);
                this.backend = next_backend;
                this.aligned = true;
            }
            Arrays.fill(this.backend, 3, this.backend.length, value);
            this.backend[2] = this.backend[1];
            this.parent.declareDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DMatrix fillWith(double[] values) {
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            this.internal_fillWith(values);
        }
        return this;
    }

    private void internal_fillWith(double[] values) {
        if (this.backend != null) {
            if (!this.aligned) {
                double[] next_backend = new double[this.backend.length];
                System.arraycopy(this.backend, 0, next_backend, 0, this.backend.length);
                this.backend = next_backend;
                this.aligned = true;
            }
            System.arraycopy(values, 0, this.backend, 3, values.length);
            this.parent.declareDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int rows() {
        int result = 0;
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            if (this.backend != null) {
                result = (int)this.backend[0];
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int columns() {
        int result = 0;
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            if (this.backend != null) {
                result = (int)this.backend[2];
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int length() {
        int result = 0;
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            if (this.backend != null) {
                result = (int)this.backend[2] * (int)this.backend[0];
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final double[] column(int index) {
        double[] result;
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            int nbRows = (int)this.backend[0];
            result = new double[nbRows];
            System.arraycopy(this.backend, 3 + index * nbRows, result, 0, nbRows);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final double get(int rowIndex, int columnIndex) {
        double result = 0.0;
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            if (this.backend != null) {
                int nbRows = (int)this.backend[0];
                result = this.backend[3 + rowIndex + columnIndex * nbRows];
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DMatrix set(int rowIndex, int columnIndex, double value) {
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            this.internal_set(rowIndex, columnIndex, value);
        }
        return this;
    }

    private void internal_set(int rowIndex, int columnIndex, double value) {
        if (this.backend != null) {
            if (!this.aligned) {
                double[] next_backend = new double[this.backend.length];
                System.arraycopy(this.backend, 0, next_backend, 0, this.backend.length);
                this.backend = next_backend;
                this.aligned = true;
            }
            int nbRows = (int)this.backend[0];
            this.backend[3 + rowIndex + columnIndex * nbRows] = value;
            this.parent.declareDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DMatrix add(int rowIndex, int columnIndex, double value) {
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            this.internal_add(rowIndex, columnIndex, value);
        }
        return this;
    }

    private void internal_add(int rowIndex, int columnIndex, double value) {
        if (this.backend != null) {
            if (!this.aligned) {
                double[] next_backend = new double[this.backend.length];
                System.arraycopy(this.backend, 0, next_backend, 0, this.backend.length);
                this.backend = next_backend;
                this.aligned = true;
            }
            int nbRows = (int)this.backend[0];
            this.backend[3 + rowIndex + columnIndex * nbRows] = value + this.backend[3 + rowIndex + columnIndex * nbRows];
            this.parent.declareDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final double[] data() {
        double[] copy = null;
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            if (this.backend != null) {
                copy = new double[this.backend.length - 3];
                System.arraycopy(this.backend, 3, copy, 0, this.backend.length - 3);
            }
        }
        return copy;
    }

    @Override
    public int leadingDimension() {
        if (this.backend == null) {
            return 0;
        }
        return (int)Math.max(this.backend[1], this.backend[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double unsafeGet(int index) {
        double result = 0.0;
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            if (this.backend != null) {
                result = this.backend[3 + index];
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DMatrix unsafeSet(int index, double value) {
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            this.internal_unsafeSet(index, value);
        }
        return this;
    }

    private void internal_unsafeSet(int index, double value) {
        if (this.backend != null) {
            if (!this.aligned) {
                double[] next_backend = new double[this.backend.length];
                System.arraycopy(this.backend, 0, next_backend, 0, this.backend.length);
                this.backend = next_backend;
                this.aligned = true;
            }
            this.backend[3 + index] = value;
            this.parent.declareDirty();
        }
    }

    final double[] unsafe_data() {
        return this.backend;
    }

    private void unsafe_init(int size) {
        this.backend = new double[size];
        this.backend[0] = 0.0;
        this.backend[1] = 0.0;
        this.aligned = true;
    }

    private void unsafe_set(long index, double value) {
        this.backend[(int)index] = value;
    }

    public final long load(Buffer buffer, long offset, long max) {
        long cursor = offset;
        byte current = buffer.read(cursor);
        boolean isFirst = true;
        long previous = offset;
        long elemIndex = 0L;
        while (cursor < max && current != 124 && current != 36 && current != 37) {
            if (current == 58) {
                if (isFirst) {
                    this.unsafe_init(Base64.decodeToIntWithBounds(buffer, previous, cursor));
                    isFirst = false;
                } else {
                    this.unsafe_set(elemIndex, Base64.decodeToDoubleWithBounds(buffer, previous, cursor));
                    ++elemIndex;
                }
                previous = cursor + 1L;
            }
            if (++cursor >= max) continue;
            current = buffer.read(cursor);
        }
        if (isFirst) {
            this.unsafe_init(Base64.decodeToIntWithBounds(buffer, previous, cursor));
        } else {
            this.unsafe_set(elemIndex, Base64.decodeToDoubleWithBounds(buffer, previous, cursor));
        }
        return cursor;
    }
}

