/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.heap;

import greycat.Graph;
import greycat.internal.heap.HeapContainer;
import greycat.internal.heap.HeapENode;
import greycat.struct.Buffer;
import greycat.struct.EGraph;
import greycat.struct.ENode;
import greycat.utility.Base64;

class HeapEGraph
implements EGraph {
    private final Graph _graph;
    private final HeapContainer parent;
    boolean _dirty;
    HeapENode[] _nodes = null;
    private int _nodes_capacity = 0;
    private int _nodes_index = 0;

    HeapEGraph(HeapContainer p_parent, HeapEGraph origin, Graph p_graph) {
        this.parent = p_parent;
        this._graph = p_graph;
        if (origin != null) {
            int i;
            this._nodes_index = origin._nodes_index;
            this._nodes_capacity = origin._nodes_capacity;
            this._nodes = new HeapENode[this._nodes_capacity];
            for (i = 0; i < this._nodes_index; ++i) {
                this._nodes[i] = new HeapENode(this, i, origin._nodes[i]);
            }
            for (i = 0; i < this._nodes_index; ++i) {
                this._nodes[i].rebase();
            }
        }
    }

    @Override
    public final int size() {
        return this._nodes_index;
    }

    @Override
    public final void free() {
        this._nodes = null;
        this._nodes_capacity = 0;
        this._nodes_index = 0;
    }

    @Override
    public final Graph graph() {
        return this._graph;
    }

    private void allocate(int newCapacity) {
        int closePowerOfTwo = (int)Math.pow(2.0, Math.ceil(Math.log(newCapacity) / Math.log(2.0)));
        if (closePowerOfTwo > this._nodes_capacity) {
            HeapENode[] new_back = new HeapENode[closePowerOfTwo];
            if (this._nodes != null) {
                System.arraycopy(this._nodes, 0, new_back, 0, this._nodes_index);
            }
            this._nodes = new_back;
            this._nodes_capacity = closePowerOfTwo;
        }
    }

    final HeapENode nodeByIndex(int index, boolean createIfAbsent) {
        if (index < this._nodes_capacity) {
            HeapENode elem;
            if (index >= this._nodes_index) {
                this._nodes_index = index + 1;
            }
            if ((elem = this._nodes[index]) == null && createIfAbsent) {
                this._nodes[index] = elem = new HeapENode(this, index, null);
            }
            return elem;
        }
        throw new RuntimeException("bad API usage");
    }

    final void declareDirty() {
        if (!this._dirty) {
            this._dirty = true;
            if (this.parent != null) {
                this.parent.declareDirty();
            }
        }
    }

    @Override
    public final ENode newNode() {
        HeapENode newNode;
        if (this._nodes_index == this._nodes_capacity) {
            int newCapacity = this._nodes_capacity * 2;
            if (newCapacity == 0) {
                newCapacity = 8;
            }
            HeapENode[] newNodes = new HeapENode[newCapacity];
            if (this._nodes != null) {
                System.arraycopy(this._nodes, 0, newNodes, 0, this._nodes_capacity);
            }
            this._nodes_capacity = newCapacity;
            this._nodes = newNodes;
        }
        this._nodes[this._nodes_index] = newNode = new HeapENode(this, this._nodes_index, null);
        ++this._nodes_index;
        return newNode;
    }

    @Override
    public ENode node(int nodeIndex) {
        return this.nodeByIndex(nodeIndex, false);
    }

    @Override
    public final ENode root() {
        if (this._nodes_index > 0) {
            return this._nodes[0];
        }
        return null;
    }

    @Override
    public final EGraph setRoot(ENode eNode) {
        HeapENode casted = (HeapENode)eNode;
        int previousID = casted._id;
        if (previousID != 0) {
            HeapENode previousRoot;
            this._nodes[previousID] = previousRoot = this._nodes[0];
            previousRoot._id = previousID;
            this._nodes[0] = casted;
            casted._id = 0;
        }
        return this;
    }

    @Override
    public final EGraph drop(ENode eNode) {
        HeapENode casted = (HeapENode)eNode;
        int previousId = casted._id;
        if (previousId == this._nodes_index - 1) {
            this._nodes[previousId] = null;
            --this._nodes_index;
        } else {
            this._nodes[previousId] = this._nodes[this._nodes_index - 1];
            this._nodes[previousId]._id = previousId;
            --this._nodes_index;
        }
        return this;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{\"nodes\":[");
        for (int i = 0; i < this._nodes_index; ++i) {
            if (i != 0) {
                builder.append(",");
            }
            builder.append(this._nodes[i].toString());
        }
        builder.append("]}");
        return builder.toString();
    }

    public final long load(Buffer buffer, long offset, long max) {
        long cursor = offset;
        byte current = buffer.read(cursor);
        boolean isFirst = true;
        int insertIndex = 0;
        while (cursor < max && current != 124) {
            if (current == 36) {
                if (isFirst) {
                    this.allocate(Base64.decodeToIntWithBounds(buffer, offset, cursor));
                    isFirst = false;
                }
                ++cursor;
                HeapENode eNode = this.nodeByIndex(insertIndex, true);
                cursor = eNode.load(buffer, cursor, this._graph);
                ++insertIndex;
            } else {
                ++cursor;
            }
            current = buffer.read(cursor);
        }
        return cursor;
    }
}

