/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.heap;

import greycat.Constants;
import greycat.Container;
import greycat.Graph;
import greycat.Type;
import greycat.internal.CoreConstants;
import greycat.internal.heap.HeapContainer;
import greycat.internal.heap.HeapDMatrix;
import greycat.internal.heap.HeapEGraph;
import greycat.internal.heap.HeapERelation;
import greycat.internal.heap.HeapLMatrix;
import greycat.internal.heap.HeapLongLongArrayMap;
import greycat.internal.heap.HeapLongLongMap;
import greycat.internal.heap.HeapRelation;
import greycat.internal.heap.HeapRelationIndexed;
import greycat.internal.heap.HeapStringIntMap;
import greycat.plugin.NodeStateCallback;
import greycat.plugin.Resolver;
import greycat.struct.Buffer;
import greycat.struct.DMatrix;
import greycat.struct.EGraph;
import greycat.struct.ENode;
import greycat.struct.ERelation;
import greycat.struct.LMatrix;
import greycat.struct.LongLongArrayMap;
import greycat.struct.LongLongArrayMapCallBack;
import greycat.struct.LongLongMap;
import greycat.struct.LongLongMapCallBack;
import greycat.struct.Relation;
import greycat.struct.RelationIndexed;
import greycat.struct.StringIntMap;
import greycat.struct.StringLongMapCallBack;
import greycat.utility.Base64;
import java.util.Arrays;
import java.util.HashSet;

class HeapENode
implements ENode,
HeapContainer {
    private final HeapEGraph _eGraph;
    int _id;
    private int _capacity;
    private volatile int _size;
    private int[] _k;
    private Object[] _v;
    private int[] _next_hash;
    private byte[] _type;
    private boolean _dirty;
    private static final byte LOAD_WAITING_ALLOC = 0;
    private static final byte LOAD_WAITING_TYPE = 1;
    private static final byte LOAD_WAITING_KEY = 2;
    private static final byte LOAD_WAITING_VALUE = 3;

    HeapENode(HeapEGraph p_egraph, int p_id, HeapENode origin) {
        this._eGraph = p_egraph;
        this._id = p_id;
        if (origin != null) {
            this._capacity = origin._capacity;
            this._size = origin._size;
            if (origin._k != null) {
                int[] cloned_k = new int[this._capacity];
                System.arraycopy(origin._k, 0, cloned_k, 0, this._capacity);
                this._k = cloned_k;
            }
            if (origin._type != null) {
                byte[] cloned_type = new byte[this._capacity];
                System.arraycopy(origin._type, 0, cloned_type, 0, this._capacity);
                this._type = cloned_type;
            }
            if (origin._next_hash != null) {
                int[] cloned_hash = new int[this._capacity * 3];
                System.arraycopy(origin._next_hash, 0, cloned_hash, 0, this._capacity * 3);
                this._next_hash = cloned_hash;
            }
            if (origin._v != null) {
                this._v = new Object[this._capacity];
                block9: for (int i = 0; i < this._size; ++i) {
                    switch (origin._type[i]) {
                        case 10: {
                            if (origin._v[i] == null) continue block9;
                            this._v[i] = ((HeapLongLongMap)origin._v[i]).cloneFor(this);
                            continue block9;
                        }
                        case 14: {
                            if (origin._v[i] == null) continue block9;
                            this._v[i] = ((HeapRelationIndexed)origin._v[i]).cloneIRelFor(this, this._eGraph.graph());
                            continue block9;
                        }
                        case 11: {
                            if (origin._v[i] == null) continue block9;
                            this._v[i] = ((HeapLongLongArrayMap)origin._v[i]).cloneFor(this);
                            continue block9;
                        }
                        case 12: {
                            if (origin._v[i] == null) continue block9;
                            this._v[i] = ((HeapStringIntMap)origin._v[i]).cloneFor(this);
                            continue block9;
                        }
                        case 13: {
                            if (origin._v[i] == null) continue block9;
                            this._v[i] = new HeapRelation(this, (HeapRelation)origin._v[i]);
                            continue block9;
                        }
                        case 15: {
                            if (origin._v[i] == null) continue block9;
                            this._v[i] = new HeapDMatrix(this, (HeapDMatrix)origin._v[i]);
                            continue block9;
                        }
                        case 16: {
                            if (origin._v[i] == null) continue block9;
                            this._v[i] = new HeapLMatrix(this, (HeapLMatrix)origin._v[i]);
                            continue block9;
                        }
                        default: {
                            this._v[i] = origin._v[i];
                        }
                    }
                }
            }
        } else {
            this._capacity = 0;
            this._size = 0;
        }
    }

    @Override
    public final ENode clear() {
        this._capacity = 0;
        this._size = 0;
        this._k = null;
        this._v = null;
        this._next_hash = null;
        this._type = null;
        return this;
    }

    @Override
    public final void declareDirty() {
        if (!this._dirty) {
            this._dirty = true;
            this._eGraph.declareDirty();
        }
    }

    final void rebase() {
        block4: for (int i = 0; i < this._size; ++i) {
            switch (this._type[i]) {
                case 19: {
                    HeapERelation previousERel = (HeapERelation)this._v[i];
                    previousERel.rebase(this._eGraph);
                    continue block4;
                }
                case 18: {
                    HeapENode previous = (HeapENode)this._v[i];
                    this._v[i] = this._eGraph._nodes[previous._id];
                }
            }
        }
    }

    private void allocate(int newCapacity) {
        if (newCapacity <= this._capacity) {
            return;
        }
        int[] ex_k = new int[newCapacity];
        if (this._k != null) {
            System.arraycopy(this._k, 0, ex_k, 0, this._capacity);
        }
        this._k = ex_k;
        Object[] ex_v = new Object[newCapacity];
        if (this._v != null) {
            System.arraycopy(this._v, 0, ex_v, 0, this._capacity);
        }
        this._v = ex_v;
        byte[] ex_type = new byte[newCapacity];
        if (this._type != null) {
            System.arraycopy(this._type, 0, ex_type, 0, this._capacity);
        }
        this._type = ex_type;
        this._capacity = newCapacity;
        this._next_hash = new int[this._capacity * 3];
        Arrays.fill(this._next_hash, 0, this._capacity * 3, -1);
        int double_capacity = this._capacity * 2;
        int i = 0;
        while (i < this._size) {
            int keyHash = this._k[i] % double_capacity;
            if (keyHash < 0) {
                keyHash *= -1;
            }
            this._next_hash[i] = this._next_hash[this._capacity + keyHash];
            this._next_hash[this._capacity + keyHash] = i++;
        }
    }

    private int internal_find(int p_key) {
        if (this._size == 0) {
            return -1;
        }
        int hashIndex = p_key % (this._capacity * 2);
        if (hashIndex < 0) {
            hashIndex *= -1;
        }
        int m = this._next_hash[this._capacity + hashIndex];
        while (m >= 0) {
            if (p_key == this._k[m]) {
                return m;
            }
            m = this._next_hash[m];
        }
        return -1;
    }

    private Object internal_get(int p_key) {
        if (this._size == 0) {
            return null;
        }
        int found = this.internal_find(p_key);
        if (found != -1) {
            return this._v[found];
        }
        return null;
    }

    private byte internal_type(int p_key) {
        if (this._size == 0) {
            return -1;
        }
        int found = this.internal_find(p_key);
        if (found != -1) {
            return this._type[found];
        }
        return -1;
    }

    private void internal_set(int p_key, byte p_type, Object p_unsafe_elem, boolean replaceIfPresent, boolean initial) {
        Object param_elem = null;
        if (p_unsafe_elem != null) {
            try {
                switch (p_type) {
                    case 1: {
                        param_elem = (boolean)((Boolean)p_unsafe_elem);
                        break;
                    }
                    case 5: {
                        param_elem = (double)((Double)p_unsafe_elem);
                        break;
                    }
                    case 3: {
                        if (p_unsafe_elem instanceof Integer) {
                            int preCasting = (Integer)p_unsafe_elem;
                            param_elem = (long)preCasting;
                            break;
                        }
                        param_elem = (long)((Long)p_unsafe_elem);
                        break;
                    }
                    case 4: {
                        param_elem = (int)((Integer)p_unsafe_elem);
                        break;
                    }
                    case 2: {
                        param_elem = (String)p_unsafe_elem;
                        break;
                    }
                    case 15: {
                        param_elem = (DMatrix)p_unsafe_elem;
                        break;
                    }
                    case 16: {
                        param_elem = (LMatrix)p_unsafe_elem;
                        break;
                    }
                    case 13: {
                        param_elem = (Relation)p_unsafe_elem;
                        break;
                    }
                    case 19: {
                        param_elem = (ERelation)p_unsafe_elem;
                        break;
                    }
                    case 18: {
                        param_elem = (ENode)p_unsafe_elem;
                        break;
                    }
                    case 6: {
                        double[] castedParamDouble = (double[])p_unsafe_elem;
                        double[] clonedDoubleArray = new double[castedParamDouble.length];
                        System.arraycopy(castedParamDouble, 0, clonedDoubleArray, 0, castedParamDouble.length);
                        param_elem = clonedDoubleArray;
                        break;
                    }
                    case 7: {
                        long[] castedParamLong = (long[])p_unsafe_elem;
                        long[] clonedLongArray = new long[castedParamLong.length];
                        System.arraycopy(castedParamLong, 0, clonedLongArray, 0, castedParamLong.length);
                        param_elem = clonedLongArray;
                        break;
                    }
                    case 8: {
                        int[] castedParamInt = (int[])p_unsafe_elem;
                        int[] clonedIntArray = new int[castedParamInt.length];
                        System.arraycopy(castedParamInt, 0, clonedIntArray, 0, castedParamInt.length);
                        param_elem = clonedIntArray;
                        break;
                    }
                    case 12: {
                        param_elem = (StringIntMap)p_unsafe_elem;
                        break;
                    }
                    case 10: {
                        param_elem = (LongLongMap)p_unsafe_elem;
                        break;
                    }
                    case 11: {
                        param_elem = (LongLongArrayMap)p_unsafe_elem;
                        break;
                    }
                    case 14: {
                        param_elem = (RelationIndexed)p_unsafe_elem;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Internal Exception, unknown type");
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("GreyCat usage error, set method called with type " + Type.typeName(p_type) + " while param object is " + p_unsafe_elem);
            }
        }
        if (this._k == null) {
            if (param_elem == null) {
                return;
            }
            this._capacity = 8;
            this._k = new int[this._capacity];
            this._v = new Object[this._capacity];
            this._type = new byte[this._capacity];
            this._next_hash = new int[this._capacity * 3];
            Arrays.fill(this._next_hash, 0, this._capacity * 3, -1);
            this._k[0] = p_key;
            this._v[0] = param_elem;
            this._type[0] = p_type;
            this._size = 1;
            int hashIndex = p_key % (this._capacity * 2);
            if (hashIndex < 0) {
                hashIndex *= -1;
            }
            this._next_hash[this._capacity + hashIndex] = 0;
            if (!initial) {
                this.declareDirty();
            }
            return;
        }
        int entry = -1;
        int p_entry = -1;
        int hashIndex = p_key % (this._capacity * 2);
        if (hashIndex < 0) {
            hashIndex *= -1;
        }
        int m = this._next_hash[this._capacity + hashIndex];
        while (m != -1) {
            if (this._k[m] == p_key) {
                entry = m;
                break;
            }
            p_entry = m;
            m = this._next_hash[m];
        }
        if (entry != -1) {
            if (replaceIfPresent || p_type != this._type[entry]) {
                if (param_elem == null) {
                    if (p_entry != -1) {
                        this._next_hash[p_entry] = this._next_hash[entry];
                    } else {
                        this._next_hash[this._capacity + hashIndex] = -1;
                    }
                    int indexVictim = this._size - 1;
                    if (entry == indexVictim) {
                        this._k[entry] = -1;
                        this._v[entry] = null;
                        this._type[entry] = -1;
                    } else {
                        this._k[entry] = this._k[indexVictim];
                        this._v[entry] = this._v[indexVictim];
                        this._type[entry] = this._type[indexVictim];
                        this._next_hash[entry] = this._next_hash[indexVictim];
                        int victimHash = this._k[entry] % (this._capacity * 2);
                        if (victimHash < 0) {
                            victimHash *= -1;
                        }
                        if ((m = this._next_hash[this._capacity + victimHash]) == indexVictim) {
                            this._next_hash[this._capacity + victimHash] = entry;
                        } else {
                            while (m != -1) {
                                if (this._next_hash[m] == indexVictim) {
                                    this._next_hash[m] = entry;
                                    break;
                                }
                                m = this._next_hash[m];
                            }
                        }
                        this._k[indexVictim] = -1;
                        this._v[indexVictim] = null;
                        this._type[indexVictim] = -1;
                    }
                    --this._size;
                } else {
                    this._v[entry] = param_elem;
                    if (this._type[entry] != p_type) {
                        this._type[entry] = p_type;
                    }
                }
            }
            if (!initial) {
                this.declareDirty();
            }
            return;
        }
        if (this._size < this._capacity) {
            this._k[this._size] = p_key;
            this._v[this._size] = param_elem;
            this._type[this._size] = p_type;
            this._next_hash[this._size] = this._next_hash[this._capacity + hashIndex];
            this._next_hash[this._capacity + hashIndex] = this._size++;
            if (!initial) {
                this.declareDirty();
            }
            return;
        }
        int newCapacity = this._capacity * 2;
        int[] ex_k = new int[newCapacity];
        System.arraycopy(this._k, 0, ex_k, 0, this._capacity);
        this._k = ex_k;
        Object[] ex_v = new Object[newCapacity];
        System.arraycopy(this._v, 0, ex_v, 0, this._capacity);
        this._v = ex_v;
        byte[] ex_type = new byte[newCapacity];
        System.arraycopy(this._type, 0, ex_type, 0, this._capacity);
        this._type = ex_type;
        this._capacity = newCapacity;
        this._k[this._size] = p_key;
        this._v[this._size] = param_elem;
        this._type[this._size] = p_type;
        ++this._size;
        this._next_hash = new int[this._capacity * 3];
        Arrays.fill(this._next_hash, 0, this._capacity * 3, -1);
        int hashCapacity = this._capacity * 2;
        int i = 0;
        while (i < this._size) {
            int keyHash = this._k[i] % hashCapacity;
            if (keyHash < 0) {
                keyHash *= -1;
            }
            this._next_hash[i] = this._next_hash[this._capacity + keyHash];
            this._next_hash[this._capacity + keyHash] = i++;
        }
        if (!initial) {
            this.declareDirty();
        }
    }

    @Override
    public ENode set(String name, byte type, Object value) {
        this.internal_set(this._eGraph.graph().resolver().stringToHash(name, true), type, value, true, false);
        return this;
    }

    @Override
    public ENode setAt(int key, byte type, Object value) {
        this.internal_set(key, type, value, true, false);
        return this;
    }

    @Override
    public Container remove(String name) {
        this.internal_set(this._eGraph.graph().resolver().stringToHash(name, true), (byte)4, null, true, false);
        return this;
    }

    @Override
    public Container removeAt(int index) {
        this.internal_set(index, (byte)4, null, true, false);
        return this;
    }

    @Override
    public Object get(String name) {
        return this.internal_get(this._eGraph.graph().resolver().stringToHash(name, false));
    }

    @Override
    public Object getAt(int key) {
        return this.internal_get(key);
    }

    @Override
    public byte type(String name) {
        return this.internal_type(this._eGraph.graph().resolver().stringToHash(name, false));
    }

    @Override
    public byte typeAt(int key) {
        return this.internal_type(key);
    }

    @Override
    public <A> A getWithDefault(String key, A defaultValue) {
        Object result = this.get(key);
        if (result == null) {
            return defaultValue;
        }
        return (A)result;
    }

    @Override
    public <A> A getAtWithDefault(int key, A defaultValue) {
        Object result = this.internal_get(key);
        if (result == null) {
            return defaultValue;
        }
        return (A)result;
    }

    @Override
    public void drop() {
        this._eGraph.drop(this);
    }

    @Override
    public EGraph egraph() {
        return this._eGraph;
    }

    @Override
    public Object getOrCreate(String key, byte type) {
        Object previous = this.get(key);
        if (previous != null) {
            return previous;
        }
        return this.getOrCreateAt(this._eGraph.graph().resolver().stringToHash(key, true), type);
    }

    @Override
    public final Object getOrCreateAt(int key, byte type) {
        int found = this.internal_find(key);
        if (found != -1 && this._type[found] == type) {
            return this._v[found];
        }
        Object toSet = null;
        switch (type) {
            case 19: {
                toSet = new HeapERelation(this, null);
                break;
            }
            case 13: {
                toSet = new HeapRelation(this, null);
                break;
            }
            case 14: {
                toSet = new HeapRelationIndexed(this, this._eGraph.graph());
                break;
            }
            case 15: {
                toSet = new HeapDMatrix(this, null);
                break;
            }
            case 16: {
                toSet = new HeapLMatrix(this, null);
                break;
            }
            case 12: {
                toSet = new HeapStringIntMap(this);
                break;
            }
            case 10: {
                toSet = new HeapLongLongMap(this);
                break;
            }
            case 11: {
                toSet = new HeapLongLongArrayMap(this);
            }
        }
        this.internal_set(key, type, toSet, true, false);
        return toSet;
    }

    public String toString() {
        final StringBuilder builder = new StringBuilder();
        final boolean[] isFirst = new boolean[]{true};
        boolean isFirstField = true;
        builder.append("{");
        block15: for (int i = 0; i < this._size; ++i) {
            Object elem = this._v[i];
            Resolver resolver = this._eGraph.graph().resolver();
            int attributeKey = this._k[i];
            byte elemType = this._type[i];
            if (elem == null) continue;
            if (isFirstField) {
                isFirstField = false;
            } else {
                builder.append(",");
            }
            String resolveName = resolver.hashToString(attributeKey);
            if (resolveName == null) {
                resolveName = attributeKey + "";
            }
            switch (elemType) {
                case 1: {
                    builder.append("\"");
                    builder.append(resolveName);
                    builder.append("\":");
                    if (((Boolean)elem).booleanValue()) {
                        builder.append("1");
                        continue block15;
                    }
                    builder.append("0");
                    continue block15;
                }
                case 2: {
                    builder.append("\"");
                    builder.append(resolveName);
                    builder.append("\":");
                    builder.append("\"");
                    builder.append(elem);
                    builder.append("\"");
                    continue block15;
                }
                case 3: {
                    builder.append("\"");
                    builder.append(resolveName);
                    builder.append("\":");
                    builder.append(elem);
                    continue block15;
                }
                case 4: {
                    builder.append("\"");
                    builder.append(resolveName);
                    builder.append("\":");
                    builder.append(elem);
                    continue block15;
                }
                case 5: {
                    if (Constants.isNaN((Double)elem)) continue block15;
                    builder.append("\"");
                    builder.append(resolveName);
                    builder.append("\":");
                    builder.append(elem);
                    continue block15;
                }
                case 6: {
                    builder.append("\"");
                    builder.append(resolveName);
                    builder.append("\":");
                    builder.append("[");
                    double[] castedArr = (double[])elem;
                    for (int j = 0; j < castedArr.length; ++j) {
                        if (j != 0) {
                            builder.append(",");
                        }
                        builder.append(castedArr[j]);
                    }
                    builder.append("]");
                    continue block15;
                }
                case 13: {
                    builder.append("\"");
                    builder.append(resolveName);
                    builder.append("\":");
                    builder.append("[");
                    Relation castedRelArr = (Relation)elem;
                    for (int j = 0; j < castedRelArr.size(); ++j) {
                        if (j != 0) {
                            builder.append(",");
                        }
                        builder.append(castedRelArr.get(j));
                    }
                    builder.append("]");
                    continue block15;
                }
                case 19: {
                    builder.append("\"");
                    builder.append(resolveName);
                    builder.append("\":");
                    builder.append("[");
                    ERelation castedERelArr = (ERelation)elem;
                    for (int j = 0; j < castedERelArr.size(); ++j) {
                        if (j != 0) {
                            builder.append(",");
                        }
                        builder.append(((HeapENode)castedERelArr.node((int)j))._id);
                    }
                    builder.append("]");
                    continue block15;
                }
                case 7: {
                    builder.append("\"");
                    builder.append(resolveName);
                    builder.append("\":");
                    builder.append("[");
                    long[] castedArr2 = (long[])elem;
                    for (int j = 0; j < castedArr2.length; ++j) {
                        if (j != 0) {
                            builder.append(",");
                        }
                        builder.append(castedArr2[j]);
                    }
                    builder.append("]");
                    continue block15;
                }
                case 8: {
                    builder.append("\"");
                    builder.append(resolveName);
                    builder.append("\":");
                    builder.append("[");
                    int[] castedArr3 = (int[])elem;
                    for (int j = 0; j < castedArr3.length; ++j) {
                        if (j != 0) {
                            builder.append(",");
                        }
                        builder.append(castedArr3[j]);
                    }
                    builder.append("]");
                    continue block15;
                }
                case 10: {
                    builder.append("\"");
                    builder.append(resolveName);
                    builder.append("\":");
                    builder.append("{");
                    LongLongMap castedMapL2L = (LongLongMap)elem;
                    isFirst[0] = true;
                    castedMapL2L.each(new LongLongMapCallBack(){

                        @Override
                        public void on(long key, long value) {
                            if (!isFirst[0]) {
                                builder.append(",");
                            } else {
                                isFirst[0] = false;
                            }
                            builder.append("\"");
                            builder.append(key);
                            builder.append("\":");
                            builder.append(value);
                        }
                    });
                    builder.append("}");
                    continue block15;
                }
                case 11: 
                case 14: {
                    builder.append("\"");
                    builder.append(resolveName);
                    builder.append("\":");
                    builder.append("{");
                    LongLongArrayMap castedMapL2LA = (LongLongArrayMap)elem;
                    isFirst[0] = true;
                    final HashSet keys = new HashSet();
                    castedMapL2LA.each(new LongLongArrayMapCallBack(){

                        @Override
                        public void on(long key, long value) {
                            keys.add(key);
                        }
                    });
                    Long[] flatKeys = keys.toArray(new Long[keys.size()]);
                    for (int k = 0; k < flatKeys.length; ++k) {
                        long[] values = castedMapL2LA.get(flatKeys[k]);
                        if (!isFirst[0]) {
                            builder.append(",");
                        } else {
                            isFirst[0] = false;
                        }
                        builder.append("\"");
                        builder.append(flatKeys[k]);
                        builder.append("\":[");
                        for (int j = 0; j < values.length; ++j) {
                            if (j != 0) {
                                builder.append(",");
                            }
                            builder.append(values[j]);
                        }
                        builder.append("]");
                    }
                    builder.append("}");
                    continue block15;
                }
                case 12: {
                    builder.append("\"");
                    builder.append(resolveName);
                    builder.append("\":");
                    builder.append("{");
                    StringIntMap castedMapS2L = (StringIntMap)elem;
                    isFirst[0] = true;
                    castedMapS2L.each(new StringLongMapCallBack(){

                        @Override
                        public void on(String key, long value) {
                            if (!isFirst[0]) {
                                builder.append(",");
                            } else {
                                isFirst[0] = false;
                            }
                            builder.append("\"");
                            builder.append(key);
                            builder.append("\":");
                            builder.append(value);
                        }
                    });
                    builder.append("}");
                    continue block15;
                }
            }
        }
        builder.append("}");
        return builder.toString();
    }

    final void save(final Buffer buffer) {
        Base64.encodeIntToBuffer(this._size, buffer);
        block18: for (int i = 0; i < this._size; ++i) {
            Object loopValue;
            if (this._v[i] == null || (loopValue = this._v[i]) == null) continue;
            buffer.write((byte)37);
            Base64.encodeIntToBuffer(this._type[i], buffer);
            buffer.write((byte)37);
            Base64.encodeIntToBuffer(this._k[i], buffer);
            buffer.write((byte)37);
            switch (this._type[i]) {
                case 18: {
                    Base64.encodeIntToBuffer(((HeapENode)loopValue)._id, buffer);
                    continue block18;
                }
                case 19: {
                    HeapERelation castedLongArrERel = (HeapERelation)loopValue;
                    Base64.encodeIntToBuffer(castedLongArrERel.size(), buffer);
                    for (int j = 0; j < castedLongArrERel.size(); ++j) {
                        buffer.write((byte)58);
                        Base64.encodeIntToBuffer(((HeapENode)castedLongArrERel.node((int)j))._id, buffer);
                    }
                    continue block18;
                }
                case 2: {
                    Base64.encodeStringToBuffer((String)loopValue, buffer);
                    continue block18;
                }
                case 1: {
                    if (((Boolean)this._v[i]).booleanValue()) {
                        Base64.encodeIntToBuffer(CoreConstants.BOOL_TRUE, buffer);
                        continue block18;
                    }
                    Base64.encodeIntToBuffer(CoreConstants.BOOL_FALSE, buffer);
                    continue block18;
                }
                case 3: {
                    Base64.encodeLongToBuffer((Long)loopValue, buffer);
                    continue block18;
                }
                case 5: {
                    Base64.encodeDoubleToBuffer((Double)loopValue, buffer);
                    continue block18;
                }
                case 4: {
                    Base64.encodeIntToBuffer((Integer)loopValue, buffer);
                    continue block18;
                }
                case 6: {
                    double[] castedDoubleArr = (double[])loopValue;
                    Base64.encodeIntToBuffer(castedDoubleArr.length, buffer);
                    for (int j = 0; j < castedDoubleArr.length; ++j) {
                        buffer.write((byte)58);
                        Base64.encodeDoubleToBuffer(castedDoubleArr[j], buffer);
                    }
                    continue block18;
                }
                case 13: {
                    HeapRelation castedLongArrRel = (HeapRelation)loopValue;
                    Base64.encodeIntToBuffer(castedLongArrRel.size(), buffer);
                    for (int j = 0; j < castedLongArrRel.size(); ++j) {
                        buffer.write((byte)58);
                        Base64.encodeLongToBuffer(castedLongArrRel.unsafe_get(j), buffer);
                    }
                    continue block18;
                }
                case 7: {
                    long[] castedLongArr = (long[])loopValue;
                    Base64.encodeIntToBuffer(castedLongArr.length, buffer);
                    for (int j = 0; j < castedLongArr.length; ++j) {
                        buffer.write((byte)58);
                        Base64.encodeLongToBuffer(castedLongArr[j], buffer);
                    }
                    continue block18;
                }
                case 8: {
                    int[] castedIntArr = (int[])loopValue;
                    Base64.encodeIntToBuffer(castedIntArr.length, buffer);
                    for (int j = 0; j < castedIntArr.length; ++j) {
                        buffer.write((byte)58);
                        Base64.encodeIntToBuffer(castedIntArr[j], buffer);
                    }
                    continue block18;
                }
                case 15: {
                    HeapDMatrix castedMatrix = (HeapDMatrix)loopValue;
                    double[] unsafeContent = castedMatrix.unsafe_data();
                    if (unsafeContent == null) continue block18;
                    Base64.encodeIntToBuffer(unsafeContent.length, buffer);
                    for (int j = 0; j < unsafeContent.length; ++j) {
                        buffer.write((byte)58);
                        Base64.encodeDoubleToBuffer(unsafeContent[j], buffer);
                    }
                    continue block18;
                }
                case 16: {
                    HeapLMatrix castedLMatrix = (HeapLMatrix)loopValue;
                    long[] unsafeLContent = castedLMatrix.unsafe_data();
                    if (unsafeLContent == null) continue block18;
                    Base64.encodeIntToBuffer(unsafeLContent.length, buffer);
                    for (int j = 0; j < unsafeLContent.length; ++j) {
                        buffer.write((byte)58);
                        Base64.encodeLongToBuffer(unsafeLContent[j], buffer);
                    }
                    continue block18;
                }
                case 12: {
                    HeapStringIntMap castedStringLongMap = (HeapStringIntMap)loopValue;
                    Base64.encodeIntToBuffer(castedStringLongMap.size(), buffer);
                    castedStringLongMap.unsafe_each(new StringLongMapCallBack(){

                        @Override
                        public void on(String key, long value) {
                            buffer.write((byte)58);
                            Base64.encodeStringToBuffer(key, buffer);
                            buffer.write((byte)58);
                            Base64.encodeLongToBuffer(value, buffer);
                        }
                    });
                    continue block18;
                }
                case 10: {
                    HeapLongLongMap castedLongLongMap = (HeapLongLongMap)loopValue;
                    Base64.encodeIntToBuffer(castedLongLongMap.size(), buffer);
                    castedLongLongMap.unsafe_each(new LongLongMapCallBack(){

                        @Override
                        public void on(long key, long value) {
                            buffer.write((byte)58);
                            Base64.encodeLongToBuffer(key, buffer);
                            buffer.write((byte)58);
                            Base64.encodeLongToBuffer(value, buffer);
                        }
                    });
                    continue block18;
                }
                case 11: 
                case 14: {
                    HeapLongLongArrayMap castedLongLongArrayMap = (HeapLongLongArrayMap)loopValue;
                    Base64.encodeIntToBuffer(castedLongLongArrayMap.size(), buffer);
                    castedLongLongArrayMap.unsafe_each(new LongLongArrayMapCallBack(){

                        @Override
                        public void on(long key, long value) {
                            buffer.write((byte)58);
                            Base64.encodeLongToBuffer(key, buffer);
                            buffer.write((byte)58);
                            Base64.encodeLongToBuffer(value, buffer);
                        }
                    });
                    continue block18;
                }
            }
        }
        this._dirty = false;
    }

    public final long load(Buffer buffer, long currentCursor, Graph graph) {
        byte current;
        long cursor;
        boolean initial = this._k == null;
        long payloadSize = buffer.length();
        long previous = cursor = currentCursor;
        int state = 0;
        byte read_type = -1;
        int read_key = -1;
        while (cursor < payloadSize && (current = buffer.read(cursor)) != 36 && current != 124) {
            if (current == 37) {
                block0 : switch (state) {
                    case 0: {
                        int closePowerOfTwo = (int)Math.pow(2.0, Math.ceil(Math.log(Base64.decodeToIntWithBounds(buffer, previous, cursor)) / Math.log(2.0)));
                        this.allocate(closePowerOfTwo);
                        state = 1;
                        previous = ++cursor;
                        break;
                    }
                    case 1: {
                        read_type = (byte)Base64.decodeToIntWithBounds(buffer, previous, cursor);
                        state = 2;
                        previous = ++cursor;
                        break;
                    }
                    case 2: {
                        read_key = Base64.decodeToIntWithBounds(buffer, previous, cursor);
                        switch (read_type) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 18: {
                                state = 3;
                                previous = ++cursor;
                                break block0;
                            }
                            case 6: {
                                double[] doubleArrayLoaded = null;
                                int doubleArrayIndex = 0;
                                previous = ++cursor;
                                current = buffer.read(cursor);
                                while (cursor < payloadSize && current != 124 && current != 36 && current != 37) {
                                    if (current == 58) {
                                        if (doubleArrayLoaded == null) {
                                            doubleArrayLoaded = new double[(int)Base64.decodeToLongWithBounds(buffer, previous, cursor)];
                                        } else {
                                            doubleArrayLoaded[doubleArrayIndex] = Base64.decodeToDoubleWithBounds(buffer, previous, cursor);
                                            ++doubleArrayIndex;
                                        }
                                        previous = cursor + 1L;
                                    }
                                    if (++cursor >= payloadSize) continue;
                                    current = buffer.read(cursor);
                                }
                                if (doubleArrayLoaded == null) {
                                    doubleArrayLoaded = new double[(int)Base64.decodeToLongWithBounds(buffer, previous, cursor)];
                                } else {
                                    doubleArrayLoaded[doubleArrayIndex] = Base64.decodeToDoubleWithBounds(buffer, previous, cursor);
                                }
                                this.internal_set(read_key, read_type, doubleArrayLoaded, true, initial);
                                if (current != 37 || cursor >= payloadSize) break block0;
                                state = 1;
                                previous = ++cursor;
                                break block0;
                            }
                            case 7: {
                                long[] longArrayLoaded = null;
                                int longArrayIndex = 0;
                                previous = ++cursor;
                                current = buffer.read(cursor);
                                while (cursor < payloadSize && current != 124 && current != 36 && current != 37) {
                                    if (current == 58) {
                                        if (longArrayLoaded == null) {
                                            longArrayLoaded = new long[(int)Base64.decodeToLongWithBounds(buffer, previous, cursor)];
                                        } else {
                                            longArrayLoaded[longArrayIndex] = Base64.decodeToLongWithBounds(buffer, previous, cursor);
                                            ++longArrayIndex;
                                        }
                                        previous = cursor + 1L;
                                    }
                                    if (++cursor >= payloadSize) continue;
                                    current = buffer.read(cursor);
                                }
                                if (longArrayLoaded == null) {
                                    longArrayLoaded = new long[(int)Base64.decodeToLongWithBounds(buffer, previous, cursor)];
                                } else {
                                    longArrayLoaded[longArrayIndex] = Base64.decodeToLongWithBounds(buffer, previous, cursor);
                                }
                                this.internal_set(read_key, read_type, longArrayLoaded, true, initial);
                                if (current != 37 || cursor >= payloadSize) break block0;
                                state = 1;
                                previous = ++cursor;
                                break block0;
                            }
                            case 8: {
                                int[] intArrayLoaded = null;
                                int intArrayIndex = 0;
                                previous = ++cursor;
                                current = buffer.read(cursor);
                                while (cursor < payloadSize && current != 124 && current != 36 && current != 37) {
                                    if (current == 58) {
                                        if (intArrayLoaded == null) {
                                            intArrayLoaded = new int[(int)Base64.decodeToLongWithBounds(buffer, previous, cursor)];
                                        } else {
                                            intArrayLoaded[intArrayIndex] = Base64.decodeToIntWithBounds(buffer, previous, cursor);
                                            ++intArrayIndex;
                                        }
                                        previous = cursor + 1L;
                                    }
                                    if (++cursor >= payloadSize) continue;
                                    current = buffer.read(cursor);
                                }
                                if (intArrayLoaded == null) {
                                    intArrayLoaded = new int[(int)Base64.decodeToLongWithBounds(buffer, previous, cursor)];
                                } else {
                                    intArrayLoaded[intArrayIndex] = Base64.decodeToIntWithBounds(buffer, previous, cursor);
                                }
                                this.internal_set(read_key, read_type, intArrayLoaded, true, initial);
                                if (current != 37 || cursor >= payloadSize) break block0;
                                state = 1;
                                previous = ++cursor;
                                break block0;
                            }
                            case 13: {
                                HeapRelation relation = new HeapRelation(this, null);
                                ++cursor;
                                cursor = relation.load(buffer, cursor, payloadSize);
                                this.internal_set(read_key, read_type, relation, true, initial);
                                if (cursor >= payloadSize || (current = buffer.read(cursor)) != 37 || cursor >= payloadSize) break block0;
                                state = 1;
                                previous = ++cursor;
                                break block0;
                            }
                            case 15: {
                                HeapDMatrix matrix = new HeapDMatrix(this, null);
                                ++cursor;
                                cursor = matrix.load(buffer, cursor, payloadSize);
                                this.internal_set(read_key, read_type, matrix, true, initial);
                                if (cursor >= payloadSize || (current = buffer.read(cursor)) != 37 || cursor >= payloadSize) break block0;
                                state = 1;
                                previous = ++cursor;
                                break block0;
                            }
                            case 16: {
                                HeapLMatrix lmatrix = new HeapLMatrix(this, null);
                                ++cursor;
                                cursor = lmatrix.load(buffer, cursor, payloadSize);
                                this.internal_set(read_key, read_type, lmatrix, true, initial);
                                if (cursor >= payloadSize || (current = buffer.read(cursor)) != 37 || cursor >= payloadSize) break block0;
                                state = 1;
                                previous = ++cursor;
                                break block0;
                            }
                            case 10: {
                                HeapLongLongMap l2lmap = new HeapLongLongMap(this);
                                ++cursor;
                                cursor = l2lmap.load(buffer, cursor, payloadSize);
                                this.internal_set(read_key, read_type, l2lmap, true, initial);
                                if (cursor >= payloadSize || (current = buffer.read(cursor)) != 37 || cursor >= payloadSize) break block0;
                                state = 1;
                                previous = ++cursor;
                                break block0;
                            }
                            case 11: {
                                HeapLongLongArrayMap l2lrmap = new HeapLongLongArrayMap(this);
                                ++cursor;
                                cursor = l2lrmap.load(buffer, cursor, payloadSize);
                                this.internal_set(read_key, read_type, l2lrmap, true, initial);
                                if (cursor >= payloadSize || (current = buffer.read(cursor)) != 37 || cursor >= payloadSize) break block0;
                                state = 1;
                                previous = ++cursor;
                                break block0;
                            }
                            case 14: {
                                HeapRelationIndexed relationIndexed = new HeapRelationIndexed(this, graph);
                                ++cursor;
                                cursor = relationIndexed.load(buffer, cursor, payloadSize);
                                this.internal_set(read_key, read_type, relationIndexed, true, initial);
                                if (cursor >= payloadSize || (current = buffer.read(cursor)) != 37 || cursor >= payloadSize) break block0;
                                state = 1;
                                previous = ++cursor;
                                break block0;
                            }
                            case 12: {
                                HeapStringIntMap s2lmap = new HeapStringIntMap(this);
                                ++cursor;
                                cursor = s2lmap.load(buffer, cursor, payloadSize);
                                this.internal_set(read_key, read_type, s2lmap, true, initial);
                                if (cursor >= payloadSize || (current = buffer.read(cursor)) != 37 || cursor >= payloadSize) break block0;
                                state = 1;
                                previous = ++cursor;
                                break block0;
                            }
                            case 19: {
                                HeapERelation eRelation = null;
                                previous = ++cursor;
                                current = buffer.read(cursor);
                                while (cursor < payloadSize && current != 124 && current != 36 && current != 37) {
                                    if (current == 58) {
                                        if (eRelation == null) {
                                            eRelation = new HeapERelation(this, null);
                                            eRelation.allocate(Base64.decodeToIntWithBounds(buffer, previous, cursor));
                                        } else {
                                            eRelation.add(this._eGraph.nodeByIndex((int)Base64.decodeToLongWithBounds(buffer, previous, cursor), true));
                                        }
                                        previous = cursor + 1L;
                                    }
                                    if (++cursor >= payloadSize) continue;
                                    current = buffer.read(cursor);
                                }
                                if (eRelation == null) {
                                    eRelation = new HeapERelation(this, null);
                                    eRelation.allocate(Base64.decodeToIntWithBounds(buffer, previous, cursor));
                                } else {
                                    eRelation.add(this._eGraph.nodeByIndex(Base64.decodeToIntWithBounds(buffer, previous, cursor), true));
                                }
                                this.internal_set(read_key, read_type, eRelation, true, initial);
                                if (current != 37 || cursor >= payloadSize) break block0;
                                state = 1;
                                previous = ++cursor;
                                break block0;
                            }
                        }
                        throw new RuntimeException("Not implemented yet!!!");
                    }
                    case 3: {
                        this.load_primitive(read_key, read_type, buffer, previous, cursor, initial);
                        state = 1;
                        previous = ++cursor;
                    }
                }
                continue;
            }
            ++cursor;
        }
        if (state == 3) {
            this.load_primitive(read_key, read_type, buffer, previous, cursor, initial);
        }
        return cursor;
    }

    private void load_primitive(int read_key, byte read_type, Buffer buffer, long previous, long cursor, boolean initial) {
        switch (read_type) {
            case 1: {
                this.internal_set(read_key, read_type, (byte)Base64.decodeToIntWithBounds(buffer, previous, cursor) == CoreConstants.BOOL_TRUE, true, initial);
                break;
            }
            case 4: {
                this.internal_set(read_key, read_type, Base64.decodeToIntWithBounds(buffer, previous, cursor), true, initial);
                break;
            }
            case 5: {
                this.internal_set(read_key, read_type, Base64.decodeToDoubleWithBounds(buffer, previous, cursor), true, initial);
                break;
            }
            case 3: {
                this.internal_set(read_key, read_type, Base64.decodeToLongWithBounds(buffer, previous, cursor), true, initial);
                break;
            }
            case 2: {
                this.internal_set(read_key, read_type, Base64.decodeToStringWithBounds(buffer, previous, cursor), true, initial);
                break;
            }
            case 18: {
                this.internal_set(read_key, read_type, this._eGraph.nodeByIndex(Base64.decodeToIntWithBounds(buffer, previous, cursor), true), true, initial);
            }
        }
    }

    @Override
    public final void each(NodeStateCallback callBack) {
        for (int i = 0; i < this._size; ++i) {
            if (this._v[i] == null) continue;
            callBack.on(this._k[i], this._type[i], this._v[i]);
        }
    }
}

