/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.heap;

import greycat.internal.heap.HeapContainer;
import greycat.internal.heap.HeapEGraph;
import greycat.internal.heap.HeapENode;
import greycat.struct.ENode;
import greycat.struct.ERelation;

class HeapERelation
implements ERelation {
    private ENode[] _back;
    private int _size;
    private int _capacity;
    private final HeapContainer parent;

    HeapERelation(HeapContainer p_parent, HeapERelation origin) {
        this.parent = p_parent;
        if (origin != null) {
            this._back = new ENode[origin._capacity];
            System.arraycopy(origin._back, 0, this._back, 0, origin._capacity);
            this._size = origin._size;
            this._capacity = origin._capacity;
        } else {
            this._back = null;
            this._size = 0;
            this._capacity = 0;
        }
    }

    final void rebase(HeapEGraph newGraph) {
        for (int i = 0; i < this._size; ++i) {
            HeapENode previous = (HeapENode)this._back[i];
            this._back[i] = newGraph._nodes[previous._id];
        }
    }

    @Override
    public final int size() {
        return this._size;
    }

    @Override
    public final ENode[] nodes() {
        ENode[] copy = new ENode[this._size];
        System.arraycopy(this._back, 0, copy, 0, this._size);
        return copy;
    }

    @Override
    public final ENode node(int index) {
        return this._back[index];
    }

    @Override
    public final ERelation add(ENode eNode) {
        if (this._capacity == this._size) {
            if (this._capacity == 0) {
                this.allocate(8);
            } else {
                this.allocate(this._capacity * 2);
            }
        }
        this._back[this._size] = eNode;
        ++this._size;
        if (this.parent != null) {
            this.parent.declareDirty();
        }
        return this;
    }

    @Override
    public final ERelation addAll(ENode[] eNodes) {
        this.allocate(eNodes.length + this._size);
        System.arraycopy(eNodes, 0, this._back, this._size, eNodes.length);
        if (this.parent != null) {
            this.parent.declareDirty();
        }
        return this;
    }

    @Override
    public final ERelation clear() {
        this._size = 0;
        this._back = null;
        if (this.parent != null) {
            this.parent.declareDirty();
        }
        return this;
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        for (int i = 0; i < this._size; ++i) {
            if (i != 0) {
                buffer.append(",");
            }
            buffer.append(((HeapENode)this._back[i])._id);
        }
        buffer.append("]");
        return buffer.toString();
    }

    final void allocate(int newCapacity) {
        int closePowerOfTwo = (int)Math.pow(2.0, Math.ceil(Math.log(newCapacity) / Math.log(2.0)));
        if (closePowerOfTwo > this._capacity) {
            ENode[] new_back = new ENode[closePowerOfTwo];
            if (this._back != null) {
                System.arraycopy(this._back, 0, new_back, 0, this._size);
            }
            this._back = new_back;
            this._capacity = closePowerOfTwo;
        }
    }
}

