/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.heap;

import greycat.chunk.Stack;
import java.util.Arrays;

public final class HeapFixedStack
implements Stack {
    private final int[] _next;
    private final int[] _prev;
    private final int _capacity;
    private int _first;
    private int _last;
    private int _count;

    public HeapFixedStack(int capacity, boolean fill) {
        this._capacity = capacity;
        this._next = new int[capacity];
        this._prev = new int[capacity];
        this._first = -1;
        this._last = -1;
        Arrays.fill(this._next, 0, capacity, -1);
        Arrays.fill(this._prev, 0, capacity, -1);
        if (fill) {
            for (int i = 0; i < capacity; ++i) {
                int l;
                this._prev[i] = l = this._last;
                this._last = i;
                if (this._first == -1) {
                    this._first = i;
                    continue;
                }
                this._next[l] = i;
            }
            this._count = capacity;
        } else {
            this._count = 0;
        }
    }

    @Override
    public final synchronized boolean enqueue(long index) {
        int l;
        if (this._count >= this._capacity) {
            return false;
        }
        int castedIndex = (int)index;
        if (this._first == castedIndex || this._last == castedIndex) {
            return false;
        }
        if (this._prev[castedIndex] != -1 || this._next[castedIndex] != -1) {
            return false;
        }
        this._prev[castedIndex] = l = this._last;
        this._last = castedIndex;
        if (this._first == -1) {
            this._first = castedIndex;
        } else {
            this._next[l] = castedIndex;
        }
        ++this._count;
        return true;
    }

    @Override
    public final synchronized long dequeueTail() {
        int f = this._first;
        if (f == -1) {
            return -1L;
        }
        int n = this._next[f];
        this._next[f] = -1;
        this._prev[f] = -1;
        this._first = n;
        if (n == -1) {
            this._last = -1;
        } else {
            this._prev[n] = -1;
        }
        --this._count;
        return f;
    }

    @Override
    public final synchronized boolean dequeue(long index) {
        int castedIndex = (int)index;
        int p = this._prev[castedIndex];
        int n = this._next[castedIndex];
        if (p == -1 && n == -1) {
            return false;
        }
        if (p == -1) {
            int f = this._first;
            if (f == -1) {
                return false;
            }
            int n2 = this._next[f];
            this._next[f] = -1;
            this._prev[f] = -1;
            this._first = n2;
            if (n2 == -1) {
                this._last = -1;
            } else {
                this._prev[n2] = -1;
            }
            --this._count;
        } else if (n == -1) {
            int l = this._last;
            if (l == -1) {
                return false;
            }
            int p2 = this._prev[l];
            this._prev[l] = -1;
            this._next[l] = -1;
            this._last = p2;
            if (p2 == -1) {
                this._first = -1;
            } else {
                this._next[p2] = -1;
            }
            --this._count;
        } else {
            this._next[p] = n;
            this._prev[n] = p;
            this._prev[castedIndex] = -1;
            this._next[castedIndex] = -1;
            --this._count;
        }
        return true;
    }

    @Override
    public final void free() {
    }

    @Override
    public synchronized long size() {
        return this._count;
    }
}

