/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.heap;

import greycat.chunk.GenChunk;
import greycat.internal.heap.HeapChunkSpace;
import greycat.struct.Buffer;
import greycat.utility.Base64;

final class HeapGenChunk
implements GenChunk {
    private final HeapChunkSpace _space;
    private final long _index;
    private final long _prefix;
    private long _seed;
    private boolean _dirty;

    HeapGenChunk(HeapChunkSpace p_space, long p_id, long p_index) {
        this._index = p_index;
        this._space = p_space;
        this._prefix = p_id << 37;
        this._seed = -1L;
        this._dirty = false;
    }

    @Override
    public final synchronized void save(Buffer buffer) {
        Base64.encodeLongToBuffer(this._seed, buffer);
        this._dirty = false;
    }

    @Override
    public synchronized void saveDiff(Buffer buffer) {
        Base64.encodeLongToBuffer(this._seed, buffer);
        this._dirty = false;
    }

    @Override
    public final synchronized void load(Buffer buffer) {
        this.internal_load(buffer, false);
    }

    @Override
    public synchronized void loadDiff(Buffer buffer) {
        this.internal_load(buffer, true);
    }

    private void internal_load(Buffer buffer, boolean diff) {
        if (buffer == null || buffer.length() == 0L) {
            return;
        }
        long loaded = Base64.decodeToLongWithBounds(buffer, 0L, buffer.length());
        long previousSeed = this._seed;
        this._seed = loaded;
        if (previousSeed != -1L && previousSeed != this._seed && this._space != null && !this._dirty && diff) {
            this._dirty = true;
            this._space.notifyUpdate(this._index);
        }
    }

    @Override
    public final synchronized long newKey() {
        if (this._seed == 0x1FFFFFFFFFL) {
            throw new IndexOutOfBoundsException("Object Index could not be created because it exceeded the capacity of the current prefix. Ask for a new prefix.");
        }
        if (this._seed == -1L) {
            this._seed = 0L;
        }
        ++this._seed;
        long nextIndex = this._seed;
        long objectKey = this._prefix + nextIndex;
        if (this._space != null) {
            this._space.notifyUpdate(this._index);
        }
        if (objectKey >= 0x1FFFFFFFFFFFFEL) {
            throw new IndexOutOfBoundsException("Object Index exceeds the maximum JavaScript number capacity. (2^53)");
        }
        return objectKey;
    }

    @Override
    public final long index() {
        return this._index;
    }

    @Override
    public final long world() {
        return this._space.worldByIndex(this._index);
    }

    @Override
    public final long time() {
        return this._space.timeByIndex(this._index);
    }

    @Override
    public final long id() {
        return this._space.idByIndex(this._index);
    }

    @Override
    public final byte chunkType() {
        return 3;
    }
}

