/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.heap;

import greycat.internal.heap.HeapContainer;
import greycat.struct.Buffer;
import greycat.struct.LMatrix;
import greycat.utility.Base64;
import java.util.Arrays;
import java.util.Random;

class HeapLMatrix
implements LMatrix {
    private static final int INDEX_ROWS = 0;
    private static final int INDEX_COLUMNS = 1;
    private static final int INDEX_MAX_COLUMN = 2;
    private static final int INDEX_OFFSET = 3;
    private final HeapContainer parent;
    private long[] backend = null;
    private boolean aligned = true;

    HeapLMatrix(HeapContainer p_parent, HeapLMatrix origin) {
        this.parent = p_parent;
        if (origin != null) {
            this.aligned = false;
            this.backend = origin.backend;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LMatrix init(int rows, int columns) {
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            this.internal_init(rows, columns);
        }
        this.parent.declareDirty();
        return this;
    }

    private void internal_init(int rows, int columns) {
        this.backend = new long[rows * columns + 3];
        this.backend[0] = rows;
        this.backend[1] = columns;
        this.backend[2] = columns;
        this.aligned = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LMatrix appendColumn(long[] newColumn) {
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            this.internal_appendColumn(newColumn);
            this.parent.declareDirty();
        }
        return this;
    }

    private void internal_appendColumn(long[] newColumn) {
        int nbMaxColumn;
        int nbColumns;
        int nbRows;
        if (this.backend == null) {
            nbRows = newColumn.length;
            nbColumns = 8;
            nbMaxColumn = 0;
            this.backend = new long[nbRows * nbColumns + 3];
            this.backend[0] = nbRows;
            this.backend[1] = nbColumns;
            this.backend[2] = nbMaxColumn;
        } else {
            nbColumns = (int)this.backend[1];
            nbRows = (int)this.backend[0];
            nbMaxColumn = (int)this.backend[2];
        }
        if (!this.aligned || nbMaxColumn == nbColumns) {
            if (nbMaxColumn == nbColumns) {
                this.backend[1] = nbColumns *= 2;
                int newLength = nbColumns * nbRows + 3;
                long[] next_backend = new long[newLength];
                System.arraycopy(this.backend, 0, next_backend, 0, this.backend.length);
                this.backend = next_backend;
                this.aligned = true;
            } else {
                long[] next_backend = new long[this.backend.length];
                System.arraycopy(this.backend, 0, next_backend, 0, this.backend.length);
                this.backend = next_backend;
                this.aligned = true;
            }
        }
        System.arraycopy(newColumn, 0, this.backend, nbMaxColumn * nbRows + 3, newColumn.length);
        this.backend[2] = nbMaxColumn + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LMatrix fill(long value) {
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            this.internal_fill(value);
        }
        return this;
    }

    private void internal_fill(long value) {
        if (this.backend != null) {
            if (!this.aligned) {
                long[] next_backend = new long[this.backend.length];
                System.arraycopy(this.backend, 0, next_backend, 0, this.backend.length);
                this.backend = next_backend;
                this.aligned = true;
            }
            Arrays.fill(this.backend, 3, this.backend.length - 3, value);
            this.backend[2] = this.backend[1];
            this.parent.declareDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LMatrix fillWith(long[] values) {
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            this.internal_fillWith(values);
        }
        return this;
    }

    private void internal_fillWith(long[] values) {
        if (this.backend != null) {
            if (!this.aligned) {
                long[] next_backend = new long[this.backend.length];
                System.arraycopy(this.backend, 0, next_backend, 0, this.backend.length);
                this.backend = next_backend;
                this.aligned = true;
            }
            System.arraycopy(values, 0, this.backend, 3, values.length);
            this.parent.declareDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LMatrix fillWithRandom(long min, long max, long seed) {
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            this.internal_fillWithRandom(min, max, seed);
        }
        return this;
    }

    private void internal_fillWithRandom(long min, long max, long seed) {
        Random rand = new Random();
        rand.setSeed(seed);
        if (this.backend != null) {
            if (!this.aligned) {
                long[] next_backend = new long[this.backend.length];
                System.arraycopy(this.backend, 0, next_backend, 0, this.backend.length);
                this.backend = next_backend;
                this.aligned = true;
            }
            int i = 0;
            while ((long)i < this.backend[0] * this.backend[1]) {
                this.backend[i + 3] = (long)rand.nextInt() * (max - min) + min;
                ++i;
            }
            this.parent.declareDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int rows() {
        int result = 0;
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            if (this.backend != null) {
                result = (int)this.backend[0];
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int columns() {
        int result = 0;
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            if (this.backend != null) {
                result = (int)this.backend[2];
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long[] column(int index) {
        long[] result;
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            int nbRows = (int)this.backend[0];
            result = new long[nbRows];
            System.arraycopy(this.backend, 3 + index * nbRows, result, 0, nbRows);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long get(int rowIndex, int columnIndex) {
        long result = 0L;
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            if (this.backend != null) {
                int nbRows = (int)this.backend[0];
                result = this.backend[3 + rowIndex + columnIndex * nbRows];
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LMatrix set(int rowIndex, int columnIndex, long value) {
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            this.internal_set(rowIndex, columnIndex, value);
        }
        return this;
    }

    private void internal_set(int rowIndex, int columnIndex, long value) {
        if (this.backend != null) {
            if (!this.aligned) {
                long[] next_backend = new long[this.backend.length];
                System.arraycopy(this.backend, 0, next_backend, 0, this.backend.length);
                this.backend = next_backend;
                this.aligned = true;
            }
            int nbRows = (int)this.backend[0];
            this.backend[3 + rowIndex + columnIndex * nbRows] = value;
            this.parent.declareDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LMatrix add(int rowIndex, int columnIndex, long value) {
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            this.internal_add(rowIndex, columnIndex, value);
        }
        return this;
    }

    private void internal_add(int rowIndex, int columnIndex, long value) {
        if (this.backend != null) {
            if (!this.aligned) {
                long[] next_backend = new long[this.backend.length];
                System.arraycopy(this.backend, 0, next_backend, 0, this.backend.length);
                this.backend = next_backend;
                this.aligned = true;
            }
            int nbRows = (int)this.backend[0];
            this.backend[3 + rowIndex + columnIndex * nbRows] = value + this.backend[3 + rowIndex + columnIndex * nbRows];
            this.parent.declareDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long[] data() {
        long[] copy = null;
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            if (this.backend != null) {
                copy = new long[this.backend.length - 3];
                System.arraycopy(this.backend, 3, copy, 0, this.backend.length - 3);
            }
        }
        return copy;
    }

    @Override
    public int leadingDimension() {
        if (this.backend == null) {
            return 0;
        }
        return (int)Math.max(this.backend[1], this.backend[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long unsafeGet(int index) {
        long result = 0L;
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            if (this.backend != null) {
                result = this.backend[3 + index];
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LMatrix unsafeSet(int index, long value) {
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            this.internal_unsafeSet(index, value);
        }
        return this;
    }

    private void internal_unsafeSet(int index, long value) {
        if (this.backend != null) {
            if (!this.aligned) {
                long[] next_backend = new long[this.backend.length];
                System.arraycopy(this.backend, 0, next_backend, 0, this.backend.length);
                this.backend = next_backend;
                this.aligned = true;
            }
            this.backend[3 + index] = value;
            this.parent.declareDirty();
        }
    }

    long[] unsafe_data() {
        return this.backend;
    }

    void unsafe_init(int size) {
        this.backend = new long[size];
        this.backend[0] = 0L;
        this.backend[1] = 0L;
        this.aligned = true;
    }

    void unsafe_set(long index, long value) {
        this.backend[(int)index] = value;
    }

    public final long load(Buffer buffer, long offset, long max) {
        long cursor = offset;
        byte current = buffer.read(cursor);
        boolean isFirst = true;
        long previous = offset;
        long elemIndex = 0L;
        while (cursor < max && current != 124 && current != 36 && current != 37) {
            if (current == 58) {
                if (isFirst) {
                    this.unsafe_init(Base64.decodeToIntWithBounds(buffer, previous, cursor));
                    isFirst = false;
                } else {
                    this.unsafe_set(elemIndex, Base64.decodeToLongWithBounds(buffer, previous, cursor));
                    ++elemIndex;
                }
                previous = cursor + 1L;
            }
            if (++cursor >= max) continue;
            current = buffer.read(cursor);
        }
        if (isFirst) {
            this.unsafe_init(Base64.decodeToIntWithBounds(buffer, previous, cursor));
        } else {
            this.unsafe_set(elemIndex, Base64.decodeToLongWithBounds(buffer, previous, cursor));
        }
        return cursor;
    }
}

