/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.heap;

import greycat.internal.heap.HeapContainer;
import greycat.struct.Buffer;
import greycat.struct.LongLongArrayMap;
import greycat.struct.LongLongArrayMapCallBack;
import greycat.utility.Base64;
import greycat.utility.HashHelper;
import java.util.Arrays;

class HeapLongLongArrayMap
implements LongLongArrayMap {
    final HeapContainer parent;
    int mapSize = 0;
    int capacity = 0;
    long[] keys = null;
    long[] values = null;
    int[] nexts = null;
    int[] hashs = null;

    HeapLongLongArrayMap(HeapContainer p_listener) {
        this.parent = p_listener;
    }

    long key(int i) {
        return this.keys[i];
    }

    private void setKey(int i, long newValue) {
        this.keys[i] = newValue;
    }

    long value(int i) {
        return this.values[i];
    }

    private void setValue(int i, long newValue) {
        this.values[i] = newValue;
    }

    private int next(int i) {
        return this.nexts[i];
    }

    private void setNext(int i, int newValue) {
        this.nexts[i] = newValue;
    }

    private int hash(int i) {
        return this.hashs[i];
    }

    private void setHash(int i, int newValue) {
        this.hashs[i] = newValue;
    }

    void reallocate(int newCapacity) {
        if (newCapacity > this.capacity) {
            long[] new_keys = new long[newCapacity];
            if (this.keys != null) {
                System.arraycopy(this.keys, 0, new_keys, 0, this.capacity);
            }
            this.keys = new_keys;
            long[] new_values = new long[newCapacity];
            if (this.values != null) {
                System.arraycopy(this.values, 0, new_values, 0, this.capacity);
            }
            this.values = new_values;
            int[] new_nexts = new int[newCapacity];
            int[] new_hashes = new int[newCapacity * 2];
            Arrays.fill(new_nexts, 0, newCapacity, -1);
            Arrays.fill(new_hashes, 0, newCapacity * 2, -1);
            this.hashs = new_hashes;
            this.nexts = new_nexts;
            for (int i = 0; i < this.mapSize; ++i) {
                int new_key_hash = (int)HashHelper.longHash(this.key(i), newCapacity * 2);
                this.setNext(i, this.hash(new_key_hash));
                this.setHash(new_key_hash, i);
            }
            this.capacity = newCapacity;
        }
    }

    HeapLongLongArrayMap cloneFor(HeapContainer newParent) {
        HeapLongLongArrayMap cloned = new HeapLongLongArrayMap(newParent);
        cloned.mapSize = this.mapSize;
        cloned.capacity = this.capacity;
        if (this.keys != null) {
            long[] cloned_keys = new long[this.capacity];
            System.arraycopy(this.keys, 0, cloned_keys, 0, this.capacity);
            cloned.keys = cloned_keys;
        }
        if (this.values != null) {
            long[] cloned_values = new long[this.capacity];
            System.arraycopy(this.values, 0, cloned_values, 0, this.capacity);
            cloned.values = cloned_values;
        }
        if (this.nexts != null) {
            int[] cloned_nexts = new int[this.capacity];
            System.arraycopy(this.nexts, 0, cloned_nexts, 0, this.capacity);
            cloned.nexts = cloned_nexts;
        }
        if (this.hashs != null) {
            int[] cloned_hashs = new int[this.capacity * 2];
            System.arraycopy(this.hashs, 0, cloned_hashs, 0, this.capacity * 2);
            cloned.hashs = cloned_hashs;
        }
        return cloned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long[] get(long requestKey) {
        long[] result = new long[]{};
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            if (this.keys != null) {
                int hashIndex = (int)HashHelper.longHash(requestKey, this.capacity * 2);
                int resultCapacity = 0;
                int resultIndex = 0;
                int m = this.hash(hashIndex);
                while (m >= 0) {
                    if (requestKey == this.key(m)) {
                        if (resultIndex == resultCapacity) {
                            int newCapacity = resultCapacity == 0 ? 1 : resultCapacity * 2;
                            long[] tempResult = new long[newCapacity];
                            System.arraycopy(result, 0, tempResult, 0, result.length);
                            result = tempResult;
                            resultCapacity = newCapacity;
                        }
                        result[resultIndex] = this.value(m);
                        ++resultIndex;
                    }
                    m = this.next(m);
                }
                if (resultIndex != resultCapacity) {
                    long[] shrinkedResult = new long[resultIndex];
                    System.arraycopy(result, 0, shrinkedResult, 0, resultIndex);
                    result = shrinkedResult;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(long requestKey, long requestValue) {
        boolean result = false;
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            if (this.keys != null) {
                int hashIndex = (int)HashHelper.longHash(requestKey, this.capacity * 2);
                int m = this.hash(hashIndex);
                while (m >= 0 && !result) {
                    if (requestKey == this.key(m) && requestValue == this.value(m)) {
                        result = true;
                    }
                    m = this.next(m);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void each(LongLongArrayMapCallBack callback) {
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            this.unsafe_each(callback);
        }
    }

    void unsafe_each(LongLongArrayMapCallBack callback) {
        for (int i = 0; i < this.mapSize; ++i) {
            callback.on(this.key(i), this.value(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        int result;
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            result = this.mapSize;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void delete(long requestKey, long requestValue) {
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            if (this.keys != null && this.mapSize != 0) {
                long hashCapacity = this.capacity * 2;
                int hashIndex = (int)HashHelper.longHash(requestKey, hashCapacity);
                int m = this.hash(hashIndex);
                int found = -1;
                while (m >= 0) {
                    if (requestKey == this.key(m) && requestValue == this.value(m)) {
                        found = m;
                        break;
                    }
                    m = this.next(m);
                }
                if (found != -1) {
                    int toRemoveHash = (int)HashHelper.longHash(requestKey, hashCapacity);
                    m = this.hash(toRemoveHash);
                    if (m == found) {
                        this.setHash(toRemoveHash, this.next(m));
                    } else {
                        while (m != -1) {
                            int next_of_m = this.next(m);
                            if (next_of_m == found) {
                                this.setNext(m, this.next(next_of_m));
                                break;
                            }
                            m = next_of_m;
                        }
                    }
                    int lastIndex = this.mapSize - 1;
                    if (lastIndex == found) {
                        --this.mapSize;
                    } else {
                        long lastKey = this.key(lastIndex);
                        this.setKey(found, lastKey);
                        this.setValue(found, this.value(lastIndex));
                        this.setNext(found, this.next(lastIndex));
                        int victimHash = (int)HashHelper.longHash(lastKey, hashCapacity);
                        m = this.hash(victimHash);
                        if (m == lastIndex) {
                            this.setHash(victimHash, found);
                        } else {
                            while (m != -1) {
                                int next_of_m = this.next(m);
                                if (next_of_m == lastIndex) {
                                    this.setNext(m, found);
                                    break;
                                }
                                m = next_of_m;
                            }
                        }
                        --this.mapSize;
                    }
                    this.parent.declareDirty();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void put(long insertKey, long insertValue) {
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            this.internal_put(insertKey, insertValue, false);
        }
    }

    private void internal_put(long insertKey, long insertValue, boolean initial) {
        if (this.keys == null) {
            this.reallocate(8);
            this.setKey(0, insertKey);
            this.setValue(0, insertValue);
            this.setHash((int)HashHelper.longHash(insertKey, this.capacity * 2), 0);
            this.setNext(0, -1);
            ++this.mapSize;
            if (!initial) {
                this.parent.declareDirty();
            }
        } else {
            int currentHash;
            long hashCapacity = this.capacity * 2;
            int insertKeyHash = (int)HashHelper.longHash(insertKey, hashCapacity);
            int m = currentHash = this.hash(insertKeyHash);
            int found = -1;
            while (m >= 0) {
                if (insertKey == this.key(m) && insertValue == this.value(m)) {
                    found = m;
                    break;
                }
                m = this.next(m);
            }
            if (found == -1) {
                int lastIndex = this.mapSize;
                if (lastIndex == this.capacity) {
                    this.reallocate(this.capacity * 2);
                    hashCapacity = this.capacity * 2;
                    insertKeyHash = (int)HashHelper.longHash(insertKey, hashCapacity);
                    currentHash = this.hash(insertKeyHash);
                }
                this.setKey(lastIndex, insertKey);
                this.setValue(lastIndex, insertValue);
                this.setHash((int)HashHelper.longHash(insertKey, this.capacity * 2), lastIndex);
                this.setNext(lastIndex, currentHash);
                ++this.mapSize;
                if (!initial) {
                    this.parent.declareDirty();
                }
            }
        }
    }

    public final long load(Buffer buffer, long offset, long max) {
        long cursor = offset;
        byte current = buffer.read(cursor);
        boolean isFirst = true;
        long previous = offset;
        long previousKey = -1L;
        boolean waitingVal = false;
        while (cursor < max && current != 124 && current != 36 && current != 37) {
            if (current == 58) {
                if (isFirst) {
                    this.reallocate(Base64.decodeToIntWithBounds(buffer, previous, cursor));
                    isFirst = false;
                } else if (!waitingVal) {
                    previousKey = Base64.decodeToLongWithBounds(buffer, previous, cursor);
                    waitingVal = true;
                } else {
                    waitingVal = false;
                    this.internal_put(previousKey, Base64.decodeToLongWithBounds(buffer, previous, cursor), true);
                }
                previous = cursor + 1L;
            }
            if (++cursor >= max) continue;
            current = buffer.read(cursor);
        }
        if (isFirst) {
            this.reallocate(Base64.decodeToIntWithBounds(buffer, previous, cursor));
        } else if (waitingVal) {
            this.internal_put(previousKey, Base64.decodeToLongWithBounds(buffer, previous, cursor), true);
        }
        return cursor;
    }
}

