/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.heap;

import greycat.Node;
import greycat.internal.heap.HeapContainer;
import greycat.struct.Buffer;
import greycat.struct.Relation;
import greycat.utility.Base64;

class HeapRelation
implements Relation {
    private long[] _back;
    private volatile int _size;
    private final HeapContainer parent;
    private boolean aligned = true;

    HeapRelation(HeapContainer p_parent, HeapRelation origin) {
        this.parent = p_parent;
        if (origin != null) {
            this.aligned = false;
            this._back = origin._back;
            this._size = origin._size;
        } else {
            this._back = null;
            this._size = 0;
        }
    }

    final void allocate(int _capacity) {
        long[] new_back = new long[_capacity];
        if (this._back != null) {
            System.arraycopy(this._back, 0, new_back, 0, this._back.length);
        }
        this._back = new_back;
        this.aligned = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] all() {
        long[] ids;
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            if (this._back == null) {
                ids = new long[]{};
            } else {
                int relSize = this._size;
                ids = new long[relSize];
                for (int i = 0; i < relSize; ++i) {
                    ids[i] = this._back[i];
                }
            }
        }
        return ids;
    }

    @Override
    public final int size() {
        return this._size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long get(int index) {
        long result;
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            result = this._back[index];
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void set(int index, long value) {
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            this._back[index] = value;
        }
    }

    final long unsafe_get(int index) {
        return this._back[index];
    }

    @Override
    public final Relation addNode(Node node) {
        return this.add(node.id());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Relation add(long newValue) {
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            this.internal_add(newValue);
            this.parent.declareDirty();
        }
        return this;
    }

    private void internal_add(long newValue) {
        if (this._back == null) {
            this.aligned = true;
            this._back = new long[8];
            this._back[0] = newValue;
            this._size = 1;
        } else if (this._size == this._back.length) {
            long[] ex_back = new long[this._back.length * 2];
            System.arraycopy(this._back, 0, ex_back, 0, this._size);
            this._back = ex_back;
            this._back[this._size] = newValue;
            this.aligned = true;
            ++this._size;
        } else {
            if (!this.aligned) {
                long[] temp_back = new long[this._back.length];
                System.arraycopy(this._back, 0, temp_back, 0, this._back.length);
                this._back = temp_back;
                this.aligned = true;
            }
            this._back[this._size] = newValue;
            ++this._size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Relation addAll(long[] newValues) {
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            int nextSize = newValues.length + this._size;
            int closePowerOfTwo = (int)Math.pow(2.0, Math.ceil(Math.log(nextSize) / Math.log(2.0)));
            this.allocate(closePowerOfTwo);
            System.arraycopy(newValues, 0, this._back, this._size, newValues.length);
            this.parent.declareDirty();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Relation insert(int targetIndex, long newValue) {
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            if (this._back == null) {
                if (targetIndex != 0) {
                    throw new RuntimeException("Bad API usage ! index out of bounds: " + targetIndex);
                }
                this._back = new long[8];
                this._back[0] = newValue;
                this._size = 1;
                this.aligned = true;
            } else if (this._size == this._back.length) {
                if (targetIndex > this._size) {
                    throw new RuntimeException("Bad API usage ! index out of bounds: " + targetIndex);
                }
                long[] ex_back = new long[this._back.length * 2];
                if (this._size == targetIndex) {
                    System.arraycopy(this._back, 0, ex_back, 0, this._size);
                    this._back = ex_back;
                    this._back[this._size] = newValue;
                    ++this._size;
                } else {
                    System.arraycopy(this._back, 0, ex_back, 0, targetIndex);
                    ex_back[targetIndex] = newValue;
                    System.arraycopy(this._back, targetIndex, ex_back, targetIndex + 1, this._size - targetIndex);
                    this._back = ex_back;
                    ++this._size;
                }
                this.aligned = true;
            } else {
                if (targetIndex > this._size) {
                    throw new RuntimeException("Bad API usage ! index out of bounds: " + targetIndex);
                }
                if (!this.aligned) {
                    long[] temp_back = new long[this._back.length];
                    System.arraycopy(this._back, 0, temp_back, 0, this._back.length);
                    this._back = temp_back;
                    this.aligned = true;
                }
                int afterIndexSize = this._size - targetIndex;
                long[] temp = new long[afterIndexSize];
                System.arraycopy(this._back, targetIndex, temp, 0, afterIndexSize);
                this._back[targetIndex] = newValue;
                System.arraycopy(temp, 0, this._back, targetIndex + 1, afterIndexSize);
                ++this._size;
            }
            this.parent.declareDirty();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Relation remove(long oldValue) {
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            int indexToRemove = -1;
            for (int i = 0; i < this._size; ++i) {
                if (this._back[i] != oldValue) continue;
                indexToRemove = i;
                break;
            }
            if (indexToRemove != -1) {
                if (!this.aligned) {
                    long[] temp_back = new long[this._back.length];
                    System.arraycopy(this._back, 0, temp_back, 0, this._back.length);
                    this._back = temp_back;
                    this.aligned = true;
                }
                System.arraycopy(this._back, indexToRemove + 1, this._back, indexToRemove, this._size - indexToRemove - 1);
                --this._size;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Relation delete(int toRemoveIndex) {
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            if (toRemoveIndex != -1) {
                if (!this.aligned) {
                    long[] temp_back = new long[this._back.length];
                    System.arraycopy(this._back, 0, temp_back, 0, this._back.length);
                    this._back = temp_back;
                    this.aligned = true;
                }
                System.arraycopy(this._back, toRemoveIndex + 1, this._back, toRemoveIndex, this._size - toRemoveIndex - 1);
                --this._size;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Relation clear() {
        HeapContainer heapContainer = this.parent;
        synchronized (heapContainer) {
            this._size = 0;
        }
        return this;
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        for (int i = 0; i < this._size; ++i) {
            if (i != 0) {
                buffer.append(",");
            }
            buffer.append(this._back[i]);
        }
        buffer.append("]");
        return buffer.toString();
    }

    public final long load(Buffer buffer, long offset, long max) {
        long cursor = offset;
        byte current = buffer.read(cursor);
        boolean isFirst = true;
        long previous = offset;
        while (cursor < max && current != 124 && current != 36 && current != 37) {
            if (current == 58) {
                if (isFirst) {
                    this.allocate(Base64.decodeToIntWithBounds(buffer, previous, cursor));
                    isFirst = false;
                } else {
                    this.internal_add(Base64.decodeToLongWithBounds(buffer, previous, cursor));
                }
                previous = cursor + 1L;
            }
            if (++cursor >= max) continue;
            current = buffer.read(cursor);
        }
        if (isFirst) {
            this.allocate(Base64.decodeToIntWithBounds(buffer, previous, cursor));
        } else {
            this.internal_add(Base64.decodeToLongWithBounds(buffer, previous, cursor));
        }
        return cursor;
    }
}

